/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.iap;

import android.content.Context;
import androidx.annotation.RestrictTo;
import com.facebook.appevents.iap.InAppPurchaseBillingClientWrapper;
import com.facebook.appevents.iap.InAppPurchaseLoggerManager;
import com.facebook.appevents.iap.InAppPurchaseUtils;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class InAppPurchaseAutoLogger {
    private static final String BILLING_CLIENT_PURCHASE_NAME = "com.android.billingclient.api.Purchase";

    public static void startIapLogging(Context context) {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseAutoLogger.class)) {
            return;
        }
        try {
            Context context2;
            if (InAppPurchaseUtils.getClass(BILLING_CLIENT_PURCHASE_NAME) == null) {
                return;
            }
            InAppPurchaseBillingClientWrapper billingClientWrapper = InAppPurchaseBillingClientWrapper.getOrCreateInstance(context2);
            if (billingClientWrapper == null) {
                return;
            }
            if (InAppPurchaseBillingClientWrapper.isServiceConnected.get()) {
                if (InAppPurchaseLoggerManager.eligibleQueryPurchaseHistory()) {
                    billingClientWrapper.queryPurchaseHistory("inapp", new Runnable(){

                        @Override
                        public void run() {
                            if (CrashShieldHandler.isObjectCrashing(this)) {
                                return;
                            }
                            try {
                                InAppPurchaseAutoLogger.access$000();
                                return;
                            }
                            catch (Throwable throwable) {
                                CrashShieldHandler.handleThrowable(throwable, this);
                                return;
                            }
                        }
                    });
                } else {
                    billingClientWrapper.queryPurchase("inapp", new Runnable(){

                        @Override
                        public void run() {
                            if (CrashShieldHandler.isObjectCrashing(this)) {
                                return;
                            }
                            try {
                                InAppPurchaseAutoLogger.access$000();
                                return;
                            }
                            catch (Throwable throwable) {
                                CrashShieldHandler.handleThrowable(throwable, this);
                                return;
                            }
                        }
                    });
                }
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseAutoLogger.class);
            return;
        }
    }

    private static void logPurchase() {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseAutoLogger.class)) {
            return;
        }
        try {
            InAppPurchaseLoggerManager.filterPurchaseLogging(InAppPurchaseBillingClientWrapper.purchaseDetailsMap, InAppPurchaseBillingClientWrapper.skuDetailsMap);
            InAppPurchaseBillingClientWrapper.purchaseDetailsMap.clear();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseAutoLogger.class);
            return;
        }
    }

    static /* synthetic */ void access$000() {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseAutoLogger.class)) {
            return;
        }
        try {
            InAppPurchaseAutoLogger.logPurchase();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseAutoLogger.class);
            return;
        }
    }
}

