/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.AsyncTask;
import android.util.Base64;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.facebook.AccessToken;
import com.facebook.AccessTokenManager;
import com.facebook.FacebookException;
import com.facebook.GraphRequest;
import com.facebook.GraphResponse;
import com.facebook.LoggingBehavior;
import com.facebook.Profile;
import com.facebook.ProfileManager;
import com.facebook.UserSettingsManager;
import com.facebook.appevents.AppEventsLogger;
import com.facebook.appevents.AppEventsManager;
import com.facebook.appevents.internal.ActivityLifecycleTracker;
import com.facebook.appevents.internal.AppEventsLoggerUtility;
import com.facebook.appevents.ondeviceprocessing.OnDeviceProcessingManager;
import com.facebook.internal.AttributionIdentifiers;
import com.facebook.internal.BoltsMeasurementEventListener;
import com.facebook.internal.FeatureManager;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.LockOnGetVariable;
import com.facebook.internal.NativeProtocol;
import com.facebook.internal.ServerProtocol;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import com.facebook.internal.instrument.InstrumentManager;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.io.File;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class FacebookSdk {
    private static final String TAG = FacebookSdk.class.getCanonicalName();
    private static final HashSet<LoggingBehavior> loggingBehaviors = new HashSet<LoggingBehavior>(Arrays.asList(LoggingBehavior.DEVELOPER_ERRORS));
    private static final int DEFAULT_CALLBACK_REQUEST_CODE_OFFSET = 64206;
    private static Executor executor;
    private static volatile String applicationId;
    @Nullable
    private static volatile String applicationName;
    private static volatile String appClientToken;
    private static volatile Boolean codelessDebugLogEnabled;
    private static final String FACEBOOK_COM = "facebook.com";
    private static final String FB_GG = "fb.gg";
    private static volatile String facebookDomain;
    private static AtomicLong onProgressThreshold;
    private static volatile boolean isDebugEnabled;
    private static boolean isLegacyTokenUpgradeSupported;
    private static LockOnGetVariable<File> cacheDir;
    private static Context applicationContext;
    private static int callbackRequestCodeOffset;
    private static final Object LOCK;
    private static String graphApiVersion;
    public static boolean hasCustomTabsPrefetching;
    public static boolean ignoreAppSwitchToLoggedOut;
    private static final int MAX_REQUEST_CODE_RANGE = 100;
    private static final String ATTRIBUTION_PREFERENCES = "com.facebook.sdk.attributionTracking";
    private static final String PUBLISH_ACTIVITY_PATH = "%s/activities";
    static final String CALLBACK_OFFSET_CHANGED_AFTER_INIT = "The callback request code offset can't be updated once the SDK is initialized. Call FacebookSdk.setCallbackRequestCodeOffset inside your Application.onCreate method";
    static final String CALLBACK_OFFSET_NEGATIVE = "The callback request code offset can't be negative.";
    public static final String APP_EVENT_PREFERENCES = "com.facebook.sdk.appEventPreferences";
    public static final String DATA_PROCESSING_OPTIONS_PREFERENCES = "com.facebook.sdk.DataProcessingOptions";
    public static final String APPLICATION_ID_PROPERTY = "com.facebook.sdk.ApplicationId";
    public static final String APPLICATION_NAME_PROPERTY = "com.facebook.sdk.ApplicationName";
    public static final String CLIENT_TOKEN_PROPERTY = "com.facebook.sdk.ClientToken";
    public static final String WEB_DIALOG_THEME = "com.facebook.sdk.WebDialogTheme";
    public static final String AUTO_INIT_ENABLED_PROPERTY = "com.facebook.sdk.AutoInitEnabled";
    public static final String AUTO_LOG_APP_EVENTS_ENABLED_PROPERTY = "com.facebook.sdk.AutoLogAppEventsEnabled";
    public static final String CODELESS_DEBUG_LOG_ENABLED_PROPERTY = "com.facebook.sdk.CodelessDebugLogEnabled";
    public static final String ADVERTISER_ID_COLLECTION_ENABLED_PROPERTY = "com.facebook.sdk.AdvertiserIDCollectionEnabled";
    public static final String CALLBACK_OFFSET_PROPERTY = "com.facebook.sdk.CallbackOffset";
    public static final String MONITOR_ENABLED_PROPERTY = "com.facebook.sdk.MonitorEnabled";
    public static final String DATA_PROCESSION_OPTIONS = "data_processing_options";
    public static final String DATA_PROCESSION_OPTIONS_COUNTRY = "data_processing_options_country";
    public static final String DATA_PROCESSION_OPTIONS_STATE = "data_processing_options_state";
    public static final String GAMING = "gaming";
    private static final AtomicBoolean sdkInitialized;
    private static Boolean sdkFullyInitialized;
    private static GraphRequestCreator graphRequestCreator;

    @Deprecated
    public static synchronized void sdkInitialize(Context applicationContext, int callbackRequestCodeOffset) {
        FacebookSdk.sdkInitialize(applicationContext, callbackRequestCodeOffset, null);
    }

    @Deprecated
    public static synchronized void sdkInitialize(Context applicationContext, int callbackRequestCodeOffset, InitializeCallback callback2) {
        if (sdkInitialized.get() && callbackRequestCodeOffset != FacebookSdk.callbackRequestCodeOffset) {
            throw new FacebookException(CALLBACK_OFFSET_CHANGED_AFTER_INIT);
        }
        if (callbackRequestCodeOffset < 0) {
            throw new FacebookException(CALLBACK_OFFSET_NEGATIVE);
        }
        FacebookSdk.callbackRequestCodeOffset = callbackRequestCodeOffset;
        FacebookSdk.sdkInitialize(applicationContext, callback2);
    }

    @Deprecated
    public static synchronized void sdkInitialize(Context applicationContext) {
        FacebookSdk.sdkInitialize(applicationContext, null);
    }

    @Deprecated
    public static synchronized void sdkInitialize(final Context applicationContext, final InitializeCallback callback2) {
        if (sdkInitialized.get()) {
            if (callback2 != null) {
                callback2.onInitialized();
            }
            return;
        }
        Validate.notNull(applicationContext, "applicationContext");
        Validate.hasFacebookActivity(applicationContext, false);
        Validate.hasInternetPermissions(applicationContext, false);
        FacebookSdk.applicationContext = applicationContext.getApplicationContext();
        AppEventsLogger.getAnonymousAppDeviceGUID(applicationContext);
        FacebookSdk.loadDefaultsFromMetadata(FacebookSdk.applicationContext);
        if (Utility.isNullOrEmpty(applicationId)) {
            throw new FacebookException("A valid Facebook app id must be set in the AndroidManifest.xml or set by calling FacebookSdk.setApplicationId before initializing the sdk.");
        }
        sdkInitialized.set(true);
        if (FacebookSdk.getAutoInitEnabled()) {
            FacebookSdk.fullyInitialize();
        }
        if (FacebookSdk.applicationContext instanceof Application && UserSettingsManager.getAutoLogAppEventsEnabled()) {
            ActivityLifecycleTracker.startTracking((Application)FacebookSdk.applicationContext, applicationId);
        }
        FetchedAppSettingsManager.loadAppSettingsAsync();
        NativeProtocol.updateAllAvailableProtocolVersionsAsync();
        BoltsMeasurementEventListener.getInstance(FacebookSdk.applicationContext);
        cacheDir = new LockOnGetVariable<File>(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return applicationContext.getCacheDir();
            }
        });
        FeatureManager.checkFeature(FeatureManager.Feature.Instrument, new FeatureManager.Callback(){

            @Override
            public void onCompleted(boolean enabled) {
                if (enabled) {
                    InstrumentManager.start();
                }
            }
        });
        FeatureManager.checkFeature(FeatureManager.Feature.AppEvents, new FeatureManager.Callback(){

            @Override
            public void onCompleted(boolean enabled) {
                if (enabled) {
                    AppEventsManager.start();
                }
            }
        });
        FeatureManager.checkFeature(FeatureManager.Feature.ChromeCustomTabsPrefetching, new FeatureManager.Callback(){

            @Override
            public void onCompleted(boolean enabled) {
                if (enabled) {
                    hasCustomTabsPrefetching = true;
                }
            }
        });
        FeatureManager.checkFeature(FeatureManager.Feature.IgnoreAppSwitchToLoggedOut, new FeatureManager.Callback(){

            @Override
            public void onCompleted(boolean enabled) {
                if (enabled) {
                    ignoreAppSwitchToLoggedOut = true;
                }
            }
        });
        FutureTask<Void> futureTask = new FutureTask<Void>(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AccessTokenManager.getInstance().loadCurrentAccessToken();
                ProfileManager.getInstance().loadCurrentProfile();
                if (AccessToken.isCurrentAccessTokenActive() && Profile.getCurrentProfile() == null) {
                    Profile.fetchProfileForCurrentAccessToken();
                }
                if (callback2 != null) {
                    callback2.onInitialized();
                }
                AppEventsLogger.initializeLib(applicationContext, applicationId);
                UserSettingsManager.logIfAutoAppLinkEnabled();
                AppEventsLogger.newLogger(applicationContext.getApplicationContext()).flush();
                return null;
            }
        });
        FacebookSdk.getExecutor().execute(futureTask);
    }

    public static boolean isInitialized() {
        return sdkInitialized.get();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static synchronized boolean isFullyInitialized() {
        return sdkFullyInitialized;
    }

    public static void fullyInitialize() {
        sdkFullyInitialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<LoggingBehavior> getLoggingBehaviors() {
        HashSet<LoggingBehavior> hashSet = loggingBehaviors;
        synchronized (hashSet) {
            return Collections.unmodifiableSet(new HashSet<LoggingBehavior>(loggingBehaviors));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLoggingBehavior(LoggingBehavior behavior) {
        HashSet<LoggingBehavior> hashSet = loggingBehaviors;
        synchronized (hashSet) {
            loggingBehaviors.add(behavior);
            FacebookSdk.updateGraphDebugBehavior();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLoggingBehavior(LoggingBehavior behavior) {
        HashSet<LoggingBehavior> hashSet = loggingBehaviors;
        synchronized (hashSet) {
            loggingBehaviors.remove((Object)behavior);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearLoggingBehaviors() {
        HashSet<LoggingBehavior> hashSet = loggingBehaviors;
        synchronized (hashSet) {
            loggingBehaviors.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLoggingBehaviorEnabled(LoggingBehavior behavior) {
        HashSet<LoggingBehavior> hashSet = loggingBehaviors;
        synchronized (hashSet) {
            return FacebookSdk.isDebugEnabled() && loggingBehaviors.contains((Object)behavior);
        }
    }

    public static boolean isDebugEnabled() {
        return isDebugEnabled;
    }

    public static void setIsDebugEnabled(boolean enabled) {
        isDebugEnabled = enabled;
    }

    public static boolean isLegacyTokenUpgradeSupported() {
        return isLegacyTokenUpgradeSupported;
    }

    private static void updateGraphDebugBehavior() {
        if (loggingBehaviors.contains((Object)LoggingBehavior.GRAPH_API_DEBUG_INFO) && !loggingBehaviors.contains((Object)LoggingBehavior.GRAPH_API_DEBUG_WARNING)) {
            loggingBehaviors.add(LoggingBehavior.GRAPH_API_DEBUG_WARNING);
        }
    }

    public static void setLegacyTokenUpgradeSupported(boolean supported) {
        isLegacyTokenUpgradeSupported = supported;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Executor getExecutor() {
        Object object = LOCK;
        synchronized (object) {
            if (executor == null) {
                executor = AsyncTask.THREAD_POOL_EXECUTOR;
            }
        }
        return executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setExecutor(Executor executor) {
        Validate.notNull(executor, "executor");
        Object object = LOCK;
        synchronized (object) {
            FacebookSdk.executor = executor;
        }
    }

    public static String getFacebookDomain() {
        return facebookDomain;
    }

    public static String getGraphDomain() {
        AccessToken currentToken = AccessToken.getCurrentAccessToken();
        String tokenGraphDomain = null;
        if (currentToken != null) {
            tokenGraphDomain = currentToken.getGraphDomain();
        }
        String graphDomain = tokenGraphDomain == null ? facebookDomain : (tokenGraphDomain.equals(GAMING) ? facebookDomain.replace(FACEBOOK_COM, FB_GG) : facebookDomain);
        return graphDomain;
    }

    public static void setFacebookDomain(String facebookDomain) {
        Log.w((String)TAG, (String)"WARNING: Calling setFacebookDomain from non-DEBUG code.");
        FacebookSdk.facebookDomain = facebookDomain;
    }

    public static Context getApplicationContext() {
        Validate.sdkInitialized();
        return applicationContext;
    }

    public static void setGraphApiVersion(String graphApiVersion) {
        Log.w((String)TAG, (String)"WARNING: Calling setGraphApiVersion from non-DEBUG code.");
        if (!Utility.isNullOrEmpty(graphApiVersion) && !FacebookSdk.graphApiVersion.equals(graphApiVersion)) {
            FacebookSdk.graphApiVersion = graphApiVersion;
        }
    }

    public static String getGraphApiVersion() {
        Utility.logd(TAG, String.format("getGraphApiVersion: %s", graphApiVersion));
        return graphApiVersion;
    }

    /*
     * WARNING - void declaration
     */
    public static void publishInstallAsync(Context context, String string) {
        if (CrashShieldHandler.isObjectCrashing(FacebookSdk.class)) {
            return;
        }
        try {
            void applicationId;
            Context context2;
            final Context applicationContext = context2.getApplicationContext();
            FacebookSdk.getExecutor().execute(new Runnable((String)applicationId){
                final /* synthetic */ String val$applicationId;
                {
                    this.val$applicationId = string;
                }

                @Override
                public void run() {
                    if (CrashShieldHandler.isObjectCrashing(this)) {
                        return;
                    }
                    try {
                        FacebookSdk.publishInstallAndWaitForResponse(applicationContext, this.val$applicationId);
                        return;
                    }
                    catch (Throwable throwable) {
                        CrashShieldHandler.handleThrowable(throwable, this);
                        return;
                    }
                }
            });
            if (FeatureManager.isEnabled(FeatureManager.Feature.OnDeviceEventProcessing) && OnDeviceProcessingManager.isOnDeviceProcessingEnabled()) {
                OnDeviceProcessingManager.sendInstallEventAsync((String)applicationId, ATTRIBUTION_PREFERENCES);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, FacebookSdk.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    static void publishInstallAndWaitForResponse(Context context, String string) {
        if (CrashShieldHandler.isObjectCrashing(FacebookSdk.class)) {
            return;
        }
        try {
            try {
                GraphResponse publishResponse;
                JSONObject publishParams;
                void applicationId;
                Context context2;
                if (context2 == null || applicationId == null) {
                    throw new IllegalArgumentException("Both context and applicationId must be non-null");
                }
                AttributionIdentifiers identifiers = AttributionIdentifiers.getAttributionIdentifiers(context2);
                SharedPreferences preferences = context2.getSharedPreferences(ATTRIBUTION_PREFERENCES, 0);
                String pingKey = (String)applicationId + "ping";
                long lastPing = preferences.getLong(pingKey, 0L);
                try {
                    publishParams = AppEventsLoggerUtility.getJSONObjectForGraphAPICall(AppEventsLoggerUtility.GraphAPIActivityType.MOBILE_INSTALL_EVENT, identifiers, AppEventsLogger.getAnonymousAppDeviceGUID(context2), FacebookSdk.getLimitEventAndDataUsage(context2), context2);
                }
                catch (JSONException e) {
                    throw new FacebookException("An error occurred while publishing install.", e);
                }
                String publishUrl = String.format(PUBLISH_ACTIVITY_PATH, applicationId);
                GraphRequest publishRequest = graphRequestCreator.createPostRequest(null, publishUrl, publishParams, null);
                if (lastPing == 0L && (publishResponse = publishRequest.executeAndWait()).getError() == null) {
                    SharedPreferences.Editor editor = preferences.edit();
                    lastPing = System.currentTimeMillis();
                    editor.putLong(pingKey, lastPing);
                    editor.apply();
                }
            }
            catch (Exception e) {
                Utility.logd("Facebook-publish", e);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, FacebookSdk.class);
            return;
        }
    }

    public static String getSdkVersion() {
        return "11.1.1";
    }

    public static boolean getLimitEventAndDataUsage(Context context) {
        Validate.sdkInitialized();
        SharedPreferences preferences = context.getSharedPreferences(APP_EVENT_PREFERENCES, 0);
        return preferences.getBoolean("limitEventUsage", false);
    }

    public static void setLimitEventAndDataUsage(Context context, boolean limitEventUsage) {
        context.getSharedPreferences(APP_EVENT_PREFERENCES, 0).edit().putBoolean("limitEventUsage", limitEventUsage).apply();
    }

    public static long getOnProgressThreshold() {
        Validate.sdkInitialized();
        return onProgressThreshold.get();
    }

    public static void setOnProgressThreshold(long threshold) {
        onProgressThreshold.set(threshold);
    }

    static void loadDefaultsFromMetadata(Context context) {
        if (context == null) {
            return;
        }
        ApplicationInfo ai = null;
        try {
            ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
        }
        catch (PackageManager.NameNotFoundException e) {
            return;
        }
        if (ai == null || ai.metaData == null) {
            return;
        }
        if (applicationId == null) {
            Object appId = ai.metaData.get(APPLICATION_ID_PROPERTY);
            if (appId instanceof String) {
                String appIdString = (String)appId;
                applicationId = appIdString.toLowerCase(Locale.ROOT).startsWith("fb") ? appIdString.substring(2) : appIdString;
            } else if (appId instanceof Number) {
                throw new FacebookException("App Ids cannot be directly placed in the manifest.They must be prefixed by 'fb' or be placed in the string resource file.");
            }
        }
        if (applicationName == null) {
            applicationName = ai.metaData.getString(APPLICATION_NAME_PROPERTY);
        }
        if (appClientToken == null) {
            appClientToken = ai.metaData.getString(CLIENT_TOKEN_PROPERTY);
        }
        if (callbackRequestCodeOffset == 64206) {
            callbackRequestCodeOffset = ai.metaData.getInt(CALLBACK_OFFSET_PROPERTY, 64206);
        }
        if (codelessDebugLogEnabled == null) {
            codelessDebugLogEnabled = ai.metaData.getBoolean(CODELESS_DEBUG_LOG_ENABLED_PROPERTY, false);
        }
    }

    public static String getApplicationSignature(Context context) {
        if (CrashShieldHandler.isObjectCrashing(FacebookSdk.class)) {
            return null;
        }
        try {
            MessageDigest md;
            PackageInfo pInfo;
            Context context2;
            Validate.sdkInitialized();
            if (context2 == null) {
                return null;
            }
            PackageManager packageManager = context2.getPackageManager();
            if (packageManager == null) {
                return null;
            }
            String packageName = context2.getPackageName();
            try {
                pInfo = packageManager.getPackageInfo(packageName, 64);
            }
            catch (PackageManager.NameNotFoundException e) {
                return null;
            }
            Signature[] signatures = pInfo.signatures;
            if (signatures == null || signatures.length == 0) {
                return null;
            }
            try {
                md = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException e) {
                return null;
            }
            md.update(pInfo.signatures[0].toByteArray());
            return Base64.encodeToString((byte[])md.digest(), (int)9);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, FacebookSdk.class);
            return null;
        }
    }

    public static String getApplicationId() {
        Validate.sdkInitialized();
        return applicationId;
    }

    public static void setApplicationId(String applicationId) {
        FacebookSdk.applicationId = applicationId;
    }

    @Nullable
    public static String getApplicationName() {
        Validate.sdkInitialized();
        return applicationName;
    }

    public static void setApplicationName(String applicationName) {
        FacebookSdk.applicationName = applicationName;
    }

    public static String getClientToken() {
        Validate.sdkInitialized();
        return appClientToken;
    }

    public static void setClientToken(String clientToken) {
        appClientToken = clientToken;
    }

    public static boolean getAutoInitEnabled() {
        return UserSettingsManager.getAutoInitEnabled();
    }

    public static void setAutoInitEnabled(boolean flag) {
        UserSettingsManager.setAutoInitEnabled(flag);
        if (flag) {
            FacebookSdk.fullyInitialize();
        }
    }

    public static boolean getAutoLogAppEventsEnabled() {
        return UserSettingsManager.getAutoLogAppEventsEnabled();
    }

    public static void setAutoLogAppEventsEnabled(boolean flag) {
        UserSettingsManager.setAutoLogAppEventsEnabled(flag);
        if (flag) {
            ActivityLifecycleTracker.startTracking((Application)applicationContext, applicationId);
        }
    }

    public static boolean getCodelessDebugLogEnabled() {
        Validate.sdkInitialized();
        return codelessDebugLogEnabled;
    }

    public static boolean getCodelessSetupEnabled() {
        return UserSettingsManager.getCodelessSetupEnabled();
    }

    public static void setAdvertiserIDCollectionEnabled(boolean flag) {
        UserSettingsManager.setAdvertiserIDCollectionEnabled(flag);
    }

    public static boolean getAdvertiserIDCollectionEnabled() {
        return UserSettingsManager.getAdvertiserIDCollectionEnabled();
    }

    public static void setCodelessDebugLogEnabled(boolean flag) {
        codelessDebugLogEnabled = flag;
    }

    public static boolean getMonitorEnabled() {
        return UserSettingsManager.getMonitorEnabled();
    }

    public static void setMonitorEnabled(boolean flag) {
        UserSettingsManager.setMonitorEnabled(flag);
    }

    public static void setDataProcessingOptions(String[] stringArray) {
        if (CrashShieldHandler.isObjectCrashing(FacebookSdk.class)) {
            return;
        }
        try {
            String[] options;
            FacebookSdk.setDataProcessingOptions(options, 0, 0);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, FacebookSdk.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void setDataProcessingOptions(String[] stringArray, int n, int n2) {
        if (CrashShieldHandler.isObjectCrashing(FacebookSdk.class)) {
            return;
        }
        try {
            String[] options;
            if (options == null) {
                options = new String[]{};
            }
            try {
                void state;
                void country;
                JSONObject dataProcessingOptions = new JSONObject();
                JSONArray array = new JSONArray(Arrays.asList(options));
                dataProcessingOptions.put(DATA_PROCESSION_OPTIONS, (Object)array);
                dataProcessingOptions.put(DATA_PROCESSION_OPTIONS_COUNTRY, (int)country);
                dataProcessingOptions.put(DATA_PROCESSION_OPTIONS_STATE, (int)state);
                applicationContext.getSharedPreferences(DATA_PROCESSING_OPTIONS_PREFERENCES, 0).edit().putString(DATA_PROCESSION_OPTIONS, dataProcessingOptions.toString()).apply();
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, FacebookSdk.class);
            return;
        }
    }

    public static File getCacheDir() {
        Validate.sdkInitialized();
        return cacheDir.getValue();
    }

    public static void setCacheDir(File cacheDir) {
        FacebookSdk.cacheDir = new LockOnGetVariable<File>(cacheDir);
    }

    public static int getCallbackRequestCodeOffset() {
        Validate.sdkInitialized();
        return callbackRequestCodeOffset;
    }

    public static boolean isFacebookRequestCode(int requestCode) {
        return requestCode >= callbackRequestCodeOffset && requestCode < callbackRequestCodeOffset + 100;
    }

    @VisibleForTesting
    public static void setGraphRequestCreator(GraphRequestCreator graphRequestCreator) {
        FacebookSdk.graphRequestCreator = graphRequestCreator;
    }

    static {
        facebookDomain = FACEBOOK_COM;
        onProgressThreshold = new AtomicLong(65536L);
        isDebugEnabled = false;
        isLegacyTokenUpgradeSupported = false;
        callbackRequestCodeOffset = 64206;
        LOCK = new Object();
        graphApiVersion = ServerProtocol.getDefaultAPIVersion();
        hasCustomTabsPrefetching = false;
        ignoreAppSwitchToLoggedOut = false;
        sdkInitialized = new AtomicBoolean(false);
        sdkFullyInitialized = false;
        graphRequestCreator = new GraphRequestCreator(){

            @Override
            public GraphRequest createPostRequest(@Nullable AccessToken accessToken, String publishUrl, JSONObject publishParams, @Nullable GraphRequest.Callback callback2) {
                return GraphRequest.newPostRequest(accessToken, publishUrl, publishParams, callback2);
            }
        };
    }

    @VisibleForTesting
    public static interface GraphRequestCreator {
        public GraphRequest createPostRequest(@Nullable AccessToken var1, String var2, JSONObject var3, @Nullable GraphRequest.Callback var4);
    }

    public static interface InitializeCallback {
        public void onInitialized();
    }
}

