/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.VisibleForTesting;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.FacebookServiceException;
import com.facebook.internal.FacebookRequestErrorClassification;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.Utility;
import java.net.HttpURLConnection;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 @2\u00020\u0001:\u0003?@AB!\b\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u0004\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\u00a2\u0006\u0002\u0010\u0007B#\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\rB\u000f\b\u0012\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010B\u0081\u0001\b\u0002\u0012\u0006\u0010\u0011\u001a\u00020\t\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u0012\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\u0014\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\u0015\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u0012\b\u0010\u0018\u001a\u0004\u0018\u00010\u0017\u0012\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c\u0012\u0006\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\u0002\u0010\u001fJ\b\u00109\u001a\u00020\tH\u0016J\b\u0010:\u001a\u00020\u000bH\u0016J\u0018\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u000f2\u0006\u0010>\u001a\u00020\tH\u0016R\u0013\u0010\u0019\u001a\u0004\u0018\u00010\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0015\u0010\f\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0013\u0010,\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010+R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010+R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010+R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010+R\"\u0010\u0004\u001a\u0004\u0018\u00010\u001c2\b\u00101\u001a\u0004\u0018\u00010\u001c@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00105R\u0011\u0010\u0011\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010)R\u0011\u0010\u0012\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010)\u00a8\u0006B"}, d2={"Lcom/facebook/FacebookRequestError;", "Landroid/os/Parcelable;", "connection", "Ljava/net/HttpURLConnection;", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "(Ljava/net/HttpURLConnection;Ljava/lang/Exception;)V", "errorCode", "", "errorType", "", "errorMessage", "(ILjava/lang/String;Ljava/lang/String;)V", "parcel", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "requestStatusCode", "subErrorCode", "errorMessageField", "errorUserTitle", "errorUserMessage", "requestResultBody", "Lorg/json/JSONObject;", "requestResult", "batchRequestResult", "", "exceptionField", "Lcom/facebook/FacebookException;", "errorIsTransient", "", "(IIILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lorg/json/JSONObject;Lorg/json/JSONObject;Ljava/lang/Object;Ljava/net/HttpURLConnection;Lcom/facebook/FacebookException;Z)V", "getBatchRequestResult", "()Ljava/lang/Object;", "category", "Lcom/facebook/FacebookRequestError$Category;", "getCategory", "()Lcom/facebook/FacebookRequestError$Category;", "getConnection", "()Ljava/net/HttpURLConnection;", "getErrorCode", "()I", "getErrorMessage", "()Ljava/lang/String;", "errorRecoveryMessage", "getErrorRecoveryMessage", "getErrorType", "getErrorUserMessage", "getErrorUserTitle", "<set-?>", "getException", "()Lcom/facebook/FacebookException;", "getRequestResult", "()Lorg/json/JSONObject;", "getRequestResultBody", "getRequestStatusCode", "getSubErrorCode", "describeContents", "toString", "writeToParcel", "", "out", "flags", "Category", "Companion", "Range", "facebook-core_release"})
public final class FacebookRequestError
implements Parcelable {
    @Nullable
    private final String errorMessage;
    @Nullable
    private FacebookException exception;
    @NotNull
    private final Category category;
    @Nullable
    private final String errorRecoveryMessage;
    private final int requestStatusCode;
    private final int errorCode;
    private final int subErrorCode;
    @Nullable
    private final String errorType;
    @Nullable
    private final String errorUserTitle;
    @Nullable
    private final String errorUserMessage;
    @Nullable
    private final JSONObject requestResultBody;
    @Nullable
    private final JSONObject requestResult;
    @Nullable
    private final Object batchRequestResult;
    @Nullable
    private final HttpURLConnection connection;
    public static final int INVALID_ERROR_CODE = -1;
    public static final int INVALID_HTTP_STATUS_CODE = -1;
    private static final String CODE_KEY = "code";
    private static final String BODY_KEY = "body";
    private static final String ERROR_KEY = "error";
    private static final String ERROR_TYPE_FIELD_KEY = "type";
    private static final String ERROR_CODE_FIELD_KEY = "code";
    private static final String ERROR_MESSAGE_FIELD_KEY = "message";
    private static final String ERROR_CODE_KEY = "error_code";
    private static final String ERROR_SUB_CODE_KEY = "error_subcode";
    private static final String ERROR_MSG_KEY = "error_msg";
    private static final String ERROR_REASON_KEY = "error_reason";
    private static final String ERROR_USER_TITLE_KEY = "error_user_title";
    private static final String ERROR_USER_MSG_KEY = "error_user_msg";
    private static final String ERROR_IS_TRANSIENT_KEY = "is_transient";
    @NotNull
    private static final Range HTTP_RANGE_SUCCESS;
    @JvmField
    @NotNull
    public static final Parcelable.Creator<FacebookRequestError> CREATOR;
    public static final Companion Companion;

    @Nullable
    public final String getErrorMessage() {
        String string = this.errorMessage;
        if (string == null) {
            FacebookException facebookException = this.exception;
            string = facebookException != null ? facebookException.getLocalizedMessage() : null;
        }
        return string;
    }

    @Nullable
    public final FacebookException getException() {
        return this.exception;
    }

    @NotNull
    public final Category getCategory() {
        return this.category;
    }

    @Nullable
    public final String getErrorRecoveryMessage() {
        return this.errorRecoveryMessage;
    }

    @NotNull
    public String toString() {
        String string = "{HttpStatus: " + this.requestStatusCode + ", errorCode: " + this.errorCode + ", subErrorCode: " + this.subErrorCode + ", errorType: " + this.errorType + ", errorMessage: " + this.getErrorMessage() + "}";
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder(\"{HttpStat\u2026(\"}\")\n        .toString()");
        return string;
    }

    public void writeToParcel(@NotNull Parcel out, int flags) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeInt(this.requestStatusCode);
        out.writeInt(this.errorCode);
        out.writeInt(this.subErrorCode);
        out.writeString(this.errorType);
        out.writeString(this.getErrorMessage());
        out.writeString(this.errorUserTitle);
        out.writeString(this.errorUserMessage);
    }

    public int describeContents() {
        return 0;
    }

    public final int getRequestStatusCode() {
        return this.requestStatusCode;
    }

    public final int getErrorCode() {
        return this.errorCode;
    }

    public final int getSubErrorCode() {
        return this.subErrorCode;
    }

    @Nullable
    public final String getErrorType() {
        return this.errorType;
    }

    @Nullable
    public final String getErrorUserTitle() {
        return this.errorUserTitle;
    }

    @Nullable
    public final String getErrorUserMessage() {
        return this.errorUserMessage;
    }

    @Nullable
    public final JSONObject getRequestResultBody() {
        return this.requestResultBody;
    }

    @Nullable
    public final JSONObject getRequestResult() {
        return this.requestResult;
    }

    @Nullable
    public final Object getBatchRequestResult() {
        return this.batchRequestResult;
    }

    @Nullable
    public final HttpURLConnection getConnection() {
        return this.connection;
    }

    private FacebookRequestError(int requestStatusCode, int errorCode, int subErrorCode, String errorType, String errorMessageField, String errorUserTitle, String errorUserMessage, JSONObject requestResultBody, JSONObject requestResult, Object batchRequestResult, HttpURLConnection connection, FacebookException exceptionField, boolean errorIsTransient) {
        this.requestStatusCode = requestStatusCode;
        this.errorCode = errorCode;
        this.subErrorCode = subErrorCode;
        this.errorType = errorType;
        this.errorUserTitle = errorUserTitle;
        this.errorUserMessage = errorUserMessage;
        this.requestResultBody = requestResultBody;
        this.requestResult = requestResult;
        this.batchRequestResult = batchRequestResult;
        this.connection = connection;
        this.errorMessage = errorMessageField;
        boolean isLocalException = false;
        if (exceptionField != null) {
            this.exception = exceptionField;
            isLocalException = true;
        } else {
            this.exception = new FacebookServiceException(this, this.getErrorMessage());
        }
        this.category = isLocalException ? Category.OTHER : Companion.getErrorClassification().classify(this.errorCode, this.subErrorCode, errorIsTransient);
        this.errorRecoveryMessage = Companion.getErrorClassification().getRecoveryMessage(this.category);
    }

    @VisibleForTesting(otherwise=4)
    public FacebookRequestError(@Nullable HttpURLConnection connection, @Nullable Exception exception) {
        this(-1, -1, -1, null, null, null, null, null, null, null, connection, exception instanceof FacebookException ? (FacebookException)exception : new FacebookException(exception), false);
    }

    public FacebookRequestError(int errorCode, @Nullable String errorType, @Nullable String errorMessage) {
        this(-1, errorCode, -1, errorType, errorMessage, null, null, null, null, null, null, null, false);
    }

    private FacebookRequestError(Parcel parcel) {
        this(parcel.readInt(), parcel.readInt(), parcel.readInt(), parcel.readString(), parcel.readString(), parcel.readString(), parcel.readString(), null, null, null, null, null, false);
    }

    static {
        Companion = new Companion(null);
        HTTP_RANGE_SUCCESS = new Range(200, 299);
        CREATOR = (Parcelable.Creator)new Parcelable.Creator<FacebookRequestError>(){

            @NotNull
            public FacebookRequestError createFromParcel(@NotNull Parcel parcel) {
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                return new FacebookRequestError(parcel, null);
            }

            @NotNull
            public FacebookRequestError[] newArray(int size) {
                return new FacebookRequestError[size];
            }
        };
    }

    public /* synthetic */ FacebookRequestError(int requestStatusCode, int errorCode, int subErrorCode, String errorType, String errorMessageField, String errorUserTitle, String errorUserMessage, JSONObject requestResultBody, JSONObject requestResult, Object batchRequestResult, HttpURLConnection connection, FacebookException exceptionField, boolean errorIsTransient, DefaultConstructorMarker $constructor_marker) {
        this(requestStatusCode, errorCode, subErrorCode, errorType, errorMessageField, errorUserTitle, errorUserMessage, requestResultBody, requestResult, batchRequestResult, connection, exceptionField, errorIsTransient);
    }

    public /* synthetic */ FacebookRequestError(Parcel parcel, DefaultConstructorMarker $constructor_marker) {
        this(parcel);
    }

    @JvmStatic
    @Nullable
    public static final FacebookRequestError checkResponseAndCreateError(@NotNull JSONObject singleResult, @Nullable Object batchResult, @Nullable HttpURLConnection connection) {
        return Companion.checkResponseAndCreateError(singleResult, batchResult, connection);
    }

    @JvmStatic
    @NotNull
    public static final synchronized FacebookRequestErrorClassification getErrorClassification() {
        return Companion.getErrorClassification();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0011\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0086\u0002R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/facebook/FacebookRequestError$Range;", "", "start", "", "end", "(II)V", "contains", "", "value", "facebook-core_release"})
    public static final class Range {
        private final int start;
        private final int end;

        public final boolean contains(int value) {
            int n = value;
            return this.start <= n && this.end >= n;
        }

        public Range(int start2, int end) {
            this.start = start2;
            this.end = end;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/facebook/FacebookRequestError$Category;", "", "(Ljava/lang/String;I)V", "LOGIN_RECOVERABLE", "OTHER", "TRANSIENT", "facebook-core_release"})
    public static final class Category
    extends Enum<Category> {
        public static final /* enum */ Category LOGIN_RECOVERABLE;
        public static final /* enum */ Category OTHER;
        public static final /* enum */ Category TRANSIENT;
        private static final /* synthetic */ Category[] $VALUES;

        static {
            Category[] categoryArray = new Category[3];
            Category[] categoryArray2 = categoryArray;
            categoryArray[0] = LOGIN_RECOVERABLE = new Category();
            categoryArray[1] = OTHER = new Category();
            categoryArray[2] = TRANSIENT = new Category();
            $VALUES = categoryArray;
        }

        public static Category[] values() {
            return (Category[])$VALUES.clone();
        }

        public static Category valueOf(String string) {
            return Enum.valueOf(Category.class, string);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u001f\u001a\u0004\u0018\u00010\b2\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u00012\b\u0010#\u001a\u0004\u0018\u00010$H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001b\u001a\u00020\u001c8G\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006%"}, d2={"Lcom/facebook/FacebookRequestError$Companion;", "", "()V", "BODY_KEY", "", "CODE_KEY", "CREATOR", "Landroid/os/Parcelable$Creator;", "Lcom/facebook/FacebookRequestError;", "ERROR_CODE_FIELD_KEY", "ERROR_CODE_KEY", "ERROR_IS_TRANSIENT_KEY", "ERROR_KEY", "ERROR_MESSAGE_FIELD_KEY", "ERROR_MSG_KEY", "ERROR_REASON_KEY", "ERROR_SUB_CODE_KEY", "ERROR_TYPE_FIELD_KEY", "ERROR_USER_MSG_KEY", "ERROR_USER_TITLE_KEY", "HTTP_RANGE_SUCCESS", "Lcom/facebook/FacebookRequestError$Range;", "getHTTP_RANGE_SUCCESS", "()Lcom/facebook/FacebookRequestError$Range;", "INVALID_ERROR_CODE", "", "INVALID_HTTP_STATUS_CODE", "errorClassification", "Lcom/facebook/internal/FacebookRequestErrorClassification;", "getErrorClassification", "()Lcom/facebook/internal/FacebookRequestErrorClassification;", "checkResponseAndCreateError", "singleResult", "Lorg/json/JSONObject;", "batchResult", "connection", "Ljava/net/HttpURLConnection;", "facebook-core_release"})
    public static final class Companion {
        @NotNull
        public final Range getHTTP_RANGE_SUCCESS() {
            return HTTP_RANGE_SUCCESS;
        }

        @JvmStatic
        @Nullable
        public final FacebookRequestError checkResponseAndCreateError(@NotNull JSONObject singleResult, @Nullable Object batchResult, @Nullable HttpURLConnection connection) {
            Intrinsics.checkNotNullParameter((Object)singleResult, (String)"singleResult");
            try {
                if (singleResult.has("code")) {
                    int responseCode = singleResult.getInt("code");
                    Object body = Utility.getStringPropertyAsJSON(singleResult, FacebookRequestError.BODY_KEY, "FACEBOOK_NON_JSON_RESULT");
                    if (body != null && body instanceof JSONObject) {
                        Object jsonBody = body;
                        String errorType = null;
                        String errorMessage = null;
                        String errorUserMessage = null;
                        String errorUserTitle = null;
                        boolean errorIsTransient = false;
                        int errorCode = -1;
                        int errorSubCode = -1;
                        boolean hasError = false;
                        if (((JSONObject)jsonBody).has(FacebookRequestError.ERROR_KEY)) {
                            JSONObject error;
                            JSONObject jSONObject = error = (JSONObject)Utility.getStringPropertyAsJSON((JSONObject)jsonBody, FacebookRequestError.ERROR_KEY, null);
                            errorType = jSONObject != null ? jSONObject.optString(FacebookRequestError.ERROR_TYPE_FIELD_KEY, null) : null;
                            JSONObject jSONObject2 = error;
                            errorMessage = jSONObject2 != null ? jSONObject2.optString(FacebookRequestError.ERROR_MESSAGE_FIELD_KEY, null) : null;
                            JSONObject jSONObject3 = error;
                            errorCode = jSONObject3 != null ? jSONObject3.optInt("code", -1) : -1;
                            JSONObject jSONObject4 = error;
                            errorSubCode = jSONObject4 != null ? jSONObject4.optInt(FacebookRequestError.ERROR_SUB_CODE_KEY, -1) : -1;
                            JSONObject jSONObject5 = error;
                            errorUserMessage = jSONObject5 != null ? jSONObject5.optString(FacebookRequestError.ERROR_USER_MSG_KEY, null) : null;
                            JSONObject jSONObject6 = error;
                            errorUserTitle = jSONObject6 != null ? jSONObject6.optString(FacebookRequestError.ERROR_USER_TITLE_KEY, null) : null;
                            JSONObject jSONObject7 = error;
                            errorIsTransient = jSONObject7 != null ? jSONObject7.optBoolean(FacebookRequestError.ERROR_IS_TRANSIENT_KEY, false) : false;
                            hasError = true;
                        } else if (((JSONObject)jsonBody).has(FacebookRequestError.ERROR_CODE_KEY) || ((JSONObject)jsonBody).has(FacebookRequestError.ERROR_MSG_KEY) || ((JSONObject)jsonBody).has(FacebookRequestError.ERROR_REASON_KEY)) {
                            errorType = ((JSONObject)jsonBody).optString(FacebookRequestError.ERROR_REASON_KEY, null);
                            errorMessage = ((JSONObject)jsonBody).optString(FacebookRequestError.ERROR_MSG_KEY, null);
                            errorCode = ((JSONObject)jsonBody).optInt(FacebookRequestError.ERROR_CODE_KEY, -1);
                            errorSubCode = ((JSONObject)jsonBody).optInt(FacebookRequestError.ERROR_SUB_CODE_KEY, -1);
                            hasError = true;
                        }
                        if (hasError) {
                            return new FacebookRequestError(responseCode, errorCode, errorSubCode, errorType, errorMessage, errorUserTitle, errorUserMessage, (JSONObject)jsonBody, singleResult, batchResult, connection, null, errorIsTransient, null);
                        }
                    }
                    if (!this.getHTTP_RANGE_SUCCESS().contains(responseCode)) {
                        return new FacebookRequestError(responseCode, -1, -1, null, null, null, null, singleResult.has(FacebookRequestError.BODY_KEY) ? (JSONObject)Utility.getStringPropertyAsJSON(singleResult, FacebookRequestError.BODY_KEY, "FACEBOOK_NON_JSON_RESULT") : null, singleResult, batchResult, connection, null, false, null);
                    }
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return null;
        }

        @JvmStatic
        @NotNull
        public final synchronized FacebookRequestErrorClassification getErrorClassification() {
            FetchedAppSettings fetchedAppSettings = FetchedAppSettingsManager.getAppSettingsWithoutQuery(FacebookSdk.getApplicationId());
            if (fetchedAppSettings == null) {
                return FacebookRequestErrorClassification.Companion.getDefaultErrorClassification();
            }
            FetchedAppSettings appSettings = fetchedAppSettings;
            return appSettings.getErrorClassification();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

