/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcel;
import android.os.StatFs;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import android.view.autofill.AutofillManager;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import com.facebook.AccessToken;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.GraphResponse;
import com.facebook.HttpMethod;
import com.facebook.appevents.UserDataStore;
import com.facebook.internal.AttributionIdentifiers;
import com.facebook.internal.ImageDownloader;
import com.facebook.internal.ProfileInformationCache;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ce\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u00c6\u0002\u0018\u00002\u00020\u0001:\b\u00e6\u0001\u00e7\u0001\u00e8\u0001\u00e9\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010'\u001a\u00020\u001e\"\u0004\b\u0000\u0010(2\b\u0010)\u001a\u0004\u0018\u0001H(2\b\u0010*\u001a\u0004\u0018\u0001H(H\u0007\u00a2\u0006\u0002\u0010+J7\u0010,\u001a\u0012\u0012\u0004\u0012\u0002H(0-j\b\u0012\u0004\u0012\u0002H(`.\"\u0004\b\u0000\u0010(2\u0012\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u0002H(00\"\u0002H(H\u0007\u00a2\u0006\u0002\u00101J-\u00102\u001a\b\u0012\u0004\u0012\u0002H(03\"\u0004\b\u0000\u0010(2\u0012\u00104\u001a\n\u0012\u0006\b\u0001\u0012\u0002H(00\"\u0002H(H\u0007\u00a2\u0006\u0002\u00105J\u0012\u00106\u001a\u0004\u0018\u00010\u00182\u0006\u00107\u001a\u00020\u0004H\u0007J&\u00108\u001a\u0002092\b\u0010:\u001a\u0004\u0018\u00010\u00042\b\u0010;\u001a\u0004\u0018\u00010\u00042\b\u0010<\u001a\u0004\u0018\u00010=H\u0007J\b\u0010>\u001a\u00020?H\u0007J\u0018\u0010@\u001a\u00020?2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020\u0004H\u0002J\u0010\u0010D\u001a\u00020?2\u0006\u0010A\u001a\u00020BH\u0007J\u0012\u0010E\u001a\u00020?2\b\u0010F\u001a\u0004\u0018\u00010GH\u0007J\u001e\u0010H\u001a\u0004\u0018\u00010\u00042\b\u0010I\u001a\u0004\u0018\u00010\u00042\b\u0010J\u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u0010K\u001a\u00020\u00112\u0006\u0010L\u001a\u00020MH\u0002J\u0016\u0010N\u001a\b\u0012\u0004\u0012\u00020\u0004032\u0006\u0010O\u001a\u00020PH\u0007J\u001c\u0010Q\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010R2\u0006\u0010S\u001a\u00020\u0018H\u0007J\u001c\u0010T\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040R2\u0006\u0010S\u001a\u00020\u0018H\u0007J\u001a\u0010U\u001a\u00020\u00062\b\u0010V\u001a\u0004\u0018\u00010W2\u0006\u0010X\u001a\u00020YH\u0007J\u0012\u0010Z\u001a\u00020?2\b\u0010[\u001a\u0004\u0018\u00010\\H\u0007J\u0012\u0010]\u001a\u00020?2\b\u0010^\u001a\u0004\u0018\u00010_H\u0007J\b\u0010`\u001a\u00020\u001eH\u0002J4\u0010a\u001a\n\u0012\u0004\u0012\u0002H(\u0018\u000103\"\u0004\b\u0000\u0010(2\u000e\u0010b\u001a\n\u0012\u0004\u0012\u0002H(\u0018\u0001032\f\u0010c\u001a\b\u0012\u0004\u0012\u0002H(0dH\u0007J\u0010\u0010e\u001a\u00020\u00042\u0006\u0010f\u001a\u00020\u0006H\u0007J\u0012\u0010g\u001a\u00020\u00042\b\u0010A\u001a\u0004\u0018\u00010BH\u0007J\u0010\u0010h\u001a\u00020\u00042\u0006\u0010A\u001a\u00020BH\u0007J\n\u0010i\u001a\u0004\u0018\u00010\u0004H\u0007J&\u0010j\u001a\u0004\u0018\u00010k2\b\u0010l\u001a\u0004\u0018\u00010=2\b\u0010m\u001a\u0004\u0018\u00010\u00042\u0006\u0010n\u001a\u00020kH\u0007J\u0010\u0010o\u001a\u00020\u00112\u0006\u0010p\u001a\u000209H\u0007J\u0010\u0010q\u001a\u00020r2\u0006\u00107\u001a\u00020\u0004H\u0002J\u0018\u0010s\u001a\u00020?2\u0006\u00107\u001a\u00020\u00042\u0006\u0010t\u001a\u00020uH\u0007J\u0012\u0010v\u001a\u00020\u00042\b\u0010A\u001a\u0004\u0018\u00010BH\u0007JC\u0010w\u001a\u0004\u0018\u00010x2\n\u0010y\u001a\u0006\u0012\u0002\b\u00030z2\u0006\u0010{\u001a\u00020\u00042\u001e\u0010|\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0002\b\u0003\u0018\u00010z00\"\b\u0012\u0002\b\u0003\u0018\u00010zH\u0007\u00a2\u0006\u0002\u0010}J?\u0010w\u001a\u0004\u0018\u00010x2\u0006\u0010~\u001a\u00020\u00042\u0006\u0010{\u001a\u00020\u00042\u001e\u0010|\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0002\b\u0003\u0018\u00010z00\"\b\u0012\u0002\b\u0003\u0018\u00010zH\u0007\u00a2\u0006\u0002\u0010\u007fJ(\u0010\u0080\u0001\u001a\u0004\u0018\u00010\u00012\u0006\u0010S\u001a\u00020\u00182\b\u0010m\u001a\u0004\u0018\u00010\u00042\t\u0010\u0081\u0001\u001a\u0004\u0018\u00010\u0004H\u0007J\u0016\u0010\u0082\u0001\u001a\u0004\u0018\u00010\u00042\t\u0010\u0083\u0001\u001a\u0004\u0018\u000109H\u0007J\u0013\u0010\u0084\u0001\u001a\u00030\u0085\u00012\u0007\u0010\u0086\u0001\u001a\u00020\u0018H\u0007J\u001d\u0010\u0087\u0001\u001a\u00020\u001e2\b\u0010)\u001a\u0004\u0018\u00010\u00182\b\u0010*\u001a\u0004\u0018\u00010\u0018H\u0007J\u001c\u0010\u0088\u0001\u001a\u00020\u00042\b\u0010\u0089\u0001\u001a\u00030\u008a\u00012\u0007\u0010L\u001a\u00030\u008b\u0001H\u0002J;\u0010\u008c\u0001\u001a\u0014\u0012\u0004\u0012\u0002H(0\u008d\u0001j\t\u0012\u0004\u0012\u0002H(`\u008e\u0001\"\u0004\b\u0000\u0010(2\u0012\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u0002H(00\"\u0002H(H\u0007\u00a2\u0006\u0003\u0010\u008f\u0001J\u001d\u0010\u0090\u0001\u001a\u0004\u0018\u00010\u00042\u0007\u0010\u0091\u0001\u001a\u00020\u00042\u0007\u0010L\u001a\u00030\u008b\u0001H\u0002J\u001c\u0010\u0090\u0001\u001a\u0004\u0018\u00010\u00042\u0007\u0010\u0091\u0001\u001a\u00020\u00042\u0006\u0010m\u001a\u00020\u0004H\u0002J$\u0010\u0092\u0001\u001a\u0005\u0018\u00010\u0093\u00012\n\u0010\u0094\u0001\u001a\u0005\u0018\u00010\u0093\u00012\n\u0010\u0095\u0001\u001a\u0005\u0018\u00010\u0093\u0001H\u0007J>\u0010\u0096\u0001\u001a\u0004\u0018\u00010\u00012\t\u0010\u0097\u0001\u001a\u0004\u0018\u00010\u00012\u0007\u0010\u0098\u0001\u001a\u00020x2\u0017\u0010\u0099\u0001\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000100\"\u0004\u0018\u00010\u0001H\u0007\u00a2\u0006\u0003\u0010\u009a\u0001J\u0011\u0010\u009b\u0001\u001a\u00020\u001e2\u0006\u0010A\u001a\u00020BH\u0007J\u0011\u0010\u009c\u0001\u001a\u00020\u001e2\u0006\u0010A\u001a\u00020BH\u0007J\u0014\u0010\u009d\u0001\u001a\u00020\u001e2\t\u0010\u0083\u0001\u001a\u0004\u0018\u000109H\u0007J\u0015\u0010\u009e\u0001\u001a\u00020\u001e2\n\u0010\u009f\u0001\u001a\u0005\u0018\u00010\u00a0\u0001H\u0007J\u0014\u0010\u00a1\u0001\u001a\u00020\u001e2\t\u0010\u0083\u0001\u001a\u0004\u0018\u000109H\u0007J\u0013\u0010\u00a2\u0001\u001a\u00020\u001e2\b\u0010I\u001a\u0004\u0018\u00010\u0004H\u0007J!\u0010\u00a2\u0001\u001a\u00020\u001e\"\u0004\b\u0000\u0010(2\u0010\u0010\u00a3\u0001\u001a\u000b\u0012\u0004\u0012\u0002H(\u0018\u00010\u00a4\u0001H\u0007J3\u0010\u00a5\u0001\u001a\u00020\u001e\"\u0004\b\u0000\u0010(2\u0010\u0010\u00a6\u0001\u001a\u000b\u0012\u0004\u0012\u0002H(\u0018\u00010\u00a4\u00012\u0010\u0010\u00a7\u0001\u001a\u000b\u0012\u0004\u0012\u0002H(\u0018\u00010\u00a4\u0001H\u0007J\u0014\u0010\u00a8\u0001\u001a\u00020\u001e2\t\u0010\u0083\u0001\u001a\u0004\u0018\u000109H\u0007J\u0018\u0010\u00a9\u0001\u001a\t\u0012\u0004\u0012\u00020\u00040\u00aa\u00012\u0006\u0010O\u001a\u00020PH\u0007J\u0017\u0010\u00ab\u0001\u001a\b\u0012\u0004\u0012\u00020\u0004032\u0006\u0010O\u001a\u00020PH\u0007J\u001e\u0010\u00ac\u0001\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040R2\u0007\u0010\u00ad\u0001\u001a\u00020\u0004H\u0007J'\u0010\u00ae\u0001\u001a\u00020?2\t\u0010\u00af\u0001\u001a\u0004\u0018\u00010\u00042\u0011\u0010\u00b0\u0001\u001a\f\u0018\u00010\u00b1\u0001j\u0005\u0018\u0001`\u00b2\u0001H\u0007J\u001f\u0010\u00ae\u0001\u001a\u00020?2\t\u0010\u00af\u0001\u001a\u0004\u0018\u00010\u00042\t\u0010\u00b3\u0001\u001a\u0004\u0018\u00010\u0004H\u0007J+\u0010\u00ae\u0001\u001a\u00020?2\t\u0010\u00af\u0001\u001a\u0004\u0018\u00010\u00042\t\u0010\u00b3\u0001\u001a\u0004\u0018\u00010\u00042\n\u0010\u00b4\u0001\u001a\u0005\u0018\u00010\u00b5\u0001H\u0007JF\u0010\u00b6\u0001\u001a\u000b\u0012\u0005\u0012\u0003H\u00b7\u0001\u0018\u000103\"\u0004\b\u0000\u0010(\"\u0005\b\u0001\u0010\u00b7\u00012\u000e\u0010b\u001a\n\u0012\u0004\u0012\u0002H(\u0018\u0001032\u0015\u0010\u00b8\u0001\u001a\u0010\u0012\u0004\u0012\u0002H(\u0012\u0005\u0012\u0003H\u00b7\u00010\u00b9\u0001H\u0007J\"\u0010\u00ba\u0001\u001a\u00020\u00042\u0017\u0010\u00b6\u0001\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040RH\u0007J\u0013\u0010\u00bb\u0001\u001a\u0004\u0018\u00010\u00042\u0006\u0010m\u001a\u00020\u0004H\u0007J\u0011\u0010\u00bc\u0001\u001a\u00020\u001e2\u0006\u0010A\u001a\u00020BH\u0007J\u0014\u0010\u00bd\u0001\u001a\u00020=2\t\u0010\u00be\u0001\u001a\u0004\u0018\u00010\u0004H\u0007J.\u0010\u00bf\u0001\u001a\u00020?2\u0006\u0010*\u001a\u00020=2\b\u0010m\u001a\u0004\u0018\u00010\u00042\u0011\u0010\u00c0\u0001\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u000103H\u0007J&\u0010\u00c1\u0001\u001a\u00020\u001e2\u0006\u0010l\u001a\u00020=2\b\u0010m\u001a\u0004\u0018\u00010\u00042\t\u0010\u00c2\u0001\u001a\u0004\u0018\u00010\u0001H\u0007J&\u0010\u00c3\u0001\u001a\u00020?2\u0006\u0010*\u001a\u00020=2\b\u0010m\u001a\u0004\u0018\u00010\u00042\t\u0010\u00c2\u0001\u001a\u0004\u0018\u00010\u0004H\u0007J&\u0010\u00c4\u0001\u001a\u00020?2\u0006\u0010*\u001a\u00020=2\b\u0010m\u001a\u0004\u0018\u00010\u00042\t\u0010\u0083\u0001\u001a\u0004\u0018\u000109H\u0007J\u0013\u0010\u00c5\u0001\u001a\u00020\u00042\b\u0010V\u001a\u0004\u0018\u00010WH\u0007J%\u0010\u00c6\u0001\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010R2\b\u0010\u00c7\u0001\u001a\u00030\u00c8\u0001H\u0007J\t\u0010\u00c9\u0001\u001a\u00020?H\u0002J\t\u0010\u00ca\u0001\u001a\u00020\u0006H\u0002J\u0012\u0010\u00cb\u0001\u001a\u00020?2\u0007\u0010\u00cc\u0001\u001a\u00020BH\u0002J\u0012\u0010\u00cd\u0001\u001a\u00020?2\u0007\u0010\u00cc\u0001\u001a\u00020BH\u0002J\t\u0010\u00ce\u0001\u001a\u00020?H\u0002J\t\u0010\u00cf\u0001\u001a\u00020?H\u0002J\u0015\u0010\u00d0\u0001\u001a\u00020?2\n\u0010\u00d1\u0001\u001a\u0005\u0018\u00010\u00d2\u0001H\u0007J\u001f\u0010\u00d3\u0001\u001a\u00020\u00042\t\u0010\u00d4\u0001\u001a\u0004\u0018\u00010\u00182\t\u0010\u00d5\u0001\u001a\u0004\u0018\u00010\u0004H\u0007J2\u0010\u00d6\u0001\u001a\u00020?2\u0007\u0010\u00d7\u0001\u001a\u00020\u00182\n\u0010\u00d8\u0001\u001a\u0005\u0018\u00010\u00d9\u00012\t\u0010\u00da\u0001\u001a\u0004\u0018\u00010\u00042\u0007\u0010\u00db\u0001\u001a\u00020\u001eH\u0007J\u001b\u0010\u00dc\u0001\u001a\u00020?2\u0007\u0010\u00d7\u0001\u001a\u00020\u00182\u0007\u0010\u00cc\u0001\u001a\u00020BH\u0007J\u0014\u0010\u00dd\u0001\u001a\u0004\u0018\u00010\u00042\u0007\u0010L\u001a\u00030\u008b\u0001H\u0007J\u0013\u0010\u00dd\u0001\u001a\u0004\u0018\u00010\u00042\u0006\u0010m\u001a\u00020\u0004H\u0007J\u0016\u0010\u00de\u0001\u001a\u0004\u0018\u00010\u00042\t\u0010L\u001a\u0005\u0018\u00010\u008b\u0001H\u0007J\u0015\u0010\u00de\u0001\u001a\u0004\u0018\u00010\u00042\b\u0010m\u001a\u0004\u0018\u00010\u0004H\u0007J\u001d\u0010\u00df\u0001\u001a\u00020\u001e2\b\u0010)\u001a\u0004\u0018\u00010\u00042\b\u0010*\u001a\u0004\u0018\u00010\u0004H\u0007J!\u0010\u00e0\u0001\u001a\u0004\u0018\u00010P2\t\u0010\u00d4\u0001\u001a\u0004\u0018\u00010\u00182\t\u0010\u00e1\u0001\u001a\u0004\u0018\u00010\u0004H\u0007J!\u0010\u00e2\u0001\u001a\u0004\u0018\u00010\u00182\t\u0010\u00d4\u0001\u001a\u0004\u0018\u00010\u00182\t\u0010\u00e1\u0001\u001a\u0004\u0018\u00010\u0004H\u0007J0\u0010\u00e3\u0001\u001a\t\u0012\u0004\u0012\u0002H(0\u00a4\u0001\"\u0004\b\u0000\u0010(2\u0012\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u0002H(00\"\u0002H(H\u0007\u00a2\u0006\u0003\u0010\u00e4\u0001J.\u0010\u00e5\u0001\u001a\u00020?2\b\u0010\u00c7\u0001\u001a\u00030\u00c8\u00012\u0019\u0010\u00b6\u0001\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010RH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u00148G\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u00188G\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u00020\u001e8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001f\u0010\u0002\u001a\u0004\b\u001d\u0010 R\u0011\u0010!\u001a\u00020\u001e8G\u00a2\u0006\u0006\u001a\u0004\b!\u0010 R\u000e\u0010\"\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010#\u001a\u0004\u0018\u00010\u00148G\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0016R\u000e\u0010%\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00ea\u0001"}, d2={"Lcom/facebook/internal/Utility;", "", "()V", "ARC_DEVICE_PATTERN", "", "DEFAULT_STREAM_BUFFER_SIZE", "", "EXTRA_APP_EVENTS_INFO_FORMAT_VERSION", "HASH_ALGORITHM_MD5", "HASH_ALGORITHM_SHA1", "HASH_ALGORITHM_SHA256", "LOG_TAG", "NO_CARRIER", "REFRESH_TIME_FOR_EXTENDED_DEVICE_INFO_MILLIS", "URL_SCHEME", "UTF8", "availableExternalStorageGB", "", "carrierName", "currentLocale", "Ljava/util/Locale;", "getCurrentLocale", "()Ljava/util/Locale;", "dataProcessingOptions", "Lorg/json/JSONObject;", "getDataProcessingOptions", "()Lorg/json/JSONObject;", "deviceTimeZoneName", "deviceTimezoneAbbreviation", "isAutoAppLinkSetup", "", "isAutoAppLinkSetup$annotations", "()Z", "isDataProcessingRestricted", "numCPUCores", "resourceLocale", "getResourceLocale", "timestampOfLastCheck", "totalExternalStorageGB", "areObjectsEqual", "T", "a", "b", "(Ljava/lang/Object;Ljava/lang/Object;)Z", "arrayList", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "ts", "", "([Ljava/lang/Object;)Ljava/util/ArrayList;", "asListNoNulls", "", "array", "([Ljava/lang/Object;)Ljava/util/List;", "awaitGetGraphMeRequestWithCache", "accessToken", "buildUri", "Landroid/net/Uri;", "authority", "path", "parameters", "Landroid/os/Bundle;", "clearCaches", "", "clearCookiesForDomain", "context", "Landroid/content/Context;", "domain", "clearFacebookCookies", "closeQuietly", "closeable", "Ljava/io/Closeable;", "coerceValueIfNullOrEmpty", "s", "valueIfNullOrEmpty", "convertBytesToGB", "bytes", "", "convertJSONArrayToList", "jsonArray", "Lorg/json/JSONArray;", "convertJSONObjectToHashMap", "", "jsonObject", "convertJSONObjectToStringMap", "copyAndCloseInputStream", "inputStream", "Ljava/io/InputStream;", "outputStream", "Ljava/io/OutputStream;", "deleteDirectory", "directoryOrFile", "Ljava/io/File;", "disconnectQuietly", "connection", "Ljava/net/URLConnection;", "externalStorageExists", "filter", "target", "predicate", "Lcom/facebook/internal/Utility$Predicate;", "generateRandomString", "length", "getActivityName", "getAppName", "getAppVersion", "getBundleLongAsDate", "Ljava/util/Date;", "bundle", "key", "dateBase", "getContentSize", "contentUri", "getGraphMeRequestWithCache", "Lcom/facebook/GraphRequest;", "getGraphMeRequestWithCacheAsync", "callback", "Lcom/facebook/internal/Utility$GraphMeRequestWithCacheCallback;", "getMetadataApplicationId", "getMethodQuietly", "Ljava/lang/reflect/Method;", "clazz", "Ljava/lang/Class;", "methodName", "parameterTypes", "(Ljava/lang/Class;Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;", "className", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;", "getStringPropertyAsJSON", "nonJSONPropertyKey", "getUriString", "uri", "handlePermissionResponse", "Lcom/facebook/internal/Utility$PermissionsLists;", "result", "hasSameId", "hashBytes", "hash", "Ljava/security/MessageDigest;", "", "hashSet", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "([Ljava/lang/Object;)Ljava/util/HashSet;", "hashWithAlgorithm", "algorithm", "intersectRanges", "", "range1", "range2", "invokeMethodQuietly", "receiver", "method", "args", "(Ljava/lang/Object;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;", "isAutofillAvailable", "isChromeOS", "isContentUri", "isCurrentAccessToken", "token", "Lcom/facebook/AccessToken;", "isFileUri", "isNullOrEmpty", "c", "", "isSubset", "subset", "superset", "isWebUri", "jsonArrayToSet", "", "jsonArrayToStringList", "jsonStrToMap", "str", "logd", "tag", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "msg", "t", "", "map", "K", "mapper", "Lcom/facebook/internal/Utility$Mapper;", "mapToJsonStr", "md5hash", "mustFixWindowParamsForAutofill", "parseUrlQueryString", "queryString", "putCommaSeparatedStringList", "list", "putJSONValueInBundle", "value", "putNonEmptyString", "putUri", "readStreamToString", "readStringMapFromParcel", "parcel", "Landroid/os/Parcel;", "refreshAvailableExternalStorage", "refreshBestGuessNumberOfCPUCores", "refreshCarrierName", "appContext", "refreshPeriodicExtendedDeviceInfo", "refreshTimezone", "refreshTotalExternalStorage", "runOnNonUiThread", "runnable", "Ljava/lang/Runnable;", "safeGetStringFromResponse", "response", "propertyName", "setAppEventAttributionParameters", "params", "attributionIdentifiers", "Lcom/facebook/internal/AttributionIdentifiers;", "anonymousAppDeviceGUID", "limitEventUsage", "setAppEventExtendedDeviceInfoParameters", "sha1hash", "sha256hash", "stringsEqualOrEmpty", "tryGetJSONArrayFromResponse", "propertyKey", "tryGetJSONObjectFromResponse", "unmodifiableCollection", "([Ljava/lang/Object;)Ljava/util/Collection;", "writeStringMapToParcel", "GraphMeRequestWithCacheCallback", "Mapper", "PermissionsLists", "Predicate", "facebook-core_release"})
public final class Utility {
    @NotNull
    public static final String LOG_TAG = "FacebookSDK";
    private static final String HASH_ALGORITHM_MD5 = "MD5";
    private static final String HASH_ALGORITHM_SHA1 = "SHA-1";
    private static final String HASH_ALGORITHM_SHA256 = "SHA-256";
    private static final String URL_SCHEME = "https";
    private static final String EXTRA_APP_EVENTS_INFO_FORMAT_VERSION = "a2";
    private static final String UTF8 = "UTF-8";
    public static final int DEFAULT_STREAM_BUFFER_SIZE = 8192;
    private static final int REFRESH_TIME_FOR_EXTENDED_DEVICE_INFO_MILLIS = 1800000;
    private static final String NO_CARRIER = "NoCarrier";
    private static int numCPUCores;
    private static long timestampOfLastCheck;
    private static long totalExternalStorageGB;
    private static long availableExternalStorageGB;
    private static String deviceTimezoneAbbreviation;
    private static String deviceTimeZoneName;
    private static String carrierName;
    private static final String ARC_DEVICE_PATTERN = ".+_cheets|cheets_.+";
    public static final Utility INSTANCE;

    @JvmStatic
    @Nullable
    public static final int[] intersectRanges(@Nullable int[] range1, @Nullable int[] range2) {
        if (range1 == null) {
            return range2;
        }
        if (range2 == null) {
            return range1;
        }
        int[] outputRange = new int[range1.length + range2.length];
        int outputIndex = 0;
        int index1 = 0;
        int lower1 = 0;
        int upper1 = 0;
        int index2 = 0;
        int lower2 = 0;
        int upper2 = 0;
        while (index1 < range1.length && index2 < range2.length) {
            int newRangeLower = Integer.MIN_VALUE;
            int newRangeUpper = Integer.MAX_VALUE;
            lower1 = range1[index1];
            upper1 = Integer.MAX_VALUE;
            lower2 = range2[index2];
            upper2 = Integer.MAX_VALUE;
            if (index1 < range1.length - 1) {
                upper1 = range1[index1 + 1];
            }
            if (index2 < range2.length - 1) {
                upper2 = range2[index2 + 1];
            }
            if (lower1 < lower2) {
                if (upper1 > lower2) {
                    newRangeLower = lower2;
                    if (upper1 > upper2) {
                        newRangeUpper = upper2;
                        index2 += 2;
                    } else {
                        newRangeUpper = upper1;
                        index1 += 2;
                    }
                } else {
                    index1 += 2;
                }
            } else if (upper2 > lower1) {
                newRangeLower = lower1;
                if (upper2 > upper1) {
                    newRangeUpper = upper1;
                    index1 += 2;
                } else {
                    newRangeUpper = upper2;
                    index2 += 2;
                }
            } else {
                index2 += 2;
            }
            if (newRangeLower == Integer.MIN_VALUE) continue;
            outputRange[outputIndex++] = newRangeLower;
            if (newRangeUpper == Integer.MAX_VALUE) break;
            outputRange[outputIndex++] = newRangeUpper;
        }
        return Arrays.copyOf(outputRange, outputIndex);
    }

    @JvmStatic
    public static final <T> boolean isSubset(@Nullable Collection<? extends T> subset, @Nullable Collection<? extends T> superset) {
        if (superset == null || superset.isEmpty()) {
            return subset == null || subset.isEmpty();
        }
        HashSet<T> hash = new HashSet<T>(superset);
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        boolean bl3 = false;
        if (subset == null) {
            boolean bl4 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        for (T t : subset) {
            if (hash.contains(t)) continue;
            return false;
        }
        return true;
    }

    @JvmStatic
    public static final <T> boolean isNullOrEmpty(@Nullable Collection<? extends T> c) {
        return c == null || c.isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean isNullOrEmpty(@Nullable String s) {
        if (s == null) return true;
        CharSequence charSequence = s;
        boolean bl = false;
        if (charSequence.length() != 0) return false;
        return true;
    }

    @JvmStatic
    @Nullable
    public static final String coerceValueIfNullOrEmpty(@Nullable String s, @Nullable String valueIfNullOrEmpty) {
        return Utility.isNullOrEmpty(s) ? valueIfNullOrEmpty : s;
    }

    @JvmStatic
    @NotNull
    public static final <T> Collection<T> unmodifiableCollection(T ... ts) {
        Intrinsics.checkNotNullParameter(ts, (String)"ts");
        Collection collection = Collections.unmodifiableCollection((Collection)Arrays.asList(Arrays.copyOf(ts, ts.length)));
        Intrinsics.checkNotNullExpressionValue(collection, (String)"Collections.unmodifiable\u2026ction(Arrays.asList(*ts))");
        return collection;
    }

    @JvmStatic
    @NotNull
    public static final <T> ArrayList<T> arrayList(T ... ts) {
        Intrinsics.checkNotNullParameter(ts, (String)"ts");
        ArrayList<T> arrayList = new ArrayList<T>(ts.length);
        for (T t : ts) {
            arrayList.add(t);
        }
        return arrayList;
    }

    @JvmStatic
    @NotNull
    public static final <T> HashSet<T> hashSet(T ... ts) {
        Intrinsics.checkNotNullParameter(ts, (String)"ts");
        HashSet<T> hashSet = new HashSet<T>(ts.length);
        for (T t : ts) {
            hashSet.add(t);
        }
        return hashSet;
    }

    @JvmStatic
    @Nullable
    public static final String md5hash(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return INSTANCE.hashWithAlgorithm(HASH_ALGORITHM_MD5, key);
    }

    @JvmStatic
    @Nullable
    public static final String sha1hash(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return INSTANCE.hashWithAlgorithm(HASH_ALGORITHM_SHA1, key);
    }

    @JvmStatic
    @Nullable
    public static final String sha1hash(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        return INSTANCE.hashWithAlgorithm(HASH_ALGORITHM_SHA1, bytes);
    }

    @JvmStatic
    @Nullable
    public static final String sha256hash(@Nullable String key) {
        return key == null ? null : INSTANCE.hashWithAlgorithm(HASH_ALGORITHM_SHA256, key);
    }

    @JvmStatic
    @Nullable
    public static final String sha256hash(@Nullable byte[] bytes) {
        return bytes == null ? null : INSTANCE.hashWithAlgorithm(HASH_ALGORITHM_SHA256, bytes);
    }

    private final String hashWithAlgorithm(String algorithm, String key) {
        String string = key;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return this.hashWithAlgorithm(algorithm, byArray);
    }

    private final String hashWithAlgorithm(String algorithm, byte[] bytes) {
        MessageDigest hash;
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        MessageDigest messageDigest2 = hash = messageDigest;
        Intrinsics.checkNotNullExpressionValue((Object)messageDigest2, (String)"hash");
        return this.hashBytes(messageDigest2, bytes);
    }

    private final String hashBytes(MessageDigest hash, byte[] bytes) {
        hash.update(bytes);
        byte[] digest = hash.digest();
        StringBuilder builder = new StringBuilder();
        for (byte b : digest) {
            builder.append(Integer.toHexString(b >> 4 & 0xF));
            builder.append(Integer.toHexString(b >> 0 & 0xF));
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final Uri buildUri(@Nullable String authority, @Nullable String path, @Nullable Bundle parameters) {
        Uri.Builder builder = new Uri.Builder();
        builder.scheme(URL_SCHEME);
        builder.authority(authority);
        builder.path(path);
        if (parameters != null) {
            for (String key : parameters.keySet()) {
                Object parameter = parameters.get(key);
                if (!(parameter instanceof String)) continue;
                builder.appendQueryParameter(key, (String)parameter);
            }
        }
        Uri uri = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"builder.build()");
        return uri;
    }

    @JvmStatic
    @NotNull
    public static final Bundle parseUrlQueryString(@Nullable String queryString) {
        Bundle params = new Bundle();
        if (!Utility.isNullOrEmpty(queryString)) {
            String[] array;
            boolean bl = false;
            int n = 0;
            n = 0;
            boolean bl2 = false;
            if (queryString == null) {
                boolean bl3 = false;
                String string = "Required value was null.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)queryString, (String[])new String[]{"&"}, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            for (String parameter : array = stringArray) {
                Collection $this$toTypedArray$iv2 = StringsKt.split$default((CharSequence)parameter, (String[])new String[]{"="}, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$toTypedArray2 = false;
                Collection thisCollection$iv2 = $this$toTypedArray$iv2;
                if (thisCollection$iv2.toArray(new String[0]) == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                try {
                    String[] keyValuePair;
                    if (keyValuePair.length == 2) {
                        params.putString(URLDecoder.decode(keyValuePair[0], UTF8), URLDecoder.decode(keyValuePair[1], UTF8));
                        continue;
                    }
                    if (keyValuePair.length != 1) continue;
                    params.putString(URLDecoder.decode(keyValuePair[0], UTF8), "");
                }
                catch (UnsupportedEncodingException e) {
                    Utility.logd(LOG_TAG, e);
                }
            }
        }
        return params;
    }

    @JvmStatic
    public static final void putNonEmptyString(@NotNull Bundle b, @Nullable String key, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (!Utility.isNullOrEmpty(value)) {
            b.putString(key, value);
        }
    }

    @JvmStatic
    public static final void putCommaSeparatedStringList(@NotNull Bundle b, @Nullable String key, @Nullable List<String> list) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (list != null) {
            StringBuilder builder = new StringBuilder();
            for (String string : list) {
                builder.append(string);
                builder.append(",");
            }
            String commaSeparated = "";
            CharSequence charSequence = builder;
            boolean bl = false;
            if (charSequence.length() > 0) {
                commaSeparated = builder.substring(0, builder.length() - 1);
            }
            b.putString(key, commaSeparated);
        }
    }

    @JvmStatic
    public static final void putUri(@NotNull Bundle b, @Nullable String key, @Nullable Uri uri) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (uri != null) {
            Utility.putNonEmptyString(b, key, uri.toString());
        }
    }

    @JvmStatic
    public static final boolean putJSONValueInBundle(@NotNull Bundle bundle, @Nullable String key, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        if (value == null) {
            bundle.remove(key);
        } else if (value instanceof Boolean) {
            bundle.putBoolean(key, ((Boolean)value).booleanValue());
        } else if (value instanceof boolean[]) {
            bundle.putBooleanArray(key, (boolean[])value);
        } else if (value instanceof Double) {
            bundle.putDouble(key, ((Number)value).doubleValue());
        } else if (value instanceof double[]) {
            bundle.putDoubleArray(key, (double[])value);
        } else if (value instanceof Integer) {
            bundle.putInt(key, ((Number)value).intValue());
        } else if (value instanceof int[]) {
            bundle.putIntArray(key, (int[])value);
        } else if (value instanceof Long) {
            bundle.putLong(key, ((Number)value).longValue());
        } else if (value instanceof long[]) {
            bundle.putLongArray(key, (long[])value);
        } else if (value instanceof String) {
            bundle.putString(key, (String)value);
        } else if (value instanceof JSONArray) {
            bundle.putString(key, value.toString());
        } else if (value instanceof JSONObject) {
            bundle.putString(key, value.toString());
        } else {
            return false;
        }
        return true;
    }

    @JvmStatic
    public static final void closeQuietly(@Nullable Closeable closeable) {
        try {
            Closeable closeable2 = closeable;
            if (closeable2 != null) {
                closeable2.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @JvmStatic
    public static final void disconnectQuietly(@Nullable URLConnection connection) {
        if (connection != null && connection instanceof HttpURLConnection) {
            ((HttpURLConnection)connection).disconnect();
        }
    }

    @JvmStatic
    @NotNull
    public static final String getMetadataApplicationId(@Nullable Context context) {
        Validate.notNull(context, "context");
        String string = FacebookSdk.getApplicationId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FacebookSdk.getApplicationId()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Map<String, Object> convertJSONObjectToHashMap(@NotNull JSONObject jsonObject) {
        Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
        HashMap map = new HashMap();
        JSONArray keys = jsonObject.names();
        int n = 0;
        int n2 = keys.length();
        while (n < n2) {
            void i;
            String key = null;
            try {
                String string = keys.getString((int)i);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"keys.getString(i)");
                key = string;
                Map<String, Object> value = jsonObject.get(key);
                if (value instanceof JSONObject) {
                    value = Utility.convertJSONObjectToHashMap((JSONObject)value);
                }
                Map map2 = map;
                Map<String, Object> map3 = value;
                Intrinsics.checkNotNullExpressionValue(map3, (String)"value");
                map2.put(key, map3);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            ++i;
        }
        return map;
    }

    @JvmStatic
    @NotNull
    public static final Map<String, String> convertJSONObjectToStringMap(@NotNull JSONObject jsonObject) {
        Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
        HashMap map = new HashMap();
        Iterator keys = jsonObject.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String value = jsonObject.optString(key);
            if (value == null) continue;
            Map map2 = map;
            String string = key;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"key");
            map2.put(string, value);
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<String> convertJSONArrayToList(@NotNull JSONArray jsonArray) {
        List list;
        Intrinsics.checkNotNullParameter((Object)jsonArray, (String)"jsonArray");
        try {
            List result = new ArrayList();
            int n = 0;
            int n2 = jsonArray.length();
            while (n < n2) {
                void i;
                String string = jsonArray.getString((int)i);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonArray.getString(i)");
                result.add(string);
                ++i;
            }
        }
        catch (JSONException je) {
            list = new ArrayList();
        }
        return list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    @Nullable
    public static final Object getStringPropertyAsJSON(@NotNull JSONObject jsonObject, @Nullable String key, @Nullable String nonJSONPropertyKey) throws JSONException {
        Object object;
        Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
        JSONObject jsonObject2 = jsonObject;
        Object value = jsonObject2.opt(key);
        if (value != null && value instanceof String) {
            JSONTokener tokener = new JSONTokener((String)value);
            value = tokener.nextValue();
        }
        if (value != null && !(value instanceof JSONObject) && !(value instanceof JSONArray)) {
            if (nonJSONPropertyKey == null) throw (Throwable)new FacebookException("Got an unexpected non-JSON object.");
            jsonObject2 = new JSONObject();
            jsonObject2.putOpt(nonJSONPropertyKey, value);
            object = jsonObject2;
            return object;
        } else {
            object = value;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final String readStreamToString(@Nullable InputStream inputStream) throws IOException {
        String string;
        BufferedInputStream bufferedInputStream = null;
        InputStreamReader reader = null;
        try {
            bufferedInputStream = new BufferedInputStream(inputStream);
            reader = new InputStreamReader(bufferedInputStream);
            StringBuilder stringBuilder = new StringBuilder();
            int bufferSize = 2048;
            char[] buffer = new char[bufferSize];
            int n = 0;
            while (true) {
                int n2 = reader.read(buffer);
                boolean bl = false;
                boolean bl2 = false;
                int it = n2;
                boolean bl3 = false;
                n = it;
                if (n2 == -1) break;
                stringBuilder.append(buffer, 0, n);
            }
            String string2 = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"stringBuilder.toString()");
            string = string2;
        }
        finally {
            Utility.closeQuietly(bufferedInputStream);
            Utility.closeQuietly(reader);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JvmStatic
    public static final int copyAndCloseInputStream(@Nullable InputStream inputStream, @NotNull OutputStream outputStream) throws IOException {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        BufferedInputStream bufferedInputStream = null;
        int totalBytes = 0;
        try {
            bufferedInputStream = new BufferedInputStream(inputStream);
            byte[] buffer = new byte[8192];
            int bytesRead = 0;
            while (true) {
                int n = bufferedInputStream.read(buffer);
                boolean bl = false;
                boolean bl2 = false;
                int it = n;
                boolean bl3 = false;
                bytesRead = it;
                if (n != -1) {
                    outputStream.write(buffer, 0, bytesRead);
                    totalBytes += bytesRead;
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            BufferedInputStream bufferedInputStream2 = bufferedInputStream;
            if (bufferedInputStream2 != null) {
                bufferedInputStream2.close();
            }
            InputStream inputStream2 = inputStream;
            if (inputStream2 == null) throw throwable;
            inputStream2.close();
            throw throwable;
        }
        bufferedInputStream.close();
        InputStream inputStream3 = inputStream;
        if (inputStream3 == null) return totalBytes;
        inputStream3.close();
        return totalBytes;
    }

    @JvmStatic
    public static final boolean stringsEqualOrEmpty(@Nullable String a, @Nullable String b) {
        boolean bEmpty;
        CharSequence charSequence = a;
        boolean bl = false;
        boolean bl2 = false;
        boolean aEmpty = charSequence == null || charSequence.length() == 0;
        CharSequence charSequence2 = b;
        bl2 = false;
        boolean bl3 = false;
        boolean bl4 = bEmpty = charSequence2 == null || charSequence2.length() == 0;
        if (aEmpty && bEmpty) {
            return true;
        }
        return !aEmpty && !bEmpty ? Intrinsics.areEqual((Object)a, (Object)b) : false;
    }

    /*
     * WARNING - void declaration
     */
    private final void clearCookiesForDomain(Context context, String domain) {
        String[] splitCookies;
        CookieSyncManager syncManager = CookieSyncManager.createInstance((Context)context);
        syncManager.sync();
        CookieManager cookieManager = CookieManager.getInstance();
        String string = cookieManager.getCookie(domain);
        if (string == null) {
            return;
        }
        String cookies = string;
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)cookies, (String[])new String[]{";"}, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        for (String cookie : splitCookies = stringArray) {
            void $this$trim$iv;
            String[] cookieParts;
            Collection $this$toTypedArray$iv2 = StringsKt.split$default((CharSequence)cookie, (String[])new String[]{"="}, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$toTypedArray22 = false;
            Collection thisCollection$iv2 = $this$toTypedArray$iv2;
            if (thisCollection$iv2.toArray(new String[0]) == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            if (cookieParts.length <= 0) continue;
            String $i$f$toTypedArray22 = cookieParts[0];
            StringBuilder stringBuilder = new StringBuilder();
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            String string2 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            String newCookie = stringBuilder.append(string2).append("=;expires=Sat, 1 Jan 2000 00:00:01 UTC;").toString();
            cookieManager.setCookie(domain, newCookie);
        }
        cookieManager.removeExpiredCookie();
    }

    @JvmStatic
    public static final void clearFacebookCookies(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        INSTANCE.clearCookiesForDomain(context, "facebook.com");
        INSTANCE.clearCookiesForDomain(context, ".facebook.com");
        INSTANCE.clearCookiesForDomain(context, "https://facebook.com");
        INSTANCE.clearCookiesForDomain(context, "https://.facebook.com");
    }

    @JvmStatic
    public static final void logd(@Nullable String tag, @Nullable Exception e) {
        if (FacebookSdk.isDebugEnabled() && tag != null && e != null) {
            Log.d((String)tag, (String)(e.getClass().getSimpleName() + ": " + e.getMessage()));
        }
    }

    @JvmStatic
    public static final void logd(@Nullable String tag, @Nullable String msg) {
        if (FacebookSdk.isDebugEnabled() && tag != null && msg != null) {
            Log.d((String)tag, (String)msg);
        }
    }

    @JvmStatic
    public static final void logd(@Nullable String tag, @Nullable String msg, @Nullable Throwable t) {
        if (FacebookSdk.isDebugEnabled() && !Utility.isNullOrEmpty(tag)) {
            Log.d((String)tag, (String)msg, (Throwable)t);
        }
    }

    @JvmStatic
    public static final <T> boolean areObjectsEqual(@Nullable T a, @Nullable T b) {
        return a == null ? b == null : Intrinsics.areEqual(a, b);
    }

    @JvmStatic
    public static final boolean hasSameId(@Nullable JSONObject a, @Nullable JSONObject b) {
        if (a == null || b == null || !a.has("id") || !b.has("id")) {
            return false;
        }
        if (Intrinsics.areEqual((Object)a, (Object)b)) {
            return true;
        }
        String idA = a.optString("id");
        String idB = b.optString("id");
        return idA == null || idB == null ? false : Intrinsics.areEqual((Object)idA, (Object)idB);
    }

    @JvmStatic
    @NotNull
    public static final String safeGetStringFromResponse(@Nullable JSONObject response, @Nullable String propertyName) {
        String string;
        if (response != null) {
            String string2 = response.optString(propertyName, "");
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"response.optString(propertyName, \"\")");
        } else {
            string = "";
        }
        return string;
    }

    @JvmStatic
    @Nullable
    public static final JSONObject tryGetJSONObjectFromResponse(@Nullable JSONObject response, @Nullable String propertyKey) {
        JSONObject jSONObject = response;
        return jSONObject != null ? jSONObject.optJSONObject(propertyKey) : null;
    }

    @JvmStatic
    @Nullable
    public static final JSONArray tryGetJSONArrayFromResponse(@Nullable JSONObject response, @Nullable String propertyKey) {
        JSONObject jSONObject = response;
        return jSONObject != null ? jSONObject.optJSONArray(propertyKey) : null;
    }

    @JvmStatic
    public static final void clearCaches() {
        ImageDownloader.clearCache();
    }

    @JvmStatic
    public static final void deleteDirectory(@Nullable File directoryOrFile) {
        File[] children;
        if (directoryOrFile == null || !directoryOrFile.exists()) {
            return;
        }
        if (directoryOrFile.isDirectory() && (children = directoryOrFile.listFiles()) != null) {
            for (File child : children) {
                Utility.deleteDirectory(child);
            }
        }
        directoryOrFile.delete();
    }

    @JvmStatic
    @NotNull
    public static final <T> List<T> asListNoNulls(T ... array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        ArrayList<T> result = new ArrayList<T>();
        for (T t : array) {
            if (t == null) continue;
            result.add(t);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<String> jsonArrayToStringList(@NotNull JSONArray jsonArray) throws JSONException {
        Intrinsics.checkNotNullParameter((Object)jsonArray, (String)"jsonArray");
        ArrayList<String> result = new ArrayList<String>();
        int n = 0;
        int n2 = jsonArray.length();
        while (n < n2) {
            void i;
            result.add(jsonArray.getString((int)i));
            ++i;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Set<String> jsonArrayToSet(@NotNull JSONArray jsonArray) throws JSONException {
        Intrinsics.checkNotNullParameter((Object)jsonArray, (String)"jsonArray");
        Set result = new HashSet();
        int n = 0;
        int n2 = jsonArray.length();
        while (n < n2) {
            void i;
            String string = jsonArray.getString((int)i);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonArray.getString(i)");
            result.add(string);
            ++i;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final String mapToJsonStr(@NotNull Map<String, String> map) {
        String string;
        Intrinsics.checkNotNullParameter(map, (String)"map");
        if (map.isEmpty()) {
            string = "";
        } else {
            String string2;
            try {
                JSONObject jsonObject = new JSONObject();
                Object object = map;
                boolean bl = false;
                Iterator<Map.Entry<String, String>> iterator = object.entrySet().iterator();
                while (iterator.hasNext()) {
                    void key;
                    Map.Entry<String, String> entry;
                    Map.Entry<String, String> entry2 = entry = iterator.next();
                    boolean bl2 = false;
                    object = entry2.getKey();
                    entry2 = entry;
                    bl2 = false;
                    String value = entry2.getValue();
                    jsonObject.put((String)key, (Object)value);
                }
                string2 = jsonObject.toString();
            }
            catch (JSONException _e) {
                string2 = "";
            }
            String string3 = string2;
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"try {\n        val jsonOb\u2026ion) {\n        \"\"\n      }");
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final Map<String, String> jsonStrToMap(@NotNull String str) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        Object object2 = str;
        boolean bl = false;
        if (object2.length() == 0) {
            object = new HashMap();
        } else {
            try {
                Map map = new HashMap();
                JSONObject jsonObject = new JSONObject(str);
                Iterator keys = jsonObject.keys();
                while (keys.hasNext()) {
                    String key;
                    String string = key = (String)keys.next();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"key");
                    String string2 = jsonObject.getString(key);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"jsonObject.getString(key)");
                    map.put(string, string2);
                }
            }
            catch (JSONException _e) {
                object2 = new HashMap();
            }
            object = object2;
        }
        return object;
    }

    @JvmStatic
    public static final void setAppEventAttributionParameters(@NotNull JSONObject params, @Nullable AttributionIdentifiers attributionIdentifiers, @Nullable String anonymousAppDeviceGUID, boolean limitEventUsage) throws JSONException {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        params.put("anon_id", (Object)anonymousAppDeviceGUID);
        params.put("application_tracking_enabled", !limitEventUsage);
        params.put("advertiser_id_collection_enabled", FacebookSdk.getAdvertiserIDCollectionEnabled());
        if (attributionIdentifiers != null) {
            if (attributionIdentifiers.getAttributionId() != null) {
                params.put("attribution", (Object)attributionIdentifiers.getAttributionId());
            }
            if (attributionIdentifiers.getAndroidAdvertiserId() != null) {
                params.put("advertiser_id", (Object)attributionIdentifiers.getAndroidAdvertiserId());
                params.put("advertiser_tracking_enabled", !attributionIdentifiers.isTrackingLimited());
            }
            if (!attributionIdentifiers.isTrackingLimited()) {
                String userData;
                String string = userData = UserDataStore.getAllHashedUserData();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"userData");
                CharSequence charSequence = string;
                boolean bl = false;
                if (!(charSequence.length() == 0)) {
                    params.put("ud", (Object)userData);
                }
            }
            if (attributionIdentifiers.getAndroidInstallerPackage() != null) {
                params.put("installer_package", (Object)attributionIdentifiers.getAndroidInstallerPackage());
            }
        }
    }

    @JvmStatic
    @Nullable
    public static final String getAppVersion() {
        Context context = FacebookSdk.getApplicationContext();
        if (context == null) {
            return null;
        }
        Context context2 = context;
        String pkgName = context2.getPackageName();
        try {
            PackageInfo packageInfo = context2.getPackageManager().getPackageInfo(pkgName, 0);
            if (packageInfo == null) {
                return null;
            }
            PackageInfo pi = packageInfo;
            return pi.versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    @JvmStatic
    public static final void setAppEventExtendedDeviceInfoParameters(@NotNull JSONObject params, @NotNull Context appContext) throws JSONException {
        Locale locale;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        JSONArray extraInfoArray = new JSONArray();
        extraInfoArray.put((Object)EXTRA_APP_EVENTS_INFO_FORMAT_VERSION);
        INSTANCE.refreshPeriodicExtendedDeviceInfo(appContext);
        String pkgName = appContext.getPackageName();
        int versionCode = -1;
        String versionName = "";
        try {
            PackageInfo packageInfo = appContext.getPackageManager().getPackageInfo(pkgName, 0);
            if (packageInfo == null) {
                return;
            }
            PackageInfo pi = packageInfo;
            versionCode = pi.versionCode;
            versionName = pi.versionName;
        }
        catch (PackageManager.NameNotFoundException pi) {
            // empty catch block
        }
        extraInfoArray.put((Object)pkgName);
        extraInfoArray.put(versionCode);
        extraInfoArray.put((Object)versionName);
        extraInfoArray.put((Object)Build.VERSION.RELEASE);
        extraInfoArray.put((Object)Build.MODEL);
        try {
            Resources resources = appContext.getResources();
            Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"appContext.resources");
            locale = resources.getConfiguration().locale;
        }
        catch (Exception e) {
            locale = Locale.getDefault();
        }
        Locale locale2 = locale;
        StringBuilder stringBuilder = new StringBuilder();
        Locale locale3 = locale2;
        Intrinsics.checkNotNullExpressionValue((Object)locale3, (String)"locale");
        extraInfoArray.put((Object)stringBuilder.append(locale3.getLanguage()).append("_").append(locale2.getCountry()).toString());
        extraInfoArray.put((Object)deviceTimezoneAbbreviation);
        extraInfoArray.put((Object)carrierName);
        int width = 0;
        int height = 0;
        double density = 0.0;
        try {
            Object object = appContext.getSystemService("window");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
            }
            WindowManager wm = (WindowManager)object;
            if (wm != null) {
                Display display = wm.getDefaultDisplay();
                DisplayMetrics displayMetrics = new DisplayMetrics();
                display.getMetrics(displayMetrics);
                width = displayMetrics.widthPixels;
                height = displayMetrics.heightPixels;
                density = displayMetrics.density;
            }
        }
        catch (Exception wm) {
            // empty catch block
        }
        extraInfoArray.put(width);
        extraInfoArray.put(height);
        DecimalFormat df = new DecimalFormat("#.##");
        extraInfoArray.put((Object)df.format(density));
        extraInfoArray.put(INSTANCE.refreshBestGuessNumberOfCPUCores());
        extraInfoArray.put(totalExternalStorageGB);
        extraInfoArray.put(availableExternalStorageGB);
        extraInfoArray.put((Object)deviceTimeZoneName);
        params.put("extinfo", (Object)extraInfoArray.toString());
    }

    @JvmStatic
    @Nullable
    public static final Method getMethodQuietly(@NotNull Class<?> clazz, @NotNull String methodName, Class<?> ... parameterTypes) {
        Method method;
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter(parameterTypes, (String)"parameterTypes");
        try {
            method = clazz.getMethod(methodName, Arrays.copyOf(parameterTypes, parameterTypes.length));
        }
        catch (NoSuchMethodException ex) {
            method = null;
        }
        return method;
    }

    @JvmStatic
    @Nullable
    public static final Method getMethodQuietly(@NotNull String className, @NotNull String methodName, Class<?> ... parameterTypes) {
        Method method;
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter(parameterTypes, (String)"parameterTypes");
        try {
            Class<?> clazz = Class.forName(className);
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"Class.forName(className)");
            Class<?> clazz2 = clazz;
            method = Utility.getMethodQuietly(clazz2, methodName, Arrays.copyOf(parameterTypes, parameterTypes.length));
        }
        catch (ClassNotFoundException ex) {
            method = null;
        }
        return method;
    }

    @JvmStatic
    @Nullable
    public static final Object invokeMethodQuietly(@Nullable Object receiver, @NotNull Method method, Object ... args) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        try {
            object = method.invoke(receiver, Arrays.copyOf(args, args.length));
        }
        catch (IllegalAccessException ex) {
            object = null;
        }
        catch (InvocationTargetException ex) {
            object = null;
        }
        return object;
    }

    @JvmStatic
    @NotNull
    public static final String getActivityName(@Nullable Context context) {
        String string;
        if (context == null) {
            string = "null";
        } else if (context == context.getApplicationContext()) {
            string = "unknown";
        } else {
            String string2 = context.getClass().getSimpleName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.javaClass.simpleName");
        }
        return string;
    }

    @JvmStatic
    @Nullable
    public static final <T> List<T> filter(@Nullable List<? extends T> target, @NotNull Predicate<T> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        if (target == null) {
            return null;
        }
        List list = new ArrayList();
        for (T item : target) {
            if (!predicate.apply(item)) continue;
            list.add(item);
        }
        return list.size() == 0 ? null : list;
    }

    @JvmStatic
    @Nullable
    public static final <T, K> List<K> map(@Nullable List<? extends T> target, @NotNull Mapper<T, K> mapper) {
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        if (target == null) {
            return null;
        }
        List list = new ArrayList();
        for (T item : target) {
            K mappedItem = mapper.apply(item);
            if (mappedItem == null) continue;
            list.add(mappedItem);
        }
        return list.size() == 0 ? null : list;
    }

    @JvmStatic
    @Nullable
    public static final String getUriString(@Nullable Uri uri) {
        Uri uri2 = uri;
        return uri2 != null ? uri2.toString() : null;
    }

    @JvmStatic
    public static final boolean isWebUri(@Nullable Uri uri) {
        return uri != null && (StringsKt.equals((String)"http", (String)uri.getScheme(), (boolean)true) || StringsKt.equals((String)URL_SCHEME, (String)uri.getScheme(), (boolean)true) || StringsKt.equals((String)"fbstaging", (String)uri.getScheme(), (boolean)true));
    }

    @JvmStatic
    public static final boolean isContentUri(@Nullable Uri uri) {
        return uri != null && StringsKt.equals((String)"content", (String)uri.getScheme(), (boolean)true);
    }

    @JvmStatic
    public static final boolean isFileUri(@Nullable Uri uri) {
        return uri != null && StringsKt.equals((String)"file", (String)uri.getScheme(), (boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final long getContentSize(@NotNull Uri contentUri) {
        Cursor cursor;
        block4: {
            Intrinsics.checkNotNullParameter((Object)contentUri, (String)"contentUri");
            cursor = null;
            try {
                Context context = FacebookSdk.getApplicationContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"FacebookSdk.getApplicationContext()");
                cursor = context.getContentResolver().query(contentUri, null, null, null, null);
                if (cursor != null) break block4;
                long l = 0L;
                return l;
            }
            catch (Throwable throwable) {
                Cursor cursor2 = cursor;
                if (cursor2 != null) {
                    cursor2.close();
                }
                throw throwable;
            }
        }
        int sizeIndex = cursor.getColumnIndex("_size");
        cursor.moveToFirst();
        long l = cursor.getLong(sizeIndex);
        cursor.close();
        return l;
    }

    @JvmStatic
    @Nullable
    public static final Date getBundleLongAsDate(@Nullable Bundle bundle, @Nullable String key, @NotNull Date dateBase) {
        Intrinsics.checkNotNullParameter((Object)dateBase, (String)"dateBase");
        if (bundle == null) {
            return null;
        }
        long secondsFromBase = 0L;
        Object secondsObject = bundle.get(key);
        if (secondsObject instanceof Long) {
            secondsFromBase = ((Number)secondsObject).longValue();
        } else if (secondsObject instanceof String) {
            try {
                String string = (String)secondsObject;
                boolean bl = false;
                secondsFromBase = Long.parseLong(string);
            }
            catch (NumberFormatException e) {
                return null;
            }
        } else {
            return null;
        }
        return secondsFromBase == 0L ? new Date(Long.MAX_VALUE) : new Date(dateBase.getTime() + secondsFromBase * 1000L);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void writeStringMapToParcel(@NotNull Parcel parcel, @Nullable Map<String, String> map) {
        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
        if (map == null) {
            parcel.writeInt(-1);
        } else {
            parcel.writeInt(map.size());
            Object object = map;
            boolean bl = false;
            Iterator<Map.Entry<String, String>> iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                void key;
                Map.Entry<String, String> entry;
                Map.Entry<String, String> entry2 = entry = iterator.next();
                boolean bl2 = false;
                object = entry2.getKey();
                entry2 = entry;
                bl2 = false;
                String value = entry2.getValue();
                parcel.writeString((String)key);
                parcel.writeString(value);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final Map<String, String> readStringMapFromParcel(@NotNull Parcel parcel) {
        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
        int size = parcel.readInt();
        if (size < 0) {
            return null;
        }
        Map map = new HashMap();
        int n = 0;
        int n2 = size;
        while (n < n2) {
            void i;
            map.put(parcel.readString(), parcel.readString());
            ++i;
        }
        return map;
    }

    @JvmStatic
    public static final boolean isCurrentAccessToken(@Nullable AccessToken token) {
        return token != null && Intrinsics.areEqual((Object)token, (Object)AccessToken.Companion.getCurrentAccessToken());
    }

    @JvmStatic
    public static final void getGraphMeRequestWithCacheAsync(@NotNull String accessToken, @NotNull GraphMeRequestWithCacheCallback callback2) {
        Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        JSONObject cachedValue = ProfileInformationCache.getProfileInformation(accessToken);
        if (cachedValue != null) {
            callback2.onSuccess(cachedValue);
            return;
        }
        GraphRequest.Callback graphCallback2 = new GraphRequest.Callback(callback2, accessToken){
            final /* synthetic */ GraphMeRequestWithCacheCallback $callback;
            final /* synthetic */ String $accessToken;

            public final void onCompleted(@NotNull GraphResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                if (response.getError() != null) {
                    this.$callback.onFailure(response.getError().getException());
                } else {
                    JSONObject jSONObject = response.getJsonObject();
                    boolean bl = false;
                    boolean bl2 = false;
                    bl2 = false;
                    boolean bl3 = false;
                    if (jSONObject == null) {
                        boolean bl4 = false;
                        String string = "Required value was null.";
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    ProfileInformationCache.putProfileInformation(this.$accessToken, jSONObject);
                    this.$callback.onSuccess(response.getJsonObject());
                }
            }
            {
                this.$callback = graphMeRequestWithCacheCallback;
                this.$accessToken = string;
            }
        };
        GraphRequest graphRequest = INSTANCE.getGraphMeRequestWithCache(accessToken);
        graphRequest.setCallback(graphCallback2);
        graphRequest.executeAsync();
    }

    @JvmStatic
    @Nullable
    public static final JSONObject awaitGetGraphMeRequestWithCache(@NotNull String accessToken) {
        Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
        JSONObject cachedValue = ProfileInformationCache.getProfileInformation(accessToken);
        if (cachedValue != null) {
            return cachedValue;
        }
        GraphRequest graphRequest = INSTANCE.getGraphMeRequestWithCache(accessToken);
        GraphResponse response = graphRequest.executeAndWait();
        return response.getError() != null ? null : response.getJsonObject();
    }

    private final GraphRequest getGraphMeRequestWithCache(String accessToken) {
        Bundle parameters = new Bundle();
        parameters.putString("fields", "id,name,first_name,middle_name,last_name");
        parameters.putString("access_token", accessToken);
        return new GraphRequest(null, "me", parameters, HttpMethod.GET, null, null, 32, null);
    }

    private final int refreshBestGuessNumberOfCPUCores() {
        if (numCPUCores > 0) {
            return numCPUCores;
        }
        try {
            File cpuDir = new File("/sys/devices/system/cpu/");
            File[] cpuFiles2 = cpuDir.listFiles(refreshBestGuessNumberOfCPUCores.cpuFiles.1.INSTANCE);
            if (cpuFiles2 != null) {
                numCPUCores = cpuFiles2.length;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (numCPUCores <= 0) {
            numCPUCores = Math.max(Runtime.getRuntime().availableProcessors(), 1);
        }
        return numCPUCores;
    }

    private final void refreshPeriodicExtendedDeviceInfo(Context appContext) {
        if (timestampOfLastCheck == -1L || System.currentTimeMillis() - timestampOfLastCheck >= (long)1800000) {
            timestampOfLastCheck = System.currentTimeMillis();
            this.refreshTimezone();
            this.refreshCarrierName(appContext);
            this.refreshTotalExternalStorage();
            this.refreshAvailableExternalStorage();
        }
    }

    private final void refreshTimezone() {
        try {
            TimeZone tz = TimeZone.getDefault();
            String string = tz.getDisplayName(tz.inDaylightTime(new Date()), 0);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tz.getDisplayName(tz.inD\u2026(Date()), TimeZone.SHORT)");
            deviceTimezoneAbbreviation = string;
            TimeZone timeZone = tz;
            Intrinsics.checkNotNullExpressionValue((Object)timeZone, (String)"tz");
            String string2 = timeZone.getID();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"tz.id");
            deviceTimeZoneName = string2;
        }
        catch (AssertionError assertionError) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void refreshCarrierName(Context appContext) {
        if (Intrinsics.areEqual((Object)carrierName, (Object)NO_CARRIER)) {
            try {
                Object object = appContext.getSystemService("phone");
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.telephony.TelephonyManager");
                }
                TelephonyManager telephonyManager = (TelephonyManager)object;
                String string = telephonyManager.getNetworkOperatorName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"telephonyManager.networkOperatorName");
                carrierName = string;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private final boolean externalStorageExists() {
        return Intrinsics.areEqual((Object)"mounted", (Object)Environment.getExternalStorageState());
    }

    private final void refreshAvailableExternalStorage() {
        try {
            if (this.externalStorageExists()) {
                File path;
                File file = path = Environment.getExternalStorageDirectory();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"path");
                StatFs stat = new StatFs(file.getPath());
                availableExternalStorageGB = (long)stat.getAvailableBlocks() * (long)stat.getBlockSize();
            }
            availableExternalStorageGB = this.convertBytesToGB(availableExternalStorageGB);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void refreshTotalExternalStorage() {
        try {
            if (this.externalStorageExists()) {
                File path;
                File file = path = Environment.getExternalStorageDirectory();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"path");
                StatFs stat = new StatFs(file.getPath());
                totalExternalStorageGB = (long)stat.getBlockCount() * (long)stat.getBlockSize();
            }
            totalExternalStorageGB = this.convertBytesToGB(totalExternalStorageGB);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final long convertBytesToGB(double bytes) {
        return Math.round(bytes / 1.073741824E9);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final PermissionsLists handlePermissionResponse(@NotNull JSONObject result) throws JSONException {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        JSONObject permissions = result.getJSONObject("permissions");
        JSONArray data = permissions.getJSONArray("data");
        List grantedPermissions = new ArrayList(data.length());
        List declinedPermissions = new ArrayList(data.length());
        List expiredPermissions = new ArrayList(data.length());
        int n = 0;
        int n2 = data.length();
        while (n < n2) {
            void i;
            JSONObject obj = data.optJSONObject((int)i);
            String permission = obj.optString("permission");
            if (permission != null && !Intrinsics.areEqual((Object)permission, (Object)"installed")) {
                String status;
                if (obj.optString("status") == null) {
                } else if (Intrinsics.areEqual((Object)status, (Object)"granted")) {
                    grantedPermissions.add(permission);
                } else if (Intrinsics.areEqual((Object)status, (Object)"declined")) {
                    declinedPermissions.add(permission);
                } else if (Intrinsics.areEqual((Object)status, (Object)"expired")) {
                    expiredPermissions.add(permission);
                }
            }
            ++i;
        }
        return new PermissionsLists(grantedPermissions, declinedPermissions, expiredPermissions);
    }

    @JvmStatic
    @NotNull
    public static final String generateRandomString(int length) {
        Random r = new Random();
        String string = new BigInteger(length * 5, r).toString(32);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"BigInteger(length * 5, r).toString(32)");
        return string;
    }

    @JvmStatic
    public static final boolean mustFixWindowParamsForAutofill(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return Utility.isAutofillAvailable(context);
    }

    @JvmStatic
    public static final boolean isAutofillAvailable(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (Build.VERSION.SDK_INT < 26) {
            return false;
        }
        AutofillManager afm = (AutofillManager)context.getSystemService(AutofillManager.class);
        return afm != null && afm.isAutofillSupported() && afm.isEnabled();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean isChromeOS(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        boolean isChromeOS = false;
        if (Build.VERSION.SDK_INT < 27) {
            if (Build.DEVICE == null) return false;
            String string = Build.DEVICE;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Build.DEVICE");
            CharSequence charSequence = string;
            Regex regex = new Regex(ARC_DEVICE_PATTERN);
            boolean bl = false;
            if (!regex.matches(charSequence)) return false;
            return true;
        }
        boolean bl = context.getPackageManager().hasSystemFeature("android.hardware.type.pc");
        return bl;
    }

    @JvmStatic
    @Nullable
    public static final Locale getResourceLocale() {
        Locale locale;
        try {
            Context context = FacebookSdk.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"FacebookSdk.getApplicationContext()");
            Resources resources = context.getResources();
            Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"FacebookSdk.getApplicationContext().resources");
            locale = resources.getConfiguration().locale;
        }
        catch (Exception e) {
            locale = null;
        }
        return locale;
    }

    @JvmStatic
    @NotNull
    public static final Locale getCurrentLocale() {
        Locale locale = Utility.getResourceLocale();
        Locale locale2 = locale;
        if (locale2 == null) {
            Locale locale3 = Locale.getDefault();
            locale2 = locale3;
            Intrinsics.checkNotNullExpressionValue((Object)locale3, (String)"Locale.getDefault()");
        }
        return locale2;
    }

    @JvmStatic
    public static final void runOnNonUiThread(@Nullable Runnable runnable2) {
        try {
            FacebookSdk.getExecutor().execute(runnable2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @JvmStatic
    @NotNull
    public static final String getAppName(@NotNull Context context) {
        String string;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            String string2;
            String applicationName = FacebookSdk.getApplicationName();
            if (applicationName != null) {
                return applicationName;
            }
            ApplicationInfo applicationInfo = context.getApplicationInfo();
            int stringId = applicationInfo.labelRes;
            if (stringId == 0) {
                string2 = ((Object)applicationInfo.nonLocalizedLabel).toString();
            } else {
                String string3 = context.getString(stringId);
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"context.getString(stringId)");
            }
            string = string2;
        }
        catch (Exception e) {
            string = "";
        }
        return string;
    }

    @JvmStatic
    public static /* synthetic */ void isAutoAppLinkSetup$annotations() {
    }

    public static final boolean isAutoAppLinkSetup() {
        try {
            Context ctx;
            Intent intent = new Intent("android.intent.action.VIEW");
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "fb%s://applinks";
            Object[] objectArray = new Object[]{FacebookSdk.getApplicationId()};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            intent.setData(Uri.parse((String)string2));
            Context context = ctx = FacebookSdk.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"ctx");
            PackageManager packageManager = context.getPackageManager();
            String packageName = ctx.getPackageName();
            List activities = packageManager.queryIntentActivities(intent, 65536);
            for (ResolveInfo info : activities) {
                if (!Intrinsics.areEqual((Object)packageName, (Object)info.activityInfo.packageName)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @JvmStatic
    @Nullable
    public static final JSONObject getDataProcessingOptions() {
        if (CrashShieldHandler.isObjectCrashing(Utility.class)) {
            return null;
        }
        try {
            Context context = FacebookSdk.getApplicationContext();
            String data = context.getSharedPreferences("com.facebook.sdk.DataProcessingOptions", 0).getString("data_processing_options", null);
            if (data != null) {
                try {
                    return new JSONObject(data);
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
            return null;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Utility.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final boolean isDataProcessingRestricted() {
        if (CrashShieldHandler.isObjectCrashing(Utility.class)) {
            return false;
        }
        try {
            JSONObject jSONObject = Utility.getDataProcessingOptions();
            if (jSONObject == null) {
                return false;
            }
            JSONObject dataProcessingOptions = jSONObject;
            try {
                JSONArray options = dataProcessingOptions.getJSONArray("data_processing_options");
                int n = 0;
                int n2 = options.length();
                while (n < n2) {
                    String option;
                    String string;
                    void i;
                    Intrinsics.checkNotNullExpressionValue((Object)options.getString((int)i), (String)"options.getString(i)");
                    boolean bl = false;
                    String string2 = string;
                    if (string2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)string2.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
                    if (Intrinsics.areEqual((Object)option, (Object)"ldu")) {
                        return true;
                    }
                    ++i;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Utility.class);
            return false;
        }
    }

    private Utility() {
    }

    static {
        Utility utility;
        INSTANCE = utility = new Utility();
        timestampOfLastCheck = -1L;
        totalExternalStorageGB = -1L;
        availableExternalStorageGB = -1L;
        deviceTimezoneAbbreviation = "";
        deviceTimeZoneName = "";
        carrierName = NO_CARRIER;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\bf\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/facebook/internal/Utility$Predicate;", "T", "", "apply", "", "item", "(Ljava/lang/Object;)Z", "facebook-core_release"})
    public static interface Predicate<T> {
        public boolean apply(T var1);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\bf\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003J\u0015\u0010\u0004\u001a\u00028\u00012\u0006\u0010\u0005\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/facebook/internal/Utility$Mapper;", "T", "K", "", "apply", "item", "(Ljava/lang/Object;)Ljava/lang/Object;", "facebook-core_release"})
    public static interface Mapper<T, K> {
        public K apply(T var1);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&J\u0012\u0010\u0006\u001a\u00020\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\bH&\u00a8\u0006\t"}, d2={"Lcom/facebook/internal/Utility$GraphMeRequestWithCacheCallback;", "", "onFailure", "", "error", "Lcom/facebook/FacebookException;", "onSuccess", "userInfo", "Lorg/json/JSONObject;", "facebook-core_release"})
    public static interface GraphMeRequestWithCacheCallback {
        public void onSuccess(@Nullable JSONObject var1);

        public void onFailure(@Nullable FacebookException var1);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\f\u0018\u00002\u00020\u0001B/\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0007R \u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000bR \u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/facebook/internal/Utility$PermissionsLists;", "", "grantedPermissions", "", "", "declinedPermissions", "expiredPermissions", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getDeclinedPermissions", "()Ljava/util/List;", "setDeclinedPermissions", "(Ljava/util/List;)V", "getExpiredPermissions", "setExpiredPermissions", "getGrantedPermissions", "setGrantedPermissions", "facebook-core_release"})
    public static final class PermissionsLists {
        @NotNull
        private List<String> grantedPermissions;
        @NotNull
        private List<String> declinedPermissions;
        @NotNull
        private List<String> expiredPermissions;

        @NotNull
        public final List<String> getGrantedPermissions() {
            return this.grantedPermissions;
        }

        public final void setGrantedPermissions(@NotNull List<String> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.grantedPermissions = list;
        }

        @NotNull
        public final List<String> getDeclinedPermissions() {
            return this.declinedPermissions;
        }

        public final void setDeclinedPermissions(@NotNull List<String> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.declinedPermissions = list;
        }

        @NotNull
        public final List<String> getExpiredPermissions() {
            return this.expiredPermissions;
        }

        public final void setExpiredPermissions(@NotNull List<String> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.expiredPermissions = list;
        }

        public PermissionsLists(@NotNull List<String> grantedPermissions, @NotNull List<String> declinedPermissions, @NotNull List<String> expiredPermissions) {
            Intrinsics.checkNotNullParameter(grantedPermissions, (String)"grantedPermissions");
            Intrinsics.checkNotNullParameter(declinedPermissions, (String)"declinedPermissions");
            Intrinsics.checkNotNullParameter(expiredPermissions, (String)"expiredPermissions");
            this.grantedPermissions = grantedPermissions;
            this.declinedPermissions = declinedPermissions;
            this.expiredPermissions = expiredPermissions;
        }
    }
}

