/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.net.Uri;
import com.facebook.LoggingBehavior;
import com.facebook.internal.FileLruCache;
import com.facebook.internal.Logger;
import com.facebook.internal.Utility;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0007J\b\u0010\r\u001a\u00020\tH\u0007J\b\u0010\u000e\u001a\u00020\u0007H\u0007J\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/facebook/internal/UrlRedirectCache;", "", "()V", "redirectContentTag", "", "tag", "urlRedirectFileLruCache", "Lcom/facebook/internal/FileLruCache;", "cacheUriRedirect", "", "fromUri", "Landroid/net/Uri;", "toUri", "clearCache", "getCache", "getRedirectedUri", "uri", "facebook-core_release"})
public final class UrlRedirectCache {
    private static final String tag;
    private static final String redirectContentTag;
    private static FileLruCache urlRedirectFileLruCache;
    public static final UrlRedirectCache INSTANCE;

    @JvmStatic
    @NotNull
    public static final synchronized FileLruCache getCache() throws IOException {
        FileLruCache nonNullCache;
        FileLruCache fileLruCache = urlRedirectFileLruCache;
        if (fileLruCache == null) {
            fileLruCache = new FileLruCache(tag, new FileLruCache.Limits());
        }
        urlRedirectFileLruCache = nonNullCache = fileLruCache;
        return nonNullCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @Nullable
    public static final Uri getRedirectedUri(@Nullable Uri uri) {
        if (uri == null) {
            return null;
        }
        String string = uri.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri.toString()");
        String uriString = string;
        InputStreamReader reader = null;
        HashSet<String> redirectChain = new HashSet<String>();
        redirectChain.add(uriString);
        try {
            FileLruCache cache = UrlRedirectCache.getCache();
            boolean redirectExists = false;
            InputStream stream = cache.get(uriString, redirectContentTag);
            while (stream != null) {
                String redirectToUriString;
                redirectExists = true;
                reader = new InputStreamReader(stream);
                char[] buffer = new char[128];
                StringBuilder urlBuilder = new StringBuilder();
                int bufferLength = reader.read(buffer, 0, buffer.length);
                while (bufferLength > 0) {
                    urlBuilder.append(buffer, 0, bufferLength);
                    bufferLength = reader.read(buffer, 0, buffer.length);
                }
                Utility.closeQuietly(reader);
                Intrinsics.checkNotNullExpressionValue((Object)urlBuilder.toString(), (String)"urlBuilder.toString()");
                if (redirectChain.contains(redirectToUriString)) {
                    if (Intrinsics.areEqual((Object)redirectToUriString, (Object)uriString)) break;
                    Logger.Companion.log(LoggingBehavior.CACHE, 6, tag, "A loop detected in UrlRedirectCache");
                    Uri uri2 = null;
                    return uri2;
                }
                uriString = redirectToUriString;
                redirectChain.add(uriString);
                stream = cache.get(uriString, redirectContentTag);
            }
            if (redirectExists) {
                Uri uri3 = Uri.parse((String)uriString);
                return uri3;
            }
        }
        catch (IOException e) {
            Logger.Companion.log(LoggingBehavior.CACHE, 4, tag, "IOException when accessing cache: " + e.getMessage());
        }
        finally {
            Utility.closeQuietly(reader);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final void cacheUriRedirect(@Nullable Uri fromUri, @Nullable Uri toUri) {
        if (fromUri == null || toUri == null) {
            return;
        }
        OutputStream redirectStream = null;
        try {
            FileLruCache cache = UrlRedirectCache.getCache();
            String string = fromUri.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fromUri.toString()");
            redirectStream = cache.openPutStream(string, redirectContentTag);
            String string2 = toUri.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUri.toString()");
            String string3 = string2;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string4.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            redirectStream.write(byArray);
        }
        catch (IOException e) {
            Logger.Companion.log(LoggingBehavior.CACHE, 4, tag, "IOException when accessing cache: " + e.getMessage());
        }
        finally {
            Utility.closeQuietly(redirectStream);
        }
    }

    @JvmStatic
    public static final void clearCache() {
        try {
            UrlRedirectCache.getCache().clearCache();
        }
        catch (IOException e) {
            Logger.Companion.log(LoggingBehavior.CACHE, 5, tag, "clearCache failed " + e.getMessage());
        }
    }

    private UrlRedirectCache() {
    }

    static {
        UrlRedirectCache urlRedirectCache;
        INSTANCE = urlRedirectCache = new UrlRedirectCache();
        String string = Reflection.getOrCreateKotlinClass(UrlRedirectCache.class).getSimpleName();
        if (string == null) {
            string = "UrlRedirectCache";
        }
        tag = string;
        redirectContentTag = tag + "_Redirect";
    }
}

