/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.VisibleForTesting;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.appevents.codeless.internal.UnityReflection;
import com.facebook.appevents.internal.AutomaticAnalyticsLogger;
import com.facebook.appevents.internal.Constants;
import com.facebook.internal.FacebookRequestErrorClassification;
import com.facebook.internal.FetchedAppGateKeepersManager;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.InternalSettings;
import com.facebook.internal.SmartLoginOption;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002ABB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020$H\u0007J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u0004H\u0002J\u0014\u00104\u001a\u0004\u0018\u00010!2\b\u00103\u001a\u0004\u0018\u00010\u0004H\u0007J\b\u00105\u001a\u00020/H\u0007J\u0018\u00106\u001a\u00020!2\u0006\u00103\u001a\u00020\u00042\u0006\u00107\u001a\u000202H\u0007J*\u00108\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020:0 092\b\u0010;\u001a\u0004\u0018\u000102H\u0002J\b\u0010<\u001a\u00020/H\u0002J\u001a\u0010=\u001a\u0004\u0018\u00010!2\u0006\u00103\u001a\u00020\u00042\u0006\u0010>\u001a\u00020&H\u0007J\u0010\u0010?\u001a\u00020/2\u0006\u0010@\u001a\u00020&H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020!0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010'\u001a\u0010\u0012\f\u0012\n **\u0004\u0018\u00010)0)0(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010,\u001a\u0004\u0018\u00010-X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/facebook/internal/FetchedAppSettingsManager;", "", "()V", "APPLICATION_FIELDS", "", "APP_SETTINGS_PREFS_KEY_FORMAT", "APP_SETTINGS_PREFS_STORE", "APP_SETTING_ANDROID_SDK_ERROR_CATEGORIES", "APP_SETTING_APP_EVENTS_AAM_RULE", "APP_SETTING_APP_EVENTS_EVENT_BINDINGS", "APP_SETTING_APP_EVENTS_FEATURE_BITMASK", "APP_SETTING_APP_EVENTS_SESSION_TIMEOUT", "APP_SETTING_DIALOG_CONFIGS", "APP_SETTING_FIELDS", "", "APP_SETTING_NUX_CONTENT", "APP_SETTING_NUX_ENABLED", "APP_SETTING_RESTRICTIVE_EVENT_FILTER_FIELD", "APP_SETTING_SMART_LOGIN_OPTIONS", "APP_SETTING_SUPPORTS_IMPLICIT_SDK_LOGGING", "AUTOMATIC_LOGGING_ENABLED_BITMASK_FIELD", "", "CODELESS_EVENTS_ENABLED_BITMASK_FIELD", "IAP_AUTOMATIC_LOGGING_ENABLED_BITMASK_FIELD", "MONITOR_ENABLED_BITMASK_FIELD", "SDK_UPDATE_MESSAGE", "SMART_LOGIN_BOOKMARK_ICON_URL", "SMART_LOGIN_MENU_ICON_URL", "SUGGESTED_EVENTS_SETTING", "TAG", "TRACK_UNINSTALL_ENABLED_BITMASK_FIELD", "fetchedAppSettings", "", "Lcom/facebook/internal/FetchedAppSettings;", "fetchedAppSettingsCallbacks", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lcom/facebook/internal/FetchedAppSettingsManager$FetchedAppSettingsCallback;", "isUnityInit", "", "loadingState", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/facebook/internal/FetchedAppSettingsManager$FetchAppSettingState;", "kotlin.jvm.PlatformType", "printedSDKUpdatedMessage", "unityEventBindings", "Lorg/json/JSONArray;", "getAppSettingsAsync", "", "callback", "getAppSettingsQueryResponse", "Lorg/json/JSONObject;", "applicationId", "getAppSettingsWithoutQuery", "loadAppSettingsAsync", "parseAppSettingsFromJSON", "settingsJSON", "parseDialogConfigurations", "", "Lcom/facebook/internal/FetchedAppSettings$DialogFeatureConfig;", "dialogConfigResponse", "pollCallbacks", "queryAppSettings", "forceRequery", "setIsUnityInit", "flag", "FetchAppSettingState", "FetchedAppSettingsCallback", "facebook-core_release"})
public final class FetchedAppSettingsManager {
    private static final String TAG;
    private static final String APP_SETTINGS_PREFS_STORE = "com.facebook.internal.preferences.APP_SETTINGS";
    private static final String APP_SETTINGS_PREFS_KEY_FORMAT = "com.facebook.internal.APP_SETTINGS.%s";
    private static final String APP_SETTING_SUPPORTS_IMPLICIT_SDK_LOGGING = "supports_implicit_sdk_logging";
    private static final String APP_SETTING_NUX_CONTENT = "gdpv4_nux_content";
    private static final String APP_SETTING_NUX_ENABLED = "gdpv4_nux_enabled";
    private static final String APP_SETTING_DIALOG_CONFIGS = "android_dialog_configs";
    private static final String APP_SETTING_ANDROID_SDK_ERROR_CATEGORIES = "android_sdk_error_categories";
    private static final String APP_SETTING_APP_EVENTS_SESSION_TIMEOUT = "app_events_session_timeout";
    private static final String APP_SETTING_APP_EVENTS_FEATURE_BITMASK = "app_events_feature_bitmask";
    private static final String APP_SETTING_APP_EVENTS_EVENT_BINDINGS = "auto_event_mapping_android";
    private static final String APP_SETTING_RESTRICTIVE_EVENT_FILTER_FIELD = "restrictive_data_filter_params";
    private static final int AUTOMATIC_LOGGING_ENABLED_BITMASK_FIELD = 8;
    private static final int IAP_AUTOMATIC_LOGGING_ENABLED_BITMASK_FIELD = 16;
    private static final int CODELESS_EVENTS_ENABLED_BITMASK_FIELD = 32;
    private static final int TRACK_UNINSTALL_ENABLED_BITMASK_FIELD = 256;
    private static final int MONITOR_ENABLED_BITMASK_FIELD = 16384;
    private static final String APP_SETTING_SMART_LOGIN_OPTIONS = "seamless_login";
    private static final String SMART_LOGIN_BOOKMARK_ICON_URL = "smart_login_bookmark_icon_url";
    private static final String SMART_LOGIN_MENU_ICON_URL = "smart_login_menu_icon_url";
    private static final String SDK_UPDATE_MESSAGE = "sdk_update_message";
    private static final String APP_SETTING_APP_EVENTS_AAM_RULE = "aam_rules";
    private static final String SUGGESTED_EVENTS_SETTING = "suggested_events_setting";
    private static final List<String> APP_SETTING_FIELDS;
    private static final String APPLICATION_FIELDS = "fields";
    private static final Map<String, FetchedAppSettings> fetchedAppSettings;
    private static final AtomicReference<FetchAppSettingState> loadingState;
    private static final ConcurrentLinkedQueue<FetchedAppSettingsCallback> fetchedAppSettingsCallbacks;
    private static boolean printedSDKUpdatedMessage;
    private static boolean isUnityInit;
    private static JSONArray unityEventBindings;
    public static final FetchedAppSettingsManager INSTANCE;

    @JvmStatic
    public static final void loadAppSettingsAsync() {
        boolean canStartLoading;
        Context context = FacebookSdk.getApplicationContext();
        String applicationId = FacebookSdk.getApplicationId();
        if (Utility.isNullOrEmpty(applicationId)) {
            loadingState.set(FetchAppSettingState.ERROR);
            INSTANCE.pollCallbacks();
            return;
        }
        if (fetchedAppSettings.containsKey(applicationId)) {
            loadingState.set(FetchAppSettingState.SUCCESS);
            INSTANCE.pollCallbacks();
            return;
        }
        boolean bl = canStartLoading = loadingState.compareAndSet(FetchAppSettingState.NOT_LOADED, FetchAppSettingState.LOADING) || loadingState.compareAndSet(FetchAppSettingState.ERROR, FetchAppSettingState.LOADING);
        if (!canStartLoading) {
            INSTANCE.pollCallbacks();
            return;
        }
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = APP_SETTINGS_PREFS_KEY_FORMAT;
        Object[] objectArray = new Object[]{applicationId};
        boolean bl2 = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        String settingsKey = string2;
        FacebookSdk.getExecutor().execute(new Runnable(context, settingsKey, applicationId){
            final /* synthetic */ Context $context;
            final /* synthetic */ String $settingsKey;
            final /* synthetic */ String $applicationId;

            public final void run() {
                if (CrashShieldHandler.isObjectCrashing(this)) {
                    return;
                }
                try {
                    if (CrashShieldHandler.isObjectCrashing(this)) {
                        return;
                    }
                    try {
                        SharedPreferences sharedPrefs = this.$context.getSharedPreferences("com.facebook.internal.preferences.APP_SETTINGS", 0);
                        String settingsJSONString = sharedPrefs.getString(this.$settingsKey, null);
                        FetchedAppSettings appSettings = null;
                        if (!Utility.isNullOrEmpty(settingsJSONString)) {
                            boolean bl = false;
                            boolean bl2 = false;
                            bl2 = false;
                            boolean bl3 = false;
                            if (settingsJSONString == null) {
                                boolean bl4 = false;
                                String string = "Required value was null.";
                                throw (Throwable)new IllegalStateException(string.toString());
                            }
                            JSONObject settingsJSON = null;
                            try {
                                settingsJSON = new JSONObject(settingsJSONString);
                            }
                            catch (JSONException je) {
                                Utility.logd("FacebookSDK", (Exception)((Object)je));
                            }
                            if (settingsJSON != null) {
                                String string = this.$applicationId;
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"applicationId");
                                appSettings = FetchedAppSettingsManager.INSTANCE.parseAppSettingsFromJSON(string, settingsJSON);
                            }
                        }
                        String string = this.$applicationId;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"applicationId");
                        JSONObject resultJSON = FetchedAppSettingsManager.access$getAppSettingsQueryResponse(FetchedAppSettingsManager.INSTANCE, string);
                        if (resultJSON != null) {
                            String string2 = this.$applicationId;
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"applicationId");
                            FetchedAppSettingsManager.INSTANCE.parseAppSettingsFromJSON(string2, resultJSON);
                            sharedPrefs.edit().putString(this.$settingsKey, resultJSON.toString()).apply();
                        }
                        if (appSettings != null) {
                            String updateMessage = appSettings.getSdkUpdateMessage();
                            if (!FetchedAppSettingsManager.access$getPrintedSDKUpdatedMessage$p(FetchedAppSettingsManager.INSTANCE) && updateMessage != null && updateMessage.length() > 0) {
                                FetchedAppSettingsManager.access$setPrintedSDKUpdatedMessage$p(FetchedAppSettingsManager.INSTANCE, true);
                                Log.w((String)FetchedAppSettingsManager.access$getTAG$p(FetchedAppSettingsManager.INSTANCE), (String)updateMessage);
                            }
                        }
                        String string3 = this.$applicationId;
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"applicationId");
                        FetchedAppGateKeepersManager.queryAppGateKeepers(string3, true);
                        AutomaticAnalyticsLogger.logActivateAppEvent();
                        FetchedAppSettingsManager.access$getLoadingState$p(FetchedAppSettingsManager.INSTANCE).set(FetchedAppSettingsManager.access$getFetchedAppSettings$p(FetchedAppSettingsManager.INSTANCE).containsKey(this.$applicationId) ? FetchAppSettingState.SUCCESS : FetchAppSettingState.ERROR);
                        FetchedAppSettingsManager.access$pollCallbacks(FetchedAppSettingsManager.INSTANCE);
                        return;
                    }
                    catch (Throwable throwable) {
                        CrashShieldHandler.handleThrowable(throwable, this);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    CrashShieldHandler.handleThrowable(throwable, this);
                    return;
                }
            }
            {
                this.$context = context;
                this.$settingsKey = string;
                this.$applicationId = string2;
            }
        });
    }

    @JvmStatic
    @Nullable
    public static final FetchedAppSettings getAppSettingsWithoutQuery(@Nullable String applicationId) {
        return applicationId != null ? fetchedAppSettings.get(applicationId) : null;
    }

    @JvmStatic
    public static final void getAppSettingsAsync(@NotNull FetchedAppSettingsCallback callback2) {
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        fetchedAppSettingsCallbacks.add(callback2);
        FetchedAppSettingsManager.loadAppSettingsAsync();
    }

    private final synchronized void pollCallbacks() {
        FetchAppSettingState currentState = loadingState.get();
        if (FetchAppSettingState.NOT_LOADED == currentState || FetchAppSettingState.LOADING == currentState) {
            return;
        }
        String applicationId = FacebookSdk.getApplicationId();
        FetchedAppSettings appSettings = fetchedAppSettings.get(applicationId);
        Handler handler = new Handler(Looper.getMainLooper());
        if (FetchAppSettingState.ERROR == currentState) {
            while (!fetchedAppSettingsCallbacks.isEmpty()) {
                FetchedAppSettingsCallback callback2 = fetchedAppSettingsCallbacks.poll();
                handler.post(new Runnable(callback2){
                    final /* synthetic */ FetchedAppSettingsCallback $callback;

                    public final void run() {
                        if (CrashShieldHandler.isObjectCrashing(this)) {
                            return;
                        }
                        try {
                            if (CrashShieldHandler.isObjectCrashing(this)) {
                                return;
                            }
                            try {
                                this.$callback.onError();
                                return;
                            }
                            catch (Throwable throwable) {
                                CrashShieldHandler.handleThrowable(throwable, this);
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            CrashShieldHandler.handleThrowable(throwable, this);
                            return;
                        }
                    }
                    {
                        this.$callback = fetchedAppSettingsCallback;
                    }
                });
            }
            return;
        }
        while (!fetchedAppSettingsCallbacks.isEmpty()) {
            FetchedAppSettingsCallback callback3 = fetchedAppSettingsCallbacks.poll();
            handler.post(new Runnable(callback3, appSettings){
                final /* synthetic */ FetchedAppSettingsCallback $callback;
                final /* synthetic */ FetchedAppSettings $appSettings;

                public final void run() {
                    if (CrashShieldHandler.isObjectCrashing(this)) {
                        return;
                    }
                    try {
                        if (CrashShieldHandler.isObjectCrashing(this)) {
                            return;
                        }
                        try {
                            this.$callback.onSuccess(this.$appSettings);
                            return;
                        }
                        catch (Throwable throwable) {
                            CrashShieldHandler.handleThrowable(throwable, this);
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        CrashShieldHandler.handleThrowable(throwable, this);
                        return;
                    }
                }
                {
                    this.$callback = fetchedAppSettingsCallback;
                    this.$appSettings = fetchedAppSettings;
                }
            });
        }
    }

    @JvmStatic
    @Nullable
    public static final FetchedAppSettings queryAppSettings(@NotNull String applicationId, boolean forceRequery) {
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        if (!forceRequery && fetchedAppSettings.containsKey(applicationId)) {
            return fetchedAppSettings.get(applicationId);
        }
        JSONObject jSONObject = INSTANCE.getAppSettingsQueryResponse(applicationId);
        if (jSONObject == null) {
            return null;
        }
        JSONObject response = jSONObject;
        FetchedAppSettings fetchedAppSettings = INSTANCE.parseAppSettingsFromJSON(applicationId, response);
        if (Intrinsics.areEqual((Object)applicationId, (Object)FacebookSdk.getApplicationId())) {
            loadingState.set(FetchAppSettingState.SUCCESS);
            INSTANCE.pollCallbacks();
        }
        return fetchedAppSettings;
    }

    @VisibleForTesting
    @NotNull
    public final FetchedAppSettings parseAppSettingsFromJSON(@NotNull String applicationId, @NotNull JSONObject settingsJSON) {
        JSONArray eventBindings;
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)settingsJSON, (String)"settingsJSON");
        JSONArray errorClassificationJSON = settingsJSON.optJSONArray(APP_SETTING_ANDROID_SDK_ERROR_CATEGORIES);
        FacebookRequestErrorClassification facebookRequestErrorClassification = FacebookRequestErrorClassification.Companion.createFromJSON(errorClassificationJSON);
        if (facebookRequestErrorClassification == null) {
            facebookRequestErrorClassification = FacebookRequestErrorClassification.Companion.getDefaultErrorClassification();
        }
        FacebookRequestErrorClassification errorClassification = facebookRequestErrorClassification;
        int featureBitmask = settingsJSON.optInt(APP_SETTING_APP_EVENTS_FEATURE_BITMASK, 0);
        boolean automaticLoggingEnabled = (featureBitmask & 8) != 0;
        boolean inAppPurchaseAutomaticLoggingEnabled = (featureBitmask & 0x10) != 0;
        boolean codelessEventsEnabled = (featureBitmask & 0x20) != 0;
        boolean trackUninstallEnabled = (featureBitmask & 0x100) != 0;
        boolean monitorEnabled = (featureBitmask & 0x4000) != 0;
        unityEventBindings = eventBindings = settingsJSON.optJSONArray(APP_SETTING_APP_EVENTS_EVENT_BINDINGS);
        if (unityEventBindings != null && InternalSettings.isUnityApp()) {
            JSONArray jSONArray = eventBindings;
            UnityReflection.sendEventMapping(jSONArray != null ? jSONArray.toString() : null);
        }
        boolean bl = settingsJSON.optBoolean(APP_SETTING_SUPPORTS_IMPLICIT_SDK_LOGGING, false);
        String string = settingsJSON.optString(APP_SETTING_NUX_CONTENT, "");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"settingsJSON.optString(A\u2026_SETTING_NUX_CONTENT, \"\")");
        boolean bl2 = settingsJSON.optBoolean(APP_SETTING_NUX_ENABLED, false);
        int n = settingsJSON.optInt(APP_SETTING_APP_EVENTS_SESSION_TIMEOUT, Constants.getDefaultAppEventsSessionTimeoutInSeconds());
        EnumSet<SmartLoginOption> enumSet = SmartLoginOption.Companion.parseOptions(settingsJSON.optLong(APP_SETTING_SMART_LOGIN_OPTIONS));
        Map<String, Map<String, FetchedAppSettings.DialogFeatureConfig>> map = this.parseDialogConfigurations(settingsJSON.optJSONObject(APP_SETTING_DIALOG_CONFIGS));
        String string2 = settingsJSON.optString(SMART_LOGIN_BOOKMARK_ICON_URL);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"settingsJSON.optString(S\u2026_LOGIN_BOOKMARK_ICON_URL)");
        String string3 = settingsJSON.optString(SMART_LOGIN_MENU_ICON_URL);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"settingsJSON.optString(SMART_LOGIN_MENU_ICON_URL)");
        String string4 = settingsJSON.optString(SDK_UPDATE_MESSAGE);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"settingsJSON.optString(SDK_UPDATE_MESSAGE)");
        FetchedAppSettings result = new FetchedAppSettings(bl, string, bl2, n, enumSet, map, automaticLoggingEnabled, errorClassification, string2, string3, inAppPurchaseAutomaticLoggingEnabled, codelessEventsEnabled, eventBindings, string4, trackUninstallEnabled, monitorEnabled, settingsJSON.optString(APP_SETTING_APP_EVENTS_AAM_RULE), settingsJSON.optString(SUGGESTED_EVENTS_SETTING), settingsJSON.optString(APP_SETTING_RESTRICTIVE_EVENT_FILTER_FIELD));
        fetchedAppSettings.put(applicationId, result);
        return result;
    }

    @JvmStatic
    public static final void setIsUnityInit(boolean flag) {
        isUnityInit = flag;
        if (unityEventBindings != null && isUnityInit) {
            UnityReflection.sendEventMapping(String.valueOf(unityEventBindings));
        }
    }

    private final JSONObject getAppSettingsQueryResponse(String applicationId) {
        Bundle appSettingsParams = new Bundle();
        boolean bl = false;
        List list = new ArrayList();
        boolean bl2 = false;
        boolean bl3 = false;
        List $this$apply = list;
        boolean bl4 = false;
        $this$apply.addAll((Collection)APP_SETTING_FIELDS);
        List appSettingFields = list;
        appSettingsParams.putString(APPLICATION_FIELDS, TextUtils.join((CharSequence)",", (Iterable)appSettingFields));
        GraphRequest request2 = GraphRequest.Companion.newGraphPathRequest(null, applicationId, null);
        request2.setSkipClientToken(true);
        request2.setParameters(appSettingsParams);
        JSONObject jSONObject = request2.executeAndWait().getJsonObject();
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        return jSONObject;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Map<String, FetchedAppSettings.DialogFeatureConfig>> parseDialogConfigurations(JSONObject dialogConfigResponse) {
        JSONArray dialogConfigData;
        HashMap dialogConfigMap = new HashMap();
        if (dialogConfigResponse != null && (dialogConfigData = dialogConfigResponse.optJSONArray("data")) != null) {
            int n = 0;
            int n2 = dialogConfigData.length();
            while (n < n2) {
                void i;
                JSONObject jSONObject = dialogConfigData.optJSONObject((int)i);
                Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"dialogConfigData.optJSONObject(i)");
                if (FetchedAppSettings.DialogFeatureConfig.Companion.parseDialogConfig(jSONObject) == null) {
                } else {
                    FetchedAppSettings.DialogFeatureConfig dialogConfig;
                    String dialogName = dialogConfig.getDialogName();
                    Map featureMap = (Map)dialogConfigMap.get(dialogName);
                    if (featureMap == null) {
                        featureMap = new HashMap();
                        ((Map)dialogConfigMap).put(dialogName, featureMap);
                    }
                    featureMap.put(dialogConfig.getFeatureName(), dialogConfig);
                }
                ++i;
            }
        }
        return dialogConfigMap;
    }

    private FetchedAppSettingsManager() {
    }

    static {
        FetchedAppSettingsManager fetchedAppSettingsManager;
        INSTANCE = fetchedAppSettingsManager = new FetchedAppSettingsManager();
        String string = FetchedAppSettingsManager.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FetchedAppSettingsManager::class.java.simpleName");
        TAG = string;
        APP_SETTING_FIELDS = CollectionsKt.listOf((Object[])new String[]{APP_SETTING_SUPPORTS_IMPLICIT_SDK_LOGGING, APP_SETTING_NUX_CONTENT, APP_SETTING_NUX_ENABLED, APP_SETTING_DIALOG_CONFIGS, APP_SETTING_ANDROID_SDK_ERROR_CATEGORIES, APP_SETTING_APP_EVENTS_SESSION_TIMEOUT, APP_SETTING_APP_EVENTS_FEATURE_BITMASK, APP_SETTING_APP_EVENTS_EVENT_BINDINGS, APP_SETTING_SMART_LOGIN_OPTIONS, SMART_LOGIN_BOOKMARK_ICON_URL, SMART_LOGIN_MENU_ICON_URL, APP_SETTING_RESTRICTIVE_EVENT_FILTER_FIELD, APP_SETTING_APP_EVENTS_AAM_RULE, SUGGESTED_EVENTS_SETTING});
        fetchedAppSettings = new ConcurrentHashMap();
        loadingState = new AtomicReference<FetchAppSettingState>(FetchAppSettingState.NOT_LOADED);
        fetchedAppSettingsCallbacks = new ConcurrentLinkedQueue();
    }

    public static final /* synthetic */ JSONObject access$getAppSettingsQueryResponse(FetchedAppSettingsManager $this, String applicationId) {
        return $this.getAppSettingsQueryResponse(applicationId);
    }

    public static final /* synthetic */ boolean access$getPrintedSDKUpdatedMessage$p(FetchedAppSettingsManager $this) {
        FetchedAppSettingsManager fetchedAppSettingsManager = $this;
        return printedSDKUpdatedMessage;
    }

    public static final /* synthetic */ void access$setPrintedSDKUpdatedMessage$p(FetchedAppSettingsManager $this, boolean bl) {
        FetchedAppSettingsManager fetchedAppSettingsManager = $this;
        printedSDKUpdatedMessage = bl;
    }

    public static final /* synthetic */ String access$getTAG$p(FetchedAppSettingsManager $this) {
        FetchedAppSettingsManager fetchedAppSettingsManager = $this;
        return TAG;
    }

    public static final /* synthetic */ AtomicReference access$getLoadingState$p(FetchedAppSettingsManager $this) {
        FetchedAppSettingsManager fetchedAppSettingsManager = $this;
        return loadingState;
    }

    public static final /* synthetic */ Map access$getFetchedAppSettings$p(FetchedAppSettingsManager $this) {
        FetchedAppSettingsManager fetchedAppSettingsManager = $this;
        return fetchedAppSettings;
    }

    public static final /* synthetic */ void access$pollCallbacks(FetchedAppSettingsManager $this) {
        $this.pollCallbacks();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/facebook/internal/FetchedAppSettingsManager$FetchAppSettingState;", "", "(Ljava/lang/String;I)V", "NOT_LOADED", "LOADING", "SUCCESS", "ERROR", "facebook-core_release"})
    public static final class FetchAppSettingState
    extends Enum<FetchAppSettingState> {
        public static final /* enum */ FetchAppSettingState NOT_LOADED;
        public static final /* enum */ FetchAppSettingState LOADING;
        public static final /* enum */ FetchAppSettingState SUCCESS;
        public static final /* enum */ FetchAppSettingState ERROR;
        private static final /* synthetic */ FetchAppSettingState[] $VALUES;

        static {
            FetchAppSettingState[] fetchAppSettingStateArray = new FetchAppSettingState[4];
            FetchAppSettingState[] fetchAppSettingStateArray2 = fetchAppSettingStateArray;
            fetchAppSettingStateArray[0] = NOT_LOADED = new FetchAppSettingState();
            fetchAppSettingStateArray[1] = LOADING = new FetchAppSettingState();
            fetchAppSettingStateArray[2] = SUCCESS = new FetchAppSettingState();
            fetchAppSettingStateArray[3] = ERROR = new FetchAppSettingState();
            $VALUES = fetchAppSettingStateArray;
        }

        public static FetchAppSettingState[] values() {
            return (FetchAppSettingState[])$VALUES.clone();
        }

        public static FetchAppSettingState valueOf(String string) {
            return Enum.valueOf(FetchAppSettingState.class, string);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\u0012\u0010\u0004\u001a\u00020\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H&\u00a8\u0006\u0007"}, d2={"Lcom/facebook/internal/FetchedAppSettingsManager$FetchedAppSettingsCallback;", "", "onError", "", "onSuccess", "fetchedAppSettings", "Lcom/facebook/internal/FetchedAppSettings;", "facebook-core_release"})
    public static interface FetchedAppSettingsCallback {
        public void onSuccess(@Nullable FetchedAppSettings var1);

        public void onError();
    }
}

