/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.ml;

import androidx.annotation.VisibleForTesting;
import com.facebook.appevents.ml.MTensor;
import com.facebook.appevents.ml.Utils;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J\u001b\u0010\b\u001a\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0007\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006H\u0007J \u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J+\u0010\u000f\u001a\u00020\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u0006H\u0007\u00a2\u0006\u0002\u0010\u0014J\u0018\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0013H\u0007J\u0018\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0013H\u0007J\u0018\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006H\u0007J\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u001e"}, d2={"Lcom/facebook/appevents/ml/Operator;", "", "()V", "addmv", "", "x", "Lcom/facebook/appevents/ml/MTensor;", "b", "concatenate", "tensors", "", "([Lcom/facebook/appevents/ml/MTensor;)Lcom/facebook/appevents/ml/MTensor;", "conv1D", "w", "dense", "embedding", "texts", "", "seqLength", "", "([Ljava/lang/String;ILcom/facebook/appevents/ml/MTensor;)Lcom/facebook/appevents/ml/MTensor;", "flatten", "startDim", "maxPool1D", "poolSize", "mul", "relu", "softmax", "transpose2D", "transpose3D", "facebook-core_release"})
@VisibleForTesting(otherwise=3)
public final class Operator {
    public static final Operator INSTANCE;

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void addmv(@NotNull MTensor mTensor, @NotNull MTensor mTensor2) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return;
        }
        try {
            void b;
            MTensor x;
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            int exampleSize = x.getShape(0);
            int seqLength = x.getShape(1);
            int inputSize = x.getShape(2);
            float[] xData = x.getData();
            float[] bData = b.getData();
            int n = 0;
            int n2 = exampleSize;
            while (n < n2) {
                void i;
                int n3 = 0;
                int n4 = seqLength;
                while (n3 < n4) {
                    void j;
                    int n5 = 0;
                    int n6 = inputSize;
                    while (n5 < n6) {
                        void k;
                        void v0 = i * seqLength * inputSize + j * inputSize + k;
                        xData[v0] = xData[v0] + bData[k];
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final MTensor mul(@NotNull MTensor mTensor, @NotNull MTensor mTensor2) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return null;
        }
        try {
            void w;
            MTensor x;
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            Intrinsics.checkNotNullParameter((Object)w, (String)"w");
            int exampleSize = x.getShape(0);
            int inputSize = w.getShape(0);
            int outputSize = w.getShape(1);
            MTensor y = new MTensor(new int[]{exampleSize, outputSize});
            float[] xData = x.getData();
            float[] wData = w.getData();
            float[] yData = y.getData();
            int n = 0;
            int n2 = exampleSize;
            while (n < n2) {
                void i;
                int n3 = 0;
                int n4 = outputSize;
                while (n3 < n4) {
                    void j;
                    yData[i * outputSize + j] = 0.0f;
                    int n5 = 0;
                    int n6 = inputSize;
                    while (n5 < n6) {
                        void k;
                        void v0 = i * outputSize + j;
                        yData[v0] = yData[v0] + xData[i * inputSize + k] * wData[k * outputSize + j];
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            return y;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void relu(@NotNull MTensor mTensor) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return;
        }
        try {
            MTensor x;
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            float[] xData = x.getData();
            int n = 0;
            int n2 = xData.length;
            while (n < n2) {
                void i;
                if (xData[i] < 0.0f) {
                    xData[i] = 0.0f;
                }
                ++i;
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void flatten(@NotNull MTensor mTensor, int n) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return;
        }
        try {
            void startDim;
            MTensor x;
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            if (startDim >= x.getShapeSize()) {
                return;
            }
            int outputSize = 1;
            void var3_3 = startDim;
            int n2 = x.getShapeSize();
            while (var3_3 < n2) {
                void i;
                outputSize *= x.getShape((int)i);
                ++i;
            }
            int[] newShape = new int[startDim + true];
            n2 = 0;
            void var5_6 = startDim;
            while (n2 < var5_6) {
                void i;
                newShape[i] = x.getShape((int)i);
                ++i;
            }
            newShape[startDim] = outputSize;
            x.reshape(newShape);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final MTensor concatenate(@NotNull MTensor[] mTensorArray) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return null;
        }
        try {
            MTensor[] tensors;
            Intrinsics.checkNotNullParameter((Object)tensors, (String)"tensors");
            int exampleSize = tensors[0].getShape(0);
            int outputSize = 0;
            int n = 0;
            int n2 = tensors.length;
            while (n < n2) {
                void i;
                outputSize += tensors[i].getShape(1);
                ++i;
            }
            MTensor y = new MTensor(new int[]{exampleSize, outputSize});
            float[] yData = y.getData();
            int n3 = 0;
            int n4 = exampleSize;
            while (n3 < n4) {
                void n5;
                void desPos = n5 * outputSize;
                int n6 = 0;
                int n7 = tensors.length;
                while (n6 < n7) {
                    void i;
                    float[] xData = tensors[i].getData();
                    int inputSize = tensors[i].getShape(1);
                    System.arraycopy(xData, (int)(n5 * inputSize), yData, (int)desPos, inputSize);
                    desPos += inputSize;
                    ++i;
                }
                ++n5;
            }
            return y;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void softmax(@NotNull MTensor mTensor) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return;
        }
        try {
            MTensor x;
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            int exampleSize = x.getShape(0);
            int inputSize = x.getShape(1);
            float[] xData = x.getData();
            int n = 0;
            int n2 = exampleSize;
            while (n < n2) {
                void i;
                void n3;
                void startIndex = n3 * inputSize;
                void endIndex = startIndex + inputSize;
                float max = Float.MIN_VALUE;
                float sum = 0.0f;
                void var10_10 = startIndex;
                void var11_11 = endIndex;
                while (var10_10 < var11_11) {
                    if (xData[i] > max) {
                        max = xData[i];
                    }
                    ++i;
                }
                var11_11 = endIndex;
                for (i = startIndex; i < var11_11; ++i) {
                    double d = xData[i] - max;
                    boolean bl = false;
                    xData[i] = (float)Math.exp(d);
                    sum += xData[i];
                }
                var11_11 = endIndex;
                for (i = startIndex; i < var11_11; ++i) {
                    xData[i] = xData[i] / sum;
                }
                ++n3;
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final MTensor dense(@NotNull MTensor mTensor, @NotNull MTensor mTensor2, @NotNull MTensor mTensor3) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return null;
        }
        try {
            void b;
            void w;
            MTensor x;
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            Intrinsics.checkNotNullParameter((Object)w, (String)"w");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            int exampleSize = x.getShape(0);
            int outputSize = b.getShape(0);
            MTensor y = Operator.mul(x, (MTensor)w);
            float[] bData = b.getData();
            float[] yData = y.getData();
            int n = 0;
            int n2 = exampleSize;
            while (n < n2) {
                void i;
                int n3 = 0;
                int n4 = outputSize;
                while (n3 < n4) {
                    void j;
                    void v0 = i * outputSize + j;
                    yData[v0] = yData[v0] + bData[j];
                    ++j;
                }
                ++i;
            }
            return y;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final MTensor embedding(@NotNull String[] stringArray, int n, @NotNull MTensor mTensor) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return null;
        }
        try {
            void seqLength;
            void w;
            String[] texts;
            Intrinsics.checkNotNullParameter((Object)texts, (String)"texts");
            Intrinsics.checkNotNullParameter((Object)w, (String)"w");
            int exampleSize = texts.length;
            int embeddingSize = w.getShape(1);
            MTensor y = new MTensor(new int[]{exampleSize, seqLength, embeddingSize});
            float[] yData = y.getData();
            float[] wData = w.getData();
            int n2 = 0;
            int n3 = exampleSize;
            while (n2 < n3) {
                void i;
                int[] vectorizedText = Utils.INSTANCE.vectorize(texts[i], (int)seqLength);
                boolean bl = false;
                void var12_12 = seqLength;
                while (bl < var12_12) {
                    void j;
                    System.arraycopy(wData, vectorizedText[j] * embeddingSize, yData, embeddingSize * seqLength * i + embeddingSize * j, embeddingSize);
                    ++j;
                }
                ++i;
            }
            return y;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final MTensor transpose2D(@NotNull MTensor mTensor) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return null;
        }
        try {
            MTensor x;
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            int m = x.getShape(0);
            int n = x.getShape(1);
            MTensor y = new MTensor(new int[]{n, m});
            float[] xData = x.getData();
            float[] yData = y.getData();
            int n2 = 0;
            int n3 = m;
            while (n2 < n3) {
                void i;
                int n4 = 0;
                int n5 = n;
                while (n4 < n5) {
                    void j;
                    yData[j * m + i] = xData[i * n + j];
                    ++j;
                }
                ++i;
            }
            return y;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final MTensor transpose3D(@NotNull MTensor mTensor) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return null;
        }
        try {
            MTensor x;
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            int m = x.getShape(0);
            int n = x.getShape(1);
            int p = x.getShape(2);
            MTensor y = new MTensor(new int[]{p, n, m});
            float[] xData = x.getData();
            float[] yData = y.getData();
            int n2 = 0;
            int n3 = m;
            while (n2 < n3) {
                void i;
                int n4 = 0;
                int n5 = n;
                while (n4 < n5) {
                    void j;
                    int n6 = 0;
                    int n7 = p;
                    while (n6 < n7) {
                        void k;
                        yData[k * m * n + j * m + i] = xData[i * n * p + j * p + k];
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            return y;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final MTensor conv1D(@NotNull MTensor mTensor, @NotNull MTensor mTensor2) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return null;
        }
        try {
            void w;
            MTensor x;
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            Intrinsics.checkNotNullParameter((Object)w, (String)"w");
            int exampleSize = x.getShape(0);
            int inputSeqLength = x.getShape(1);
            int inputSize = x.getShape(2);
            int kernelSize = w.getShape(0);
            int outputSeqLength = inputSeqLength - kernelSize + 1;
            int outputSize = w.getShape(2);
            MTensor y = new MTensor(new int[]{exampleSize, outputSeqLength, outputSize});
            float[] xData = x.getData();
            float[] yData = y.getData();
            float[] wData = w.getData();
            int n = 0;
            int n2 = exampleSize;
            while (n < n2) {
                void n3;
                int n4 = 0;
                int n5 = outputSize;
                while (n4 < n5) {
                    void o;
                    int n6 = 0;
                    int n7 = outputSeqLength;
                    while (n6 < n7) {
                        void i;
                        float sum = 0.0f;
                        int n8 = 0;
                        int n9 = kernelSize;
                        while (n8 < n9) {
                            void m;
                            int n10 = 0;
                            int n11 = inputSize;
                            while (n10 < n11) {
                                void k;
                                sum += xData[n3 * (inputSeqLength * inputSize) + (m + i) * inputSize + k] * wData[(m * inputSize + k) * outputSize + o];
                                ++k;
                            }
                            ++m;
                        }
                        yData[n3 * (outputSeqLength * outputSize) + i * outputSize + o] = sum;
                        ++i;
                    }
                    ++o;
                }
                ++n3;
            }
            return y;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final MTensor maxPool1D(@NotNull MTensor mTensor, int n) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return null;
        }
        try {
            void poolSize;
            MTensor x;
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            int exampleSize = x.getShape(0);
            int inputSeqLength = x.getShape(1);
            int inputSize = x.getShape(2);
            int outputSeqLength = inputSeqLength - poolSize + 1;
            MTensor y = new MTensor(new int[]{exampleSize, outputSeqLength, inputSize});
            float[] xData = x.getData();
            float[] yData = y.getData();
            int n2 = 0;
            int n3 = exampleSize;
            while (n2 < n3) {
                void n4;
                int n5 = 0;
                int n6 = inputSize;
                while (n5 < n6) {
                    void c;
                    int n7 = 0;
                    int n8 = outputSeqLength;
                    while (n7 < n8) {
                        void i;
                        void yIndex = n4 * outputSeqLength * inputSize + i * inputSize + c;
                        void xIndex = n4 * inputSeqLength * inputSize + i * inputSize + c;
                        yData[yIndex] = Float.MIN_VALUE;
                        boolean bl = false;
                        void var18_18 = poolSize;
                        while (bl < var18_18) {
                            void r;
                            float f = yData[yIndex];
                            float f2 = xData[xIndex + r * inputSize];
                            boolean bl2 = false;
                            yData[yIndex] = Math.max(f, f2);
                            ++r;
                        }
                        ++i;
                    }
                    ++c;
                }
                ++n4;
            }
            return y;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return null;
        }
    }

    private Operator() {
    }

    static {
        Operator operator;
        INSTANCE = operator = new Operator();
    }
}

