/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import androidx.annotation.VisibleForTesting;
import com.facebook.LoggingBehavior;
import com.facebook.appevents.AppEventsLogger;
import com.facebook.appevents.InternalAppEventsLogger;
import com.facebook.appevents.internal.HashUtils;
import com.facebook.appevents.internal.SessionInfo;
import com.facebook.appevents.internal.SourceApplicationInfo;
import com.facebook.internal.Logger;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import com.facebook.internal.security.CertificateUtil;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J,\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\nH\u0007J\b\u0010\u0015\u001a\u00020\u0010H\u0002J$\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00062\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0014\u001a\u0004\u0018\u00010\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/facebook/appevents/internal/SessionLogger;", "", "()V", "INACTIVE_SECONDS_QUANTA", "", "PACKAGE_CHECKSUM", "", "TAG", "computePackageChecksum", "context", "Landroid/content/Context;", "getQuantaIndex", "", "timeBetweenSessions", "", "logActivateApp", "", "activityName", "sourceApplicationInfo", "Lcom/facebook/appevents/internal/SourceApplicationInfo;", "appId", "logClockSkewEvent", "logDeactivateApp", "sessionInfo", "Lcom/facebook/appevents/internal/SessionInfo;", "facebook-core_release"})
@VisibleForTesting(otherwise=3)
public final class SessionLogger {
    private static final String PACKAGE_CHECKSUM = "PCKGCHKSUM";
    private static final String TAG;
    private static final long[] INACTIVE_SECONDS_QUANTA;
    public static final SessionLogger INSTANCE;

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void logActivateApp(@NotNull String string, @Nullable SourceApplicationInfo sourceApplicationInfo, @Nullable String string2, @NotNull Context context) {
        if (CrashShieldHandler.isObjectCrashing(SessionLogger.class)) {
            return;
        }
        try {
            void appId;
            void sourceApplicationInfo2;
            void context2;
            String activityName;
            Intrinsics.checkNotNullParameter((Object)activityName, (String)"activityName");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            String string3 = sourceApplicationInfo2;
            if (string3 == null || (string3 = ((SourceApplicationInfo)((Object)string3)).toString()) == null) {
                string3 = "Unclassified";
            }
            String sourAppInfoStr = string3;
            Bundle eventParams = new Bundle();
            eventParams.putString("fb_mobile_launch_source", sourAppInfoStr);
            eventParams.putString("fb_mobile_pckg_fp", INSTANCE.computePackageChecksum((Context)context2));
            eventParams.putString("fb_mobile_app_cert_hash", CertificateUtil.getCertificateHash((Context)context2));
            InternalAppEventsLogger logger = new InternalAppEventsLogger(activityName, (String)appId, null);
            logger.logEvent("fb_mobile_activate_app", eventParams);
            if (InternalAppEventsLogger.Companion.getFlushBehavior() != AppEventsLogger.FlushBehavior.EXPLICIT_ONLY) {
                logger.flush();
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, SessionLogger.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void logDeactivateApp(@NotNull String string, @Nullable SessionInfo sessionInfo, @Nullable String string2) {
        if (CrashShieldHandler.isObjectCrashing(SessionLogger.class)) {
            return;
        }
        try {
            void appId;
            long sessionLength;
            long interruptionDurationMillis;
            long l;
            void sessionInfo2;
            String activityName;
            Intrinsics.checkNotNullParameter((Object)activityName, (String)"activityName");
            if (sessionInfo2 == null) {
                return;
            }
            Long l2 = sessionInfo2.getDiskRestoreTime();
            if (l2 != null) {
                l = l2;
            } else {
                Long l3 = sessionInfo2.getSessionLastEventTime();
                l = interruptionDurationMillis = 0L - (l3 != null ? l3 : 0L);
            }
            if (interruptionDurationMillis < 0L) {
                interruptionDurationMillis = 0L;
                INSTANCE.logClockSkewEvent();
            }
            if ((sessionLength = sessionInfo2.getSessionLength()) < 0L) {
                INSTANCE.logClockSkewEvent();
                sessionLength = 0L;
            }
            Bundle eventParams = new Bundle();
            eventParams.putInt("fb_mobile_app_interruptions", sessionInfo2.getInterruptionCount());
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Locale locale = Locale.ROOT;
            String string3 = "session_quanta_%d";
            Object[] objectArray = new Object[]{SessionLogger.getQuantaIndex(interruptionDurationMillis)};
            boolean bl = false;
            String string4 = String.format(locale, string3, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(locale, format, *args)");
            eventParams.putString("fb_mobile_time_between_sessions", string4);
            SourceApplicationInfo sourceApplicationInfo = sessionInfo2.getSourceApplicationInfo();
            Object object = sourceApplicationInfo;
            if (object == null || (object = ((SourceApplicationInfo)object).toString()) == null) {
                object = "Unclassified";
            }
            Object sourAppInfoStr = object;
            eventParams.putString("fb_mobile_launch_source", (String)sourAppInfoStr);
            Long l4 = sessionInfo2.getSessionLastEventTime();
            eventParams.putLong("_logTime", (l4 != null ? l4 : 0L) / (long)1000);
            new InternalAppEventsLogger(activityName, (String)appId, null).logEvent("fb_mobile_deactivate_app", (double)sessionLength / (double)1000L, eventParams);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, SessionLogger.class);
            return;
        }
    }

    private final void logClockSkewEvent() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            String string = TAG;
            Intrinsics.checkNotNull((Object)string);
            Logger.Companion.log(LoggingBehavior.APP_EVENTS, string, "Clock skew detected");
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    @JvmStatic
    @VisibleForTesting
    public static final int getQuantaIndex(long l) {
        if (CrashShieldHandler.isObjectCrashing(SessionLogger.class)) {
            return 0;
        }
        try {
            long timeBetweenSessions;
            int quantaIndex;
            for (quantaIndex = 0; quantaIndex < INACTIVE_SECONDS_QUANTA.length && INACTIVE_SECONDS_QUANTA[quantaIndex] < timeBetweenSessions; ++quantaIndex) {
            }
            return quantaIndex;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, SessionLogger.class);
            return 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String computePackageChecksum(@NotNull Context context) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return null;
        }
        try {
            String string;
            void context2;
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            try {
                String string2;
                PackageManager pm = context2.getPackageManager();
                String packageVersion = pm.getPackageInfo((String)context2.getPackageName(), (int)0).versionName;
                String packageHashSharedPrefKey = "PCKGCHKSUM;" + packageVersion;
                SharedPreferences preferences = context2.getSharedPreferences("com.facebook.sdk.appEventPreferences", 0);
                String packageHash = preferences.getString(packageHashSharedPrefKey, null);
                if (packageHash != null && packageHash.length() == 32) {
                    return packageHash;
                }
                String androidPackageManagerChecksum = HashUtils.computeChecksumWithPackageManager((Context)context2, null);
                if (androidPackageManagerChecksum != null) {
                    string2 = androidPackageManagerChecksum;
                } else {
                    ApplicationInfo ai = pm.getApplicationInfo(context2.getPackageName(), 0);
                    string2 = HashUtils.computeChecksum(ai.sourceDir);
                }
                packageHash = string2;
                preferences.edit().putString(packageHashSharedPrefKey, packageHash).apply();
                string = packageHash;
            }
            catch (Exception e) {
                string = null;
            }
            return string;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return null;
        }
    }

    private SessionLogger() {
    }

    static {
        SessionLogger sessionLogger;
        INSTANCE = sessionLogger = new SessionLogger();
        TAG = SessionLogger.class.getCanonicalName();
        INACTIVE_SECONDS_QUANTA = new long[]{300000L, 900000L, 1800000L, 3600000L, 21600000L, 43200000L, 86400000L, 172800000L, 259200000L, 604800000L, 1209600000L, 1814400000L, 2419200000L, 5184000000L, 7776000000L, 10368000000L, 12960000000L, 15552000000L, 31536000000L};
    }
}

