/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.internal;

import android.content.Context;
import android.content.pm.PackageManager;
import android.util.Base64;
import android.util.Log;
import androidx.annotation.VisibleForTesting;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000b\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\u0006H\u0007J!\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0007\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/facebook/appevents/internal/HashUtils;", "", "()V", "BUFFER_SIZE", "", "MD5", "", "TAG", "TRUSTED_CERTS", "", "[Ljava/lang/String;", "computeChecksum", "path", "computeChecksumWithPackageManager", "context", "Landroid/content/Context;", "nanosTimeout", "", "(Landroid/content/Context;Ljava/lang/Long;)Ljava/lang/String;", "computeFileMd5", "file", "Ljava/io/File;", "facebook-core_release"})
@VisibleForTesting(otherwise=3)
public final class HashUtils {
    private static final String MD5 = "MD5";
    private static final int BUFFER_SIZE = 1024;
    private static final String TAG;
    private static final String[] TRUSTED_CERTS;
    public static final HashUtils INSTANCE;

    @JvmStatic
    @NotNull
    public static final String computeChecksum(@Nullable String path) throws Exception {
        return INSTANCE.computeFileMd5(new File(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String computeFileMd5(File file) throws Exception {
        Closeable closeable = new BufferedInputStream(new FileInputStream(file), 1024);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            BufferedInputStream fis = (BufferedInputStream)closeable;
            boolean bl3 = false;
            MessageDigest md = MessageDigest.getInstance(MD5);
            byte[] buffer = new byte[1024];
            int numRead = 0;
            do {
                if ((numRead = fis.read(buffer)) <= 0) continue;
                md.update(buffer, 0, numRead);
            } while (numRead != -1);
            String string = new BigInteger(1, md.digest()).toString(16);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"BigInteger(1, md.digest()).toString(16)");
            String string2 = string;
            return string2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final String computeChecksumWithPackageManager(@NotNull Context context, @Nullable Long nanosTimeout) {
        String string;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        Ref.ObjectRef $this$map$iv = TRUSTED_CERTS;
        boolean $i$f$map = false;
        Ref.ObjectRef objectRef = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((String[])$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            string = item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Certificate certificate = certFactory.generateCertificate(new ByteArrayInputStream(Base64.decode((String)it, (int)0)));
            collection.add(certificate);
        }
        List trustedInstaller = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        $this$map$iv = new Ref.ObjectRef();
        $this$map$iv.element = null;
        ReentrantLock lock = new ReentrantLock();
        Condition checksumReady = lock.newCondition();
        lock.lock();
        try {
            void resultChecksum;
            Class<?> clazz = Class.forName("android.content.pm.Checksum");
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"Class.forName(\"android.content.pm.Checksum\")");
            Class<?> checksumClass = clazz;
            Field field = checksumClass.getField("TYPE_WHOLE_MD5");
            Intrinsics.checkNotNullExpressionValue((Object)field, (String)"checksumClass.getField(\"TYPE_WHOLE_MD5\")");
            Field typeWholeMd5Field = field;
            Object TYPE_WHOLE_MD5 = typeWholeMd5Field.get(null);
            Class<?> clazz2 = Class.forName("android.content.pm.PackageManager$OnChecksumsReadyListener");
            Intrinsics.checkNotNullExpressionValue(clazz2, (String)"Class.forName(\"android.c\u2026nChecksumsReadyListener\")");
            Class<?> checksumReadyListenerClass = clazz2;
            Object object = Proxy.newProxyInstance(HashUtils.class.getClassLoader(), new Class[]{checksumReadyListenerClass}, new InvocationHandler(TYPE_WHOLE_MD5, (Ref.ObjectRef)resultChecksum, lock, checksumReady){
                final /* synthetic */ Object $TYPE_WHOLE_MD5;
                final /* synthetic */ Ref.ObjectRef $resultChecksum;
                final /* synthetic */ ReentrantLock $lock;
                final /* synthetic */ Condition $checksumReady;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Nullable
                public Object invoke(@Nullable Object o, @NotNull Method method, @NotNull Object[] objects) {
                    block8: {
                        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
                        try {
                            if (!Intrinsics.areEqual((Object)method.getName(), (Object)"onChecksumsReady") || objects.length != 1 || !(objects[0] instanceof List)) break block8;
                            Object object = objects[0];
                            if (object == null) {
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<*>");
                            }
                            List list = (List)object;
                            for (E c : list) {
                                Method getTypeMethod;
                                Method getSplitNameMethod;
                                if (c == null) continue;
                                Intrinsics.checkNotNullExpressionValue((Object)c.getClass().getMethod("getSplitName", new Class[0]), (String)"c.javaClass.getMethod(\"getSplitName\")");
                                Intrinsics.checkNotNullExpressionValue((Object)c.getClass().getMethod("getType", new Class[0]), (String)"c.javaClass.getMethod(\"getType\")");
                                if (getSplitNameMethod.invoke(c, new Object[0]) != null || !Intrinsics.areEqual((Object)getTypeMethod.invoke(c, new Object[0]), (Object)this.$TYPE_WHOLE_MD5)) continue;
                                Method method2 = c.getClass().getMethod("getValue", new Class[0]);
                                Intrinsics.checkNotNullExpressionValue((Object)method2, (String)"c.javaClass.getMethod(\"getValue\")");
                                Method getValueMethod = method2;
                                Object object2 = getValueMethod.invoke(c, new Object[0]);
                                if (object2 == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.ByteArray");
                                }
                                byte[] checksumValue = (byte[])object2;
                                this.$resultChecksum.element = new BigInteger(1, checksumValue).toString(16);
                                this.$lock.lock();
                                try {
                                    this.$checksumReady.signalAll();
                                }
                                finally {
                                    this.$lock.unlock();
                                }
                                return null;
                            }
                        }
                        catch (Throwable t) {
                            Log.d((String)HashUtils.access$getTAG$p(HashUtils.INSTANCE), (String)"Can't fetch checksum.", (Throwable)t);
                        }
                    }
                    return null;
                }
                {
                    this.$TYPE_WHOLE_MD5 = $captured_local_variable$0;
                    this.$resultChecksum = $captured_local_variable$1;
                    this.$lock = $captured_local_variable$2;
                    this.$checksumReady = $captured_local_variable$3;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Proxy.newProxyInstance(\n\u2026       }\n              })");
            Object listener2 = object;
            Method method = PackageManager.class.getMethod("requestChecksums", String.class, Boolean.TYPE, Integer.TYPE, List.class, checksumReadyListenerClass);
            Intrinsics.checkNotNullExpressionValue((Object)method, (String)"PackageManager::class.ja\u2026ecksumReadyListenerClass)");
            Method requestChecksumsMethod = method;
            requestChecksumsMethod.invoke((Object)context.getPackageManager(), context.getPackageName(), false, TYPE_WHOLE_MD5, CollectionsKt.toMutableList((Collection)trustedInstaller), listener2);
            if (nanosTimeout == null) {
                checksumReady.await();
            } else {
                checksumReady.awaitNanos(nanosTimeout);
            }
            string = (String)resultChecksum.element;
            return string;
        }
        catch (Throwable t) {
            String string2 = null;
            return string2;
        }
        finally {
            lock.unlock();
        }
    }

    private HashUtils() {
    }

    static {
        HashUtils hashUtils;
        INSTANCE = hashUtils = new HashUtils();
        String string = HashUtils.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"HashUtils::class.java.simpleName");
        TAG = string;
        TRUSTED_CERTS = new String[]{"MIIEQzCCAyugAwIBAgIJAMLgh0ZkSjCNMA0GCSqGSIb3DQEBBAUAMHQxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpDYWxpZm9ybmlhMRYwFAYDVQQHEw1Nb3VudGFpbiBWaWV3MRQwEgYDVQQKEwtHb29nbGUgSW5jLjEQMA4GA1UECxMHQW5kcm9pZDEQMA4GA1UEAxMHQW5kcm9pZDAeFw0wODA4MjEyMzEzMzRaFw0zNjAxMDcyMzEzMzRaMHQxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpDYWxpZm9ybmlhMRYwFAYDVQQHEw1Nb3VudGFpbiBWaWV3MRQwEgYDVQQKEwtHb29nbGUgSW5jLjEQMA4GA1UECxMHQW5kcm9pZDEQMA4GA1UEAxMHQW5kcm9pZDCCASAwDQYJKoZIhvcNAQEBBQADggENADCCAQgCggEBAKtWLgDYO6IIrgqWbxJOKdoR8qtW0I9Y4sypEwPpt1TTcvZApxsdyxMJZ2JORland2qSGT2y5b+3JKkedxiLDmpHpDsz2WCbdxgxRczfey5YZnTJ4VZbH0xqWVW/8lGmPav5xVwnIiJS6HXk+BVKZF+JcWjAsb/GEuq/eFdpuzSqeYTcfi6idkyugwfYwXFU1+5fZKUaRKYCwkkFQVfcAs1fXA5V+++FGfvjJ/CxURaSxaBvGdGDhfXE28LWuT9ozCl5xw4Yq5OGazvV24mZVSoOO0yZ31j7kYvtwYK6NeADwbSxDdJEqO4k//0zOHKrUiGYXtqw/A0LFFtqoZKFjnkCAQOjgdkwgdYwHQYDVR0OBBYEFMd9jMIhF1Ylmn/Tgt9r45jk14alMIGmBgNVHSMEgZ4wgZuAFMd9jMIhF1Ylmn/Tgt9r45jk14aloXikdjB0MQswCQYDVQQGEwJVUzETMBEGA1UECBMKQ2FsaWZvcm5pYTEWMBQGA1UEBxMNTW91bnRhaW4gVmlldzEUMBIGA1UEChMLR29vZ2xlIEluYy4xEDAOBgNVBAsTB0FuZHJvaWQxEDAOBgNVBAMTB0FuZHJvaWSCCQDC4IdGZEowjTAMBgNVHRMEBTADAQH/MA0GCSqGSIb3DQEBBAUAA4IBAQBt0lLO74UwLDYKqs6Tm8/yzKkEu116FmH4rkaymUIE0P9KaMftGlMexFlaYjzmB2OxZyl6euNXEsQH8gjwyxCUKRJNexBiGcCEyj6z+a1fuHHvkiaai+KL8W1EyNmgjmyy8AW7P+LLlkR+ho5zEHatRbM/YAnqGcFh5iZBqpknHf1SKMXFh4dd239FJ1jWYfbMDMy3NS5CTMQ2XFI1MvcyUTdZPErjQfTbQe3aDQsQcafEQPD+nqActifKZ0Np0IS9L9kR/wbNvyz6ENwPiTrjV2KRkEjH78ZMcUQXg0L3BYHJ3lc69Vs5Ddf9uUGGMYldX3WfMBEmh/9iFBDAaTCK", "MIIEqDCCA5CgAwIBAgIJANWFuGx90071MA0GCSqGSIb3DQEBBAUAMIGUMQswCQYDVQQGEwJVUzETMBEGA1UECBMKQ2FsaWZvcm5pYTEWMBQGA1UEBxMNTW91bnRhaW4gVmlldzEQMA4GA1UEChMHQW5kcm9pZDEQMA4GA1UECxMHQW5kcm9pZDEQMA4GA1UEAxMHQW5kcm9pZDEiMCAGCSqGSIb3DQEJARYTYW5kcm9pZEBhbmRyb2lkLmNvbTAeFw0wODA0MTUyMzM2NTZaFw0zNTA5MDEyMzM2NTZaMIGUMQswCQYDVQQGEwJVUzETMBEGA1UECBMKQ2FsaWZvcm5pYTEWMBQGA1UEBxMNTW91bnRhaW4gVmlldzEQMA4GA1UEChMHQW5kcm9pZDEQMA4GA1UECxMHQW5kcm9pZDEQMA4GA1UEAxMHQW5kcm9pZDEiMCAGCSqGSIb3DQEJARYTYW5kcm9pZEBhbmRyb2lkLmNvbTCCASAwDQYJKoZIhvcNAQEBBQADggENADCCAQgCggEBANbOLggKv+IxTdGNs8/TGFy0PTP6DHThvbbR24kT9ixcOd9W+EaBPWW+wPPKQmsHxajtWjmQwWfna8mZuSeJS48LIgAZlKkpFeVyxW0qMBujb8X8ETrWy550NaFtI6t9+u7hZeTfHwqNvacKhp1RbE6dBRGWynwMVX8XW8N1+UjFaq6GCJukT4qmpN2afb8sCjUigq0GuMwYXrFVee74bQgLHWGJwPmvmLHC69EH6kWr22ijx4OKXlSIx2xT1AsSHee70w5iDBiK4aph27yH3TxkXy9V89TDdexAcKk/cVHYNnDBapcavl7y0RiQ4biu8ymM8Ga/nmzhRKya6G0cGw8CAQOjgfwwgfkwHQYDVR0OBBYEFI0cxb6VTEM8YYY6FbBMvAPyT+CyMIHJBgNVHSMEgcEwgb6AFI0cxb6VTEM8YYY6FbBMvAPyT+CyoYGapIGXMIGUMQswCQYDVQQGEwJVUzETMBEGA1UECBMKQ2FsaWZvcm5pYTEWMBQGA1UEBxMNTW91bnRhaW4gVmlldzEQMA4GA1UEChMHQW5kcm9pZDEQMA4GA1UECxMHQW5kcm9pZDEQMA4GA1UEAxMHQW5kcm9pZDEiMCAGCSqGSIb3DQEJARYTYW5kcm9pZEBhbmRyb2lkLmNvbYIJANWFuGx90071MAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEEBQADggEBABnTDPEF+3iSP0wNfdIjIz1AlnrPzgAIHVvXxunW7SBrDhEglQZBbKJEk5kT0mtKoOD1JMrSu1xuTKEBahWRbqHsXclaXjoBADb0kkjVEJu/Lh5hgYZnOjvlba8Ld7HCKePCVePoTJBdI4fvugnL8TsgK05aIskyY0hKI9L8KfqfGTl1lzOv2KoWD0KWwtAWPoGChZxmQ+nBli+gwYMzM1vAkP+aayLe0a1EQimlOalO762r0GXO0ks+UeXde2Z4e+8S/pf7pITEI/tP+MxJTALw9QUWEv9lKTk+jkbqxbsh8nfBUapfKqYn0eidpwq2AzVp3juYl7//fKnaPhJD9gs="};
    }

    public static final /* synthetic */ String access$getTAG$p(HashUtils $this) {
        HashUtils hashUtils = $this;
        return TAG;
    }
}

