/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.iap;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import androidx.annotation.RestrictTo;
import com.facebook.FacebookSdk;
import com.facebook.appevents.iap.InAppPurchaseActivityLifecycleTracker;
import com.facebook.appevents.iap.InAppPurchaseAutoLogger;
import com.facebook.internal.FeatureManager;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.util.concurrent.atomic.AtomicBoolean;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class InAppPurchaseManager {
    private static final String GOOGLE_BILLINGCLIENT_VERSION = "com.google.android.play.billingclient.version";
    private static final AtomicBoolean enabled = new AtomicBoolean(false);

    public static void enableAutoLogging() {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseManager.class)) {
            return;
        }
        try {
            enabled.set(true);
            InAppPurchaseManager.startTracking();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseManager.class);
            return;
        }
    }

    public static void startTracking() {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseManager.class)) {
            return;
        }
        try {
            if (enabled.get()) {
                if (InAppPurchaseManager.usingBillingLib2Plus() && FeatureManager.isEnabled(FeatureManager.Feature.IapLoggingLib2)) {
                    InAppPurchaseAutoLogger.startIapLogging(FacebookSdk.getApplicationContext());
                } else {
                    InAppPurchaseActivityLifecycleTracker.startIapLogging();
                }
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseManager.class);
            return;
        }
    }

    private static boolean usingBillingLib2Plus() {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseManager.class)) {
            return false;
        }
        try {
            try {
                Context context = FacebookSdk.getApplicationContext();
                ApplicationInfo info = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
                if (info != null) {
                    String version = info.metaData.getString(GOOGLE_BILLINGCLIENT_VERSION);
                    String[] versionArray = version.split("\\.", 3);
                    return Integer.parseInt(versionArray[0]) >= 2;
                }
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseManager.class);
            return false;
        }
    }
}

