/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.iap;

import android.content.SharedPreferences;
import androidx.annotation.RestrictTo;
import com.facebook.FacebookSdk;
import com.facebook.appevents.internal.AutomaticAnalyticsLogger;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class InAppPurchaseLoggerManager {
    private static SharedPreferences sharedPreferences;
    private static final Set<String> cachedPurchaseSet;
    private static final Map<String, Long> cachedPurchaseMap;
    private static final String PURCHASE_TIME = "purchaseTime";
    private static final String PRODUCT_DETAILS_STORE = "com.facebook.internal.iap.PRODUCT_DETAILS";
    private static final String LAST_CLEARED_TIME = "LAST_CLEARED_TIME";
    private static final String PURCHASE_DETAILS_SET = "PURCHASE_DETAILS_SET";
    private static final String LAST_QUERY_PURCHASE_HISTORY_TIME = "LAST_QUERY_PURCHASE_HISTORY_TIME";
    private static final int CACHE_CLEAR_TIME_LIMIT_SEC = 604800;
    private static final int PURCHASE_IN_CACHE_INTERVAL = 86400;

    private static void readPurchaseCache() {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseLoggerManager.class)) {
            return;
        }
        try {
            SharedPreferences cachedSkuSharedPref = FacebookSdk.getApplicationContext().getSharedPreferences("com.facebook.internal.SKU_DETAILS", 0);
            SharedPreferences cachedPurchaseSharedPref = FacebookSdk.getApplicationContext().getSharedPreferences("com.facebook.internal.PURCHASE", 0);
            if (cachedSkuSharedPref.contains(LAST_CLEARED_TIME)) {
                cachedSkuSharedPref.edit().clear().apply();
                cachedPurchaseSharedPref.edit().clear().apply();
            }
            sharedPreferences = FacebookSdk.getApplicationContext().getSharedPreferences(PRODUCT_DETAILS_STORE, 0);
            cachedPurchaseSet.addAll(sharedPreferences.getStringSet(PURCHASE_DETAILS_SET, new HashSet()));
            for (String purchaseHistory : cachedPurchaseSet) {
                String[] splitPurchase = purchaseHistory.split(";", 2);
                cachedPurchaseMap.put(splitPurchase[0], Long.parseLong(splitPurchase[1]));
            }
            InAppPurchaseLoggerManager.clearOutdatedProductInfoInCache();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseLoggerManager.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void filterPurchaseLogging(Map<String, JSONObject> map, Map<String, JSONObject> map2) {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseLoggerManager.class)) {
            return;
        }
        try {
            void skuDetailsMap;
            Map<String, JSONObject> purchaseDetailsMap;
            InAppPurchaseLoggerManager.readPurchaseCache();
            HashMap<String, String> loggingReadyMap = new HashMap<String, String>(InAppPurchaseLoggerManager.constructLoggingReadyMap(InAppPurchaseLoggerManager.cacheDeDupPurchase(purchaseDetailsMap), (Map<String, JSONObject>)skuDetailsMap));
            InAppPurchaseLoggerManager.logPurchases(loggingReadyMap);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseLoggerManager.class);
            return;
        }
    }

    static void logPurchases(Map<String, String> map) {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseLoggerManager.class)) {
            return;
        }
        try {
            Map<String, String> purchaseDetailsMap;
            for (Map.Entry<String, String> pair : purchaseDetailsMap.entrySet()) {
                String purchaseDetails = pair.getKey();
                String skuDetails = pair.getValue();
                if (purchaseDetails == null || skuDetails == null) continue;
                AutomaticAnalyticsLogger.logPurchase(purchaseDetails, skuDetails, false);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseLoggerManager.class);
            return;
        }
    }

    static Map<String, JSONObject> cacheDeDupPurchase(Map<String, JSONObject> map) {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseLoggerManager.class)) {
            return null;
        }
        try {
            Map<String, JSONObject> purchaseDetailsMap;
            long nowSec = System.currentTimeMillis() / 1000L;
            HashMap<String, JSONObject> tempPurchaseDetailsMap = new HashMap<String, JSONObject>(purchaseDetailsMap);
            for (Map.Entry entry : tempPurchaseDetailsMap.entrySet()) {
                try {
                    JSONObject purchaseJson = (JSONObject)entry.getValue();
                    if (!purchaseJson.has("purchaseToken")) continue;
                    String purchaseToken = purchaseJson.getString("purchaseToken");
                    if (cachedPurchaseMap.containsKey(purchaseToken)) {
                        purchaseDetailsMap.remove(entry.getKey());
                        continue;
                    }
                    cachedPurchaseSet.add(purchaseToken + ';' + nowSec);
                }
                catch (Exception exception) {}
            }
            sharedPreferences.edit().putStringSet(PURCHASE_DETAILS_SET, cachedPurchaseSet).apply();
            return new HashMap<String, JSONObject>(purchaseDetailsMap);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseLoggerManager.class);
            return null;
        }
    }

    private static void clearOutdatedProductInfoInCache() {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseLoggerManager.class)) {
            return;
        }
        try {
            long nowSec = System.currentTimeMillis() / 1000L;
            long lastClearedTimeSec = sharedPreferences.getLong(LAST_CLEARED_TIME, 0L);
            if (lastClearedTimeSec == 0L) {
                sharedPreferences.edit().putLong(LAST_CLEARED_TIME, nowSec).apply();
            } else if (nowSec - lastClearedTimeSec > 604800L) {
                HashMap<String, Long> tempPurchaseMap = new HashMap<String, Long>(cachedPurchaseMap);
                for (Map.Entry historyPurchase : tempPurchaseMap.entrySet()) {
                    String purchaseToken = (String)historyPurchase.getKey();
                    Long historyPurchaseTime = (Long)historyPurchase.getValue();
                    if (nowSec - historyPurchaseTime <= 86400L) continue;
                    cachedPurchaseSet.remove(purchaseToken + ";" + historyPurchaseTime);
                    cachedPurchaseMap.remove(purchaseToken);
                }
                sharedPreferences.edit().putStringSet(PURCHASE_DETAILS_SET, cachedPurchaseSet).putLong(LAST_CLEARED_TIME, nowSec).apply();
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseLoggerManager.class);
            return;
        }
    }

    public static boolean eligibleQueryPurchaseHistory() {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseLoggerManager.class)) {
            return false;
        }
        try {
            InAppPurchaseLoggerManager.readPurchaseCache();
            long nowSec = System.currentTimeMillis() / 1000L;
            long lastQueryPurchaseHistoryTime = sharedPreferences.getLong(LAST_QUERY_PURCHASE_HISTORY_TIME, 0L);
            if (lastQueryPurchaseHistoryTime != 0L && nowSec - lastQueryPurchaseHistoryTime < 86400L) {
                return false;
            }
            sharedPreferences.edit().putLong(LAST_QUERY_PURCHASE_HISTORY_TIME, nowSec).apply();
            return true;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseLoggerManager.class);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    static Map<String, String> constructLoggingReadyMap(Map<String, JSONObject> map, Map<String, JSONObject> map2) {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseLoggerManager.class)) {
            return null;
        }
        try {
            Map<String, JSONObject> purchaseDetailsMap;
            long nowSec = System.currentTimeMillis() / 1000L;
            HashMap<String, String> purchaseResultMap = new HashMap<String, String>();
            for (Map.Entry<String, JSONObject> pair : purchaseDetailsMap.entrySet()) {
                void skuDetailsMap;
                JSONObject skuDetail = (JSONObject)skuDetailsMap.get(pair.getKey());
                JSONObject purchaseDetail = pair.getValue();
                if (purchaseDetail == null || !purchaseDetail.has(PURCHASE_TIME)) continue;
                try {
                    long purchaseTime = purchaseDetail.getLong(PURCHASE_TIME);
                    if (nowSec - purchaseTime / 1000L > 86400L || skuDetail == null) continue;
                    purchaseResultMap.put(purchaseDetail.toString(), skuDetail.toString());
                }
                catch (Exception exception) {}
            }
            return purchaseResultMap;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseLoggerManager.class);
            return null;
        }
    }

    static {
        cachedPurchaseSet = new CopyOnWriteArraySet<String>();
        cachedPurchaseMap = new ConcurrentHashMap<String, Long>();
    }
}

