/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.codeless.internal;

import android.util.Log;
import java.lang.reflect.Method;

public class UnityReflection {
    private static final String TAG = UnityReflection.class.getCanonicalName();
    private static final String UNITY_PLAYER_CLASS = "com.unity3d.player.UnityPlayer";
    private static final String UNITY_SEND_MESSAGE_METHOD = "UnitySendMessage";
    private static final String FB_UNITY_GAME_OBJECT = "UnityFacebookSDKPlugin";
    private static final String CAPTURE_VIEW_HIERARCHY_METHOD = "CaptureViewHierarchy";
    private static final String EVENT_MAPPING_METHOD = "OnReceiveMapping";
    private static Class<?> unityPlayer;

    public static void sendMessage(String unityObject, String unityMethod, String message) {
        try {
            if (unityPlayer == null) {
                unityPlayer = Class.forName(UNITY_PLAYER_CLASS);
            }
            Method method = unityPlayer.getMethod(UNITY_SEND_MESSAGE_METHOD, String.class, String.class, String.class);
            method.invoke(unityPlayer, unityObject, unityMethod, message);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Failed to send message to Unity", (Throwable)e);
        }
    }

    public static void captureViewHierarchy() {
        UnityReflection.sendMessage(FB_UNITY_GAME_OBJECT, CAPTURE_VIEW_HIERARCHY_METHOD, "");
    }

    public static void sendEventMapping(String eventMapping) {
        UnityReflection.sendMessage(FB_UNITY_GAME_OBJECT, EVENT_MAPPING_METHOD, eventMapping);
    }
}

