/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.aam;

import android.content.res.Resources;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.TextView;
import com.facebook.appevents.codeless.internal.ViewHierarchy;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.util.ArrayList;
import java.util.List;

final class MetadataMatcher {
    private static final String TAG = MetadataMatcher.class.getCanonicalName();
    private static final int MAX_INDICATOR_LENGTH = 100;

    MetadataMatcher() {
    }

    static List<String> getCurrentViewIndicators(View view) {
        if (CrashShieldHandler.isObjectCrashing(MetadataMatcher.class)) {
            return null;
        }
        try {
            CharSequence description;
            View view2;
            ArrayList<String> indicators = new ArrayList<String>();
            indicators.add(ViewHierarchy.getHintOfView(view2));
            Object tag = view2.getTag();
            if (tag != null) {
                indicators.add(tag.toString());
            }
            if ((description = view2.getContentDescription()) != null) {
                indicators.add(description.toString());
            }
            try {
                String resourceName;
                String[] splitted;
                if (view2.getId() != -1 && (splitted = (resourceName = view2.getResources().getResourceName(view2.getId())).split("/")).length == 2) {
                    indicators.add(splitted[1]);
                }
            }
            catch (Resources.NotFoundException resourceName) {
                // empty catch block
            }
            ArrayList<String> validIndicators = new ArrayList<String>();
            for (String indicator : indicators) {
                if (indicator.isEmpty() || indicator.length() > 100) continue;
                validIndicators.add(indicator.toLowerCase());
            }
            return validIndicators;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, MetadataMatcher.class);
            return null;
        }
    }

    static List<String> getAroundViewIndicators(View view) {
        if (CrashShieldHandler.isObjectCrashing(MetadataMatcher.class)) {
            return null;
        }
        try {
            View view2;
            ArrayList<String> aroundTextIndicators = new ArrayList<String>();
            ViewGroup parentView = ViewHierarchy.getParentOfView(view2);
            if (parentView != null) {
                for (View child : ViewHierarchy.getChildrenOfView((View)parentView)) {
                    if (view2 == child) continue;
                    aroundTextIndicators.addAll(MetadataMatcher.getTextIndicators(child));
                }
            }
            return aroundTextIndicators;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, MetadataMatcher.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    static boolean matchIndicator(List<String> list, List<String> list2) {
        if (CrashShieldHandler.isObjectCrashing(MetadataMatcher.class)) {
            return false;
        }
        try {
            List<String> indicators;
            for (String indicator : indicators) {
                void keys;
                if (!MetadataMatcher.matchIndicator(indicator, (List<String>)keys)) continue;
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, MetadataMatcher.class);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    static boolean matchIndicator(String string, List<String> list) {
        if (CrashShieldHandler.isObjectCrashing(MetadataMatcher.class)) {
            return false;
        }
        try {
            void keys;
            for (String key : keys) {
                String indicator;
                if (!indicator.contains(key)) continue;
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, MetadataMatcher.class);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    static boolean matchValue(String string, String string2) {
        if (CrashShieldHandler.isObjectCrashing(MetadataMatcher.class)) {
            return false;
        }
        try {
            void rule;
            String text;
            return text.matches((String)rule);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, MetadataMatcher.class);
            return false;
        }
    }

    static List<String> getTextIndicators(View view) {
        if (CrashShieldHandler.isObjectCrashing(MetadataMatcher.class)) {
            return null;
        }
        try {
            View view2;
            ArrayList<String> indicators = new ArrayList<String>();
            if (view2 instanceof EditText) {
                return indicators;
            }
            if (view2 instanceof TextView) {
                String text = ((TextView)view2).getText().toString();
                if (!text.isEmpty() && text.length() < 100) {
                    indicators.add(text.toLowerCase());
                }
                return indicators;
            }
            List<View> children = ViewHierarchy.getChildrenOfView(view2);
            for (View child : children) {
                indicators.addAll(MetadataMatcher.getTextIndicators(child));
            }
            return indicators;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, MetadataMatcher.class);
            return null;
        }
    }
}

