/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents;

import android.content.SharedPreferences;
import androidx.annotation.RestrictTo;
import com.facebook.FacebookSdk;
import com.facebook.appevents.PerformanceGuardian$WhenMappings;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0006\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001\"B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0003J\u001a\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00062\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0007J\u0012\u0010\u0019\u001a\u00020\u00102\b\u0010\u001a\u001a\u0004\u0018\u00010\u0006H\u0002J,\u0010\u001b\u001a\u00020\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u00062\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0007J:\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u00062\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00040\n2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00060\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00040\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00040\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/facebook/appevents/PerformanceGuardian;", "", "()V", "ACTIVITY_PROCESS_TIME_THRESHOLD", "", "BANNED_ACTIVITY_STORE", "", "CACHE_APP_VERSION", "MAX_EXCEED_LIMIT_COUNT", "activityProcessTimeMapCodeless", "", "activityProcessTimeMapSe", "bannedCodelessActivitySet", "", "bannedSuggestedEventActivitySet", "initialized", "", "sharedPreferences", "Landroid/content/SharedPreferences;", "initializeIfNotYet", "", "isBannedActivity", "activityName", "useCase", "Lcom/facebook/appevents/PerformanceGuardian$UseCase;", "isCacheValid", "previousVersion", "limitProcessTime", "startTime", "", "endTime", "updateActivityMap", "activityExceedLimitCountMap", "bannedActivitySet", "UseCase", "facebook-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class PerformanceGuardian {
    private static boolean initialized;
    private static SharedPreferences sharedPreferences;
    private static final String BANNED_ACTIVITY_STORE = "com.facebook.internal.BANNED_ACTIVITY";
    private static final String CACHE_APP_VERSION = "app_version";
    private static final int ACTIVITY_PROCESS_TIME_THRESHOLD = 40;
    private static final int MAX_EXCEED_LIMIT_COUNT = 3;
    private static final Set<String> bannedSuggestedEventActivitySet;
    private static final Set<String> bannedCodelessActivitySet;
    private static final Map<String, Integer> activityProcessTimeMapCodeless;
    private static final Map<String, Integer> activityProcessTimeMapSe;
    public static final PerformanceGuardian INSTANCE;

    @JvmStatic
    private static final synchronized void initializeIfNotYet() {
        if (CrashShieldHandler.isObjectCrashing(PerformanceGuardian.class)) {
            return;
        }
        try {
            String cachedVersion;
            if (initialized) {
                return;
            }
            SharedPreferences sharedPreferences = FacebookSdk.getApplicationContext().getSharedPreferences(BANNED_ACTIVITY_STORE, 0);
            Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"FacebookSdk.getApplicati\u2026RE, Context.MODE_PRIVATE)");
            SharedPreferences sharedPreferences2 = PerformanceGuardian.sharedPreferences = sharedPreferences;
            if (sharedPreferences2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sharedPreferences");
            }
            if (!INSTANCE.isCacheValid(cachedVersion = sharedPreferences2.getString(CACHE_APP_VERSION, ""))) {
                SharedPreferences sharedPreferences3 = PerformanceGuardian.sharedPreferences;
                if (sharedPreferences3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"sharedPreferences");
                }
                sharedPreferences3.edit().clear().apply();
            } else {
                Collection collection;
                Collection collection2;
                SharedPreferences sharedPreferences4 = PerformanceGuardian.sharedPreferences;
                if (sharedPreferences4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"sharedPreferences");
                }
                boolean bl = false;
                Set set = sharedPreferences4.getStringSet(UseCase.CODELESS.toString(), (Set)new LinkedHashSet());
                if (set != null) {
                    collection2 = set;
                } else {
                    bl = false;
                    collection2 = new LinkedHashSet();
                }
                bannedCodelessActivitySet.addAll(collection2);
                SharedPreferences sharedPreferences5 = PerformanceGuardian.sharedPreferences;
                if (sharedPreferences5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"sharedPreferences");
                }
                bl = false;
                Set set2 = sharedPreferences5.getStringSet(UseCase.SUGGESTED_EVENT.toString(), (Set)new LinkedHashSet());
                if (set2 != null) {
                    collection = set2;
                } else {
                    bl = false;
                    collection = new LinkedHashSet();
                }
                bannedSuggestedEventActivitySet.addAll(collection);
            }
            initialized = true;
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, PerformanceGuardian.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final boolean isBannedActivity(@NotNull String string, @Nullable UseCase useCase) {
        if (CrashShieldHandler.isObjectCrashing(PerformanceGuardian.class)) {
            return false;
        }
        try {
            void useCase2;
            String activityName;
            Intrinsics.checkNotNullParameter((Object)activityName, (String)"activityName");
            PerformanceGuardian.initializeIfNotYet();
            void v0 = useCase2;
            if (v0 != null) {
                switch (PerformanceGuardian$WhenMappings.$EnumSwitchMapping$0[v0.ordinal()]) {
                    case 1: {
                        return bannedCodelessActivitySet.contains(activityName);
                    }
                    case 2: {
                        return bannedSuggestedEventActivitySet.contains(activityName);
                    }
                }
            }
            return false;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, PerformanceGuardian.class);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void limitProcessTime(@Nullable String string, @Nullable UseCase useCase, long l, long l2) {
        if (CrashShieldHandler.isObjectCrashing(PerformanceGuardian.class)) {
            return;
        }
        try {
            void useCase2;
            String activityName;
            void startTime;
            void endTime;
            PerformanceGuardian.initializeIfNotYet();
            void processTime = endTime - startTime;
            if (activityName == null || processTime < (long)40) {
                return;
            }
            void v0 = useCase2;
            if (v0 != null) {
                switch (PerformanceGuardian$WhenMappings.$EnumSwitchMapping$1[v0.ordinal()]) {
                    case 1: {
                        INSTANCE.updateActivityMap((UseCase)useCase2, activityName, activityProcessTimeMapCodeless, bannedCodelessActivitySet);
                        break;
                    }
                    case 2: {
                        INSTANCE.updateActivityMap((UseCase)useCase2, activityName, activityProcessTimeMapSe, bannedSuggestedEventActivitySet);
                        break;
                    }
                }
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, PerformanceGuardian.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateActivityMap(UseCase useCase, String string, Map<String, Integer> map, Set<String> set) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void activityName;
            void activityExceedLimitCountMap;
            int curExceedLimitCount = 0;
            if (activityExceedLimitCountMap.containsKey(activityName)) {
                Integer n = (Integer)activityExceedLimitCountMap.get(activityName);
                curExceedLimitCount = n != null ? n : 0;
            }
            activityExceedLimitCountMap.put(activityName, curExceedLimitCount + 1);
            if (curExceedLimitCount + 1 >= 3) {
                void useCase2;
                void bannedActivitySet;
                bannedActivitySet.add(activityName);
                SharedPreferences sharedPreferences = PerformanceGuardian.sharedPreferences;
                if (sharedPreferences == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"sharedPreferences");
                }
                sharedPreferences.edit().putStringSet(useCase2.toString(), (Set)bannedActivitySet).putString(CACHE_APP_VERSION, Utility.getAppVersion()).apply();
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isCacheValid(String string) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return false;
        }
        try {
            void previousVersion;
            String appVersion = Utility.getAppVersion();
            if (appVersion == null) return false;
            if (previousVersion == null) return false;
            CharSequence charSequence = (CharSequence)previousVersion;
            boolean bl = false;
            if (charSequence.length() == 0) {
                return false;
            }
            boolean bl2 = false;
            if (bl2) {
                return false;
            }
            boolean bl3 = Intrinsics.areEqual((Object)previousVersion, (Object)appVersion);
            return bl3;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return false;
        }
    }

    private PerformanceGuardian() {
    }

    static {
        PerformanceGuardian performanceGuardian;
        INSTANCE = performanceGuardian = new PerformanceGuardian();
        boolean bl = false;
        bannedSuggestedEventActivitySet = new HashSet();
        bl = false;
        bannedCodelessActivitySet = new HashSet();
        bl = false;
        activityProcessTimeMapCodeless = new HashMap();
        bl = false;
        activityProcessTimeMapSe = new HashMap();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/facebook/appevents/PerformanceGuardian$UseCase;", "", "(Ljava/lang/String;I)V", "CODELESS", "SUGGESTED_EVENT", "facebook-core_release"})
    public static final class UseCase
    extends Enum<UseCase> {
        public static final /* enum */ UseCase CODELESS;
        public static final /* enum */ UseCase SUGGESTED_EVENT;
        private static final /* synthetic */ UseCase[] $VALUES;

        static {
            UseCase[] useCaseArray = new UseCase[2];
            UseCase[] useCaseArray2 = useCaseArray;
            useCaseArray[0] = CODELESS = new UseCase();
            useCaseArray[1] = SUGGESTED_EVENT = new UseCase();
            $VALUES = useCaseArray;
        }

        public static UseCase[] values() {
            return (UseCase[])$VALUES.clone();
        }

        public static UseCase valueOf(String string) {
            return Enum.valueOf(UseCase.class, string);
        }
    }
}

