/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import androidx.annotation.VisibleForTesting;
import com.facebook.AccessTokenSource;
import com.facebook.LoggingBehavior;
import com.facebook.internal.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u001b\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eJ\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eJ \u0010\u0011\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/facebook/LegacyTokenHelper;", "", "context", "Landroid/content/Context;", "cacheKey", "", "(Landroid/content/Context;Ljava/lang/String;)V", "cache", "Landroid/content/SharedPreferences;", "clear", "", "deserializeKey", "key", "bundle", "Landroid/os/Bundle;", "load", "save", "serializeKey", "editor", "Landroid/content/SharedPreferences$Editor;", "Companion", "facebook-core_release"})
@VisibleForTesting(otherwise=3)
public final class LegacyTokenHelper {
    private final String cacheKey;
    private final SharedPreferences cache;
    @NotNull
    public static final String TOKEN_KEY = "com.facebook.TokenCachingStrategy.Token";
    @NotNull
    public static final String EXPIRATION_DATE_KEY = "com.facebook.TokenCachingStrategy.ExpirationDate";
    @NotNull
    public static final String LAST_REFRESH_DATE_KEY = "com.facebook.TokenCachingStrategy.LastRefreshDate";
    @NotNull
    public static final String TOKEN_SOURCE_KEY = "com.facebook.TokenCachingStrategy.AccessTokenSource";
    @NotNull
    public static final String PERMISSIONS_KEY = "com.facebook.TokenCachingStrategy.Permissions";
    @NotNull
    public static final String DECLINED_PERMISSIONS_KEY = "com.facebook.TokenCachingStrategy.DeclinedPermissions";
    @NotNull
    public static final String EXPIRED_PERMISSIONS_KEY = "com.facebook.TokenCachingStrategy.ExpiredPermissions";
    @NotNull
    public static final String APPLICATION_ID_KEY = "com.facebook.TokenCachingStrategy.ApplicationId";
    private static final long INVALID_BUNDLE_MILLISECONDS = Long.MIN_VALUE;
    private static final String IS_SSO_KEY = "com.facebook.TokenCachingStrategy.IsSSO";
    @NotNull
    public static final String DEFAULT_CACHE_KEY = "com.facebook.SharedPreferencesTokenCachingStrategy.DEFAULT_KEY";
    private static final String TAG;
    private static final String JSON_VALUE_TYPE = "valueType";
    private static final String JSON_VALUE = "value";
    private static final String JSON_VALUE_ENUM_TYPE = "enumType";
    private static final String TYPE_BOOLEAN = "bool";
    private static final String TYPE_BOOLEAN_ARRAY = "bool[]";
    private static final String TYPE_BYTE = "byte";
    private static final String TYPE_BYTE_ARRAY = "byte[]";
    private static final String TYPE_SHORT = "short";
    private static final String TYPE_SHORT_ARRAY = "short[]";
    private static final String TYPE_INTEGER = "int";
    private static final String TYPE_INTEGER_ARRAY = "int[]";
    private static final String TYPE_LONG = "long";
    private static final String TYPE_LONG_ARRAY = "long[]";
    private static final String TYPE_FLOAT = "float";
    private static final String TYPE_FLOAT_ARRAY = "float[]";
    private static final String TYPE_DOUBLE = "double";
    private static final String TYPE_DOUBLE_ARRAY = "double[]";
    private static final String TYPE_CHAR = "char";
    private static final String TYPE_CHAR_ARRAY = "char[]";
    private static final String TYPE_STRING = "string";
    private static final String TYPE_STRING_LIST = "stringList";
    private static final String TYPE_ENUM = "enum";
    public static final Companion Companion;

    @Nullable
    public final Bundle load() {
        Bundle settings = new Bundle();
        Map allCachedEntries = this.cache.getAll();
        for (String key : allCachedEntries.keySet()) {
            try {
                String string = key;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"key");
                this.deserializeKey(string, settings);
            }
            catch (JSONException e) {
                Logger.Companion.log(LoggingBehavior.CACHE, 5, TAG, "Error reading cached value for key: '" + key + "' -- " + (Object)((Object)e));
                return null;
            }
        }
        return settings;
    }

    public final void save(@NotNull Bundle bundle) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        SharedPreferences.Editor editor = this.cache.edit();
        for (String key : bundle.keySet()) {
            try {
                String string = key;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"key");
                SharedPreferences.Editor editor2 = editor;
                Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"editor");
                this.serializeKey(string, bundle, editor2);
            }
            catch (JSONException e) {
                Logger.Companion.log(LoggingBehavior.CACHE, 5, TAG, "Error processing value for key: '" + key + "' -- " + (Object)((Object)e));
                return;
            }
        }
        editor.apply();
    }

    public final void clear() {
        this.cache.edit().clear().apply();
    }

    private final void serializeKey(String key, Bundle bundle, SharedPreferences.Editor editor) throws JSONException {
        Object object = bundle.get(key);
        if (object == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"bundle[key] ?: // Cannot\u2026ll values.\n        return");
        Object value = object;
        String supportedType = null;
        JSONArray jsonArray = null;
        JSONObject json = new JSONObject();
        Object object2 = value;
        if (object2 instanceof Byte) {
            supportedType = TYPE_BYTE;
            json.put(JSON_VALUE, (int)((Number)value).byteValue());
        } else if (object2 instanceof Short) {
            supportedType = TYPE_SHORT;
            json.put(JSON_VALUE, (int)((Number)value).shortValue());
        } else if (object2 instanceof Integer) {
            supportedType = TYPE_INTEGER;
            json.put(JSON_VALUE, ((Number)value).intValue());
        } else if (object2 instanceof Long) {
            supportedType = TYPE_LONG;
            json.put(JSON_VALUE, ((Number)value).longValue());
        } else if (object2 instanceof Float) {
            supportedType = TYPE_FLOAT;
            json.put(JSON_VALUE, (double)((Number)value).floatValue());
        } else if (object2 instanceof Double) {
            supportedType = TYPE_DOUBLE;
            json.put(JSON_VALUE, ((Number)value).doubleValue());
        } else if (object2 instanceof Boolean) {
            supportedType = TYPE_BOOLEAN;
            Object object3 = value;
            if (object3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
            }
            json.put(JSON_VALUE, ((Boolean)object3).booleanValue());
        } else if (object2 instanceof Character) {
            supportedType = TYPE_CHAR;
            json.put(JSON_VALUE, (Object)value.toString());
        } else if (object2 instanceof String) {
            supportedType = TYPE_STRING;
            json.put(JSON_VALUE, value);
        } else if (object2 instanceof Enum) {
            supportedType = TYPE_ENUM;
            json.put(JSON_VALUE, (Object)value.toString());
            json.put(JSON_VALUE_ENUM_TYPE, (Object)((Enum)value).getClass().getName());
        } else {
            jsonArray = new JSONArray();
            Object object4 = value;
            if (object4 instanceof byte[]) {
                supportedType = TYPE_BYTE_ARRAY;
                for (byte v : (byte[])value) {
                    jsonArray.put((int)v);
                }
            } else if (object4 instanceof short[]) {
                supportedType = TYPE_SHORT_ARRAY;
                for (short v : (short[])value) {
                    jsonArray.put((int)v);
                }
            } else if (object4 instanceof int[]) {
                supportedType = TYPE_INTEGER_ARRAY;
                for (int v : (int[])value) {
                    jsonArray.put(v);
                }
            } else if (object4 instanceof long[]) {
                supportedType = TYPE_LONG_ARRAY;
                for (long v : (long[])value) {
                    jsonArray.put(v);
                }
            } else if (object4 instanceof float[]) {
                supportedType = TYPE_FLOAT_ARRAY;
                for (float v : (float[])value) {
                    jsonArray.put((double)v);
                }
            } else if (object4 instanceof double[]) {
                supportedType = TYPE_DOUBLE_ARRAY;
                for (double v : (double[])value) {
                    jsonArray.put(v);
                }
            } else if (object4 instanceof boolean[]) {
                supportedType = TYPE_BOOLEAN_ARRAY;
                for (boolean v : (boolean[])value) {
                    jsonArray.put(v);
                }
            } else if (object4 instanceof char[]) {
                supportedType = TYPE_CHAR_ARRAY;
                for (char v : (char[])value) {
                    jsonArray.put((Object)String.valueOf(v));
                }
            } else if (object4 instanceof List) {
                supportedType = TYPE_STRING_LIST;
                Object object5 = value;
                if (object5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
                }
                List stringList = (List)object5;
                for (String v : stringList) {
                    Object object6 = v;
                    if (object6 == null) {
                        object6 = JSONObject.NULL;
                    }
                    jsonArray.put(object6);
                }
            } else {
                jsonArray = null;
            }
        }
        if (supportedType != null) {
            json.put(JSON_VALUE_TYPE, (Object)supportedType);
            if (jsonArray != null) {
                json.putOpt(JSON_VALUE, (Object)jsonArray);
            }
            String string = json.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"json.toString()");
            String jsonString = string;
            editor.putString(key, jsonString);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void deserializeKey(String key, Bundle bundle) throws JSONException {
        String string = this.cache.getString(key, "{}");
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        boolean bl3 = false;
        if (string == null) {
            boolean bl4 = false;
            String string2 = "Required value was null.";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        String jsonString = string;
        JSONObject json = new JSONObject(jsonString);
        String valueType = json.getString(JSON_VALUE_TYPE);
        if (Intrinsics.areEqual((Object)valueType, (Object)TYPE_BOOLEAN)) {
            bundle.putBoolean(key, json.getBoolean(JSON_VALUE));
        } else if (Intrinsics.areEqual((Object)valueType, (Object)TYPE_BOOLEAN_ARRAY)) {
            JSONArray jsonArray = json.getJSONArray(JSON_VALUE);
            boolean[] array = new boolean[jsonArray.length()];
            int n = 0;
            int n2 = array.length;
            while (n < n2) {
                void i;
                array[i] = jsonArray.getBoolean((int)i);
                ++i;
            }
            bundle.putBooleanArray(key, array);
        } else if (Intrinsics.areEqual((Object)valueType, (Object)TYPE_BYTE)) {
            bundle.putByte(key, (byte)json.getInt(JSON_VALUE));
        } else if (Intrinsics.areEqual((Object)valueType, (Object)TYPE_BYTE_ARRAY)) {
            JSONArray jsonArray = json.getJSONArray(JSON_VALUE);
            byte[] array = new byte[jsonArray.length()];
            int n = array.length;
            for (int i = 0; i < n; ++i) {
                array[i] = (byte)jsonArray.getInt(i);
            }
            bundle.putByteArray(key, array);
        } else if (Intrinsics.areEqual((Object)valueType, (Object)TYPE_SHORT)) {
            bundle.putShort(key, (short)json.getInt(JSON_VALUE));
        } else if (Intrinsics.areEqual((Object)valueType, (Object)TYPE_SHORT_ARRAY)) {
            JSONArray jsonArray = json.getJSONArray(JSON_VALUE);
            short[] array = new short[jsonArray.length()];
            int n = array.length;
            for (int i = 0; i < n; ++i) {
                array[i] = (short)jsonArray.getInt(i);
            }
            bundle.putShortArray(key, array);
        } else if (Intrinsics.areEqual((Object)valueType, (Object)TYPE_INTEGER)) {
            bundle.putInt(key, json.getInt(JSON_VALUE));
        } else if (Intrinsics.areEqual((Object)valueType, (Object)TYPE_INTEGER_ARRAY)) {
            JSONArray jsonArray = json.getJSONArray(JSON_VALUE);
            int[] array = new int[jsonArray.length()];
            int n = array.length;
            for (int i = 0; i < n; ++i) {
                array[i] = jsonArray.getInt(i);
            }
            bundle.putIntArray(key, array);
        } else if (Intrinsics.areEqual((Object)valueType, (Object)TYPE_LONG)) {
            bundle.putLong(key, json.getLong(JSON_VALUE));
        } else if (Intrinsics.areEqual((Object)valueType, (Object)TYPE_LONG_ARRAY)) {
            JSONArray jsonArray = json.getJSONArray(JSON_VALUE);
            long[] array = new long[jsonArray.length()];
            int n = array.length;
            for (int i = 0; i < n; ++i) {
                array[i] = jsonArray.getLong(i);
            }
            bundle.putLongArray(key, array);
        } else if (Intrinsics.areEqual((Object)valueType, (Object)TYPE_FLOAT)) {
            bundle.putFloat(key, (float)json.getDouble(JSON_VALUE));
        } else if (Intrinsics.areEqual((Object)valueType, (Object)TYPE_FLOAT_ARRAY)) {
            JSONArray jsonArray = json.getJSONArray(JSON_VALUE);
            float[] array = new float[jsonArray.length()];
            int n = array.length;
            for (int i = 0; i < n; ++i) {
                array[i] = (float)jsonArray.getDouble(i);
            }
            bundle.putFloatArray(key, array);
        } else if (Intrinsics.areEqual((Object)valueType, (Object)TYPE_DOUBLE)) {
            bundle.putDouble(key, json.getDouble(JSON_VALUE));
        } else if (Intrinsics.areEqual((Object)valueType, (Object)TYPE_DOUBLE_ARRAY)) {
            JSONArray jsonArray = json.getJSONArray(JSON_VALUE);
            double[] array = new double[jsonArray.length()];
            int n = array.length;
            for (int i = 0; i < n; ++i) {
                array[i] = jsonArray.getDouble(i);
            }
            bundle.putDoubleArray(key, array);
        } else if (Intrinsics.areEqual((Object)valueType, (Object)TYPE_CHAR)) {
            String charString = json.getString(JSON_VALUE);
            if (charString != null && charString.length() == 1) {
                bundle.putChar(key, charString.charAt(0));
            }
        } else if (Intrinsics.areEqual((Object)valueType, (Object)TYPE_CHAR_ARRAY)) {
            JSONArray jsonArray = json.getJSONArray(JSON_VALUE);
            char[] array = new char[jsonArray.length()];
            int n = array.length;
            for (int i = 0; i < n; ++i) {
                String charString = jsonArray.getString(i);
                if (charString == null || charString.length() != 1) continue;
                array[i] = charString.charAt(0);
            }
            bundle.putCharArray(key, array);
        } else if (Intrinsics.areEqual((Object)valueType, (Object)TYPE_STRING)) {
            bundle.putString(key, json.getString(JSON_VALUE));
        } else if (Intrinsics.areEqual((Object)valueType, (Object)TYPE_STRING_LIST)) {
            JSONArray jsonArray = json.getJSONArray(JSON_VALUE);
            int numStrings = jsonArray.length();
            ArrayList<String> stringList = new ArrayList<String>(numStrings);
            int n = 0;
            int n3 = numStrings;
            while (n < n3) {
                String string3;
                void i;
                Object jsonStringValue = jsonArray.get((int)i);
                if (jsonStringValue == JSONObject.NULL) {
                    string3 = null;
                } else {
                    Object object = jsonStringValue;
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    string3 = (String)object;
                }
                stringList.add((int)i, string3);
                ++i;
            }
            bundle.putStringArrayList(key, stringList);
        } else if (Intrinsics.areEqual((Object)valueType, (Object)TYPE_ENUM)) {
            try {
                String enumType = json.getString(JSON_VALUE_ENUM_TYPE);
                Class<?> clazz = Class.forName(enumType);
                if (clazz == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<out kotlin.Enum<*>>");
                }
                Class<?> enumClass = clazz;
                Object enumValue = Enum.valueOf(enumClass, json.getString(JSON_VALUE));
                bundle.putSerializable(key, (Serializable)enumValue);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @JvmOverloads
    public LegacyTokenHelper(@NotNull Context context, @Nullable String cacheKey) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super();
        context = context;
        if (cacheKey == null) ** GOTO lbl-1000
        var4_4 = cacheKey;
        var5_5 = false;
        if (var4_4.length() == 0) lbl-1000:
        // 2 sources

        {
            v0 = "com.facebook.SharedPreferencesTokenCachingStrategy.DEFAULT_KEY";
        } else {
            v0 = this.cacheKey = cacheKey;
        }
        if ((v1 = (applicationContext = context.getApplicationContext())) == null) {
            v1 = context;
        }
        context = v1;
        v2 = context.getSharedPreferences(this.cacheKey, 0);
        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"context.getSharedPrefere\u2026ey, Context.MODE_PRIVATE)");
        this.cache = v2;
    }

    public /* synthetic */ LegacyTokenHelper(Context context, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        this(context, string);
    }

    @JvmOverloads
    public LegacyTokenHelper(@NotNull Context context) {
        this(context, null, 2, null);
    }

    static {
        Companion = new Companion(null);
        String string = LegacyTokenHelper.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"LegacyTokenHelper::class.java.simpleName");
        TAG = string;
    }

    @JvmStatic
    public static final boolean hasTokenInformation(@Nullable Bundle bundle) {
        return Companion.hasTokenInformation(bundle);
    }

    @JvmStatic
    @Nullable
    public static final String getToken(@NotNull Bundle bundle) {
        return Companion.getToken(bundle);
    }

    @JvmStatic
    public static final void putToken(@NotNull Bundle bundle, @NotNull String value) {
        Companion.putToken(bundle, value);
    }

    @JvmStatic
    @Nullable
    public static final Date getExpirationDate(@NotNull Bundle bundle) {
        return Companion.getExpirationDate(bundle);
    }

    @JvmStatic
    public static final void putExpirationDate(@NotNull Bundle bundle, @NotNull Date value) {
        Companion.putExpirationDate(bundle, value);
    }

    @JvmStatic
    public static final long getExpirationMilliseconds(@NotNull Bundle bundle) {
        return Companion.getExpirationMilliseconds(bundle);
    }

    @JvmStatic
    public static final void putExpirationMilliseconds(@NotNull Bundle bundle, long value) {
        Companion.putExpirationMilliseconds(bundle, value);
    }

    @JvmStatic
    @Nullable
    public static final Set<String> getPermissions(@NotNull Bundle bundle) {
        return Companion.getPermissions(bundle);
    }

    @JvmStatic
    public static final void putPermissions(@NotNull Bundle bundle, @NotNull Collection<String> value) {
        Companion.putPermissions(bundle, value);
    }

    @JvmStatic
    public static final void putDeclinedPermissions(@NotNull Bundle bundle, @NotNull Collection<String> value) {
        Companion.putDeclinedPermissions(bundle, value);
    }

    @JvmStatic
    public static final void putExpiredPermissions(@NotNull Bundle bundle, @NotNull Collection<String> value) {
        Companion.putExpiredPermissions(bundle, value);
    }

    @JvmStatic
    @Nullable
    public static final AccessTokenSource getSource(@NotNull Bundle bundle) {
        return Companion.getSource(bundle);
    }

    @JvmStatic
    public static final void putSource(@NotNull Bundle bundle, @NotNull AccessTokenSource value) {
        Companion.putSource(bundle, value);
    }

    @JvmStatic
    @Nullable
    public static final Date getLastRefreshDate(@NotNull Bundle bundle) {
        return Companion.getLastRefreshDate(bundle);
    }

    @JvmStatic
    public static final void putLastRefreshDate(@NotNull Bundle bundle, @NotNull Date value) {
        Companion.putLastRefreshDate(bundle, value);
    }

    @JvmStatic
    public static final long getLastRefreshMilliseconds(@NotNull Bundle bundle) {
        return Companion.getLastRefreshMilliseconds(bundle);
    }

    @JvmStatic
    public static final void putLastRefreshMilliseconds(@NotNull Bundle bundle, long value) {
        Companion.putLastRefreshMilliseconds(bundle, value);
    }

    @JvmStatic
    @Nullable
    public static final String getApplicationId(@NotNull Bundle bundle) {
        return Companion.getApplicationId(bundle);
    }

    @JvmStatic
    public static final void putApplicationId(@NotNull Bundle bundle, @Nullable String value) {
        Companion.putApplicationId(bundle, value);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010'\u001a\u0004\u0018\u00010\u00042\u0006\u0010(\u001a\u00020)H\u0007J\u001e\u0010*\u001a\u0004\u0018\u00010+2\b\u0010(\u001a\u0004\u0018\u00010)2\b\u0010,\u001a\u0004\u0018\u00010\u0004H\u0002J\u0012\u0010-\u001a\u0004\u0018\u00010+2\u0006\u0010(\u001a\u00020)H\u0007J\u0010\u0010.\u001a\u00020\n2\u0006\u0010(\u001a\u00020)H\u0007J\u0012\u0010/\u001a\u0004\u0018\u00010+2\u0006\u0010(\u001a\u00020)H\u0007J\u0010\u00100\u001a\u00020\n2\u0006\u0010(\u001a\u00020)H\u0007J\u0018\u00101\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u0001022\u0006\u0010(\u001a\u00020)H\u0007J\u0012\u00103\u001a\u0004\u0018\u0001042\u0006\u0010(\u001a\u00020)H\u0007J\u0012\u00105\u001a\u0004\u0018\u00010\u00042\u0006\u0010(\u001a\u00020)H\u0007J\u0012\u00106\u001a\u0002072\b\u0010(\u001a\u0004\u0018\u00010)H\u0007J\u001a\u00108\u001a\u0002092\u0006\u0010(\u001a\u00020)2\b\u0010:\u001a\u0004\u0018\u00010\u0004H\u0007J\"\u0010;\u001a\u0002092\u0006\u0010(\u001a\u00020)2\b\u0010,\u001a\u0004\u0018\u00010\u00042\u0006\u0010<\u001a\u00020+H\u0002J\u001e\u0010=\u001a\u0002092\u0006\u0010(\u001a\u00020)2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00040>H\u0007J\u0018\u0010?\u001a\u0002092\u0006\u0010(\u001a\u00020)2\u0006\u0010:\u001a\u00020+H\u0007J\u0018\u0010@\u001a\u0002092\u0006\u0010(\u001a\u00020)2\u0006\u0010:\u001a\u00020\nH\u0007J\u001e\u0010A\u001a\u0002092\u0006\u0010(\u001a\u00020)2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00040>H\u0007J\u0018\u0010B\u001a\u0002092\u0006\u0010(\u001a\u00020)2\u0006\u0010:\u001a\u00020+H\u0007J\u0018\u0010C\u001a\u0002092\u0006\u0010(\u001a\u00020)2\u0006\u0010:\u001a\u00020\nH\u0007J\u001e\u0010D\u001a\u0002092\u0006\u0010(\u001a\u00020)2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00040>H\u0007J\u0018\u0010E\u001a\u0002092\u0006\u0010(\u001a\u00020)2\u0006\u0010:\u001a\u000204H\u0007J\u0018\u0010F\u001a\u0002092\u0006\u0010(\u001a\u00020)2\u0006\u0010:\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lcom/facebook/LegacyTokenHelper$Companion;", "", "()V", "APPLICATION_ID_KEY", "", "DECLINED_PERMISSIONS_KEY", "DEFAULT_CACHE_KEY", "EXPIRATION_DATE_KEY", "EXPIRED_PERMISSIONS_KEY", "INVALID_BUNDLE_MILLISECONDS", "", "IS_SSO_KEY", "JSON_VALUE", "JSON_VALUE_ENUM_TYPE", "JSON_VALUE_TYPE", "LAST_REFRESH_DATE_KEY", "PERMISSIONS_KEY", "TAG", "TOKEN_KEY", "TOKEN_SOURCE_KEY", "TYPE_BOOLEAN", "TYPE_BOOLEAN_ARRAY", "TYPE_BYTE", "TYPE_BYTE_ARRAY", "TYPE_CHAR", "TYPE_CHAR_ARRAY", "TYPE_DOUBLE", "TYPE_DOUBLE_ARRAY", "TYPE_ENUM", "TYPE_FLOAT", "TYPE_FLOAT_ARRAY", "TYPE_INTEGER", "TYPE_INTEGER_ARRAY", "TYPE_LONG", "TYPE_LONG_ARRAY", "TYPE_SHORT", "TYPE_SHORT_ARRAY", "TYPE_STRING", "TYPE_STRING_LIST", "getApplicationId", "bundle", "Landroid/os/Bundle;", "getDate", "Ljava/util/Date;", "key", "getExpirationDate", "getExpirationMilliseconds", "getLastRefreshDate", "getLastRefreshMilliseconds", "getPermissions", "", "getSource", "Lcom/facebook/AccessTokenSource;", "getToken", "hasTokenInformation", "", "putApplicationId", "", "value", "putDate", "date", "putDeclinedPermissions", "", "putExpirationDate", "putExpirationMilliseconds", "putExpiredPermissions", "putLastRefreshDate", "putLastRefreshMilliseconds", "putPermissions", "putSource", "putToken", "facebook-core_release"})
    public static final class Companion {
        @JvmStatic
        public final boolean hasTokenInformation(@Nullable Bundle bundle) {
            block5: {
                block4: {
                    if (bundle == null) {
                        return false;
                    }
                    String token = bundle.getString(LegacyTokenHelper.TOKEN_KEY);
                    if (token == null) break block4;
                    CharSequence charSequence = token;
                    boolean bl = false;
                    if (!(charSequence.length() == 0)) break block5;
                }
                return false;
            }
            long expiresMilliseconds = bundle.getLong(LegacyTokenHelper.EXPIRATION_DATE_KEY, 0L);
            return expiresMilliseconds != 0L;
        }

        @JvmStatic
        @Nullable
        public final String getToken(@NotNull Bundle bundle) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            return bundle.getString(LegacyTokenHelper.TOKEN_KEY);
        }

        @JvmStatic
        public final void putToken(@NotNull Bundle bundle, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)value, (String)LegacyTokenHelper.JSON_VALUE);
            bundle.putString(LegacyTokenHelper.TOKEN_KEY, value);
        }

        @JvmStatic
        @Nullable
        public final Date getExpirationDate(@NotNull Bundle bundle) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            return this.getDate(bundle, LegacyTokenHelper.EXPIRATION_DATE_KEY);
        }

        @JvmStatic
        public final void putExpirationDate(@NotNull Bundle bundle, @NotNull Date value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)value, (String)LegacyTokenHelper.JSON_VALUE);
            this.putDate(bundle, LegacyTokenHelper.EXPIRATION_DATE_KEY, value);
        }

        @JvmStatic
        public final long getExpirationMilliseconds(@NotNull Bundle bundle) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            return bundle.getLong(LegacyTokenHelper.EXPIRATION_DATE_KEY);
        }

        @JvmStatic
        public final void putExpirationMilliseconds(@NotNull Bundle bundle, long value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            bundle.putLong(LegacyTokenHelper.EXPIRATION_DATE_KEY, value);
        }

        @JvmStatic
        @Nullable
        public final Set<String> getPermissions(@NotNull Bundle bundle) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            ArrayList arrayList = bundle.getStringArrayList(LegacyTokenHelper.PERMISSIONS_KEY);
            if (arrayList == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"bundle.getStringArrayLis\u2026SIONS_KEY) ?: return null");
            ArrayList arrayList2 = arrayList;
            return new HashSet(arrayList2);
        }

        @JvmStatic
        public final void putPermissions(@NotNull Bundle bundle, @NotNull Collection<String> value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter(value, (String)LegacyTokenHelper.JSON_VALUE);
            bundle.putStringArrayList(LegacyTokenHelper.PERMISSIONS_KEY, new ArrayList<String>(value));
        }

        @JvmStatic
        public final void putDeclinedPermissions(@NotNull Bundle bundle, @NotNull Collection<String> value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter(value, (String)LegacyTokenHelper.JSON_VALUE);
            bundle.putStringArrayList(LegacyTokenHelper.DECLINED_PERMISSIONS_KEY, new ArrayList<String>(value));
        }

        @JvmStatic
        public final void putExpiredPermissions(@NotNull Bundle bundle, @NotNull Collection<String> value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter(value, (String)LegacyTokenHelper.JSON_VALUE);
            bundle.putStringArrayList(LegacyTokenHelper.EXPIRED_PERMISSIONS_KEY, new ArrayList<String>(value));
        }

        @JvmStatic
        @Nullable
        public final AccessTokenSource getSource(@NotNull Bundle bundle) {
            boolean isSSO;
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            return bundle.containsKey(LegacyTokenHelper.TOKEN_SOURCE_KEY) ? (AccessTokenSource)((Object)bundle.getSerializable(LegacyTokenHelper.TOKEN_SOURCE_KEY)) : ((isSSO = bundle.getBoolean(LegacyTokenHelper.IS_SSO_KEY)) ? AccessTokenSource.FACEBOOK_APPLICATION_WEB : AccessTokenSource.WEB_VIEW);
        }

        @JvmStatic
        public final void putSource(@NotNull Bundle bundle, @NotNull AccessTokenSource value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)((Object)value), (String)LegacyTokenHelper.JSON_VALUE);
            bundle.putSerializable(LegacyTokenHelper.TOKEN_SOURCE_KEY, (Serializable)((Object)value));
        }

        @JvmStatic
        @Nullable
        public final Date getLastRefreshDate(@NotNull Bundle bundle) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            return this.getDate(bundle, LegacyTokenHelper.LAST_REFRESH_DATE_KEY);
        }

        @JvmStatic
        public final void putLastRefreshDate(@NotNull Bundle bundle, @NotNull Date value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)value, (String)LegacyTokenHelper.JSON_VALUE);
            this.putDate(bundle, LegacyTokenHelper.LAST_REFRESH_DATE_KEY, value);
        }

        @JvmStatic
        public final long getLastRefreshMilliseconds(@NotNull Bundle bundle) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            return bundle.getLong(LegacyTokenHelper.LAST_REFRESH_DATE_KEY);
        }

        @JvmStatic
        public final void putLastRefreshMilliseconds(@NotNull Bundle bundle, long value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            bundle.putLong(LegacyTokenHelper.LAST_REFRESH_DATE_KEY, value);
        }

        @JvmStatic
        @Nullable
        public final String getApplicationId(@NotNull Bundle bundle) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            return bundle.getString(LegacyTokenHelper.APPLICATION_ID_KEY);
        }

        @JvmStatic
        public final void putApplicationId(@NotNull Bundle bundle, @Nullable String value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            bundle.putString(LegacyTokenHelper.APPLICATION_ID_KEY, value);
        }

        private final Date getDate(Bundle bundle, String key) {
            if (bundle == null) {
                return null;
            }
            long n = bundle.getLong(key, Long.MIN_VALUE);
            return n == Long.MIN_VALUE ? null : new Date(n);
        }

        private final void putDate(Bundle bundle, String key, Date date) {
            bundle.putLong(key, date.getTime());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

