/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.content.Context;
import android.graphics.Bitmap;
import android.location.Location;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import com.facebook.AccessToken;
import com.facebook.AccessTokenManager;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequestAsyncTask;
import com.facebook.GraphRequestBatch;
import com.facebook.GraphResponse;
import com.facebook.HttpMethod;
import com.facebook.LoggingBehavior;
import com.facebook.ProgressNoopOutputStream;
import com.facebook.ProgressOutputStream;
import com.facebook.RequestOutputStream;
import com.facebook.RequestProgress;
import com.facebook.internal.AttributionIdentifiers;
import com.facebook.internal.InternalSettings;
import com.facebook.internal.Logger;
import com.facebook.internal.ServerProtocol;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u001e\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 Y2\u00020\u0001:\tWXYZ[\\]^_BO\b\u0017\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\rB\u0019\b\u0010\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010F\u001a\u00020GH\u0002J\u0018\u0010H\u001a\u00020\u00052\u0006\u0010I\u001a\u00020\u00052\u0006\u0010J\u001a\u00020\u001eH\u0002J\u0006\u0010K\u001a\u00020LJ\u0006\u0010M\u001a\u00020NJ$\u0010O\u001a\u00020G2\u0006\u0010P\u001a\u00020Q2\u0012\u0010R\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020T0SH\u0002J\u0010\u0010U\u001a\u00020G2\u0006\u0010<\u001a\u00020\u001eH\u0007J\b\u0010V\u001a\u00020\u0005H\u0016R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0017\"\u0004\b\u001c\u0010\u0019R\u001a\u0010\u001d\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R(\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001c\u0010'\u001a\u0004\u0018\u00010(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u0017\"\u0004\b.\u0010\u0019R\u0016\u0010/\u001a\u0004\u0018\u00010\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u0017R(\u0010\b\u001a\u0004\u0018\u00010\t2\b\u00101\u001a\u0004\u0018\u00010\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u0011\u0010:\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b;\u0010\u0017R\u000e\u0010<\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010=\u001a\u0004\u0018\u00010\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010?\"\u0004\b@\u0010AR\u0011\u0010B\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\bC\u0010\u0017R\u001c\u0010\f\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010\u0017\"\u0004\bE\u0010\u0019\u00a8\u0006`"}, d2={"Lcom/facebook/GraphRequest;", "", "accessToken", "Lcom/facebook/AccessToken;", "graphPath", "", "parameters", "Landroid/os/Bundle;", "httpMethod", "Lcom/facebook/HttpMethod;", "callback", "Lcom/facebook/GraphRequest$Callback;", "version", "(Lcom/facebook/AccessToken;Ljava/lang/String;Landroid/os/Bundle;Lcom/facebook/HttpMethod;Lcom/facebook/GraphRequest$Callback;Ljava/lang/String;)V", "overriddenURL", "Ljava/net/URL;", "(Lcom/facebook/AccessToken;Ljava/net/URL;)V", "getAccessToken", "()Lcom/facebook/AccessToken;", "setAccessToken", "(Lcom/facebook/AccessToken;)V", "batchEntryDependsOn", "getBatchEntryDependsOn", "()Ljava/lang/String;", "setBatchEntryDependsOn", "(Ljava/lang/String;)V", "batchEntryName", "getBatchEntryName", "setBatchEntryName", "batchEntryOmitResultOnSuccess", "", "getBatchEntryOmitResultOnSuccess", "()Z", "setBatchEntryOmitResultOnSuccess", "(Z)V", "getCallback", "()Lcom/facebook/GraphRequest$Callback;", "setCallback", "(Lcom/facebook/GraphRequest$Callback;)V", "graphObject", "Lorg/json/JSONObject;", "getGraphObject", "()Lorg/json/JSONObject;", "setGraphObject", "(Lorg/json/JSONObject;)V", "getGraphPath", "setGraphPath", "graphPathWithVersion", "getGraphPathWithVersion", "value", "getHttpMethod", "()Lcom/facebook/HttpMethod;", "setHttpMethod", "(Lcom/facebook/HttpMethod;)V", "getParameters", "()Landroid/os/Bundle;", "setParameters", "(Landroid/os/Bundle;)V", "relativeUrlForBatchedRequest", "getRelativeUrlForBatchedRequest", "skipClientToken", "tag", "getTag", "()Ljava/lang/Object;", "setTag", "(Ljava/lang/Object;)V", "urlForSingleRequest", "getUrlForSingleRequest", "getVersion", "setVersion", "addCommonParameters", "", "appendParametersToBaseUrl", "baseUrl", "isBatch", "executeAndWait", "Lcom/facebook/GraphResponse;", "executeAsync", "Lcom/facebook/GraphRequestAsyncTask;", "serializeToBatch", "batch", "Lorg/json/JSONArray;", "attachments", "", "Lcom/facebook/GraphRequest$Attachment;", "setSkipClientToken", "toString", "Attachment", "Callback", "Companion", "GraphJSONArrayCallback", "GraphJSONObjectCallback", "KeyValueSerializer", "OnProgressCallback", "ParcelableResourceWithMimeType", "Serializer", "facebook-core_release"})
public final class GraphRequest {
    @Nullable
    private AccessToken accessToken;
    @Nullable
    private String graphPath;
    @Nullable
    private JSONObject graphObject;
    @Nullable
    private String batchEntryName;
    @Nullable
    private String batchEntryDependsOn;
    private boolean batchEntryOmitResultOnSuccess;
    @NotNull
    private Bundle parameters;
    @Nullable
    private Object tag;
    @Nullable
    private String version;
    @Nullable
    private Callback callback;
    @Nullable
    private HttpMethod httpMethod;
    private boolean skipClientToken;
    private String overriddenURL;
    public static final int MAXIMUM_BATCH_SIZE = 50;
    @NotNull
    private static final String TAG;
    private static final String VIDEOS_SUFFIX = "/videos";
    private static final String ME = "me";
    private static final String MY_FRIENDS = "me/friends";
    private static final String MY_PHOTOS = "me/photos";
    private static final String SEARCH = "search";
    private static final String USER_AGENT_BASE = "FBAndroidSDK";
    private static final String USER_AGENT_HEADER = "User-Agent";
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String ACCEPT_LANGUAGE_HEADER = "Accept-Language";
    private static final String CONTENT_ENCODING_HEADER = "Content-Encoding";
    private static final String FORMAT_PARAM = "format";
    private static final String FORMAT_JSON = "json";
    private static final String SDK_PARAM = "sdk";
    private static final String SDK_ANDROID = "android";
    @NotNull
    public static final String ACCESS_TOKEN_PARAM = "access_token";
    private static final String BATCH_ENTRY_NAME_PARAM = "name";
    private static final String BATCH_ENTRY_OMIT_RESPONSE_ON_SUCCESS_PARAM = "omit_response_on_success";
    private static final String BATCH_ENTRY_DEPENDS_ON_PARAM = "depends_on";
    private static final String BATCH_APP_ID_PARAM = "batch_app_id";
    private static final String BATCH_RELATIVE_URL_PARAM = "relative_url";
    private static final String BATCH_BODY_PARAM = "body";
    private static final String BATCH_METHOD_PARAM = "method";
    private static final String BATCH_PARAM = "batch";
    private static final String ATTACHMENT_FILENAME_PREFIX = "file";
    private static final String ATTACHED_FILES_PARAM = "attached_files";
    private static final String ISO_8601_FORMAT_STRING = "yyyy-MM-dd'T'HH:mm:ssZ";
    private static final String DEBUG_PARAM = "debug";
    private static final String DEBUG_SEVERITY_INFO = "info";
    private static final String DEBUG_SEVERITY_WARNING = "warning";
    private static final String DEBUG_KEY = "__debug__";
    private static final String DEBUG_MESSAGES_KEY = "messages";
    private static final String DEBUG_MESSAGE_KEY = "message";
    private static final String DEBUG_MESSAGE_TYPE_KEY = "type";
    private static final String DEBUG_MESSAGE_LINK_KEY = "link";
    private static final String PICTURE_PARAM = "picture";
    private static final String CAPTION_PARAM = "caption";
    @NotNull
    public static final String FIELDS_PARAM = "fields";
    private static final String MIME_BOUNDARY;
    private static String defaultBatchApplicationId;
    private static final Pattern versionPattern;
    private static volatile String userAgent;
    public static final Companion Companion;

    @Nullable
    public final AccessToken getAccessToken() {
        return this.accessToken;
    }

    public final void setAccessToken(@Nullable AccessToken accessToken) {
        this.accessToken = accessToken;
    }

    @Nullable
    public final String getGraphPath() {
        return this.graphPath;
    }

    public final void setGraphPath(@Nullable String string) {
        this.graphPath = string;
    }

    @Nullable
    public final JSONObject getGraphObject() {
        return this.graphObject;
    }

    public final void setGraphObject(@Nullable JSONObject jSONObject) {
        this.graphObject = jSONObject;
    }

    @Nullable
    public final String getBatchEntryName() {
        return this.batchEntryName;
    }

    public final void setBatchEntryName(@Nullable String string) {
        this.batchEntryName = string;
    }

    @Nullable
    public final String getBatchEntryDependsOn() {
        return this.batchEntryDependsOn;
    }

    public final void setBatchEntryDependsOn(@Nullable String string) {
        this.batchEntryDependsOn = string;
    }

    public final boolean getBatchEntryOmitResultOnSuccess() {
        return this.batchEntryOmitResultOnSuccess;
    }

    public final void setBatchEntryOmitResultOnSuccess(boolean bl) {
        this.batchEntryOmitResultOnSuccess = bl;
    }

    @NotNull
    public final Bundle getParameters() {
        return this.parameters;
    }

    public final void setParameters(@NotNull Bundle bundle) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"<set-?>");
        this.parameters = bundle;
    }

    @Nullable
    public final Object getTag() {
        return this.tag;
    }

    public final void setTag(@Nullable Object object) {
        this.tag = object;
    }

    @Nullable
    public final String getVersion() {
        return this.version;
    }

    public final void setVersion(@Nullable String string) {
        this.version = string;
    }

    @Nullable
    public final Callback getCallback() {
        return this.callback;
    }

    public final void setCallback(@Nullable Callback callback2) {
        Callback wrapper2;
        this.callback = FacebookSdk.isLoggingBehaviorEnabled(LoggingBehavior.GRAPH_API_DEBUG_INFO) || FacebookSdk.isLoggingBehaviorEnabled(LoggingBehavior.GRAPH_API_DEBUG_WARNING) ? (wrapper2 = (Callback)new Callback(callback2){
            final /* synthetic */ Callback $callback;

            /*
             * WARNING - void declaration
             */
            public final void onCompleted(@NotNull GraphResponse response) {
                block5: {
                    JSONArray debugMessages;
                    JSONObject debug;
                    JSONObject responseObject;
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    JSONObject jSONObject = responseObject = response.getJSONObject();
                    JSONObject jSONObject2 = debug = jSONObject != null ? jSONObject.optJSONObject("__debug__") : null;
                    Object object = debugMessages = jSONObject2 != null ? jSONObject2.optJSONArray("messages") : null;
                    if (debugMessages != null) {
                        int n = 0;
                        int n2 = debugMessages.length();
                        while (n < n2) {
                            String debugMessageLink;
                            void i;
                            JSONObject debugMessageObject;
                            JSONObject jSONObject3 = debugMessageObject = debugMessages.optJSONObject((int)i);
                            String debugMessage = jSONObject3 != null ? jSONObject3.optString("message") : null;
                            JSONObject jSONObject4 = debugMessageObject;
                            String debugMessageType = jSONObject4 != null ? jSONObject4.optString("type") : null;
                            JSONObject jSONObject5 = debugMessageObject;
                            String string = debugMessageLink = jSONObject5 != null ? jSONObject5.optString("link") : null;
                            if (debugMessage != null && debugMessageType != null) {
                                LoggingBehavior behavior = LoggingBehavior.GRAPH_API_DEBUG_INFO;
                                if (Intrinsics.areEqual((Object)debugMessageType, (Object)"warning")) {
                                    behavior = LoggingBehavior.GRAPH_API_DEBUG_WARNING;
                                }
                                if (!Utility.isNullOrEmpty(debugMessageLink)) {
                                    debugMessage = debugMessage + " Link: " + debugMessageLink;
                                }
                                Logger.Companion.log(behavior, GraphRequest.Companion.getTAG(), debugMessage);
                            }
                            ++i;
                        }
                    }
                    Callback callback2 = this.$callback;
                    if (callback2 == null) break block5;
                    callback2.onCompleted(response);
                }
            }
            {
                this.$callback = callback2;
            }
        }) : callback2;
    }

    @Nullable
    public final HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public final void setHttpMethod(@Nullable HttpMethod value) {
        if (this.overriddenURL != null && value != HttpMethod.GET) {
            throw (Throwable)new FacebookException("Can't change HTTP method on request with overridden URL.");
        }
        HttpMethod httpMethod = value;
        if (httpMethod == null) {
            httpMethod = HttpMethod.GET;
        }
        this.httpMethod = httpMethod;
    }

    @Deprecated(message="Starting in v13, the SDK will require a client token to be set before making GraphAPI calls.")
    public final void setSkipClientToken(boolean skipClientToken) {
        this.skipClientToken = skipClientToken;
    }

    @NotNull
    public final GraphResponse executeAndWait() {
        return Companion.executeAndWait(this);
    }

    @NotNull
    public final GraphRequestAsyncTask executeAsync() {
        return Companion.executeBatchAsync(this);
    }

    @NotNull
    public String toString() {
        String string = "{Request: " + " accessToken: " + (this.accessToken == null ? "null" : this.accessToken) + ", graphPath: " + this.graphPath + ", graphObject: " + this.graphObject + ", httpMethod: " + (Object)((Object)this.httpMethod) + ", parameters: " + this.parameters + "}";
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder()\n        \u2026(\"}\")\n        .toString()");
        return string;
    }

    private final void addCommonParameters() {
        AccessToken accessToken = this.accessToken;
        Bundle parameters = this.parameters;
        if (accessToken != null) {
            if (!parameters.containsKey(ACCESS_TOKEN_PARAM)) {
                String token = accessToken.getToken();
                Logger.Companion.registerAccessToken(token);
                parameters.putString(ACCESS_TOKEN_PARAM, token);
            }
        } else if (!this.skipClientToken && !parameters.containsKey(ACCESS_TOKEN_PARAM)) {
            String appID = FacebookSdk.getApplicationId();
            String clientToken = FacebookSdk.getClientToken();
            if (!Utility.isNullOrEmpty(appID) && !Utility.isNullOrEmpty(clientToken)) {
                String accessToken2 = appID + '|' + clientToken;
                parameters.putString(ACCESS_TOKEN_PARAM, accessToken2);
            } else {
                Utility.logd(TAG, "Warning: Request without access token missing application ID or client token.");
            }
        }
        if (!parameters.containsKey(ACCESS_TOKEN_PARAM) && Utility.isNullOrEmpty(FacebookSdk.getClientToken())) {
            Log.w((String)TAG, (String)"Starting with v13 of the SDK, a client token must be embedded in your client code before making Graph API calls. Visit https://developers.facebook.com/docs/android/getting-started#client-token to learn how to implement this change.");
        }
        parameters.putString(SDK_PARAM, SDK_ANDROID);
        parameters.putString(FORMAT_PARAM, FORMAT_JSON);
        if (FacebookSdk.isLoggingBehaviorEnabled(LoggingBehavior.GRAPH_API_DEBUG_INFO)) {
            parameters.putString(DEBUG_PARAM, DEBUG_SEVERITY_INFO);
        } else if (FacebookSdk.isLoggingBehaviorEnabled(LoggingBehavior.GRAPH_API_DEBUG_WARNING)) {
            parameters.putString(DEBUG_PARAM, DEBUG_SEVERITY_WARNING);
        }
    }

    private final String appendParametersToBaseUrl(String baseUrl, boolean isBatch) {
        if (!isBatch && this.httpMethod == HttpMethod.POST) {
            return baseUrl;
        }
        Uri.Builder uriBuilder = Uri.parse((String)baseUrl).buildUpon();
        Set keys = this.parameters.keySet();
        for (String key : keys) {
            Object value = this.parameters.get(key);
            if (value == null) {
                value = "";
            }
            if (!GraphRequest.Companion.isSupportedParameterType(value)) {
                if (this.httpMethod == HttpMethod.GET) continue;
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                Locale locale = Locale.US;
                String string = "Unsupported parameter type for GET request: %s";
                Object[] objectArray = new Object[]{value.getClass().getSimpleName()};
                boolean bl = false;
                String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(locale, format, *args)");
                throw (Throwable)new IllegalArgumentException(string2);
            }
            value = GraphRequest.Companion.parameterToString(value);
            uriBuilder.appendQueryParameter(key, value.toString());
        }
        String string = uriBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uriBuilder.toString()");
        return string;
    }

    @NotNull
    public final String getRelativeUrlForBatchedRequest() {
        if (this.overriddenURL != null) {
            throw (Throwable)new FacebookException("Can't override URL for a batch request");
        }
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "%s/%s";
        StringCompanionObject stringCompanionObject2 = new StringCompanionObject[]{ServerProtocol.getGraphUrlBase(), this.getGraphPathWithVersion()};
        boolean bl = false;
        StringCompanionObject stringCompanionObject3 = stringCompanionObject2;
        String string2 = String.format(string, Arrays.copyOf(stringCompanionObject3, ((Object[])stringCompanionObject3).length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        String baseUrl = string2;
        this.addCommonParameters();
        String fullUrl = this.appendParametersToBaseUrl(baseUrl, true);
        Uri uri = Uri.parse((String)fullUrl);
        stringCompanionObject2 = StringCompanionObject.INSTANCE;
        String string3 = "%s?%s";
        Object[] objectArray = new Object[2];
        Uri uri2 = uri;
        Intrinsics.checkNotNullExpressionValue((Object)uri2, (String)"uri");
        objectArray[0] = uri2.getPath();
        objectArray[1] = uri.getQuery();
        Object[] objectArray2 = objectArray;
        boolean bl2 = false;
        String string4 = String.format(string3, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(format, *args)");
        return string4;
    }

    @NotNull
    public final String getUrlForSingleRequest() {
        if (this.overriddenURL != null) {
            return String.valueOf(this.overriddenURL);
        }
        String graphPath = this.graphPath;
        String graphBaseUrlBase = this.httpMethod == HttpMethod.POST && graphPath != null && StringsKt.endsWith$default((String)graphPath, (String)VIDEOS_SUFFIX, (boolean)false, (int)2, null) ? ServerProtocol.getGraphVideoUrlBase() : ServerProtocol.getGraphUrlBase();
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "%s/%s";
        Object[] objectArray = new Object[]{graphBaseUrlBase, this.getGraphPathWithVersion()};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        String baseUrl = string2;
        this.addCommonParameters();
        return this.appendParametersToBaseUrl(baseUrl, false);
    }

    private final String getGraphPathWithVersion() {
        String string;
        Matcher matcher = versionPattern.matcher(this.graphPath);
        if (matcher.matches()) {
            string = this.graphPath;
        } else {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = "%s/%s";
            Object[] objectArray = new Object[]{this.version, this.graphPath};
            boolean bl = false;
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
        }
        return string;
    }

    private final void serializeToBatch(JSONArray batch2, Map<String, Attachment> attachments) throws JSONException, IOException {
        JSONObject graphObject;
        JSONObject batchEntry = new JSONObject();
        if (this.batchEntryName != null) {
            batchEntry.put(BATCH_ENTRY_NAME_PARAM, (Object)this.batchEntryName);
            batchEntry.put(BATCH_ENTRY_OMIT_RESPONSE_ON_SUCCESS_PARAM, this.batchEntryOmitResultOnSuccess);
        }
        if (this.batchEntryDependsOn != null) {
            batchEntry.put(BATCH_ENTRY_DEPENDS_ON_PARAM, (Object)this.batchEntryDependsOn);
        }
        String relativeURL = this.getRelativeUrlForBatchedRequest();
        batchEntry.put(BATCH_RELATIVE_URL_PARAM, (Object)relativeURL);
        batchEntry.put(BATCH_METHOD_PARAM, (Object)this.httpMethod);
        AccessToken accessToken = this.accessToken;
        if (accessToken != null) {
            String token = accessToken.getToken();
            Logger.Companion.registerAccessToken(token);
        }
        ArrayList<String> attachmentNames = new ArrayList<String>();
        Set keys = this.parameters.keySet();
        for (String key : keys) {
            String name;
            Object value = this.parameters.get(key);
            if (!GraphRequest.Companion.isSupportedAttachmentType(value)) continue;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Locale locale = Locale.ROOT;
            String string = "%s%d";
            Object[] objectArray = new Object[]{ATTACHMENT_FILENAME_PREFIX, attachments.size()};
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(locale, format, *args)");
            attachmentNames.add(name);
            attachments.put(name, new Attachment(this, value));
        }
        if (!attachmentNames.isEmpty()) {
            String attachmentNamesString = TextUtils.join((CharSequence)",", (Iterable)attachmentNames);
            batchEntry.put(ATTACHED_FILES_PARAM, (Object)attachmentNamesString);
        }
        if ((graphObject = this.graphObject) != null) {
            ArrayList keysAndValues = new ArrayList();
            GraphRequest.Companion.processGraphObject(graphObject, relativeURL, new KeyValueSerializer(keysAndValues){
                final /* synthetic */ ArrayList $keysAndValues;

                public void writeString(@NotNull String key, @NotNull String value) throws IOException {
                    Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                    StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                    Locale locale = Locale.US;
                    String string = "%s=%s";
                    Object[] objectArray = new Object[]{key, URLEncoder.encode(value, "UTF-8")};
                    boolean bl = false;
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(locale, format, *args)");
                    this.$keysAndValues.add(string2);
                }
                {
                    this.$keysAndValues = $captured_local_variable$0;
                }
            });
            String bodyValue = TextUtils.join((CharSequence)"&", (Iterable)keysAndValues);
            batchEntry.put(BATCH_BODY_PARAM, (Object)bodyValue);
        }
        batch2.put((Object)batchEntry);
    }

    @JvmOverloads
    public GraphRequest(@Nullable AccessToken accessToken, @Nullable String graphPath, @Nullable Bundle parameters, @Nullable HttpMethod httpMethod, @Nullable Callback callback2, @Nullable String version) {
        this.batchEntryOmitResultOnSuccess = true;
        this.accessToken = accessToken;
        this.graphPath = graphPath;
        this.version = version;
        this.setCallback(callback2);
        this.setHttpMethod(httpMethod);
        this.parameters = parameters != null ? new Bundle(parameters) : new Bundle();
        if (this.version == null) {
            this.version = FacebookSdk.getGraphApiVersion();
        }
    }

    public /* synthetic */ GraphRequest(AccessToken accessToken, String string, Bundle bundle, HttpMethod httpMethod, Callback callback2, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            accessToken = null;
        }
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            bundle = null;
        }
        if ((n & 8) != 0) {
            httpMethod = null;
        }
        if ((n & 0x10) != 0) {
            callback2 = null;
        }
        if ((n & 0x20) != 0) {
            string2 = null;
        }
        this(accessToken, string, bundle, httpMethod, callback2, string2);
    }

    @JvmOverloads
    public GraphRequest(@Nullable AccessToken accessToken, @Nullable String graphPath, @Nullable Bundle parameters, @Nullable HttpMethod httpMethod, @Nullable Callback callback2) {
        this(accessToken, graphPath, parameters, httpMethod, callback2, null, 32, null);
    }

    @JvmOverloads
    public GraphRequest(@Nullable AccessToken accessToken, @Nullable String graphPath, @Nullable Bundle parameters, @Nullable HttpMethod httpMethod) {
        this(accessToken, graphPath, parameters, httpMethod, null, null, 48, null);
    }

    @JvmOverloads
    public GraphRequest(@Nullable AccessToken accessToken, @Nullable String graphPath, @Nullable Bundle parameters) {
        this(accessToken, graphPath, parameters, null, null, null, 56, null);
    }

    @JvmOverloads
    public GraphRequest(@Nullable AccessToken accessToken, @Nullable String graphPath) {
        this(accessToken, graphPath, null, null, null, null, 60, null);
    }

    @JvmOverloads
    public GraphRequest(@Nullable AccessToken accessToken) {
        this(accessToken, null, null, null, null, null, 62, null);
    }

    @JvmOverloads
    public GraphRequest() {
        this(null, null, null, null, null, null, 63, null);
    }

    public GraphRequest(@Nullable AccessToken accessToken, @NotNull URL overriddenURL) {
        Intrinsics.checkNotNullParameter((Object)overriddenURL, (String)"overriddenURL");
        this.batchEntryOmitResultOnSuccess = true;
        this.accessToken = accessToken;
        this.overriddenURL = overriddenURL.toString();
        this.setHttpMethod(HttpMethod.GET);
        this.parameters = new Bundle();
    }

    /*
     * WARNING - void declaration
     */
    static {
        Companion = new Companion(null);
        String string = GraphRequest.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GraphRequest::class.java.simpleName");
        TAG = string;
        String string2 = "-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        boolean bl = false;
        char[] cArray = string2.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        char[] chars = cArray;
        StringBuilder buffer = new StringBuilder();
        SecureRandom random = new SecureRandom();
        int count = random.nextInt(11) + 30;
        int n = 0;
        int n2 = count;
        while (n < n2) {
            void i;
            buffer.append(chars[random.nextInt(chars.length)]);
            ++i;
        }
        String string3 = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"buffer.toString()");
        MIME_BOUNDARY = string3;
        versionPattern = Pattern.compile("^/?v\\d+\\.\\d+/(.*)");
    }

    @JvmStatic
    @Nullable
    public static final String getDefaultBatchApplicationId() {
        return Companion.getDefaultBatchApplicationId();
    }

    @JvmStatic
    public static final void setDefaultBatchApplicationId(@Nullable String applicationId) {
        Companion.setDefaultBatchApplicationId(applicationId);
    }

    @JvmStatic
    @NotNull
    public static final GraphRequest newDeleteObjectRequest(@Nullable AccessToken accessToken, @Nullable String id, @Nullable Callback callback2) {
        return Companion.newDeleteObjectRequest(accessToken, id, callback2);
    }

    @JvmStatic
    @NotNull
    public static final GraphRequest newMeRequest(@Nullable AccessToken accessToken, @Nullable GraphJSONObjectCallback callback2) {
        return Companion.newMeRequest(accessToken, callback2);
    }

    @JvmStatic
    @NotNull
    public static final GraphRequest newPostRequest(@Nullable AccessToken accessToken, @Nullable String graphPath, @Nullable JSONObject graphObject, @Nullable Callback callback2) {
        return Companion.newPostRequest(accessToken, graphPath, graphObject, callback2);
    }

    @JvmStatic
    @NotNull
    public static final GraphRequest newMyFriendsRequest(@Nullable AccessToken accessToken, @Nullable GraphJSONArrayCallback callback2) {
        return Companion.newMyFriendsRequest(accessToken, callback2);
    }

    @JvmStatic
    @NotNull
    public static final GraphRequest newGraphPathRequest(@Nullable AccessToken accessToken, @Nullable String graphPath, @Nullable Callback callback2) {
        return Companion.newGraphPathRequest(accessToken, graphPath, callback2);
    }

    @JvmStatic
    @NotNull
    public static final GraphRequest newPlacesSearchRequest(@Nullable AccessToken accessToken, @Nullable Location location, int radiusInMeters, int resultsLimit, @Nullable String searchText, @Nullable GraphJSONArrayCallback callback2) {
        return Companion.newPlacesSearchRequest(accessToken, location, radiusInMeters, resultsLimit, searchText, callback2);
    }

    @JvmStatic
    @NotNull
    public static final GraphRequest newUploadPhotoRequest(@Nullable AccessToken accessToken, @Nullable String graphPath, @Nullable Bitmap image, @Nullable String caption, @Nullable Bundle params, @Nullable Callback callback2) {
        return Companion.newUploadPhotoRequest(accessToken, graphPath, image, caption, params, callback2);
    }

    @JvmStatic
    @NotNull
    public static final GraphRequest newUploadPhotoRequest(@Nullable AccessToken accessToken, @Nullable String graphPath, @Nullable File file, @Nullable String caption, @Nullable Bundle params, @Nullable Callback callback2) throws FileNotFoundException {
        return Companion.newUploadPhotoRequest(accessToken, graphPath, file, caption, params, callback2);
    }

    @JvmStatic
    @NotNull
    public static final GraphRequest newUploadPhotoRequest(@Nullable AccessToken accessToken, @Nullable String graphPath, @NotNull Uri photoUri, @Nullable String caption, @Nullable Bundle params, @Nullable Callback callback2) throws FileNotFoundException {
        return Companion.newUploadPhotoRequest(accessToken, graphPath, photoUri, caption, params, callback2);
    }

    @JvmStatic
    @NotNull
    public static final GraphRequest newCustomAudienceThirdPartyIdRequest(@Nullable AccessToken accessToken, @NotNull Context context, @Nullable String applicationId, @Nullable Callback callback2) {
        return Companion.newCustomAudienceThirdPartyIdRequest(accessToken, context, applicationId, callback2);
    }

    @JvmStatic
    @NotNull
    public static final GraphRequest newCustomAudienceThirdPartyIdRequest(@Nullable AccessToken accessToken, @NotNull Context context, @Nullable Callback callback2) {
        return Companion.newCustomAudienceThirdPartyIdRequest(accessToken, context, callback2);
    }

    @JvmStatic
    @NotNull
    public static final HttpURLConnection toHttpConnection(GraphRequest ... requests) {
        return Companion.toHttpConnection(requests);
    }

    @JvmStatic
    @NotNull
    public static final HttpURLConnection toHttpConnection(@NotNull Collection<GraphRequest> requests) {
        return Companion.toHttpConnection(requests);
    }

    @JvmStatic
    @NotNull
    public static final HttpURLConnection toHttpConnection(@NotNull GraphRequestBatch requests) {
        return Companion.toHttpConnection(requests);
    }

    @JvmStatic
    @NotNull
    public static final GraphResponse executeAndWait(@NotNull GraphRequest request2) {
        return Companion.executeAndWait(request2);
    }

    @JvmStatic
    @NotNull
    public static final List<GraphResponse> executeBatchAndWait(GraphRequest ... requests) {
        return Companion.executeBatchAndWait(requests);
    }

    @JvmStatic
    @NotNull
    public static final List<GraphResponse> executeBatchAndWait(@NotNull Collection<GraphRequest> requests) {
        return Companion.executeBatchAndWait(requests);
    }

    @JvmStatic
    @NotNull
    public static final List<GraphResponse> executeBatchAndWait(@NotNull GraphRequestBatch requests) {
        return Companion.executeBatchAndWait(requests);
    }

    @JvmStatic
    @NotNull
    public static final GraphRequestAsyncTask executeBatchAsync(GraphRequest ... requests) {
        return Companion.executeBatchAsync(requests);
    }

    @JvmStatic
    @NotNull
    public static final GraphRequestAsyncTask executeBatchAsync(@NotNull Collection<GraphRequest> requests) {
        return Companion.executeBatchAsync(requests);
    }

    @JvmStatic
    @NotNull
    public static final GraphRequestAsyncTask executeBatchAsync(@NotNull GraphRequestBatch requests) {
        return Companion.executeBatchAsync(requests);
    }

    @JvmStatic
    @NotNull
    public static final List<GraphResponse> executeConnectionAndWait(@NotNull HttpURLConnection connection, @NotNull Collection<GraphRequest> requests) {
        return Companion.executeConnectionAndWait(connection, requests);
    }

    @JvmStatic
    @NotNull
    public static final List<GraphResponse> executeConnectionAndWait(@NotNull HttpURLConnection connection, @NotNull GraphRequestBatch requests) {
        return Companion.executeConnectionAndWait(connection, requests);
    }

    @JvmStatic
    @NotNull
    public static final GraphRequestAsyncTask executeConnectionAsync(@NotNull HttpURLConnection connection, @NotNull GraphRequestBatch requests) {
        return Companion.executeConnectionAsync(connection, requests);
    }

    @JvmStatic
    @NotNull
    public static final GraphRequestAsyncTask executeConnectionAsync(@Nullable Handler callbackHandler, @NotNull HttpURLConnection connection, @NotNull GraphRequestBatch requests) {
        return Companion.executeConnectionAsync(callbackHandler, connection, requests);
    }

    @JvmStatic
    public static final void runCallbacks$facebook_core_release(@NotNull GraphRequestBatch requests, @NotNull List<GraphResponse> responses) {
        Companion.runCallbacks$facebook_core_release(requests, responses);
    }

    @JvmStatic
    public static final boolean shouldWarnOnMissingFieldsParam$facebook_core_release(@NotNull GraphRequest request2) {
        return Companion.shouldWarnOnMissingFieldsParam$facebook_core_release(request2);
    }

    @JvmStatic
    public static final void validateFieldsParamForGetRequests$facebook_core_release(@NotNull GraphRequestBatch requests) {
        Companion.validateFieldsParamForGetRequests$facebook_core_release(requests);
    }

    @JvmStatic
    public static final void serializeToUrlConnection$facebook_core_release(@NotNull GraphRequestBatch requests, @NotNull HttpURLConnection connection) throws IOException, JSONException {
        Companion.serializeToUrlConnection$facebook_core_release(requests, connection);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/facebook/GraphRequest$Attachment;", "", "request", "Lcom/facebook/GraphRequest;", "value", "(Lcom/facebook/GraphRequest;Ljava/lang/Object;)V", "getRequest", "()Lcom/facebook/GraphRequest;", "getValue", "()Ljava/lang/Object;", "facebook-core_release"})
    private static final class Attachment {
        @NotNull
        private final GraphRequest request;
        @Nullable
        private final Object value;

        @NotNull
        public final GraphRequest getRequest() {
            return this.request;
        }

        @Nullable
        public final Object getValue() {
            return this.value;
        }

        public Attachment(@NotNull GraphRequest request2, @Nullable Object value) {
            Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
            this.request = request2;
            this.value = value;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\bb\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&\u00a8\u0006\u0007"}, d2={"Lcom/facebook/GraphRequest$KeyValueSerializer;", "", "writeString", "", "key", "", "value", "facebook-core_release"})
    private static interface KeyValueSerializer {
        public void writeString(@NotNull String var1, @NotNull String var2);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ+\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0016\u0010\u0013\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00150\u0014\"\u0004\u0018\u00010\u0015\u00a2\u0006\u0002\u0010\u0016J\u0016\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001dJ$\u0010\u001e\u001a\u00020\u00102\b\u0010\u001f\u001a\u0004\u0018\u00010\u00122\b\u0010 \u001a\u0004\u0018\u00010\u00122\b\u0010!\u001a\u0004\u0018\u00010\u0012J \u0010\"\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u0012J \u0010&\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010'\u001a\u00020(2\b\u0010%\u001a\u0004\u0018\u00010\u0012J+\u0010)\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0016\u0010\u0013\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00150\u0014\"\u0004\u0018\u00010\u0015\u00a2\u0006\u0002\u0010\u0016J\"\u0010*\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00122\b\u0010+\u001a\u0004\u0018\u00010\u00152\b\u0010,\u001a\u0004\u0018\u00010-J\u0006\u0010.\u001a\u00020\u0010J$\u0010/\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u00100\u001a\u0002012\f\u00102\u001a\b\u0012\u0004\u0012\u00020-03J\u0018\u00104\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u0012H\u0016R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\u00060\u000bj\u0002`\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/facebook/GraphRequest$Serializer;", "Lcom/facebook/GraphRequest$KeyValueSerializer;", "outputStream", "Ljava/io/OutputStream;", "logger", "Lcom/facebook/internal/Logger;", "useUrlEncode", "", "(Ljava/io/OutputStream;Lcom/facebook/internal/Logger;Z)V", "firstWrite", "invalidTypeError", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "getInvalidTypeError", "()Ljava/lang/RuntimeException;", "write", "", "format", "", "args", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)V", "writeBitmap", "key", "bitmap", "Landroid/graphics/Bitmap;", "writeBytes", "bytes", "", "writeContentDisposition", "name", "filename", "contentType", "writeContentUri", "contentUri", "Landroid/net/Uri;", "mimeType", "writeFile", "descriptor", "Landroid/os/ParcelFileDescriptor;", "writeLine", "writeObject", "value", "request", "Lcom/facebook/GraphRequest;", "writeRecordBoundary", "writeRequestsAsJson", "requestJsonArray", "Lorg/json/JSONArray;", "requests", "", "writeString", "facebook-core_release"})
    private static final class Serializer
    implements KeyValueSerializer {
        private boolean firstWrite;
        private final boolean useUrlEncode;
        private final OutputStream outputStream;
        private final Logger logger;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final void writeObject(@NotNull String key, @Nullable Object value, @Nullable GraphRequest request2) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            if (this.outputStream instanceof RequestOutputStream) {
                OutputStream outputStream = this.outputStream;
                if (outputStream == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.facebook.RequestOutputStream");
                }
                ((RequestOutputStream)((Object)outputStream)).setCurrentRequest(request2);
            }
            if (Companion.isSupportedParameterType(value)) {
                this.writeString(key, Companion.parameterToString(value));
                return;
            } else if (value instanceof Bitmap) {
                this.writeBitmap(key, (Bitmap)value);
                return;
            } else if (value instanceof byte[]) {
                this.writeBytes(key, (byte[])value);
                return;
            } else if (value instanceof Uri) {
                this.writeContentUri(key, (Uri)value, null);
                return;
            } else if (value instanceof ParcelFileDescriptor) {
                this.writeFile(key, (ParcelFileDescriptor)value, null);
                return;
            } else {
                if (!(value instanceof ParcelableResourceWithMimeType)) throw (Throwable)this.getInvalidTypeError();
                Object resource = ((ParcelableResourceWithMimeType)value).getResource();
                String mimeType = ((ParcelableResourceWithMimeType)value).getMimeType();
                if (resource instanceof ParcelFileDescriptor) {
                    this.writeFile(key, (ParcelFileDescriptor)resource, mimeType);
                    return;
                } else {
                    if (!(resource instanceof Uri)) throw (Throwable)this.getInvalidTypeError();
                    this.writeContentUri(key, (Uri)resource, mimeType);
                }
            }
        }

        private final RuntimeException getInvalidTypeError() {
            return new IllegalArgumentException("value is not a supported type.");
        }

        /*
         * WARNING - void declaration
         */
        public final void writeRequestsAsJson(@NotNull String key, @NotNull JSONArray requestJsonArray, @NotNull Collection<GraphRequest> requests) {
            block5: {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter((Object)requestJsonArray, (String)"requestJsonArray");
                Intrinsics.checkNotNullParameter(requests, (String)"requests");
                if (!(this.outputStream instanceof RequestOutputStream)) {
                    String string = requestJsonArray.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"requestJsonArray.toString()");
                    this.writeString(key, string);
                    return;
                }
                OutputStream outputStream = this.outputStream;
                if (outputStream == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.facebook.RequestOutputStream");
                }
                RequestOutputStream requestOutputStream = (RequestOutputStream)((Object)outputStream);
                this.writeContentDisposition(key, null, null);
                this.write("[", new Object[0]);
                boolean bl = false;
                for (GraphRequest request2 : (Iterable)requests) {
                    void i;
                    JSONObject requestJson = requestJsonArray.getJSONObject((int)i);
                    requestOutputStream.setCurrentRequest(request2);
                    if (i > 0) {
                        this.write(",%s", requestJson.toString());
                    } else {
                        this.write("%s", requestJson.toString());
                    }
                    ++i;
                }
                this.write("]", new Object[0]);
                Logger logger = this.logger;
                if (logger == null) break block5;
                String string = "    " + key;
                String string2 = requestJsonArray.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"requestJsonArray.toString()");
                logger.appendKeyValue(string, string2);
            }
        }

        @Override
        public void writeString(@NotNull String key, @NotNull String value) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                this.writeContentDisposition(key, null, null);
                this.writeLine("%s", value);
                this.writeRecordBoundary();
                Logger logger = this.logger;
                if (logger == null) break block0;
                logger.appendKeyValue("    " + key, value);
            }
        }

        public final void writeBitmap(@NotNull String key, @NotNull Bitmap bitmap) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
                this.writeContentDisposition(key, key, "image/png");
                bitmap.compress(Bitmap.CompressFormat.PNG, 100, this.outputStream);
                this.writeLine("", new Object[0]);
                this.writeRecordBoundary();
                Logger logger = this.logger;
                if (logger == null) break block0;
                logger.appendKeyValue("    " + key, "<Image>");
            }
        }

        public final void writeBytes(@NotNull String key, @NotNull byte[] bytes) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
                this.writeContentDisposition(key, key, "content/unknown");
                this.outputStream.write(bytes);
                this.writeLine("", new Object[0]);
                this.writeRecordBoundary();
                Logger logger = this.logger;
                if (logger == null) break block0;
                String string = "    " + key;
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                Locale locale = Locale.ROOT;
                String string2 = "<Data: %d>";
                Object[] objectArray = new Object[]{bytes.length};
                boolean bl = false;
                String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(locale, format, *args)");
                logger.appendKeyValue(string, string3);
            }
        }

        public final void writeContentUri(@NotNull String key, @NotNull Uri contentUri, @Nullable String mimeType) {
            block3: {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter((Object)contentUri, (String)"contentUri");
                String mimeType2 = mimeType;
                if (mimeType2 == null) {
                    mimeType2 = "content/unknown";
                }
                this.writeContentDisposition(key, key, mimeType2);
                int totalBytes = 0;
                if (this.outputStream instanceof ProgressNoopOutputStream) {
                    long contentSize = Utility.getContentSize(contentUri);
                    ((ProgressNoopOutputStream)this.outputStream).addProgress(contentSize);
                } else {
                    Context context = FacebookSdk.getApplicationContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"FacebookSdk.getApplicationContext()");
                    InputStream inputStream = context.getContentResolver().openInputStream(contentUri);
                    totalBytes += Utility.copyAndCloseInputStream(inputStream, this.outputStream);
                }
                this.writeLine("", new Object[0]);
                this.writeRecordBoundary();
                Logger logger = this.logger;
                if (logger == null) break block3;
                String string = "    " + key;
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                Locale locale = Locale.ROOT;
                String string2 = "<Data: %d>";
                Object[] objectArray = new Object[]{totalBytes};
                boolean bl = false;
                String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(locale, format, *args)");
                logger.appendKeyValue(string, string3);
            }
        }

        public final void writeFile(@NotNull String key, @NotNull ParcelFileDescriptor descriptor, @Nullable String mimeType) {
            block3: {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                String mimeType2 = mimeType;
                if (mimeType2 == null) {
                    mimeType2 = "content/unknown";
                }
                this.writeContentDisposition(key, key, mimeType2);
                int totalBytes = 0;
                if (this.outputStream instanceof ProgressNoopOutputStream) {
                    ((ProgressNoopOutputStream)this.outputStream).addProgress(descriptor.getStatSize());
                } else {
                    ParcelFileDescriptor.AutoCloseInputStream inputStream = new ParcelFileDescriptor.AutoCloseInputStream(descriptor);
                    totalBytes += Utility.copyAndCloseInputStream((InputStream)inputStream, this.outputStream);
                }
                this.writeLine("", new Object[0]);
                this.writeRecordBoundary();
                Logger logger = this.logger;
                if (logger == null) break block3;
                String string = "    " + key;
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                Locale locale = Locale.ROOT;
                String string2 = "<Data: %d>";
                Object[] objectArray = new Object[]{totalBytes};
                boolean bl = false;
                String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(locale, format, *args)");
                logger.appendKeyValue(string, string3);
            }
        }

        public final void writeRecordBoundary() {
            if (!this.useUrlEncode) {
                this.writeLine("--%s", MIME_BOUNDARY);
            } else {
                String string = "&";
                Charset charset = Charsets.UTF_8;
                boolean bl = false;
                byte[] byArray = string.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                this.outputStream.write(byArray);
            }
        }

        public final void writeContentDisposition(@Nullable String name, @Nullable String filename, @Nullable String contentType) {
            if (!this.useUrlEncode) {
                this.write("Content-Disposition: form-data; name=\"%s\"", name);
                if (filename != null) {
                    this.write("; filename=\"%s\"", filename);
                }
                this.writeLine("", new Object[0]);
                if (contentType != null) {
                    this.writeLine("%s: %s", GraphRequest.CONTENT_TYPE_HEADER, contentType);
                }
                this.writeLine("", new Object[0]);
            } else {
                Object object = StringCompanionObject.INSTANCE;
                Object object2 = "%s=";
                Object[] objectArray = new Object[]{name};
                boolean bl = false;
                String string = String.format((String)object2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.String.format(format, *args)");
                object = string;
                object2 = Charsets.UTF_8;
                boolean bl2 = false;
                Object object3 = object;
                if (object3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = ((String)object3).getBytes((Charset)object2);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                this.outputStream.write(byArray);
            }
        }

        public final void write(@NotNull String format, Object ... args) {
            Intrinsics.checkNotNullParameter((Object)format, (String)GraphRequest.FORMAT_PARAM);
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            if (!this.useUrlEncode) {
                boolean bl;
                Object object;
                String string;
                if (this.firstWrite) {
                    string = "--";
                    object = Charsets.UTF_8;
                    bl = false;
                    byte[] byArray = string.getBytes((Charset)object);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                    this.outputStream.write(byArray);
                    string = MIME_BOUNDARY;
                    object = Charsets.UTF_8;
                    bl = false;
                    String string2 = string;
                    if (string2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    byte[] byArray2 = string2.getBytes((Charset)object);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
                    this.outputStream.write(byArray2);
                    string = "\r\n";
                    object = Charsets.UTF_8;
                    bl = false;
                    byte[] byArray3 = string.getBytes((Charset)object);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"(this as java.lang.String).getBytes(charset)");
                    this.outputStream.write(byArray3);
                    this.firstWrite = false;
                }
                string = StringCompanionObject.INSTANCE;
                object = Arrays.copyOf(args, args.length);
                bl = false;
                String string3 = String.format(format, Arrays.copyOf(object, ((Object[])object).length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
                string = string3;
                object = Charsets.UTF_8;
                bl = false;
                String string4 = string;
                if (string4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = string4.getBytes((Charset)object);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                this.outputStream.write(byArray);
            } else {
                Object object = StringCompanionObject.INSTANCE;
                Object object2 = Locale.US;
                Object[] objectArray = Arrays.copyOf(args, args.length);
                boolean bl = false;
                String string = String.format((Locale)object2, format, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.String.format(locale, format, *args)");
                String string5 = URLEncoder.encode(string, "UTF-8");
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"URLEncoder.encode(String\u2026 format, *args), \"UTF-8\")");
                object = string5;
                object2 = Charsets.UTF_8;
                boolean bl2 = false;
                Object object3 = object;
                if (object3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = ((String)object3).getBytes((Charset)object2);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                this.outputStream.write(byArray);
            }
        }

        public final void writeLine(@NotNull String format, Object ... args) {
            Intrinsics.checkNotNullParameter((Object)format, (String)GraphRequest.FORMAT_PARAM);
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            this.write(format, Arrays.copyOf(args, args.length));
            if (!this.useUrlEncode) {
                this.write("\r\n", new Object[0]);
            }
        }

        public Serializer(@NotNull OutputStream outputStream, @Nullable Logger logger, boolean useUrlEncode) {
            Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
            this.outputStream = outputStream;
            this.logger = logger;
            this.firstWrite = true;
            this.useUrlEncode = useUrlEncode;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/facebook/GraphRequest$Callback;", "", "onCompleted", "", "response", "Lcom/facebook/GraphResponse;", "facebook-core_release"})
    public static interface Callback {
        public void onCompleted(@NotNull GraphResponse var1);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&\u00a8\u0006\u0007"}, d2={"Lcom/facebook/GraphRequest$OnProgressCallback;", "Lcom/facebook/GraphRequest$Callback;", "onProgress", "", "current", "", "max", "facebook-core_release"})
    public static interface OnProgressCallback
    extends Callback {
        public void onProgress(long var1, long var3);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00a8\u0006\b"}, d2={"Lcom/facebook/GraphRequest$GraphJSONArrayCallback;", "", "onCompleted", "", "objects", "Lorg/json/JSONArray;", "response", "Lcom/facebook/GraphResponse;", "facebook-core_release"})
    public static interface GraphJSONArrayCallback {
        public void onCompleted(@Nullable JSONArray var1, @Nullable GraphResponse var2);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00a8\u0006\b"}, d2={"Lcom/facebook/GraphRequest$GraphJSONObjectCallback;", "", "onCompleted", "", "obj", "Lorg/json/JSONObject;", "response", "Lcom/facebook/GraphResponse;", "facebook-core_release"})
    public static interface GraphJSONObjectCallback {
        public void onCompleted(@Nullable JSONObject var1, @Nullable GraphResponse var2);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u0015*\n\b\u0000\u0010\u0001*\u0004\u0018\u00010\u00022\u00020\u0002:\u0001\u0015B\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0012\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0010H\u0016R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\u0003\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lcom/facebook/GraphRequest$ParcelableResourceWithMimeType;", "RESOURCE", "Landroid/os/Parcelable;", "resource", "mimeType", "", "(Landroid/os/Parcelable;Ljava/lang/String;)V", "source", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "getMimeType", "()Ljava/lang/String;", "getResource", "()Landroid/os/Parcelable;", "Landroid/os/Parcelable;", "describeContents", "", "writeToParcel", "", "out", "flags", "Companion", "facebook-core_release"})
    public static final class ParcelableResourceWithMimeType<RESOURCE extends Parcelable>
    implements Parcelable {
        @Nullable
        private final String mimeType;
        @Nullable
        private final RESOURCE resource;
        @NotNull
        private static final Parcelable.Creator<ParcelableResourceWithMimeType<?>> CREATOR;
        public static final Companion Companion;

        @Nullable
        public final String getMimeType() {
            return this.mimeType;
        }

        @Nullable
        public final RESOURCE getResource() {
            return this.resource;
        }

        public int describeContents() {
            return 1;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            out.writeString(this.mimeType);
            out.writeParcelable(this.resource, flags);
        }

        public ParcelableResourceWithMimeType(RESOURCE resource, @Nullable String mimeType) {
            this.mimeType = mimeType;
            this.resource = resource;
        }

        private ParcelableResourceWithMimeType(Parcel source) {
            this.mimeType = source.readString();
            Context context = FacebookSdk.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"FacebookSdk.getApplicationContext()");
            this.resource = source.readParcelable(context.getClassLoader());
        }

        static {
            Companion = new Companion(null);
            CREATOR = new Parcelable.Creator<ParcelableResourceWithMimeType<?>>(){

                @NotNull
                public ParcelableResourceWithMimeType<?> createFromParcel(@NotNull Parcel source) {
                    Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                    return new ParcelableResourceWithMimeType<RESOURCE>(source, null);
                }

                @NotNull
                public ParcelableResourceWithMimeType<?>[] newArray(int size) {
                    return new ParcelableResourceWithMimeType[size];
                }
            };
        }

        public /* synthetic */ ParcelableResourceWithMimeType(Parcel source, DefaultConstructorMarker $constructor_marker) {
            this(source);
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/facebook/GraphRequest$ParcelableResourceWithMimeType$Companion;", "", "()V", "CREATOR", "Landroid/os/Parcelable$Creator;", "Lcom/facebook/GraphRequest$ParcelableResourceWithMimeType;", "getCREATOR", "()Landroid/os/Parcelable$Creator;", "facebook-core_release"})
        public static final class Companion {
            @NotNull
            public final Parcelable.Creator<ParcelableResourceWithMimeType<?>> getCREATOR() {
                return CREATOR;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ee\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u001b\n\u0002\u0010\b\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0002J\u0010\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0007J\u0016\u0010A\u001a\b\u0012\u0004\u0012\u00020>0B2\u0006\u0010C\u001a\u00020DH\u0007J'\u0010A\u001a\b\u0012\u0004\u0012\u00020>0B2\u0012\u0010C\u001a\n\u0012\u0006\b\u0001\u0012\u00020@0E\"\u00020@H\u0007\u00a2\u0006\u0002\u0010FJ\u001c\u0010A\u001a\b\u0012\u0004\u0012\u00020>0B2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020@0GH\u0007J\u0010\u0010H\u001a\u00020I2\u0006\u0010C\u001a\u00020DH\u0007J!\u0010H\u001a\u00020I2\u0012\u0010C\u001a\n\u0012\u0006\b\u0001\u0012\u00020@0E\"\u00020@H\u0007\u00a2\u0006\u0002\u0010JJ\u0016\u0010H\u001a\u00020I2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020@0GH\u0007J\u001e\u0010K\u001a\b\u0012\u0004\u0012\u00020>0B2\u0006\u0010L\u001a\u00020:2\u0006\u0010C\u001a\u00020DH\u0007J$\u0010K\u001a\b\u0012\u0004\u0012\u00020>0B2\u0006\u0010L\u001a\u00020:2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020@0GH\u0007J\"\u0010M\u001a\u00020I2\b\u0010N\u001a\u0004\u0018\u00010O2\u0006\u0010L\u001a\u00020:2\u0006\u0010C\u001a\u00020DH\u0007J\u0018\u0010M\u001a\u00020I2\u0006\u0010L\u001a\u00020:2\u0006\u0010C\u001a\u00020DH\u0007J\u0010\u0010P\u001a\u00020\u00042\u0006\u0010Q\u001a\u00020DH\u0002J\n\u0010R\u001a\u0004\u0018\u00010\u0004H\u0007J\u0012\u0010S\u001a\u00020\u00042\b\u0010T\u001a\u0004\u0018\u00010\u0004H\u0002J\u0010\u0010U\u001a\u00020V2\u0006\u0010C\u001a\u00020DH\u0002J\u0010\u0010W\u001a\u00020V2\u0006\u0010C\u001a\u00020DH\u0002J\u0010\u0010X\u001a\u00020V2\u0006\u0010Y\u001a\u00020\u0004H\u0002J\u0012\u0010Z\u001a\u00020V2\b\u0010[\u001a\u0004\u0018\u00010\u0001H\u0002J\u0012\u0010\\\u001a\u00020V2\b\u0010[\u001a\u0004\u0018\u00010\u0001H\u0002J$\u0010]\u001a\u00020@2\b\u0010^\u001a\u0004\u0018\u00010_2\u0006\u0010`\u001a\u00020a2\b\u0010b\u001a\u0004\u0018\u00010cH\u0007J.\u0010]\u001a\u00020@2\b\u0010^\u001a\u0004\u0018\u00010_2\u0006\u0010`\u001a\u00020a2\b\u0010d\u001a\u0004\u0018\u00010\u00042\b\u0010b\u001a\u0004\u0018\u00010cH\u0007J&\u0010e\u001a\u00020@2\b\u0010^\u001a\u0004\u0018\u00010_2\b\u0010f\u001a\u0004\u0018\u00010\u00042\b\u0010b\u001a\u0004\u0018\u00010cH\u0007J&\u0010g\u001a\u00020@2\b\u0010^\u001a\u0004\u0018\u00010_2\b\u0010T\u001a\u0004\u0018\u00010\u00042\b\u0010b\u001a\u0004\u0018\u00010cH\u0007J\u001c\u0010h\u001a\u00020@2\b\u0010^\u001a\u0004\u0018\u00010_2\b\u0010b\u001a\u0004\u0018\u00010iH\u0007J\u001c\u0010j\u001a\u00020@2\b\u0010^\u001a\u0004\u0018\u00010_2\b\u0010b\u001a\u0004\u0018\u00010kH\u0007J@\u0010l\u001a\u00020@2\b\u0010^\u001a\u0004\u0018\u00010_2\b\u0010m\u001a\u0004\u0018\u00010n2\u0006\u0010o\u001a\u00020 2\u0006\u0010p\u001a\u00020 2\b\u0010q\u001a\u0004\u0018\u00010\u00042\b\u0010b\u001a\u0004\u0018\u00010kH\u0007J0\u0010r\u001a\u00020@2\b\u0010^\u001a\u0004\u0018\u00010_2\b\u0010T\u001a\u0004\u0018\u00010\u00042\b\u0010s\u001a\u0004\u0018\u00010t2\b\u0010b\u001a\u0004\u0018\u00010cH\u0007JD\u0010u\u001a\u00020@2\b\u0010^\u001a\u0004\u0018\u00010_2\b\u0010T\u001a\u0004\u0018\u00010\u00042\b\u0010v\u001a\u0004\u0018\u00010w2\b\u0010x\u001a\u0004\u0018\u00010\u00042\b\u0010y\u001a\u0004\u0018\u00010z2\b\u0010b\u001a\u0004\u0018\u00010cH\u0007JB\u0010u\u001a\u00020@2\b\u0010^\u001a\u0004\u0018\u00010_2\b\u0010T\u001a\u0004\u0018\u00010\u00042\u0006\u0010{\u001a\u00020|2\b\u0010x\u001a\u0004\u0018\u00010\u00042\b\u0010y\u001a\u0004\u0018\u00010z2\b\u0010b\u001a\u0004\u0018\u00010cH\u0007JD\u0010u\u001a\u00020@2\b\u0010^\u001a\u0004\u0018\u00010_2\b\u0010T\u001a\u0004\u0018\u00010\u00042\b\u0010}\u001a\u0004\u0018\u00010~2\b\u0010x\u001a\u0004\u0018\u00010\u00042\b\u0010y\u001a\u0004\u0018\u00010z2\b\u0010b\u001a\u0004\u0018\u00010cH\u0007J\u0012\u0010\u007f\u001a\u00020\u00042\b\u0010[\u001a\u0004\u0018\u00010\u0001H\u0002J$\u0010\u0080\u0001\u001a\u00030\u0081\u00012\u0006\u0010s\u001a\u00020t2\u0006\u0010Y\u001a\u00020\u00042\b\u0010\u0082\u0001\u001a\u00030\u0083\u0001H\u0002J.\u0010\u0084\u0001\u001a\u00030\u0081\u00012\u0007\u0010\u0085\u0001\u001a\u00020\u00042\u0006\u0010[\u001a\u00020\u00012\b\u0010\u0082\u0001\u001a\u00030\u0083\u00012\u0007\u0010\u0086\u0001\u001a\u00020VH\u0002JB\u0010\u0087\u0001\u001a\u00030\u0081\u00012\u0006\u0010C\u001a\u00020D2\n\u0010\u0088\u0001\u001a\u0005\u0018\u00010\u0089\u00012\u0007\u0010\u008a\u0001\u001a\u00020 2\u0006\u0010;\u001a\u00020<2\b\u0010\u008b\u0001\u001a\u00030\u008c\u00012\u0007\u0010\u008d\u0001\u001a\u00020VH\u0002J'\u0010\u008e\u0001\u001a\u00030\u0081\u00012\u0006\u0010C\u001a\u00020D2\r\u0010\u008f\u0001\u001a\b\u0012\u0004\u0012\u00020>0BH\u0001\u00a2\u0006\u0003\b\u0090\u0001J+\u0010\u0091\u0001\u001a\u00030\u0081\u00012\u0015\u0010\u0092\u0001\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0005\u0012\u00030\u0094\u00010\u0093\u00012\b\u0010\u0082\u0001\u001a\u00030\u0095\u0001H\u0002J%\u0010\u0096\u0001\u001a\u00030\u0081\u00012\u0007\u0010\u0097\u0001\u001a\u00020z2\b\u0010\u0082\u0001\u001a\u00030\u0095\u00012\u0006\u0010?\u001a\u00020@H\u0002J9\u0010\u0098\u0001\u001a\u00030\u0081\u00012\b\u0010\u0082\u0001\u001a\u00030\u0095\u00012\f\u0010C\u001a\b\u0012\u0004\u0012\u00020@0G2\u0015\u0010\u0092\u0001\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0005\u0012\u00030\u0094\u00010\u0099\u0001H\u0002J \u0010\u009a\u0001\u001a\u00030\u0081\u00012\u0006\u0010C\u001a\u00020D2\u0006\u0010L\u001a\u00020:H\u0001\u00a2\u0006\u0003\b\u009b\u0001J\u001b\u0010\u009c\u0001\u001a\u00030\u0081\u00012\u0006\u0010L\u001a\u00020:2\u0007\u0010\u008d\u0001\u001a\u00020VH\u0002J\u0014\u0010\u009d\u0001\u001a\u00030\u0081\u00012\b\u0010d\u001a\u0004\u0018\u00010\u0004H\u0007J\u0017\u0010\u009e\u0001\u001a\u00020V2\u0006\u0010?\u001a\u00020@H\u0001\u00a2\u0006\u0003\b\u009f\u0001J\u0011\u0010\u00a0\u0001\u001a\u00020:2\u0006\u0010C\u001a\u00020DH\u0007J#\u0010\u00a0\u0001\u001a\u00020:2\u0012\u0010C\u001a\n\u0012\u0006\b\u0001\u0012\u00020@0E\"\u00020@H\u0007\u00a2\u0006\u0003\u0010\u00a1\u0001J\u0017\u0010\u00a0\u0001\u001a\u00020:2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020@0GH\u0007J\u0018\u0010\u00a2\u0001\u001a\u00030\u0081\u00012\u0006\u0010C\u001a\u00020DH\u0001\u00a2\u0006\u0003\b\u00a3\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010)\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u000e\u0010,\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00100\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u0010+R\u001e\u00102\u001a\u0004\u0018\u00010\u00048BX\u0082\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010+\"\u0004\b4\u00105R\u0016\u00106\u001a\n 8*\u0004\u0018\u00010707X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00a4\u0001"}, d2={"Lcom/facebook/GraphRequest$Companion;", "", "()V", "ACCEPT_LANGUAGE_HEADER", "", "ACCESS_TOKEN_PARAM", "ATTACHED_FILES_PARAM", "ATTACHMENT_FILENAME_PREFIX", "BATCH_APP_ID_PARAM", "BATCH_BODY_PARAM", "BATCH_ENTRY_DEPENDS_ON_PARAM", "BATCH_ENTRY_NAME_PARAM", "BATCH_ENTRY_OMIT_RESPONSE_ON_SUCCESS_PARAM", "BATCH_METHOD_PARAM", "BATCH_PARAM", "BATCH_RELATIVE_URL_PARAM", "CAPTION_PARAM", "CONTENT_ENCODING_HEADER", "CONTENT_TYPE_HEADER", "DEBUG_KEY", "DEBUG_MESSAGES_KEY", "DEBUG_MESSAGE_KEY", "DEBUG_MESSAGE_LINK_KEY", "DEBUG_MESSAGE_TYPE_KEY", "DEBUG_PARAM", "DEBUG_SEVERITY_INFO", "DEBUG_SEVERITY_WARNING", "FIELDS_PARAM", "FORMAT_JSON", "FORMAT_PARAM", "ISO_8601_FORMAT_STRING", "MAXIMUM_BATCH_SIZE", "", "ME", "MIME_BOUNDARY", "MY_FRIENDS", "MY_PHOTOS", "PICTURE_PARAM", "SDK_ANDROID", "SDK_PARAM", "SEARCH", "TAG", "getTAG", "()Ljava/lang/String;", "USER_AGENT_BASE", "USER_AGENT_HEADER", "VIDEOS_SUFFIX", "defaultBatchApplicationId", "mimeContentType", "getMimeContentType", "userAgent", "getUserAgent", "setUserAgent", "(Ljava/lang/String;)V", "versionPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "createConnection", "Ljava/net/HttpURLConnection;", "url", "Ljava/net/URL;", "executeAndWait", "Lcom/facebook/GraphResponse;", "request", "Lcom/facebook/GraphRequest;", "executeBatchAndWait", "", "requests", "Lcom/facebook/GraphRequestBatch;", "", "([Lcom/facebook/GraphRequest;)Ljava/util/List;", "", "executeBatchAsync", "Lcom/facebook/GraphRequestAsyncTask;", "([Lcom/facebook/GraphRequest;)Lcom/facebook/GraphRequestAsyncTask;", "executeConnectionAndWait", "connection", "executeConnectionAsync", "callbackHandler", "Landroid/os/Handler;", "getBatchAppId", "batch", "getDefaultBatchApplicationId", "getDefaultPhotoPathIfNull", "graphPath", "hasOnProgressCallbacks", "", "isGzipCompressible", "isMeRequest", "path", "isSupportedAttachmentType", "value", "isSupportedParameterType", "newCustomAudienceThirdPartyIdRequest", "accessToken", "Lcom/facebook/AccessToken;", "context", "Landroid/content/Context;", "callback", "Lcom/facebook/GraphRequest$Callback;", "applicationId", "newDeleteObjectRequest", "id", "newGraphPathRequest", "newMeRequest", "Lcom/facebook/GraphRequest$GraphJSONObjectCallback;", "newMyFriendsRequest", "Lcom/facebook/GraphRequest$GraphJSONArrayCallback;", "newPlacesSearchRequest", "location", "Landroid/location/Location;", "radiusInMeters", "resultsLimit", "searchText", "newPostRequest", "graphObject", "Lorg/json/JSONObject;", "newUploadPhotoRequest", "image", "Landroid/graphics/Bitmap;", "caption", "params", "Landroid/os/Bundle;", "photoUri", "Landroid/net/Uri;", "file", "Ljava/io/File;", "parameterToString", "processGraphObject", "", "serializer", "Lcom/facebook/GraphRequest$KeyValueSerializer;", "processGraphObjectProperty", "key", "passByValue", "processRequest", "logger", "Lcom/facebook/internal/Logger;", "numRequests", "outputStream", "Ljava/io/OutputStream;", "shouldUseGzip", "runCallbacks", "responses", "runCallbacks$facebook_core_release", "serializeAttachments", "attachments", "", "Lcom/facebook/GraphRequest$Attachment;", "Lcom/facebook/GraphRequest$Serializer;", "serializeParameters", "bundle", "serializeRequestsAsJSON", "", "serializeToUrlConnection", "serializeToUrlConnection$facebook_core_release", "setConnectionContentType", "setDefaultBatchApplicationId", "shouldWarnOnMissingFieldsParam", "shouldWarnOnMissingFieldsParam$facebook_core_release", "toHttpConnection", "([Lcom/facebook/GraphRequest;)Ljava/net/HttpURLConnection;", "validateFieldsParamForGetRequests", "validateFieldsParamForGetRequests$facebook_core_release", "facebook-core_release"})
    public static final class Companion {
        @NotNull
        public final String getTAG() {
            return TAG;
        }

        @JvmStatic
        @Nullable
        public final String getDefaultBatchApplicationId() {
            return defaultBatchApplicationId;
        }

        @JvmStatic
        public final void setDefaultBatchApplicationId(@Nullable String applicationId) {
            defaultBatchApplicationId = applicationId;
        }

        @JvmStatic
        @NotNull
        public final GraphRequest newDeleteObjectRequest(@Nullable AccessToken accessToken, @Nullable String id, @Nullable Callback callback2) {
            return new GraphRequest(accessToken, id, null, HttpMethod.DELETE, callback2, null, 32, null);
        }

        @JvmStatic
        @NotNull
        public final GraphRequest newMeRequest(@Nullable AccessToken accessToken, @Nullable GraphJSONObjectCallback callback2) {
            Callback wrapper2 = new Callback(callback2){
                final /* synthetic */ GraphJSONObjectCallback $callback;

                public final void onCompleted(@NotNull GraphResponse response) {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                        GraphJSONObjectCallback graphJSONObjectCallback = this.$callback;
                        if (graphJSONObjectCallback == null) break block0;
                        graphJSONObjectCallback.onCompleted(response.getJSONObject(), response);
                    }
                }
                {
                    this.$callback = graphJSONObjectCallback;
                }
            };
            return new GraphRequest(accessToken, GraphRequest.ME, null, null, wrapper2, null, 32, null);
        }

        @JvmStatic
        @NotNull
        public final GraphRequest newPostRequest(@Nullable AccessToken accessToken, @Nullable String graphPath, @Nullable JSONObject graphObject, @Nullable Callback callback2) {
            GraphRequest request2 = new GraphRequest(accessToken, graphPath, null, HttpMethod.POST, callback2, null, 32, null);
            request2.setGraphObject(graphObject);
            return request2;
        }

        @JvmStatic
        @NotNull
        public final GraphRequest newMyFriendsRequest(@Nullable AccessToken accessToken, @Nullable GraphJSONArrayCallback callback2) {
            Callback wrapper2 = new Callback(callback2){
                final /* synthetic */ GraphJSONArrayCallback $callback;

                public void onCompleted(@NotNull GraphResponse response) {
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    if (this.$callback != null) {
                        JSONObject result;
                        JSONObject jSONObject = result = response.getJSONObject();
                        JSONArray data = jSONObject != null ? jSONObject.optJSONArray("data") : null;
                        this.$callback.onCompleted(data, response);
                    }
                }
                {
                    this.$callback = $captured_local_variable$0;
                }
            };
            return new GraphRequest(accessToken, GraphRequest.MY_FRIENDS, null, null, wrapper2, null, 32, null);
        }

        @JvmStatic
        @NotNull
        public final GraphRequest newGraphPathRequest(@Nullable AccessToken accessToken, @Nullable String graphPath, @Nullable Callback callback2) {
            return new GraphRequest(accessToken, graphPath, null, null, callback2, null, 32, null);
        }

        @JvmStatic
        @NotNull
        public final GraphRequest newPlacesSearchRequest(@Nullable AccessToken accessToken, @Nullable Location location, int radiusInMeters, int resultsLimit, @Nullable String searchText, @Nullable GraphJSONArrayCallback callback2) {
            if (location == null && Utility.isNullOrEmpty(searchText)) {
                throw (Throwable)new FacebookException("Either location or searchText must be specified.");
            }
            Bundle parameters = new Bundle(5);
            parameters.putString(GraphRequest.DEBUG_MESSAGE_TYPE_KEY, "place");
            parameters.putInt("limit", resultsLimit);
            if (location != null) {
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                Locale locale = Locale.US;
                String string = "%f,%f";
                Object[] objectArray = new Object[]{location.getLatitude(), location.getLongitude()};
                boolean bl = false;
                String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(locale, format, *args)");
                parameters.putString("center", string2);
                parameters.putInt("distance", radiusInMeters);
            }
            if (!Utility.isNullOrEmpty(searchText)) {
                parameters.putString("q", searchText);
            }
            Callback wrapper2 = new Callback(callback2){
                final /* synthetic */ GraphJSONArrayCallback $callback;

                public final void onCompleted(@NotNull GraphResponse response) {
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    if (this.$callback != null) {
                        JSONObject result;
                        JSONObject jSONObject = result = response.getJSONObject();
                        JSONArray data = jSONObject != null ? jSONObject.optJSONArray("data") : null;
                        this.$callback.onCompleted(data, response);
                    }
                }
                {
                    this.$callback = graphJSONArrayCallback;
                }
            };
            return new GraphRequest(accessToken, GraphRequest.SEARCH, parameters, HttpMethod.GET, wrapper2, null, 32, null);
        }

        @JvmStatic
        @NotNull
        public final GraphRequest newUploadPhotoRequest(@Nullable AccessToken accessToken, @Nullable String graphPath, @Nullable Bitmap image, @Nullable String caption, @Nullable Bundle params, @Nullable Callback callback2) {
            String graphPath2 = graphPath;
            graphPath2 = this.getDefaultPhotoPathIfNull(graphPath2);
            Bundle parameters = new Bundle();
            if (params != null) {
                parameters.putAll(params);
            }
            parameters.putParcelable(GraphRequest.PICTURE_PARAM, (Parcelable)image);
            if (caption != null) {
                CharSequence charSequence = caption;
                boolean bl = false;
                if (charSequence.length() > 0) {
                    parameters.putString(GraphRequest.CAPTION_PARAM, caption);
                }
            }
            return new GraphRequest(accessToken, graphPath2, parameters, HttpMethod.POST, callback2, null, 32, null);
        }

        @JvmStatic
        @NotNull
        public final GraphRequest newUploadPhotoRequest(@Nullable AccessToken accessToken, @Nullable String graphPath, @Nullable File file, @Nullable String caption, @Nullable Bundle params, @Nullable Callback callback2) throws FileNotFoundException {
            String graphPath2 = graphPath;
            graphPath2 = this.getDefaultPhotoPathIfNull(graphPath2);
            ParcelFileDescriptor descriptor = ParcelFileDescriptor.open((File)file, (int)0x10000000);
            Bundle parameters = new Bundle();
            if (params != null) {
                parameters.putAll(params);
            }
            parameters.putParcelable(GraphRequest.PICTURE_PARAM, (Parcelable)descriptor);
            if (caption != null) {
                CharSequence charSequence = caption;
                boolean bl = false;
                if (charSequence.length() > 0) {
                    parameters.putString(GraphRequest.CAPTION_PARAM, caption);
                }
            }
            return new GraphRequest(accessToken, graphPath2, parameters, HttpMethod.POST, callback2, null, 32, null);
        }

        @JvmStatic
        @NotNull
        public final GraphRequest newUploadPhotoRequest(@Nullable AccessToken accessToken, @Nullable String graphPath, @NotNull Uri photoUri, @Nullable String caption, @Nullable Bundle params, @Nullable Callback callback2) throws FileNotFoundException {
            Intrinsics.checkNotNullParameter((Object)photoUri, (String)"photoUri");
            String graphPath2 = graphPath;
            graphPath2 = this.getDefaultPhotoPathIfNull(graphPath2);
            if (Utility.isFileUri(photoUri)) {
                return this.newUploadPhotoRequest(accessToken, graphPath2, new File(photoUri.getPath()), caption, params, callback2);
            }
            if (!Utility.isContentUri(photoUri)) {
                throw (Throwable)new FacebookException("The photo Uri must be either a file:// or content:// Uri");
            }
            Bundle parameters = new Bundle();
            if (params != null) {
                parameters.putAll(params);
            }
            parameters.putParcelable(GraphRequest.PICTURE_PARAM, (Parcelable)photoUri);
            if (caption != null) {
                CharSequence charSequence = caption;
                boolean bl = false;
                if (charSequence.length() > 0) {
                    parameters.putString(GraphRequest.CAPTION_PARAM, caption);
                }
            }
            return new GraphRequest(accessToken, graphPath2, parameters, HttpMethod.POST, callback2, null, 32, null);
        }

        @JvmStatic
        @NotNull
        public final GraphRequest newCustomAudienceThirdPartyIdRequest(@Nullable AccessToken accessToken, @NotNull Context context, @Nullable String applicationId, @Nullable Callback callback2) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            String applicationId2 = applicationId;
            if (applicationId2 == null && accessToken != null) {
                applicationId2 = accessToken.getApplicationId();
            }
            if (applicationId2 == null) {
                applicationId2 = Utility.getMetadataApplicationId(context);
            }
            if (applicationId2 == null) {
                throw (Throwable)new FacebookException("Facebook App ID cannot be determined");
            }
            String endpoint = applicationId2 + "/custom_audience_third_party_id";
            AttributionIdentifiers attributionIdentifiers = AttributionIdentifiers.Companion.getAttributionIdentifiers(context);
            Bundle parameters = new Bundle();
            if (accessToken == null) {
                String udid;
                if (attributionIdentifiers == null) {
                    throw (Throwable)new FacebookException("There is no access token and attribution identifiers could not be retrieved");
                }
                String string = udid = attributionIdentifiers.getAttributionId() != null ? attributionIdentifiers.getAttributionId() : attributionIdentifiers.getAndroidAdvertiserId();
                if (attributionIdentifiers.getAttributionId() != null) {
                    parameters.putString("udid", udid);
                }
            }
            if (FacebookSdk.getLimitEventAndDataUsage(context) || attributionIdentifiers != null && attributionIdentifiers.isTrackingLimited()) {
                parameters.putString("limit_event_usage", "1");
            }
            return new GraphRequest(accessToken, endpoint, parameters, HttpMethod.GET, callback2, null, 32, null);
        }

        @JvmStatic
        @NotNull
        public final GraphRequest newCustomAudienceThirdPartyIdRequest(@Nullable AccessToken accessToken, @NotNull Context context, @Nullable Callback callback2) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return this.newCustomAudienceThirdPartyIdRequest(accessToken, context, null, callback2);
        }

        @JvmStatic
        @NotNull
        public final HttpURLConnection toHttpConnection(GraphRequest ... requests) {
            Intrinsics.checkNotNullParameter((Object)requests, (String)"requests");
            return this.toHttpConnection(ArraysKt.toList((Object[])requests));
        }

        @JvmStatic
        @NotNull
        public final HttpURLConnection toHttpConnection(@NotNull Collection<GraphRequest> requests) {
            Intrinsics.checkNotNullParameter(requests, (String)"requests");
            Validate.notEmpty(requests, "requests");
            return this.toHttpConnection(new GraphRequestBatch(requests));
        }

        @JvmStatic
        @NotNull
        public final HttpURLConnection toHttpConnection(@NotNull GraphRequestBatch requests) {
            Object request2;
            Intrinsics.checkNotNullParameter((Object)requests, (String)"requests");
            this.validateFieldsParamForGetRequests$facebook_core_release(requests);
            Object url = null;
            try {
                URL uRL;
                if (requests.size() == 1) {
                    request2 = requests.get(0);
                    uRL = new URL(((GraphRequest)request2).getUrlForSingleRequest());
                } else {
                    uRL = new URL(ServerProtocol.getGraphUrlBase());
                }
                request2 = uRL;
            }
            catch (MalformedURLException e) {
                throw (Throwable)new FacebookException("could not construct URL for request", e);
            }
            url = request2;
            HttpURLConnection connection = null;
            try {
                connection = this.createConnection((URL)url);
                this.serializeToUrlConnection$facebook_core_release(requests, connection);
            }
            catch (IOException e) {
                Utility.disconnectQuietly(connection);
                throw (Throwable)new FacebookException("could not construct request body", e);
            }
            catch (JSONException e) {
                Utility.disconnectQuietly(connection);
                throw (Throwable)new FacebookException("could not construct request body", e);
            }
            return connection;
        }

        @JvmStatic
        @NotNull
        public final GraphResponse executeAndWait(@NotNull GraphRequest request2) {
            Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
            List<GraphResponse> responses = this.executeBatchAndWait(request2);
            if (responses.size() != 1) {
                throw (Throwable)new FacebookException("invalid state: expected a single response");
            }
            return responses.get(0);
        }

        @JvmStatic
        @NotNull
        public final List<GraphResponse> executeBatchAndWait(GraphRequest ... requests) {
            Intrinsics.checkNotNullParameter((Object)requests, (String)"requests");
            return this.executeBatchAndWait(ArraysKt.toList((Object[])requests));
        }

        @JvmStatic
        @NotNull
        public final List<GraphResponse> executeBatchAndWait(@NotNull Collection<GraphRequest> requests) {
            Intrinsics.checkNotNullParameter(requests, (String)"requests");
            return this.executeBatchAndWait(new GraphRequestBatch(requests));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @NotNull
        public final List<GraphResponse> executeBatchAndWait(@NotNull GraphRequestBatch requests) {
            List<GraphResponse> list;
            Intrinsics.checkNotNullParameter((Object)requests, (String)"requests");
            Validate.notEmptyAndContainsNoNulls(requests, "requests");
            HttpURLConnection connection = null;
            try {
                List<GraphResponse> list2;
                HttpURLConnection httpURLConnection;
                Exception exception = null;
                try {
                    httpURLConnection = this.toHttpConnection(requests);
                }
                catch (Exception ex) {
                    exception = ex;
                    httpURLConnection = null;
                }
                connection = httpURLConnection;
                if (connection != null) {
                    list2 = this.executeConnectionAndWait(connection, requests);
                } else {
                    List<GraphResponse> responses = GraphResponse.Companion.constructErrorResponses(requests.getRequests(), null, new FacebookException(exception));
                    this.runCallbacks$facebook_core_release(requests, responses);
                    list2 = responses;
                }
                list = list2;
            }
            finally {
                Utility.disconnectQuietly(connection);
            }
            return list;
        }

        @JvmStatic
        @NotNull
        public final GraphRequestAsyncTask executeBatchAsync(GraphRequest ... requests) {
            Intrinsics.checkNotNullParameter((Object)requests, (String)"requests");
            return this.executeBatchAsync(ArraysKt.toList((Object[])requests));
        }

        @JvmStatic
        @NotNull
        public final GraphRequestAsyncTask executeBatchAsync(@NotNull Collection<GraphRequest> requests) {
            Intrinsics.checkNotNullParameter(requests, (String)"requests");
            return this.executeBatchAsync(new GraphRequestBatch(requests));
        }

        @JvmStatic
        @NotNull
        public final GraphRequestAsyncTask executeBatchAsync(@NotNull GraphRequestBatch requests) {
            Intrinsics.checkNotNullParameter((Object)requests, (String)"requests");
            Validate.notEmptyAndContainsNoNulls(requests, "requests");
            GraphRequestAsyncTask asyncTask = new GraphRequestAsyncTask(requests);
            asyncTask.executeOnExecutor(FacebookSdk.getExecutor(), new Void[0]);
            return asyncTask;
        }

        @JvmStatic
        @NotNull
        public final List<GraphResponse> executeConnectionAndWait(@NotNull HttpURLConnection connection, @NotNull Collection<GraphRequest> requests) {
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            Intrinsics.checkNotNullParameter(requests, (String)"requests");
            return this.executeConnectionAndWait(connection, new GraphRequestBatch(requests));
        }

        @JvmStatic
        @NotNull
        public final List<GraphResponse> executeConnectionAndWait(@NotNull HttpURLConnection connection, @NotNull GraphRequestBatch requests) {
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            Intrinsics.checkNotNullParameter((Object)requests, (String)"requests");
            List<GraphResponse> responses = GraphResponse.Companion.fromHttpConnection(connection, requests);
            Utility.disconnectQuietly(connection);
            int numRequests = requests.size();
            if (numRequests != responses.size()) {
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                Locale locale = Locale.US;
                String string = "Received %d responses while expecting %d";
                Object[] objectArray = new Object[]{responses.size(), numRequests};
                boolean bl = false;
                String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(locale, format, *args)");
                throw (Throwable)new FacebookException(string2);
            }
            this.runCallbacks$facebook_core_release(requests, responses);
            AccessTokenManager.Companion.getInstance().extendAccessTokenIfNeeded();
            return responses;
        }

        @JvmStatic
        @NotNull
        public final GraphRequestAsyncTask executeConnectionAsync(@NotNull HttpURLConnection connection, @NotNull GraphRequestBatch requests) {
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            Intrinsics.checkNotNullParameter((Object)requests, (String)"requests");
            return this.executeConnectionAsync(null, connection, requests);
        }

        @JvmStatic
        @NotNull
        public final GraphRequestAsyncTask executeConnectionAsync(@Nullable Handler callbackHandler, @NotNull HttpURLConnection connection, @NotNull GraphRequestBatch requests) {
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            Intrinsics.checkNotNullParameter((Object)requests, (String)"requests");
            GraphRequestAsyncTask asyncTask = new GraphRequestAsyncTask(connection, requests);
            requests.setCallbackHandler(callbackHandler);
            asyncTask.executeOnExecutor(FacebookSdk.getExecutor(), new Void[0]);
            return asyncTask;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final void runCallbacks$facebook_core_release(@NotNull GraphRequestBatch requests, @NotNull List<GraphResponse> responses) {
            Intrinsics.checkNotNullParameter((Object)requests, (String)"requests");
            Intrinsics.checkNotNullParameter(responses, (String)"responses");
            int numRequests = requests.size();
            ArrayList<Pair> callbacks = new ArrayList<Pair>();
            int n = 0;
            int n2 = numRequests;
            while (n < n2) {
                void i;
                GraphRequest request2 = requests.get((int)i);
                if (request2.getCallback() != null) {
                    callbacks.add(new Pair((Object)request2.getCallback(), (Object)responses.get((int)i)));
                }
                ++i;
            }
            if (callbacks.size() > 0) {
                Handler callbackHandler;
                Runnable runnable2 = new Runnable(callbacks, requests){
                    final /* synthetic */ ArrayList $callbacks;
                    final /* synthetic */ GraphRequestBatch $requests;

                    public final void run() {
                        if (CrashShieldHandler.isObjectCrashing(this)) {
                            return;
                        }
                        try {
                            if (CrashShieldHandler.isObjectCrashing(this)) {
                                return;
                            }
                            try {
                                for (Pair pair : this.$callbacks) {
                                    Callback callback2 = (Callback)pair.first;
                                    Object object = pair.second;
                                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"pair.second");
                                    callback2.onCompleted((GraphResponse)object);
                                }
                                List<GraphRequestBatch.Callback> batchCallbacks = this.$requests.getCallbacks();
                                for (GraphRequestBatch.Callback batchCallback : batchCallbacks) {
                                    batchCallback.onBatchCompleted(this.$requests);
                                }
                                return;
                            }
                            catch (Throwable throwable) {
                                CrashShieldHandler.handleThrowable(throwable, this);
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            CrashShieldHandler.handleThrowable(throwable, this);
                            return;
                        }
                    }
                    {
                        this.$callbacks = arrayList;
                        this.$requests = graphRequestBatch;
                    }
                };
                Handler handler = callbackHandler = requests.getCallbackHandler();
                if (handler != null) {
                    handler.post(runnable2);
                } else {
                    runnable2.run();
                }
            }
        }

        private final String getDefaultPhotoPathIfNull(String graphPath) {
            String string = graphPath;
            if (string == null) {
                string = GraphRequest.MY_PHOTOS;
            }
            return string;
        }

        private final HttpURLConnection createConnection(URL url) throws IOException {
            URLConnection uRLConnection = url.openConnection();
            if (uRLConnection == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
            }
            HttpURLConnection connection = (HttpURLConnection)uRLConnection;
            connection.setRequestProperty(GraphRequest.USER_AGENT_HEADER, this.getUserAgent());
            connection.setRequestProperty(GraphRequest.ACCEPT_LANGUAGE_HEADER, Locale.getDefault().toString());
            connection.setChunkedStreamingMode(0);
            return connection;
        }

        private final boolean hasOnProgressCallbacks(GraphRequestBatch requests) {
            for (GraphRequestBatch.Callback callback2 : requests.getCallbacks()) {
                if (!(callback2 instanceof GraphRequestBatch.OnProgressCallback)) continue;
                return true;
            }
            for (GraphRequest request2 : requests) {
                if (!(request2.getCallback() instanceof OnProgressCallback)) continue;
                return true;
            }
            return false;
        }

        private final void setConnectionContentType(HttpURLConnection connection, boolean shouldUseGzip) {
            if (shouldUseGzip) {
                connection.setRequestProperty(GraphRequest.CONTENT_TYPE_HEADER, "application/x-www-form-urlencoded");
                connection.setRequestProperty(GraphRequest.CONTENT_ENCODING_HEADER, "gzip");
            } else {
                connection.setRequestProperty(GraphRequest.CONTENT_TYPE_HEADER, this.getMimeContentType());
            }
        }

        private final boolean isGzipCompressible(GraphRequestBatch requests) {
            for (GraphRequest request2 : requests) {
                for (String key : request2.getParameters().keySet()) {
                    Object value = request2.getParameters().get(key);
                    if (!this.isSupportedAttachmentType(value)) continue;
                    return false;
                }
            }
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        public final boolean shouldWarnOnMissingFieldsParam$facebook_core_release(@NotNull GraphRequest request2) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
            String string = request2.getVersion();
            if (string == null) return true;
            String version = string;
            CharSequence charSequence = version;
            int n = 0;
            if (charSequence.length() == 0) {
                return true;
            }
            boolean bl2 = false;
            if (bl2) {
                return true;
            }
            if (StringsKt.startsWith$default((String)version, (String)"v", (boolean)false, (int)2, null)) {
                charSequence = version;
                n = 1;
                boolean bl3 = false;
                CharSequence charSequence2 = charSequence;
                if (charSequence2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string2 = ((String)charSequence2).substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                version = string2;
            }
            CharSequence charSequence3 = version;
            String string3 = "\\.";
            int n2 = 0;
            string3 = new Regex(string3);
            n2 = 0;
            boolean bl4 = false;
            Collection $this$toTypedArray$iv = string3.split(charSequence3, n2);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] versionParts = stringArray;
            if (versionParts.length >= 2) {
                charSequence3 = versionParts[0];
                bl = false;
                if (Integer.parseInt((String)charSequence3) > 2) return true;
            }
            charSequence3 = versionParts[0];
            bl = false;
            if (Integer.parseInt((String)charSequence3) < 2) return false;
            charSequence3 = versionParts[1];
            bl = false;
            if (Integer.parseInt((String)charSequence3) < 4) return false;
            return true;
        }

        @JvmStatic
        public final void validateFieldsParamForGetRequests$facebook_core_release(@NotNull GraphRequestBatch requests) {
            Intrinsics.checkNotNullParameter((Object)requests, (String)"requests");
            for (GraphRequest request2 : requests) {
                if (HttpMethod.GET != request2.getHttpMethod()) continue;
                GraphRequest graphRequest = request2;
                Intrinsics.checkNotNullExpressionValue((Object)graphRequest, (String)"request");
                if (!this.shouldWarnOnMissingFieldsParam$facebook_core_release(graphRequest) || request2.getParameters().containsKey(GraphRequest.FIELDS_PARAM) && !Utility.isNullOrEmpty(request2.getParameters().getString(GraphRequest.FIELDS_PARAM))) continue;
                Object[] objectArray = new Object[1];
                String string = request2.getGraphPath();
                if (string == null) {
                    string = "";
                }
                objectArray[0] = string;
                Logger.Companion.log(LoggingBehavior.DEVELOPER_ERRORS, 5, "Request", "starting with Graph API v2.4, GET requests for /%s should contain an explicit \"fields\" parameter.", objectArray);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        public final void serializeToUrlConnection$facebook_core_release(@NotNull GraphRequestBatch requests, @NotNull HttpURLConnection connection) throws IOException, JSONException {
            boolean isPost;
            Intrinsics.checkNotNullParameter((Object)requests, (String)"requests");
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            Logger logger = new Logger(LoggingBehavior.REQUESTS, "Request");
            int numRequests = requests.size();
            boolean shouldUseGzip = this.isGzipCompressible(requests);
            HttpMethod httpMethod = numRequests == 1 ? requests.get(0).getHttpMethod() : null;
            if (httpMethod == null) {
                httpMethod = HttpMethod.POST;
            }
            HttpMethod connectionHttpMethod = httpMethod;
            connection.setRequestMethod(connectionHttpMethod.name());
            this.setConnectionContentType(connection, shouldUseGzip);
            URL url = connection.getURL();
            logger.append("Request:\n");
            logger.appendKeyValue("Id", requests.getId());
            URL uRL = url;
            Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"url");
            logger.appendKeyValue("URL", uRL);
            String string = connection.getRequestMethod();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"connection.requestMethod");
            logger.appendKeyValue("Method", string);
            String string2 = connection.getRequestProperty(GraphRequest.USER_AGENT_HEADER);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"connection.getRequestProperty(\"User-Agent\")");
            logger.appendKeyValue(GraphRequest.USER_AGENT_HEADER, string2);
            String string3 = connection.getRequestProperty(GraphRequest.CONTENT_TYPE_HEADER);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"connection.getRequestProperty(\"Content-Type\")");
            logger.appendKeyValue(GraphRequest.CONTENT_TYPE_HEADER, string3);
            connection.setConnectTimeout(requests.getTimeout());
            connection.setReadTimeout(requests.getTimeout());
            boolean bl = isPost = connectionHttpMethod == HttpMethod.POST;
            if (!isPost) {
                logger.log();
                return;
            }
            connection.setDoOutput(true);
            OutputStream outputStream = null;
            try {
                outputStream = new BufferedOutputStream(connection.getOutputStream());
                if (shouldUseGzip) {
                    outputStream = new GZIPOutputStream(outputStream);
                }
                if (this.hasOnProgressCallbacks(requests)) {
                    ProgressNoopOutputStream countingStream = null;
                    countingStream = new ProgressNoopOutputStream(requests.getCallbackHandler());
                    this.processRequest(requests, null, numRequests, url, countingStream, shouldUseGzip);
                    int max = countingStream.getMaxProgress();
                    Map<GraphRequest, RequestProgress> progressMap = countingStream.getProgressMap();
                    outputStream = new ProgressOutputStream(outputStream, requests, progressMap, max);
                }
                this.processRequest(requests, logger, numRequests, url, outputStream, shouldUseGzip);
            }
            catch (Throwable throwable) {
                OutputStream outputStream2 = outputStream;
                if (outputStream2 != null) {
                    outputStream2.close();
                }
                throw throwable;
            }
            outputStream.close();
            logger.log();
        }

        private final void processRequest(GraphRequestBatch requests, Logger logger, int numRequests, URL url, OutputStream outputStream, boolean shouldUseGzip) {
            Serializer serializer = new Serializer(outputStream, logger, shouldUseGzip);
            if (numRequests == 1) {
                GraphRequest request2 = requests.get(0);
                Map attachments = new HashMap();
                for (String key : request2.getParameters().keySet()) {
                    Object value = request2.getParameters().get(key);
                    if (!this.isSupportedAttachmentType(value)) continue;
                    String string = key;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"key");
                    attachments.put(string, new Attachment(request2, value));
                }
                Logger logger2 = logger;
                if (logger2 != null) {
                    logger2.append("  Parameters:\n");
                }
                this.serializeParameters(request2.getParameters(), serializer, request2);
                Logger logger3 = logger;
                if (logger3 != null) {
                    logger3.append("  Attachments:\n");
                }
                this.serializeAttachments(attachments, serializer);
                JSONObject graphObject = request2.getGraphObject();
                if (graphObject != null) {
                    String string = url.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url.path");
                    this.processGraphObject(graphObject, string, serializer);
                }
            } else {
                String batchAppID = this.getBatchAppId(requests);
                Object attachments = batchAppID;
                boolean bl = false;
                if (attachments.length() == 0) {
                    throw (Throwable)new FacebookException("App ID was not specified at the request or Settings.");
                }
                serializer.writeString(GraphRequest.BATCH_APP_ID_PARAM, batchAppID);
                attachments = new HashMap();
                this.serializeRequestsAsJSON(serializer, requests, (Map<String, Attachment>)attachments);
                Logger logger4 = logger;
                if (logger4 != null) {
                    logger4.append("  Attachments:\n");
                }
                this.serializeAttachments((Map<String, Attachment>)attachments, serializer);
            }
        }

        private final boolean isMeRequest(String path) {
            String path2 = path;
            Matcher matcher = versionPattern.matcher(path2);
            if (matcher.matches()) {
                String string = matcher.group(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"matcher.group(1)");
                path2 = string;
            }
            return StringsKt.startsWith$default((String)path2, (String)"me/", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)path2, (String)"/me/", (boolean)false, (int)2, null);
        }

        private final void processGraphObject(JSONObject graphObject, String path, KeyValueSerializer serializer) {
            boolean isOGAction = false;
            if (this.isMeRequest(path)) {
                int colonLocation = StringsKt.indexOf$default((CharSequence)path, (String)":", (int)0, (boolean)false, (int)6, null);
                int questionMarkLocation = StringsKt.indexOf$default((CharSequence)path, (String)"?", (int)0, (boolean)false, (int)6, null);
                isOGAction = colonLocation > 3 && (questionMarkLocation == -1 || colonLocation < questionMarkLocation);
            }
            Iterator keyIterator = graphObject.keys();
            while (keyIterator.hasNext()) {
                String key = (String)keyIterator.next();
                Object value = graphObject.opt(key);
                boolean passByValue = isOGAction && StringsKt.equals((String)key, (String)"image", (boolean)true);
                String string = key;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"key");
                Object object = value;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"value");
                this.processGraphObjectProperty(string, object, serializer, passByValue);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void processGraphObjectProperty(String key, Object value, KeyValueSerializer serializer, boolean passByValue) {
            Class<?> valueClass = value.getClass();
            if (JSONObject.class.isAssignableFrom(valueClass)) {
                Object object = value;
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.json.JSONObject");
                }
                JSONObject jsonObject = (JSONObject)object;
                if (passByValue) {
                    Iterator keys = jsonObject.keys();
                    while (keys.hasNext()) {
                        String subKey;
                        String propertyName = (String)keys.next();
                        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                        String string = "%s[%s]";
                        Object[] objectArray = new Object[]{key, propertyName};
                        boolean bl = false;
                        Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(format, *args)");
                        Object object2 = jsonObject.opt(propertyName);
                        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"jsonObject.opt(propertyName)");
                        this.processGraphObjectProperty(subKey, object2, serializer, passByValue);
                    }
                } else if (jsonObject.has("id")) {
                    String string = jsonObject.optString("id");
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonObject.optString(\"id\")");
                    this.processGraphObjectProperty(key, string, serializer, passByValue);
                } else if (jsonObject.has("url")) {
                    String string = jsonObject.optString("url");
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonObject.optString(\"url\")");
                    this.processGraphObjectProperty(key, string, serializer, passByValue);
                } else if (jsonObject.has("fbsdk:create_object")) {
                    String string = jsonObject.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonObject.toString()");
                    this.processGraphObjectProperty(key, string, serializer, passByValue);
                }
            } else if (JSONArray.class.isAssignableFrom(valueClass)) {
                Object object = value;
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.json.JSONArray");
                }
                JSONArray jsonArray = (JSONArray)object;
                int length = jsonArray.length();
                int propertyName = 0;
                int n = length;
                while (propertyName < n) {
                    String subKey;
                    void i;
                    StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                    Locale locale = Locale.ROOT;
                    String string = "%s[%d]";
                    Object[] objectArray = new Object[]{key, (int)i};
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(locale, format, *args)");
                    Object object3 = jsonArray.opt((int)i);
                    Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"jsonArray.opt(i)");
                    this.processGraphObjectProperty(subKey, object3, serializer, passByValue);
                    ++i;
                }
            } else if (String.class.isAssignableFrom(valueClass) || Number.class.isAssignableFrom(valueClass) || Boolean.TYPE.isAssignableFrom(valueClass)) {
                serializer.writeString(key, value.toString());
            } else if (Date.class.isAssignableFrom(valueClass)) {
                Object object = value;
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.util.Date");
                }
                Date date = (Date)object;
                SimpleDateFormat iso8601DateFormat = new SimpleDateFormat(GraphRequest.ISO_8601_FORMAT_STRING, Locale.US);
                String string = iso8601DateFormat.format(date);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"iso8601DateFormat.format(date)");
                serializer.writeString(key, string);
            }
        }

        private final void serializeParameters(Bundle bundle, Serializer serializer, GraphRequest request2) {
            Set keys = bundle.keySet();
            for (String key : keys) {
                Object value = bundle.get(key);
                if (!this.isSupportedParameterType(value)) continue;
                String string = key;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"key");
                serializer.writeObject(string, value, request2);
            }
        }

        private final void serializeAttachments(Map<String, Attachment> attachments, Serializer serializer) {
            Map<String, Attachment> $this$forEach$iv = attachments;
            boolean $i$f$forEach = false;
            Map<String, Attachment> map = $this$forEach$iv;
            boolean bl = false;
            Iterator<Map.Entry<String, Attachment>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Attachment> element$iv;
                Map.Entry<String, Attachment> it = element$iv = iterator.next();
                boolean bl2 = false;
                if (!Companion.isSupportedAttachmentType(it.getValue())) continue;
                serializer.writeObject(it.getKey(), it.getValue().getValue(), it.getValue().getRequest());
            }
        }

        private final void serializeRequestsAsJSON(Serializer serializer, Collection<GraphRequest> requests, Map<String, Attachment> attachments) {
            JSONArray batch2 = new JSONArray();
            for (GraphRequest request2 : requests) {
                request2.serializeToBatch(batch2, attachments);
            }
            serializer.writeRequestsAsJson(GraphRequest.BATCH_PARAM, batch2, requests);
        }

        private final String getMimeContentType() {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "multipart/form-data; boundary=%s";
            Object[] objectArray = new Object[]{MIME_BOUNDARY};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            return string2;
        }

        private final String getUserAgent() {
            if (userAgent == null) {
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = "%s.%s";
                Object object = new Object[]{GraphRequest.USER_AGENT_BASE, "11.1.0"};
                boolean bl = false;
                String string2 = String.format(string, Arrays.copyOf(object, ((Object[])object).length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                userAgent = string2;
                String customUserAgent = InternalSettings.getCustomUserAgent();
                if (!Utility.isNullOrEmpty(customUserAgent)) {
                    string = StringCompanionObject.INSTANCE;
                    object = Locale.ROOT;
                    String string3 = "%s/%s";
                    Object[] objectArray = new Object[]{userAgent, customUserAgent};
                    boolean bl2 = false;
                    String string4 = String.format((Locale)object, string3, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(locale, format, *args)");
                    userAgent = string4;
                }
            }
            return userAgent;
        }

        private final void setUserAgent(String string) {
            userAgent = string;
        }

        /*
         * Enabled aggressive block sorting
         */
        private final String getBatchAppId(GraphRequestBatch batch2) {
            String string;
            String batchApplicationId = batch2.getBatchApplicationId();
            if (batchApplicationId != null) {
                Collection collection = batch2;
                boolean bl = false;
                if (!collection.isEmpty()) {
                    return batchApplicationId;
                }
            }
            for (GraphRequest request2 : batch2) {
                AccessToken accessToken = request2.getAccessToken();
                if (accessToken == null) continue;
                return accessToken.getApplicationId();
            }
            String defaultBatchApplicationId = defaultBatchApplicationId;
            if (defaultBatchApplicationId != null) {
                CharSequence charSequence = defaultBatchApplicationId;
                boolean bl = false;
                if (charSequence.length() > 0) {
                    string = defaultBatchApplicationId;
                    return string;
                }
            }
            String string2 = FacebookSdk.getApplicationId();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"FacebookSdk.getApplicationId()");
            return string;
        }

        private final boolean isSupportedAttachmentType(Object value) {
            return value instanceof Bitmap || value instanceof byte[] || value instanceof Uri || value instanceof ParcelFileDescriptor || value instanceof ParcelableResourceWithMimeType;
        }

        private final boolean isSupportedParameterType(Object value) {
            return value instanceof String || value instanceof Boolean || value instanceof Number || value instanceof Date;
        }

        private final String parameterToString(Object value) {
            if (value instanceof String) {
                return (String)value;
            }
            if (value instanceof Boolean || value instanceof Number) {
                return value.toString();
            }
            if (value instanceof Date) {
                SimpleDateFormat iso8601DateFormat = new SimpleDateFormat(GraphRequest.ISO_8601_FORMAT_STRING, Locale.US);
                String string = iso8601DateFormat.format((Date)value);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"iso8601DateFormat.format(value)");
                return string;
            }
            throw (Throwable)new IllegalArgumentException("Unsupported parameter type.");
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

