/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal.instrument.errorreport;

import androidx.annotation.RestrictTo;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.GraphResponse;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.InstrumentUtility;
import com.facebook.internal.instrument.errorreport.ErrorReportData;
import com.facebook.internal.instrument.errorreport.ErrorReportHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0007J\u0013\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0007\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u000b\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0007J\b\u0010\u000e\u001a\u00020\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/facebook/internal/instrument/errorreport/ErrorReportHandler;", "", "()V", "MAX_ERROR_REPORT_NUM", "", "enable", "", "listErrorReportFiles", "", "Ljava/io/File;", "()[Ljava/io/File;", "save", "msg", "", "sendErrorReports", "facebook-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class ErrorReportHandler {
    private static final int MAX_ERROR_REPORT_NUM = 1000;
    public static final ErrorReportHandler INSTANCE;

    @JvmStatic
    public static final void save(@Nullable String msg) {
        try {
            ErrorReportData errorReport = new ErrorReportData(msg);
            errorReport.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @JvmStatic
    public static final void enable() {
        if (FacebookSdk.getAutoLogAppEventsEnabled()) {
            ErrorReportHandler.sendErrorReports();
        }
    }

    @JvmStatic
    public static final void sendErrorReports() {
        if (Utility.isDataProcessingRestricted()) {
            return;
        }
        File[] reports2 = ErrorReportHandler.listErrorReportFiles();
        ArrayList<ErrorReportData> validReports2 = new ArrayList<ErrorReportData>();
        for (File report : reports2) {
            ErrorReportData errorData = new ErrorReportData(report);
            if (!errorData.isValid()) continue;
            validReports2.add(errorData);
        }
        CollectionsKt.sortWith((List)validReports2, (Comparator)sendErrorReports.1.INSTANCE);
        JSONArray errorLogs = new JSONArray();
        for (int i = 0; i < validReports2.size() && i < 1000; ++i) {
            errorLogs.put(validReports2.get(i));
        }
        InstrumentUtility.sendReports("error_reports", errorLogs, new GraphRequest.Callback(validReports2){
            final /* synthetic */ ArrayList $validReports;

            public final void onCompleted(@NotNull GraphResponse response) {
                block3: {
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    try {
                        if (response.getError() != null) break block3;
                        JSONObject jSONObject = response.getJsonObject();
                        if (jSONObject == null) break block3;
                        if (!jSONObject.getBoolean("success")) break block3;
                        Iterable $this$forEach$iv = this.$validReports;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            ErrorReportData it = (ErrorReportData)element$iv;
                            boolean bl = false;
                            it.clear();
                        }
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                }
            }
            {
                this.$validReports = arrayList;
            }
        });
    }

    @JvmStatic
    @NotNull
    public static final File[] listErrorReportFiles() {
        File file = InstrumentUtility.getInstrumentReportDir();
        if (file == null) {
            return new File[0];
        }
        File reportDir = file;
        File[] fileArray = reportDir.listFiles(listErrorReportFiles.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)fileArray, (String)"reportDir.listFiles { di\u2026OR_REPORT_PREFIX)))\n    }");
        return fileArray;
    }

    private ErrorReportHandler() {
    }

    static {
        ErrorReportHandler errorReportHandler;
        INSTANCE = errorReportHandler = new ErrorReportHandler();
    }
}

