/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal.instrument;

import android.content.Context;
import androidx.annotation.RestrictTo;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.InstrumentUtility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0004H\u0007J\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0007J\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007J\u0012\u0010\u0014\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007J\u0013\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0016H\u0007\u00a2\u0006\u0002\u0010\u0017J\u0013\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u0016H\u0007\u00a2\u0006\u0002\u0010\u0017J\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001b\u001a\u00020\fH\u0007J$\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0007J\u001c\u0010#\u001a\u00020\u001d2\b\u0010\r\u001a\u0004\u0018\u00010\u00042\b\u0010$\u001a\u0004\u0018\u00010\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/facebook/internal/instrument/InstrumentUtility;", "", "()V", "ANALYSIS_REPORT_PREFIX", "", "CRASH_REPORT_PREFIX", "CRASH_SHIELD_PREFIX", "ERROR_REPORT_PREFIX", "FBSDK_PREFIX", "INSTRUMENT_DIR", "THREAD_CHECK_PREFIX", "deleteFile", "", "filename", "getCause", "e", "", "getInstrumentReportDir", "Ljava/io/File;", "getStackTrace", "isSDKRelatedException", "listExceptionAnalysisReportFiles", "", "()[Ljava/io/File;", "listExceptionReportFiles", "readFile", "Lorg/json/JSONObject;", "deleteOnException", "sendReports", "", "key", "reports", "Lorg/json/JSONArray;", "callback", "Lcom/facebook/GraphRequest$Callback;", "writeFile", "content", "facebook-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class InstrumentUtility {
    @NotNull
    public static final String ANALYSIS_REPORT_PREFIX = "analysis_log_";
    @NotNull
    public static final String CRASH_REPORT_PREFIX = "crash_log_";
    @NotNull
    public static final String CRASH_SHIELD_PREFIX = "shield_log_";
    @NotNull
    public static final String THREAD_CHECK_PREFIX = "thread_check_log_";
    @NotNull
    public static final String ERROR_REPORT_PREFIX = "error_log_";
    private static final String FBSDK_PREFIX = "com.facebook";
    private static final String INSTRUMENT_DIR = "instrument";
    public static final InstrumentUtility INSTANCE;

    @JvmStatic
    @Nullable
    public static final String getCause(@Nullable Throwable e) {
        if (e == null) {
            return null;
        }
        return e.getCause() == null ? e.toString() : String.valueOf(e.getCause());
    }

    @JvmStatic
    @Nullable
    public static final String getStackTrace(@Nullable Throwable e) {
        if (e == null) {
            return null;
        }
        JSONArray array = new JSONArray();
        Throwable previous = null;
        for (Throwable t = e; t != null && t != previous; t = t.getCause()) {
            for (StackTraceElement element : t.getStackTrace()) {
                array.put((Object)element.toString());
            }
            previous = t;
        }
        return array.toString();
    }

    @JvmStatic
    public static final boolean isSDKRelatedException(@Nullable Throwable e) {
        if (e == null) {
            return false;
        }
        Throwable previous = null;
        for (Throwable t = e; t != null && t != previous; t = t.getCause()) {
            StackTraceElement[] stackTraceElementArray = t.getStackTrace();
            int n = stackTraceElementArray.length;
            for (int i = 0; i < n; ++i) {
                StackTraceElement element;
                StackTraceElement stackTraceElement = element = stackTraceElementArray[i];
                Intrinsics.checkNotNullExpressionValue((Object)stackTraceElement, (String)"element");
                String string = stackTraceElement.getClassName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.className");
                if (!StringsKt.startsWith$default((String)string, (String)FBSDK_PREFIX, (boolean)false, (int)2, null)) continue;
                return true;
            }
            previous = t;
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final File[] listExceptionAnalysisReportFiles() {
        File[] reports2;
        File file = InstrumentUtility.getInstrumentReportDir();
        if (file == null) {
            return new File[0];
        }
        File reportDir = file;
        File[] fileArray = reports2 = reportDir.listFiles(listExceptionAnalysisReportFiles.reports.1.INSTANCE);
        if (reports2 == null) {
            fileArray = new File[]{};
        }
        return fileArray;
    }

    @JvmStatic
    @NotNull
    public static final File[] listExceptionReportFiles() {
        File[] reports2;
        File file = InstrumentUtility.getInstrumentReportDir();
        if (file == null) {
            return new File[0];
        }
        File reportDir = file;
        File[] fileArray = reports2 = reportDir.listFiles(listExceptionReportFiles.reports.1.INSTANCE);
        if (reports2 == null) {
            fileArray = new File[]{};
        }
        return fileArray;
    }

    @JvmStatic
    @Nullable
    public static final JSONObject readFile(@Nullable String filename, boolean deleteOnException) {
        File reportDir = InstrumentUtility.getInstrumentReportDir();
        if (reportDir == null || filename == null) {
            return null;
        }
        File file = new File(reportDir, filename);
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            String content = Utility.readStreamToString(inputStream);
            return new JSONObject(content);
        }
        catch (Exception e) {
            if (deleteOnException) {
                InstrumentUtility.deleteFile(filename);
            }
            return null;
        }
    }

    @JvmStatic
    public static final void writeFile(@Nullable String filename, @Nullable String content) {
        File reportDir = InstrumentUtility.getInstrumentReportDir();
        if (reportDir == null || filename == null || content == null) {
            return;
        }
        File file = new File(reportDir, filename);
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(file);
            String string = content;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            outputStream.write(byArray);
            outputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @JvmStatic
    public static final boolean deleteFile(@Nullable String filename) {
        File reportDir = InstrumentUtility.getInstrumentReportDir();
        if (reportDir == null || filename == null) {
            return false;
        }
        File file = new File(reportDir, filename);
        return file.delete();
    }

    @JvmStatic
    public static final void sendReports(@Nullable String key, @NotNull JSONArray reports2, @Nullable GraphRequest.Callback callback2) {
        Intrinsics.checkNotNullParameter((Object)reports2, (String)"reports");
        if (reports2.length() == 0) {
            return;
        }
        JSONObject params = new JSONObject();
        try {
            params.put(key, (Object)reports2.toString());
        }
        catch (JSONException e) {
            return;
        }
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "%s/instruments";
        Object[] objectArray = new Object[]{FacebookSdk.getApplicationId()};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        GraphRequest request2 = GraphRequest.Companion.newPostRequest(null, string2, params, callback2);
        request2.executeAsync();
    }

    @JvmStatic
    @Nullable
    public static final File getInstrumentReportDir() {
        Context context = FacebookSdk.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"FacebookSdk.getApplicationContext()");
        File cacheDir = context.getCacheDir();
        File dir = new File(cacheDir, INSTRUMENT_DIR);
        return dir.exists() || dir.mkdirs() ? dir : null;
    }

    private InstrumentUtility() {
    }

    static {
        InstrumentUtility instrumentUtility;
        INSTANCE = instrumentUtility = new InstrumentUtility();
    }
}

