/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal.instrument;

import android.os.Build;
import androidx.annotation.RestrictTo;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.InstrumentData$Type$WhenMappings;
import com.facebook.internal.instrument.InstrumentData$WhenMappings;
import com.facebook.internal.instrument.InstrumentUtility;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0007\u0018\u0000 *2\u00020\u0001:\u0003)*+B\u000f\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0012\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u000f\b\u0012\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\"\u001a\u00020#J\u0011\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0000H\u0086\u0002J\u0006\u0010'\u001a\u00020#J\b\u0010(\u001a\u00020\u0012H\u0016R\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0010R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u001aR\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0010R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010 R\u0010\u0010!\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/facebook/internal/instrument/InstrumentData;", "", "features", "Lorg/json/JSONArray;", "(Lorg/json/JSONArray;)V", "e", "", "t", "Lcom/facebook/internal/instrument/InstrumentData$Type;", "(Ljava/lang/Throwable;Lcom/facebook/internal/instrument/InstrumentData$Type;)V", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "analysisReportParameters", "Lorg/json/JSONObject;", "getAnalysisReportParameters", "()Lorg/json/JSONObject;", "appVersion", "", "cause", "exceptionReportParameters", "getExceptionReportParameters", "featureNames", "filename", "isValid", "", "()Z", "parameters", "getParameters", "stackTrace", "timestamp", "", "Ljava/lang/Long;", "type", "clear", "", "compareTo", "", "data", "save", "toString", "Builder", "Companion", "Type", "facebook-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class InstrumentData {
    private String filename;
    private Type type;
    private JSONArray featureNames;
    private String appVersion;
    private String cause;
    private String stackTrace;
    private Long timestamp;
    private static final String UNKNOWN = "Unknown";
    private static final String PARAM_TIMESTAMP = "timestamp";
    private static final String PARAM_APP_VERSION = "app_version";
    private static final String PARAM_DEVICE_OS = "device_os_version";
    private static final String PARAM_DEVICE_MODEL = "device_model";
    private static final String PARAM_REASON = "reason";
    private static final String PARAM_CALLSTACK = "callstack";
    private static final String PARAM_TYPE = "type";
    private static final String PARAM_FEATURE_NAMES = "feature_names";
    public static final Companion Companion = new Companion(null);

    public final int compareTo(@NotNull InstrumentData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Long l = this.timestamp;
        if (l == null) {
            return -1;
        }
        long ts = l;
        Long l2 = data.timestamp;
        if (l2 == null) {
            return 1;
        }
        long dts = l2;
        return dts == ts ? 0 : (dts < ts ? -1 : 1);
    }

    public final boolean isValid() {
        Type type = this.type;
        if (type != null) {
            switch (InstrumentData$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    return this.featureNames != null && this.timestamp != null;
                }
                case 2: 
                case 3: 
                case 4: {
                    return this.stackTrace != null && this.timestamp != null;
                }
            }
        }
        return false;
    }

    public final void save() {
        if (!this.isValid()) {
            return;
        }
        InstrumentUtility.writeFile(this.filename, this.toString());
    }

    public final void clear() {
        InstrumentUtility.deleteFile(this.filename);
    }

    @NotNull
    public String toString() {
        JSONObject jSONObject = this.getParameters();
        if (jSONObject == null) {
            String string = new JSONObject().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JSONObject().toString()");
            return string;
        }
        JSONObject params = jSONObject;
        String string = params.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"params.toString()");
        return string;
    }

    private final JSONObject getParameters() {
        Type type = this.type;
        if (type != null) {
            switch (InstrumentData$WhenMappings.$EnumSwitchMapping$1[type.ordinal()]) {
                case 1: {
                    return this.getAnalysisReportParameters();
                }
                case 2: 
                case 3: 
                case 4: {
                    return this.getExceptionReportParameters();
                }
            }
        }
        return null;
    }

    private final JSONObject getAnalysisReportParameters() {
        JSONObject obj = new JSONObject();
        try {
            if (this.featureNames != null) {
                obj.put(PARAM_FEATURE_NAMES, (Object)this.featureNames);
            }
            if (this.timestamp != null) {
                obj.put(PARAM_TIMESTAMP, (Object)this.timestamp);
            }
            return obj;
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    private final JSONObject getExceptionReportParameters() {
        JSONObject obj = new JSONObject();
        try {
            obj.put(PARAM_DEVICE_OS, (Object)Build.VERSION.RELEASE);
            obj.put(PARAM_DEVICE_MODEL, (Object)Build.MODEL);
            if (this.appVersion != null) {
                obj.put(PARAM_APP_VERSION, (Object)this.appVersion);
            }
            if (this.timestamp != null) {
                obj.put(PARAM_TIMESTAMP, (Object)this.timestamp);
            }
            if (this.cause != null) {
                obj.put(PARAM_REASON, (Object)this.cause);
            }
            if (this.stackTrace != null) {
                obj.put(PARAM_CALLSTACK, (Object)this.stackTrace);
            }
            if (this.type != null) {
                obj.put(PARAM_TYPE, (Object)this.type);
            }
            return obj;
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    private InstrumentData(JSONArray features) {
        this.type = Type.Analysis;
        this.timestamp = System.currentTimeMillis() / (long)1000;
        this.featureNames = features;
        String string = new StringBuffer().append("analysis_log_").append(String.valueOf(this.timestamp)).append(".json").toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuffer()\n         \u2026)\n            .toString()");
        this.filename = string;
    }

    private InstrumentData(Throwable e, Type t) {
        this.type = t;
        this.appVersion = Utility.getAppVersion();
        this.cause = InstrumentUtility.getCause(e);
        this.stackTrace = InstrumentUtility.getStackTrace(e);
        this.timestamp = System.currentTimeMillis() / (long)1000;
        String string = new StringBuffer().append(t.getLogPrefix()).append(String.valueOf(this.timestamp)).append(".json").toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuffer().append(t.\u2026ppend(\".json\").toString()");
        this.filename = string;
    }

    private InstrumentData(File file) {
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
        this.filename = string;
        this.type = InstrumentData.Companion.getType(this.filename);
        JSONObject obj = InstrumentUtility.readFile(this.filename, true);
        if (obj != null) {
            this.timestamp = obj.optLong(PARAM_TIMESTAMP, 0L);
            this.appVersion = obj.optString(PARAM_APP_VERSION, null);
            this.cause = obj.optString(PARAM_REASON, null);
            this.stackTrace = obj.optString(PARAM_CALLSTACK, null);
            this.featureNames = obj.optJSONArray(PARAM_FEATURE_NAMES);
        }
    }

    public /* synthetic */ InstrumentData(File file, DefaultConstructorMarker $constructor_marker) {
        this(file);
    }

    public /* synthetic */ InstrumentData(Throwable e, Type t, DefaultConstructorMarker $constructor_marker) {
        this(e, t);
    }

    public /* synthetic */ InstrumentData(JSONArray features, DefaultConstructorMarker $constructor_marker) {
        this(features);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\u0004H\u0016R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lcom/facebook/internal/instrument/InstrumentData$Type;", "", "(Ljava/lang/String;I)V", "logPrefix", "", "getLogPrefix", "()Ljava/lang/String;", "toString", "Unknown", "Analysis", "CrashReport", "CrashShield", "ThreadCheck", "facebook-core_release"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type Unknown;
        public static final /* enum */ Type Analysis;
        public static final /* enum */ Type CrashReport;
        public static final /* enum */ Type CrashShield;
        public static final /* enum */ Type ThreadCheck;
        private static final /* synthetic */ Type[] $VALUES;

        static {
            Type[] typeArray = new Type[5];
            Type[] typeArray2 = typeArray;
            typeArray[0] = Unknown = new Type();
            typeArray[1] = Analysis = new Type();
            typeArray[2] = CrashReport = new Type();
            typeArray[3] = CrashShield = new Type();
            typeArray[4] = ThreadCheck = new Type();
            $VALUES = typeArray;
        }

        @NotNull
        public String toString() {
            switch (InstrumentData$Type$WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
                case 1: {
                    return "Analysis";
                }
                case 2: {
                    return "CrashReport";
                }
                case 3: {
                    return "CrashShield";
                }
                case 4: {
                    return "ThreadCheck";
                }
            }
            return InstrumentData.UNKNOWN;
        }

        @NotNull
        public final String getLogPrefix() {
            switch (InstrumentData$Type$WhenMappings.$EnumSwitchMapping$1[this.ordinal()]) {
                case 1: {
                    return "analysis_log_";
                }
                case 2: {
                    return "crash_log_";
                }
                case 3: {
                    return "shield_log_";
                }
                case 4: {
                    return "thread_check_log_";
                }
            }
            return InstrumentData.UNKNOWN;
        }

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String string) {
            return Enum.valueOf(Type.class, string);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0007\u00a8\u0006\u000e"}, d2={"Lcom/facebook/internal/instrument/InstrumentData$Builder;", "", "()V", "build", "Lcom/facebook/internal/instrument/InstrumentData;", "e", "", "t", "Lcom/facebook/internal/instrument/InstrumentData$Type;", "features", "Lorg/json/JSONArray;", "load", "file", "Ljava/io/File;", "facebook-core_release"})
    public static final class Builder {
        public static final Builder INSTANCE;

        @JvmStatic
        @NotNull
        public static final InstrumentData load(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return new InstrumentData(file, null);
        }

        @JvmStatic
        @NotNull
        public static final InstrumentData build(@Nullable Throwable e, @NotNull Type t) {
            Intrinsics.checkNotNullParameter((Object)((Object)t), (String)"t");
            return new InstrumentData(e, t, null);
        }

        @JvmStatic
        @NotNull
        public static final InstrumentData build(@NotNull JSONArray features) {
            Intrinsics.checkNotNullParameter((Object)features, (String)"features");
            return new InstrumentData(features, null);
        }

        private Builder() {
        }

        static {
            Builder builder;
            INSTANCE = builder = new Builder();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/facebook/internal/instrument/InstrumentData$Companion;", "", "()V", "PARAM_APP_VERSION", "", "PARAM_CALLSTACK", "PARAM_DEVICE_MODEL", "PARAM_DEVICE_OS", "PARAM_FEATURE_NAMES", "PARAM_REASON", "PARAM_TIMESTAMP", "PARAM_TYPE", "UNKNOWN", "getType", "Lcom/facebook/internal/instrument/InstrumentData$Type;", "filename", "facebook-core_release"})
    public static final class Companion {
        private final Type getType(String filename) {
            if (StringsKt.startsWith$default((String)filename, (String)"crash_log_", (boolean)false, (int)2, null)) {
                return Type.CrashReport;
            }
            if (StringsKt.startsWith$default((String)filename, (String)"shield_log_", (boolean)false, (int)2, null)) {
                return Type.CrashShield;
            }
            if (StringsKt.startsWith$default((String)filename, (String)"thread_check_log_", (boolean)false, (int)2, null)) {
                return Type.ThreadCheck;
            }
            if (StringsKt.startsWith$default((String)filename, (String)"analysis_log_", (boolean)false, (int)2, null)) {
                return Type.Analysis;
            }
            return Type.Unknown;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

