/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import androidx.annotation.RestrictTo;
import com.facebook.FacebookSdk;
import com.facebook.internal.FeatureManager$Feature$WhenMappings;
import com.facebook.internal.FeatureManager$WhenMappings;
import com.facebook.internal.FetchedAppGateKeepersManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0002\u0016\u0017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007H\u0007J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0004H\u0007J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J\b\u0010\u0014\u001a\u00020\nH\u0002J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0007H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/facebook/internal/FeatureManager;", "", "()V", "FEATURE_MANAGER_STORE", "", "featureMapping", "", "Lcom/facebook/internal/FeatureManager$Feature;", "", "checkFeature", "", "feature", "callback", "Lcom/facebook/internal/FeatureManager$Callback;", "defaultStatus", "", "disableFeature", "getFeature", "className", "getGKStatus", "initializeFeatureMapping", "isEnabled", "Callback", "Feature", "facebook-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class FeatureManager {
    private static final String FEATURE_MANAGER_STORE = "com.facebook.internal.FEATURE_MANAGER";
    private static final Map<Feature, String[]> featureMapping;
    public static final FeatureManager INSTANCE;

    @JvmStatic
    public static final void checkFeature(@NotNull Feature feature, @NotNull Callback callback2) {
        Intrinsics.checkNotNullParameter((Object)((Object)feature), (String)"feature");
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        FetchedAppGateKeepersManager.loadAppGateKeepersAsync(new FetchedAppGateKeepersManager.Callback(callback2, feature){
            final /* synthetic */ Callback $callback;
            final /* synthetic */ Feature $feature;

            public void onCompleted() {
                this.$callback.onCompleted(FeatureManager.isEnabled(this.$feature));
            }
            {
                this.$callback = $captured_local_variable$0;
                this.$feature = $captured_local_variable$1;
            }
        });
    }

    @JvmStatic
    public static final boolean isEnabled(@NotNull Feature feature) {
        Intrinsics.checkNotNullParameter((Object)((Object)feature), (String)"feature");
        if (Feature.Unknown == feature) {
            return false;
        }
        if (Feature.Core == feature) {
            return true;
        }
        String version = FacebookSdk.getApplicationContext().getSharedPreferences(FEATURE_MANAGER_STORE, 0).getString(feature.toKey(), null);
        if (version != null && Intrinsics.areEqual((Object)version, (Object)FacebookSdk.getSdkVersion())) {
            return false;
        }
        Feature parent = feature.getParent();
        return parent == feature ? INSTANCE.getGKStatus(feature) : FeatureManager.isEnabled(parent) && INSTANCE.getGKStatus(feature);
    }

    @JvmStatic
    public static final void disableFeature(@NotNull Feature feature) {
        Intrinsics.checkNotNullParameter((Object)((Object)feature), (String)"feature");
        FacebookSdk.getApplicationContext().getSharedPreferences(FEATURE_MANAGER_STORE, 0).edit().putString(feature.toKey(), FacebookSdk.getSdkVersion()).apply();
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Feature getFeature(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        INSTANCE.initializeFeatureMapping();
        Object object = featureMapping;
        boolean bl = false;
        Iterator<Map.Entry<Feature, String[]>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            String[] value;
            Map.Entry<Feature, String[]> entry;
            Map.Entry<Feature, String[]> entry2 = entry = iterator.next();
            int n = 0;
            object = entry2.getKey();
            entry2 = entry;
            n = 0;
            for (String v : value = entry2.getValue()) {
                void key;
                if (!StringsKt.startsWith$default((String)className, (String)v, (boolean)false, (int)2, null)) continue;
                return key;
            }
        }
        return Feature.Unknown;
    }

    private final synchronized void initializeFeatureMapping() {
        if (!featureMapping.isEmpty()) {
            return;
        }
        featureMapping.put(Feature.AAM, new String[]{"com.facebook.appevents.aam."});
        featureMapping.put(Feature.CodelessEvents, new String[]{"com.facebook.appevents.codeless."});
        featureMapping.put(Feature.ErrorReport, new String[]{"com.facebook.internal.instrument.errorreport."});
        featureMapping.put(Feature.PrivacyProtection, new String[]{"com.facebook.appevents.ml."});
        featureMapping.put(Feature.SuggestedEvents, new String[]{"com.facebook.appevents.suggestedevents."});
        featureMapping.put(Feature.RestrictiveDataFiltering, new String[]{"com.facebook.appevents.restrictivedatafilter.RestrictiveDataManager"});
        featureMapping.put(Feature.IntelligentIntegrity, new String[]{"com.facebook.appevents.integrity.IntegrityManager"});
        featureMapping.put(Feature.EventDeactivation, new String[]{"com.facebook.appevents.eventdeactivation."});
        featureMapping.put(Feature.OnDeviceEventProcessing, new String[]{"com.facebook.appevents.ondeviceprocessing."});
        featureMapping.put(Feature.IapLogging, new String[]{"com.facebook.appevents.iap."});
        featureMapping.put(Feature.Monitoring, new String[]{"com.facebook.internal.logging.monitor"});
    }

    private final boolean getGKStatus(Feature feature) {
        boolean defaultStatus = this.defaultStatus(feature);
        return FetchedAppGateKeepersManager.getGateKeeperForKey(feature.toKey(), FacebookSdk.getApplicationId(), defaultStatus);
    }

    private final boolean defaultStatus(Feature feature) {
        boolean bl;
        switch (FeatureManager$WhenMappings.$EnumSwitchMapping$0[feature.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                bl = false;
                break;
            }
            default: {
                bl = true;
            }
        }
        return bl;
    }

    private FeatureManager() {
    }

    static {
        FeatureManager featureManager;
        INSTANCE = featureManager = new FeatureManager();
        boolean bl = false;
        featureMapping = new HashMap();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u001d\b\u0086\u0001\u0018\u0000 %2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001%B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\b\u001a\u00020\tJ\b\u0010\n\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b j\u0002\b!j\u0002\b\"j\u0002\b#j\u0002\b$\u00a8\u0006&"}, d2={"Lcom/facebook/internal/FeatureManager$Feature;", "", "code", "", "(Ljava/lang/String;II)V", "parent", "getParent", "()Lcom/facebook/internal/FeatureManager$Feature;", "toKey", "", "toString", "Unknown", "Core", "AppEvents", "CodelessEvents", "RestrictiveDataFiltering", "AAM", "PrivacyProtection", "SuggestedEvents", "IntelligentIntegrity", "ModelRequest", "EventDeactivation", "OnDeviceEventProcessing", "OnDevicePostInstallEventProcessing", "IapLogging", "IapLoggingLib2", "Instrument", "CrashReport", "CrashShield", "ThreadCheck", "ErrorReport", "Monitoring", "Login", "ChromeCustomTabsPrefetching", "IgnoreAppSwitchToLoggedOut", "Share", "Places", "Companion", "facebook-core_release"})
    public static final class Feature
    extends Enum<Feature> {
        public static final /* enum */ Feature Unknown;
        public static final /* enum */ Feature Core;
        public static final /* enum */ Feature AppEvents;
        public static final /* enum */ Feature CodelessEvents;
        public static final /* enum */ Feature RestrictiveDataFiltering;
        public static final /* enum */ Feature AAM;
        public static final /* enum */ Feature PrivacyProtection;
        public static final /* enum */ Feature SuggestedEvents;
        public static final /* enum */ Feature IntelligentIntegrity;
        public static final /* enum */ Feature ModelRequest;
        public static final /* enum */ Feature EventDeactivation;
        public static final /* enum */ Feature OnDeviceEventProcessing;
        public static final /* enum */ Feature OnDevicePostInstallEventProcessing;
        public static final /* enum */ Feature IapLogging;
        public static final /* enum */ Feature IapLoggingLib2;
        public static final /* enum */ Feature Instrument;
        public static final /* enum */ Feature CrashReport;
        public static final /* enum */ Feature CrashShield;
        public static final /* enum */ Feature ThreadCheck;
        public static final /* enum */ Feature ErrorReport;
        public static final /* enum */ Feature Monitoring;
        public static final /* enum */ Feature Login;
        public static final /* enum */ Feature ChromeCustomTabsPrefetching;
        public static final /* enum */ Feature IgnoreAppSwitchToLoggedOut;
        public static final /* enum */ Feature Share;
        public static final /* enum */ Feature Places;
        private static final /* synthetic */ Feature[] $VALUES;
        private final int code;
        public static final Companion Companion;

        static {
            Feature[] featureArray = new Feature[26];
            Feature[] featureArray2 = featureArray;
            featureArray[0] = Unknown = new Feature(-1);
            featureArray[1] = Core = new Feature(0);
            featureArray[2] = AppEvents = new Feature(65536);
            featureArray[3] = CodelessEvents = new Feature(65792);
            featureArray[4] = RestrictiveDataFiltering = new Feature(66048);
            featureArray[5] = AAM = new Feature(66304);
            featureArray[6] = PrivacyProtection = new Feature(66560);
            featureArray[7] = SuggestedEvents = new Feature(66561);
            featureArray[8] = IntelligentIntegrity = new Feature(66562);
            featureArray[9] = ModelRequest = new Feature(66563);
            featureArray[10] = EventDeactivation = new Feature(66816);
            featureArray[11] = OnDeviceEventProcessing = new Feature(67072);
            featureArray[12] = OnDevicePostInstallEventProcessing = new Feature(67073);
            featureArray[13] = IapLogging = new Feature(67328);
            featureArray[14] = IapLoggingLib2 = new Feature(67329);
            featureArray[15] = Instrument = new Feature(131072);
            featureArray[16] = CrashReport = new Feature(131328);
            featureArray[17] = CrashShield = new Feature(131329);
            featureArray[18] = ThreadCheck = new Feature(131330);
            featureArray[19] = ErrorReport = new Feature(131584);
            featureArray[20] = Monitoring = new Feature(196608);
            featureArray[21] = Login = new Feature(0x1000000);
            featureArray[22] = ChromeCustomTabsPrefetching = new Feature(0x1010000);
            featureArray[23] = IgnoreAppSwitchToLoggedOut = new Feature(0x1020000);
            featureArray[24] = Share = new Feature(0x2000000);
            featureArray[25] = Places = new Feature(0x3000000);
            $VALUES = featureArray;
            Companion = new Companion(null);
        }

        @NotNull
        public String toString() {
            String string;
            switch (FeatureManager$Feature$WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
                case 1: {
                    string = "CoreKit";
                    break;
                }
                case 2: {
                    string = "AppEvents";
                    break;
                }
                case 3: {
                    string = "CodelessEvents";
                    break;
                }
                case 4: {
                    string = "RestrictiveDataFiltering";
                    break;
                }
                case 5: {
                    string = "Instrument";
                    break;
                }
                case 6: {
                    string = "CrashReport";
                    break;
                }
                case 7: {
                    string = "CrashShield";
                    break;
                }
                case 8: {
                    string = "ThreadCheck";
                    break;
                }
                case 9: {
                    string = "ErrorReport";
                    break;
                }
                case 10: {
                    string = "AAM";
                    break;
                }
                case 11: {
                    string = "PrivacyProtection";
                    break;
                }
                case 12: {
                    string = "SuggestedEvents";
                    break;
                }
                case 13: {
                    string = "IntelligentIntegrity";
                    break;
                }
                case 14: {
                    string = "ModelRequest";
                    break;
                }
                case 15: {
                    string = "EventDeactivation";
                    break;
                }
                case 16: {
                    string = "OnDeviceEventProcessing";
                    break;
                }
                case 17: {
                    string = "OnDevicePostInstallEventProcessing";
                    break;
                }
                case 18: {
                    string = "IAPLogging";
                    break;
                }
                case 19: {
                    string = "IAPLoggingLib2";
                    break;
                }
                case 20: {
                    string = "Monitoring";
                    break;
                }
                case 21: {
                    string = "LoginKit";
                    break;
                }
                case 22: {
                    string = "ChromeCustomTabsPrefetching";
                    break;
                }
                case 23: {
                    string = "IgnoreAppSwitchToLoggedOut";
                    break;
                }
                case 24: {
                    string = "ShareKit";
                    break;
                }
                case 25: {
                    string = "PlacesKit";
                    break;
                }
                default: {
                    string = "unknown";
                }
            }
            return string;
        }

        @NotNull
        public final String toKey() {
            return "FBSDKFeature" + (Object)((Object)this);
        }

        @NotNull
        public final Feature getParent() {
            return (this.code & 0xFF) > 0 ? Companion.fromInt(this.code & 0xFFFFFF00) : ((this.code & 0xFF00) > 0 ? Companion.fromInt(this.code & 0xFFFF0000) : ((this.code & 0xFF0000) > 0 ? Companion.fromInt(this.code & 0xFF000000) : Companion.fromInt(0)));
        }

        private Feature(int code) {
            this.code = code;
        }

        public static Feature[] values() {
            return (Feature[])$VALUES.clone();
        }

        public static Feature valueOf(String string) {
            return Enum.valueOf(Feature.class, string);
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/facebook/internal/FeatureManager$Feature$Companion;", "", "()V", "fromInt", "Lcom/facebook/internal/FeatureManager$Feature;", "code", "", "facebook-core_release"})
        public static final class Companion {
            @NotNull
            public final Feature fromInt(int code) {
                for (Feature feature : Feature.values()) {
                    if (feature.code != code) continue;
                    return feature;
                }
                return Unknown;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/facebook/internal/FeatureManager$Callback;", "", "onCompleted", "", "enabled", "", "facebook-core_release"})
    public static interface Callback {
        public void onCompleted(boolean var1);
    }
}

