/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.bolts;

import com.facebook.bolts.AggregateException;
import com.facebook.bolts.AndroidExecutors;
import com.facebook.bolts.BoltsExecutors;
import com.facebook.bolts.CancellationToken;
import com.facebook.bolts.Capture;
import com.facebook.bolts.Continuation;
import com.facebook.bolts.ExecutorException;
import com.facebook.bolts.UnobservedErrorNotifier;
import com.facebook.bolts.UnobservedTaskException;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class Task<TResult> {
    public static final ExecutorService BACKGROUND_EXECUTOR = BoltsExecutors.background();
    private static final Executor IMMEDIATE_EXECUTOR = BoltsExecutors.immediate();
    public static final Executor UI_THREAD_EXECUTOR = AndroidExecutors.uiThread();
    private static volatile UnobservedExceptionHandler unobservedExceptionHandler;
    private final Object lock = new Object();
    private boolean complete;
    private boolean cancelled;
    private TResult result;
    private Exception error;
    private boolean errorHasBeenObserved;
    private UnobservedErrorNotifier unobservedErrorNotifier;
    private List<Continuation<TResult, Void>> continuations = new ArrayList<Continuation<TResult, Void>>();
    private static Task<?> TASK_NULL;
    private static Task<Boolean> TASK_TRUE;
    private static Task<Boolean> TASK_FALSE;
    private static Task<?> TASK_CANCELLED;

    public static UnobservedExceptionHandler getUnobservedExceptionHandler() {
        return unobservedExceptionHandler;
    }

    public static void setUnobservedExceptionHandler(UnobservedExceptionHandler eh) {
        unobservedExceptionHandler = eh;
    }

    Task() {
    }

    private Task(TResult result) {
        this.trySetResult(result);
    }

    private Task(boolean cancelled) {
        if (cancelled) {
            this.trySetCancelled();
        } else {
            this.trySetResult(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCompleted() {
        Object object = this.lock;
        synchronized (object) {
            return this.complete;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCancelled() {
        Object object = this.lock;
        synchronized (object) {
            return this.cancelled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFaulted() {
        Object object = this.lock;
        synchronized (object) {
            return this.getError() != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TResult getResult() {
        Object object = this.lock;
        synchronized (object) {
            return this.result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Exception getError() {
        Object object = this.lock;
        synchronized (object) {
            if (this.error != null) {
                this.errorHasBeenObserved = true;
                if (this.unobservedErrorNotifier != null) {
                    this.unobservedErrorNotifier.setObserved();
                    this.unobservedErrorNotifier = null;
                }
            }
            return this.error;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForCompletion() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isCompleted()) {
                this.lock.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForCompletion(long duration, TimeUnit timeUnit) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isCompleted()) {
                this.lock.wait(timeUnit.toMillis(duration));
            }
            return this.isCompleted();
        }
    }

    public static <TResult> Task<TResult> forResult(TResult value) {
        if (value == null) {
            return TASK_NULL;
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? TASK_TRUE : TASK_FALSE;
        }
        com.facebook.bolts.TaskCompletionSource<TResult> tcs = new com.facebook.bolts.TaskCompletionSource<TResult>();
        tcs.setResult(value);
        return tcs.getTask();
    }

    public static <TResult> Task<TResult> forError(Exception error) {
        com.facebook.bolts.TaskCompletionSource tcs = new com.facebook.bolts.TaskCompletionSource();
        tcs.setError(error);
        return tcs.getTask();
    }

    public static <TResult> Task<TResult> cancelled() {
        return TASK_CANCELLED;
    }

    public static Task<Void> delay(long delay) {
        return Task.delay(delay, BoltsExecutors.scheduled(), null);
    }

    public static Task<Void> delay(long delay, CancellationToken cancellationToken) {
        return Task.delay(delay, BoltsExecutors.scheduled(), cancellationToken);
    }

    static Task<Void> delay(long delay, ScheduledExecutorService executor, CancellationToken cancellationToken) {
        if (cancellationToken != null && cancellationToken.isCancellationRequested()) {
            return Task.cancelled();
        }
        if (delay <= 0L) {
            return Task.forResult(null);
        }
        final com.facebook.bolts.TaskCompletionSource tcs = new com.facebook.bolts.TaskCompletionSource();
        final ScheduledFuture<?> scheduled = executor.schedule(new Runnable(){

            @Override
            public void run() {
                if (CrashShieldHandler.isObjectCrashing(this)) {
                    return;
                }
                try {
                    tcs.trySetResult(null);
                    return;
                }
                catch (Throwable throwable) {
                    CrashShieldHandler.handleThrowable(throwable, this);
                    return;
                }
            }
        }, delay, TimeUnit.MILLISECONDS);
        if (cancellationToken != null) {
            cancellationToken.register(new Runnable(){

                @Override
                public void run() {
                    if (CrashShieldHandler.isObjectCrashing(this)) {
                        return;
                    }
                    try {
                        scheduled.cancel(true);
                        tcs.trySetCancelled();
                        return;
                    }
                    catch (Throwable throwable) {
                        CrashShieldHandler.handleThrowable(throwable, this);
                        return;
                    }
                }
            });
        }
        return tcs.getTask();
    }

    public <TOut> Task<TOut> cast() {
        Task task2 = this;
        return task2;
    }

    public Task<Void> makeVoid() {
        return this.continueWithTask(new Continuation<TResult, Task<Void>>(){

            @Override
            public Task<Void> then(Task<TResult> task2) throws Exception {
                if (task2.isCancelled()) {
                    return Task.cancelled();
                }
                if (task2.isFaulted()) {
                    return Task.forError(task2.getError());
                }
                return Task.forResult(null);
            }
        });
    }

    public static <TResult> Task<TResult> callInBackground(Callable<TResult> callable) {
        return Task.call(callable, BACKGROUND_EXECUTOR, null);
    }

    public static <TResult> Task<TResult> callInBackground(Callable<TResult> callable, CancellationToken ct) {
        return Task.call(callable, BACKGROUND_EXECUTOR, ct);
    }

    public static <TResult> Task<TResult> call(Callable<TResult> callable, Executor executor) {
        return Task.call(callable, executor, null);
    }

    public static <TResult> Task<TResult> call(final Callable<TResult> callable, Executor executor, final CancellationToken ct) {
        final com.facebook.bolts.TaskCompletionSource tcs = new com.facebook.bolts.TaskCompletionSource();
        try {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (CrashShieldHandler.isObjectCrashing(this)) {
                        return;
                    }
                    try {
                        if (ct != null && ct.isCancellationRequested()) {
                            tcs.setCancelled();
                            return;
                        }
                        try {
                            tcs.setResult(callable.call());
                        }
                        catch (CancellationException e) {
                            tcs.setCancelled();
                        }
                        catch (Exception e) {
                            tcs.setError(e);
                        }
                        return;
                    }
                    catch (Throwable throwable) {
                        CrashShieldHandler.handleThrowable(throwable, this);
                        return;
                    }
                }
            });
        }
        catch (Exception e) {
            tcs.setError(new ExecutorException(e));
        }
        return tcs.getTask();
    }

    public static <TResult> Task<TResult> call(Callable<TResult> callable) {
        return Task.call(callable, IMMEDIATE_EXECUTOR, null);
    }

    public static <TResult> Task<TResult> call(Callable<TResult> callable, CancellationToken ct) {
        return Task.call(callable, IMMEDIATE_EXECUTOR, ct);
    }

    public static <TResult> Task<Task<TResult>> whenAnyResult(Collection<? extends Task<TResult>> tasks) {
        if (tasks.size() == 0) {
            return Task.forResult(null);
        }
        final com.facebook.bolts.TaskCompletionSource firstCompleted = new com.facebook.bolts.TaskCompletionSource();
        final AtomicBoolean isAnyTaskComplete = new AtomicBoolean(false);
        for (Task<TResult> task2 : tasks) {
            task2.continueWith(new Continuation<TResult, Void>(){

                @Override
                public Void then(Task<TResult> task2) {
                    if (isAnyTaskComplete.compareAndSet(false, true)) {
                        firstCompleted.setResult(task2);
                    } else {
                        Exception exception = task2.getError();
                    }
                    return null;
                }
            });
        }
        return firstCompleted.getTask();
    }

    public static Task<Task<?>> whenAny(Collection<? extends Task<?>> tasks) {
        if (tasks.size() == 0) {
            return Task.forResult(null);
        }
        final com.facebook.bolts.TaskCompletionSource firstCompleted = new com.facebook.bolts.TaskCompletionSource();
        final AtomicBoolean isAnyTaskComplete = new AtomicBoolean(false);
        for (Task<?> task2 : tasks) {
            task2.continueWith(new Continuation<Object, Void>(){

                @Override
                public Void then(Task<Object> task2) {
                    if (isAnyTaskComplete.compareAndSet(false, true)) {
                        firstCompleted.setResult(task2);
                    } else {
                        Exception exception = task2.getError();
                    }
                    return null;
                }
            });
        }
        return firstCompleted.getTask();
    }

    public static <TResult> Task<List<TResult>> whenAllResult(final Collection<? extends Task<TResult>> tasks) {
        return Task.whenAll(tasks).onSuccess(new Continuation<Void, List<TResult>>(){

            @Override
            public List<TResult> then(Task<Void> task2) throws Exception {
                if (tasks.size() == 0) {
                    return Collections.emptyList();
                }
                ArrayList results = new ArrayList();
                for (Task individualTask : tasks) {
                    results.add(individualTask.getResult());
                }
                return results;
            }
        });
    }

    public static Task<Void> whenAll(Collection<? extends Task<?>> tasks) {
        if (tasks.size() == 0) {
            return Task.forResult(null);
        }
        final com.facebook.bolts.TaskCompletionSource allFinished = new com.facebook.bolts.TaskCompletionSource();
        final ArrayList causes = new ArrayList();
        final Object errorLock = new Object();
        final AtomicInteger count = new AtomicInteger(tasks.size());
        final AtomicBoolean isCancelled = new AtomicBoolean(false);
        Iterator<Task<?>> iterator = tasks.iterator();
        while (iterator.hasNext()) {
            Task<?> task2;
            Task<?> t = task2 = iterator.next();
            t.continueWith(new Continuation<Object, Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void then(Task<Object> task2) {
                    if (task2.isFaulted()) {
                        Object object = errorLock;
                        synchronized (object) {
                            causes.add(task2.getError());
                        }
                    }
                    if (task2.isCancelled()) {
                        isCancelled.set(true);
                    }
                    if (count.decrementAndGet() == 0) {
                        if (causes.size() != 0) {
                            if (causes.size() == 1) {
                                allFinished.setError((Exception)causes.get(0));
                            } else {
                                AggregateException error = new AggregateException(String.format("There were %d exceptions.", causes.size()), causes);
                                allFinished.setError(error);
                            }
                        } else if (isCancelled.get()) {
                            allFinished.setCancelled();
                        } else {
                            allFinished.setResult(null);
                        }
                    }
                    return null;
                }
            });
        }
        return allFinished.getTask();
    }

    public Task<Void> continueWhile(Callable<Boolean> predicate, Continuation<Void, Task<Void>> continuation) {
        return this.continueWhile(predicate, continuation, IMMEDIATE_EXECUTOR, null);
    }

    public Task<Void> continueWhile(Callable<Boolean> predicate, Continuation<Void, Task<Void>> continuation, CancellationToken ct) {
        return this.continueWhile(predicate, continuation, IMMEDIATE_EXECUTOR, ct);
    }

    public Task<Void> continueWhile(Callable<Boolean> predicate, Continuation<Void, Task<Void>> continuation, Executor executor) {
        return this.continueWhile(predicate, continuation, executor, null);
    }

    public Task<Void> continueWhile(final Callable<Boolean> predicate, final Continuation<Void, Task<Void>> continuation, final Executor executor, final CancellationToken ct) {
        final Capture<9> predicateContinuation = new Capture<9>();
        predicateContinuation.set(new Continuation<Void, Task<Void>>(){

            @Override
            public Task<Void> then(Task<Void> task2) throws Exception {
                if (ct != null && ct.isCancellationRequested()) {
                    return Task.cancelled();
                }
                if (((Boolean)predicate.call()).booleanValue()) {
                    return Task.forResult(null).onSuccessTask(continuation, executor).onSuccessTask((Continuation)predicateContinuation.get(), executor);
                }
                return Task.forResult(null);
            }
        });
        return this.makeVoid().continueWithTask((Continuation)predicateContinuation.get(), executor);
    }

    public <TContinuationResult> Task<TContinuationResult> continueWith(Continuation<TResult, TContinuationResult> continuation, Executor executor) {
        return this.continueWith(continuation, executor, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <TContinuationResult> Task<TContinuationResult> continueWith(final Continuation<TResult, TContinuationResult> continuation, final Executor executor, final CancellationToken ct) {
        boolean completed;
        final com.facebook.bolts.TaskCompletionSource tcs = new com.facebook.bolts.TaskCompletionSource();
        Object object = this.lock;
        synchronized (object) {
            completed = this.isCompleted();
            if (!completed) {
                this.continuations.add(new Continuation<TResult, Void>(){

                    @Override
                    public Void then(Task<TResult> task2) {
                        Task.completeImmediately(tcs, continuation, task2, executor, ct);
                        return null;
                    }
                });
            }
        }
        if (completed) {
            Task.completeImmediately(tcs, continuation, this, executor, ct);
        }
        return tcs.getTask();
    }

    public <TContinuationResult> Task<TContinuationResult> continueWith(Continuation<TResult, TContinuationResult> continuation) {
        return this.continueWith(continuation, IMMEDIATE_EXECUTOR, null);
    }

    public <TContinuationResult> Task<TContinuationResult> continueWith(Continuation<TResult, TContinuationResult> continuation, CancellationToken ct) {
        return this.continueWith(continuation, IMMEDIATE_EXECUTOR, ct);
    }

    public <TContinuationResult> Task<TContinuationResult> continueWithTask(Continuation<TResult, Task<TContinuationResult>> continuation, Executor executor) {
        return this.continueWithTask(continuation, executor, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <TContinuationResult> Task<TContinuationResult> continueWithTask(final Continuation<TResult, Task<TContinuationResult>> continuation, final Executor executor, final CancellationToken ct) {
        boolean completed;
        final com.facebook.bolts.TaskCompletionSource tcs = new com.facebook.bolts.TaskCompletionSource();
        Object object = this.lock;
        synchronized (object) {
            completed = this.isCompleted();
            if (!completed) {
                this.continuations.add(new Continuation<TResult, Void>(){

                    @Override
                    public Void then(Task<TResult> task2) {
                        Task.completeAfterTask(tcs, continuation, task2, executor, ct);
                        return null;
                    }
                });
            }
        }
        if (completed) {
            Task.completeAfterTask(tcs, continuation, this, executor, ct);
        }
        return tcs.getTask();
    }

    public <TContinuationResult> Task<TContinuationResult> continueWithTask(Continuation<TResult, Task<TContinuationResult>> continuation) {
        return this.continueWithTask(continuation, IMMEDIATE_EXECUTOR, null);
    }

    public <TContinuationResult> Task<TContinuationResult> continueWithTask(Continuation<TResult, Task<TContinuationResult>> continuation, CancellationToken ct) {
        return this.continueWithTask(continuation, IMMEDIATE_EXECUTOR, ct);
    }

    public <TContinuationResult> Task<TContinuationResult> onSuccess(Continuation<TResult, TContinuationResult> continuation, Executor executor) {
        return this.onSuccess(continuation, executor, null);
    }

    public <TContinuationResult> Task<TContinuationResult> onSuccess(final Continuation<TResult, TContinuationResult> continuation, Executor executor, final CancellationToken ct) {
        return this.continueWithTask(new Continuation<TResult, Task<TContinuationResult>>(){

            @Override
            public Task<TContinuationResult> then(Task<TResult> task2) {
                if (ct != null && ct.isCancellationRequested()) {
                    return Task.cancelled();
                }
                if (task2.isFaulted()) {
                    return Task.forError(task2.getError());
                }
                if (task2.isCancelled()) {
                    return Task.cancelled();
                }
                return task2.continueWith(continuation);
            }
        }, executor);
    }

    public <TContinuationResult> Task<TContinuationResult> onSuccess(Continuation<TResult, TContinuationResult> continuation) {
        return this.onSuccess(continuation, IMMEDIATE_EXECUTOR, null);
    }

    public <TContinuationResult> Task<TContinuationResult> onSuccess(Continuation<TResult, TContinuationResult> continuation, CancellationToken ct) {
        return this.onSuccess(continuation, IMMEDIATE_EXECUTOR, ct);
    }

    public <TContinuationResult> Task<TContinuationResult> onSuccessTask(Continuation<TResult, Task<TContinuationResult>> continuation, Executor executor) {
        return this.onSuccessTask(continuation, executor, null);
    }

    public <TContinuationResult> Task<TContinuationResult> onSuccessTask(final Continuation<TResult, Task<TContinuationResult>> continuation, Executor executor, final CancellationToken ct) {
        return this.continueWithTask(new Continuation<TResult, Task<TContinuationResult>>(){

            @Override
            public Task<TContinuationResult> then(Task<TResult> task2) {
                if (ct != null && ct.isCancellationRequested()) {
                    return Task.cancelled();
                }
                if (task2.isFaulted()) {
                    return Task.forError(task2.getError());
                }
                if (task2.isCancelled()) {
                    return Task.cancelled();
                }
                return task2.continueWithTask(continuation);
            }
        }, executor);
    }

    public <TContinuationResult> Task<TContinuationResult> onSuccessTask(Continuation<TResult, Task<TContinuationResult>> continuation) {
        return this.onSuccessTask(continuation, IMMEDIATE_EXECUTOR);
    }

    public <TContinuationResult> Task<TContinuationResult> onSuccessTask(Continuation<TResult, Task<TContinuationResult>> continuation, CancellationToken ct) {
        return this.onSuccessTask(continuation, IMMEDIATE_EXECUTOR, ct);
    }

    private static <TContinuationResult, TResult> void completeImmediately(final com.facebook.bolts.TaskCompletionSource<TContinuationResult> tcs, final Continuation<TResult, TContinuationResult> continuation, final Task<TResult> task2, Executor executor, final CancellationToken ct) {
        try {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (CrashShieldHandler.isObjectCrashing(this)) {
                        return;
                    }
                    try {
                        if (ct != null && ct.isCancellationRequested()) {
                            tcs.setCancelled();
                            return;
                        }
                        try {
                            Object result = continuation.then(task2);
                            tcs.setResult(result);
                        }
                        catch (CancellationException e) {
                            tcs.setCancelled();
                        }
                        catch (Exception e) {
                            tcs.setError(e);
                        }
                        return;
                    }
                    catch (Throwable throwable) {
                        CrashShieldHandler.handleThrowable(throwable, this);
                        return;
                    }
                }
            });
        }
        catch (Exception e) {
            tcs.setError(new ExecutorException(e));
        }
    }

    private static <TContinuationResult, TResult> void completeAfterTask(final com.facebook.bolts.TaskCompletionSource<TContinuationResult> tcs, final Continuation<TResult, Task<TContinuationResult>> continuation, final Task<TResult> task2, Executor executor, final CancellationToken ct) {
        try {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (CrashShieldHandler.isObjectCrashing(this)) {
                        return;
                    }
                    try {
                        if (ct != null && ct.isCancellationRequested()) {
                            tcs.setCancelled();
                            return;
                        }
                        try {
                            Task result = (Task)continuation.then(task2);
                            if (result == null) {
                                tcs.setResult(null);
                            } else {
                                result.continueWith(new Continuation<TContinuationResult, Void>(){

                                    @Override
                                    public Void then(Task<TContinuationResult> task2) {
                                        if (ct != null && ct.isCancellationRequested()) {
                                            tcs.setCancelled();
                                            return null;
                                        }
                                        if (task2.isCancelled()) {
                                            tcs.setCancelled();
                                        } else if (task2.isFaulted()) {
                                            tcs.setError(task2.getError());
                                        } else {
                                            tcs.setResult(task2.getResult());
                                        }
                                        return null;
                                    }
                                });
                            }
                        }
                        catch (CancellationException e) {
                            tcs.setCancelled();
                        }
                        catch (Exception e) {
                            tcs.setError(e);
                        }
                        return;
                    }
                    catch (Throwable throwable) {
                        CrashShieldHandler.handleThrowable(throwable, this);
                        return;
                    }
                }
            });
        }
        catch (Exception e) {
            tcs.setError(new ExecutorException(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runContinuations() {
        Object object = this.lock;
        synchronized (object) {
            for (Continuation<TResult, Void> continuation : this.continuations) {
                try {
                    continuation.then(this);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            this.continuations = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean trySetCancelled() {
        Object object = this.lock;
        synchronized (object) {
            if (this.complete) {
                return false;
            }
            this.complete = true;
            this.cancelled = true;
            this.lock.notifyAll();
            this.runContinuations();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean trySetResult(TResult result) {
        Object object = this.lock;
        synchronized (object) {
            if (this.complete) {
                return false;
            }
            this.complete = true;
            this.result = result;
            this.lock.notifyAll();
            this.runContinuations();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean trySetError(Exception error) {
        Object object = this.lock;
        synchronized (object) {
            if (this.complete) {
                return false;
            }
            this.complete = true;
            this.error = error;
            this.errorHasBeenObserved = false;
            this.lock.notifyAll();
            this.runContinuations();
            if (!this.errorHasBeenObserved && Task.getUnobservedExceptionHandler() != null) {
                this.unobservedErrorNotifier = new UnobservedErrorNotifier(this);
            }
            return true;
        }
    }

    static {
        TASK_NULL = new Task<Object>(null);
        TASK_TRUE = new Task<Boolean>(Boolean.valueOf(true));
        TASK_FALSE = new Task<Boolean>(Boolean.valueOf(false));
        TASK_CANCELLED = new Task(true);
    }

    public class TaskCompletionSource
    extends com.facebook.bolts.TaskCompletionSource<TResult> {
        TaskCompletionSource() {
        }
    }

    public static interface UnobservedExceptionHandler {
        public void unobservedException(Task<?> var1, UnobservedTaskException var2);
    }
}

