/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.ml;

import android.content.Context;
import android.text.TextUtils;
import com.facebook.FacebookSdk;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/facebook/appevents/ml/Utils;", "", "()V", "DIR_NAME", "", "getMlDir", "Ljava/io/File;", "normalizeString", "str", "vectorize", "", "texts", "maxLen", "", "facebook-core_release"})
public final class Utils {
    private static final String DIR_NAME = "facebook_ml/";
    public static final Utils INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final int[] vectorize(@NotNull String string, int n) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return null;
        }
        try {
            String normalizedStr;
            void maxLen;
            void texts;
            Intrinsics.checkNotNullParameter((Object)texts, (String)"texts");
            int[] ret = new int[maxLen];
            String string2 = normalizedStr = this.normalizeString((String)texts);
            Charset charset = Charset.forName("UTF-8");
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"Charset.forName(\"UTF-8\")");
            Charset charset2 = charset;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string3.getBytes(charset2);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] strBytes = byArray;
            boolean bl2 = false;
            void var7_8 = maxLen;
            while (bl2 < var7_8) {
                void i;
                ret[i] = i < strBytes.length ? strBytes[i] & 0xFF : 0;
                ++i;
            }
            return ret;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String normalizeString(@NotNull String string) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return null;
        }
        try {
            void str;
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            void $this$trim$iv = str;
            boolean $i$f$trim22 = false;
            CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
            int $i$f$trim = 0;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            String trim = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            CharSequence $i$f$trim22 = trim;
            $this$trim$iv$iv = "\\s+";
            $i$f$trim = 0;
            $this$trim$iv$iv = new Regex((String)$this$trim$iv$iv);
            $i$f$trim = 0;
            boolean bl = false;
            Collection $this$toTypedArray$iv = $this$trim$iv$iv.split($i$f$trim22, $i$f$trim);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Object[] objectArray = thisCollection$iv.toArray(new String[0]);
            if (objectArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Object[] strArray = objectArray;
            String string2 = TextUtils.join((CharSequence)" ", (Object[])strArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TextUtils.join(\" \", strArray)");
            return string2;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return null;
        }
    }

    @JvmStatic
    @Nullable
    public static final File getMlDir() {
        if (CrashShieldHandler.isObjectCrashing(Utils.class)) {
            return null;
        }
        try {
            Context context = FacebookSdk.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"FacebookSdk.getApplicationContext()");
            File dir = new File(context.getFilesDir(), DIR_NAME);
            return dir.exists() || dir.mkdirs() ? dir : null;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Utils.class);
            return null;
        }
    }

    private Utils() {
    }

    static {
        Utils utils;
        INSTANCE = utils = new Utils();
    }
}

