/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.internal;

import android.content.Context;
import android.content.pm.PackageManager;
import android.util.Log;
import androidx.annotation.VisibleForTesting;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u000b\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\u0006H\u0007J!\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0007\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/facebook/appevents/internal/HashUtils;", "", "()V", "BUFFER_SIZE", "", "MD5", "", "TAG", "checksumArrayToString", "checksum", "", "computeChecksum", "path", "computeChecksumWithPackageManager", "context", "Landroid/content/Context;", "nanosTimeout", "", "(Landroid/content/Context;Ljava/lang/Long;)Ljava/lang/String;", "computeFileMd5", "file", "Ljava/io/File;", "facebook-core_release"})
@VisibleForTesting(otherwise=3)
public final class HashUtils {
    private static final String MD5 = "MD5";
    private static final int BUFFER_SIZE = 1024;
    private static final String TAG;
    public static final HashUtils INSTANCE;

    @JvmStatic
    @NotNull
    public static final String computeChecksum(@Nullable String path) throws Exception {
        return INSTANCE.computeFileMd5(new File(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String computeFileMd5(File file) throws Exception {
        Closeable closeable = new BufferedInputStream(new FileInputStream(file), 1024);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            BufferedInputStream fis = (BufferedInputStream)closeable;
            boolean bl3 = false;
            MessageDigest md = MessageDigest.getInstance(MD5);
            byte[] buffer = new byte[1024];
            int numRead = 0;
            do {
                if ((numRead = fis.read(buffer)) <= 0) continue;
                md.update(buffer, 0, numRead);
            } while (numRead != -1);
            String string = new BigInteger(1, md.digest()).toString(16);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"BigInteger(1, md.digest()).toString(16)");
            String string2 = string;
            return string2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final String computeChecksumWithPackageManager(@NotNull Context context, @Nullable Long nanosTimeout) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        ReentrantLock lock = new ReentrantLock();
        Condition checksumReady = lock.newCondition();
        lock.lock();
        try {
            void resultChecksum;
            Class<?> clazz = Class.forName("android.content.pm.Checksum");
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"Class.forName(\"android.content.pm.Checksum\")");
            Class<?> checksumClass = clazz;
            Field field = checksumClass.getField("TYPE_WHOLE_MD5");
            Intrinsics.checkNotNullExpressionValue((Object)field, (String)"checksumClass.getField(\"TYPE_WHOLE_MD5\")");
            Field typeWholeMd5Field = field;
            Object TYPE_WHOLE_MD5 = typeWholeMd5Field.get(null);
            Field field2 = PackageManager.class.getField("TRUST_ALL");
            Intrinsics.checkNotNullExpressionValue((Object)field2, (String)"PackageManager::class.java.getField(\"TRUST_ALL\")");
            Field trustAllField = field2;
            Class<?> clazz2 = Class.forName("android.content.pm.PackageManager$OnChecksumsReadyListener");
            Intrinsics.checkNotNullExpressionValue(clazz2, (String)"Class.forName(\"android.c\u2026nChecksumsReadyListener\")");
            Class<?> checksumReadyListenerClass = clazz2;
            Object object = Proxy.newProxyInstance(HashUtils.class.getClassLoader(), new Class[]{checksumReadyListenerClass}, new InvocationHandler(TYPE_WHOLE_MD5, (Ref.ObjectRef)resultChecksum, lock, checksumReady){
                final /* synthetic */ Object $TYPE_WHOLE_MD5;
                final /* synthetic */ Ref.ObjectRef $resultChecksum;
                final /* synthetic */ ReentrantLock $lock;
                final /* synthetic */ Condition $checksumReady;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Nullable
                public Object invoke(@Nullable Object o, @NotNull Method method, @NotNull Object[] objects) {
                    block8: {
                        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
                        try {
                            if (!Intrinsics.areEqual((Object)method.getName(), (Object)"onChecksumsReady") || objects.length != 1 || !(objects[0] instanceof List)) break block8;
                            Object object = objects[0];
                            if (object == null) {
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<*>");
                            }
                            List list = (List)object;
                            for (E c : list) {
                                Method getTypeMethod;
                                Method getSplitNameMethod;
                                if (c == null) continue;
                                Intrinsics.checkNotNullExpressionValue((Object)c.getClass().getMethod("getSplitName", new Class[0]), (String)"c.javaClass.getMethod(\"getSplitName\")");
                                Intrinsics.checkNotNullExpressionValue((Object)c.getClass().getMethod("getType", new Class[0]), (String)"c.javaClass.getMethod(\"getType\")");
                                if (getSplitNameMethod.invoke(c, new Object[0]) != null || !Intrinsics.areEqual((Object)getTypeMethod.invoke(c, new Object[0]), (Object)this.$TYPE_WHOLE_MD5)) continue;
                                Method method2 = c.getClass().getMethod("getValue", new Class[0]);
                                Intrinsics.checkNotNullExpressionValue((Object)method2, (String)"c.javaClass.getMethod(\"getValue\")");
                                Method getValueMethod = method2;
                                Object object2 = getValueMethod.invoke(c, new Object[0]);
                                if (object2 == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.ByteArray");
                                }
                                byte[] checksumValue = (byte[])object2;
                                this.$resultChecksum.element = HashUtils.access$checksumArrayToString(HashUtils.INSTANCE, checksumValue);
                                this.$lock.lock();
                                try {
                                    this.$checksumReady.signalAll();
                                }
                                finally {
                                    this.$lock.unlock();
                                }
                                return null;
                            }
                        }
                        catch (Throwable t) {
                            Log.d((String)HashUtils.access$getTAG$p(HashUtils.INSTANCE), (String)"Can't fetch checksum.", (Throwable)t);
                        }
                    }
                    return null;
                }
                {
                    this.$TYPE_WHOLE_MD5 = $captured_local_variable$0;
                    this.$resultChecksum = $captured_local_variable$1;
                    this.$lock = $captured_local_variable$2;
                    this.$checksumReady = $captured_local_variable$3;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Proxy.newProxyInstance(\n\u2026       }\n              })");
            Object listener2 = object;
            Method method = PackageManager.class.getMethod("requestChecksums", String.class, Boolean.TYPE, Integer.TYPE, List.class, checksumReadyListenerClass);
            Intrinsics.checkNotNullExpressionValue((Object)method, (String)"PackageManager::class.ja\u2026ecksumReadyListenerClass)");
            Method requestChecksumsMethod = method;
            requestChecksumsMethod.invoke((Object)context.getPackageManager(), context.getPackageName(), false, TYPE_WHOLE_MD5, trustAllField.get(null), listener2);
            if (nanosTimeout == null) {
                checksumReady.await();
            } else {
                checksumReady.awaitNanos(nanosTimeout);
            }
            String string = (String)resultChecksum.element;
            return string;
        }
        catch (Throwable t) {
            String string = null;
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    private final String checksumArrayToString(byte[] checksum) {
        StringBuilder builder = new StringBuilder();
        byte[] $this$forEach$iv = checksum;
        boolean $i$f$forEach = false;
        byte[] byArray = $this$forEach$iv;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            int unsignedByte;
            int element$iv;
            int it = element$iv = byArray[i];
            boolean bl = false;
            int n2 = unsignedByte = it >= 0 ? it : 256 + it;
            if (unsignedByte < 16) {
                builder.append('0');
            }
            int n3 = unsignedByte;
            int n4 = 16;
            boolean bl2 = false;
            String string = Integer.toString(n3, CharsKt.checkRadix((int)n4));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.Integer.toStri\u2026(this, checkRadix(radix))");
            builder.append(string);
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    private HashUtils() {
    }

    static {
        HashUtils hashUtils;
        INSTANCE = hashUtils = new HashUtils();
        String string = HashUtils.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"HashUtils::class.java.simpleName");
        TAG = string;
    }

    public static final /* synthetic */ String access$checksumArrayToString(HashUtils $this, byte[] checksum) {
        return $this.checksumArrayToString(checksum);
    }

    public static final /* synthetic */ String access$getTAG$p(HashUtils $this) {
        HashUtils hashUtils = $this;
        return TAG;
    }
}

