/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.internal;

import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Looper;
import android.view.View;
import android.view.Window;
import com.facebook.FacebookSdk;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0007J\b\u0010\n\u001a\u00020\tH\u0007J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0007J\b\u0010\u000e\u001a\u00020\u0004H\u0007J\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0007J\b\u0010\u0013\u001a\u00020\u0006H\u0007J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068CX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lcom/facebook/appevents/internal/AppEventUtility;", "", "()V", "PRICE_REGEX", "", "isMainThread", "", "()Z", "assertIsMainThread", "", "assertIsNotMainThread", "bytesToHex", "bytes", "", "getAppVersion", "getRootView", "Landroid/view/View;", "activity", "Landroid/app/Activity;", "isEmulator", "normalizePrice", "", "value", "facebook-core_release"})
public final class AppEventUtility {
    private static final String PRICE_REGEX = "[-+]*\\d+([.,]\\d+)*([.,]\\d+)?";
    public static final AppEventUtility INSTANCE;

    @JvmStatic
    public static final void assertIsNotMainThread() {
    }

    @JvmStatic
    public static final void assertIsMainThread() {
    }

    @JvmStatic
    public static final double normalizePrice(@Nullable String value) {
        double d;
        try {
            double d2;
            Pattern pattern = Pattern.compile(PRICE_REGEX, 8);
            Matcher matcher = pattern.matcher(value);
            if (matcher.find()) {
                String firstValue = matcher.group(0);
                d2 = NumberFormat.getNumberInstance(Utility.getCurrentLocale()).parse(firstValue).doubleValue();
            } else {
                d2 = 0.0;
            }
            d = d2;
        }
        catch (ParseException e) {
            d = 0.0;
        }
        return d;
    }

    @JvmStatic
    @NotNull
    public static final String bytesToHex(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        StringBuffer sb = new StringBuffer();
        for (byte b : bytes) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "%02x";
            Object[] objectArray = new Object[]{b};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            sb.append(string2);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean isEmulator() {
        String string = Build.FINGERPRINT;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Build.FINGERPRINT");
        if (StringsKt.startsWith$default((String)string, (String)"generic", (boolean)false, (int)2, null)) return true;
        String string2 = Build.FINGERPRINT;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"Build.FINGERPRINT");
        if (StringsKt.startsWith$default((String)string2, (String)"unknown", (boolean)false, (int)2, null)) return true;
        String string3 = Build.MODEL;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"Build.MODEL");
        if (StringsKt.contains$default((CharSequence)string3, (CharSequence)"google_sdk", (boolean)false, (int)2, null)) return true;
        String string4 = Build.MODEL;
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"Build.MODEL");
        if (StringsKt.contains$default((CharSequence)string4, (CharSequence)"Emulator", (boolean)false, (int)2, null)) return true;
        String string5 = Build.MODEL;
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"Build.MODEL");
        if (StringsKt.contains$default((CharSequence)string5, (CharSequence)"Android SDK built for x86", (boolean)false, (int)2, null)) return true;
        String string6 = Build.MANUFACTURER;
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"Build.MANUFACTURER");
        if (StringsKt.contains$default((CharSequence)string6, (CharSequence)"Genymotion", (boolean)false, (int)2, null)) return true;
        String string7 = Build.BRAND;
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"Build.BRAND");
        if (StringsKt.startsWith$default((String)string7, (String)"generic", (boolean)false, (int)2, null)) {
            String string8 = Build.DEVICE;
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"Build.DEVICE");
            if (StringsKt.startsWith$default((String)string8, (String)"generic", (boolean)false, (int)2, null)) return true;
        }
        if (!Intrinsics.areEqual((Object)"google_sdk", (Object)Build.PRODUCT)) return false;
        return true;
    }

    @JvmStatic
    private static final boolean isMainThread() {
        return Intrinsics.areEqual((Object)Looper.myLooper(), (Object)Looper.getMainLooper());
    }

    @JvmStatic
    @NotNull
    public static final String getAppVersion() {
        String string;
        Context context = FacebookSdk.getApplicationContext();
        try {
            Context context2 = context;
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
            PackageInfo packageInfo = context2.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            String string2 = packageInfo.versionName;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"packageInfo.versionName");
            string = string2;
        }
        catch (PackageManager.NameNotFoundException e) {
            string = "";
        }
        return string;
    }

    @JvmStatic
    @Nullable
    public static final View getRootView(@Nullable Activity activity) {
        if (CrashShieldHandler.isObjectCrashing(AppEventUtility.class)) {
            return null;
        }
        try {
            View view;
            try {
                Activity activity2;
                if (activity2 == null) {
                    return null;
                }
                Window window = activity2.getWindow();
                if (window == null) {
                    return null;
                }
                Window window2 = window;
                View view2 = window2.getDecorView();
                Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"window.decorView");
                view = view2.getRootView();
            }
            catch (Exception e) {
                view = null;
            }
            return view;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventUtility.class);
            return null;
        }
    }

    private AppEventUtility() {
    }

    static {
        AppEventUtility appEventUtility;
        INSTANCE = appEventUtility = new AppEventUtility();
    }
}

