/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.eventdeactivation;

import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.facebook.FacebookSdk;
import com.facebook.appevents.AppEvent;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0007J\b\u0010\r\u001a\u00020\fH\u0002J&\u0010\u000e\u001a\u00020\f2\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00102\u0006\u0010\u0011\u001a\u00020\u0005H\u0007J\u0016\u0010\u0012\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0007H\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/facebook/appevents/eventdeactivation/EventDeactivationManager;", "", "()V", "deprecatedEvents", "", "", "deprecatedParamFilters", "", "Lcom/facebook/appevents/eventdeactivation/EventDeactivationManager$DeprecatedParamFilter;", "enabled", "", "enable", "", "initialize", "processDeprecatedParameters", "parameters", "", "eventName", "processEvents", "events", "Lcom/facebook/appevents/AppEvent;", "DeprecatedParamFilter", "facebook-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class EventDeactivationManager {
    private static boolean enabled;
    private static final List<DeprecatedParamFilter> deprecatedParamFilters;
    private static final Set<String> deprecatedEvents;
    public static final EventDeactivationManager INSTANCE;

    @JvmStatic
    public static final void enable() {
        if (CrashShieldHandler.isObjectCrashing(EventDeactivationManager.class)) {
            return;
        }
        try {
            enabled = true;
            INSTANCE.initialize();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, EventDeactivationManager.class);
            return;
        }
    }

    private final synchronized void initialize() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            try {
                String string = FacebookSdk.getApplicationId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FacebookSdk.getApplicationId()");
                FetchedAppSettings fetchedAppSettings = FetchedAppSettingsManager.queryAppSettings(string, false);
                if (fetchedAppSettings == null) {
                    return;
                }
                FetchedAppSettings settings = fetchedAppSettings;
                String eventFilterResponse = settings.getRestrictiveDataSetting();
                if (eventFilterResponse != null) {
                    CharSequence charSequence = eventFilterResponse;
                    boolean bl = false;
                    if (charSequence.length() > 0) {
                        JSONObject jsonObject = new JSONObject(eventFilterResponse);
                        deprecatedParamFilters.clear();
                        Iterator keys = jsonObject.keys();
                        while (keys.hasNext()) {
                            String key = (String)keys.next();
                            JSONObject json = jsonObject.getJSONObject(key);
                            if (json == null) continue;
                            if (json.optBoolean("is_deprecated_event")) {
                                String string2 = key;
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"key");
                                deprecatedEvents.add(string2);
                                continue;
                            }
                            JSONArray deprecatedParamJsonArray = json.optJSONArray("deprecated_param");
                            String string3 = key;
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"key");
                            DeprecatedParamFilter deprecatedParamFilter = new DeprecatedParamFilter(string3, new ArrayList());
                            if (deprecatedParamJsonArray != null) {
                                deprecatedParamFilter.setDeprecateParams(Utility.convertJSONArrayToList(deprecatedParamJsonArray));
                            }
                            deprecatedParamFilters.add(deprecatedParamFilter);
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    @JvmStatic
    public static final void processEvents(@NotNull List<AppEvent> list) {
        if (CrashShieldHandler.isObjectCrashing(EventDeactivationManager.class)) {
            return;
        }
        try {
            List<AppEvent> events;
            Intrinsics.checkNotNullParameter(events, (String)"events");
            if (!enabled) {
                return;
            }
            Iterator<AppEvent> iterator = events.iterator();
            while (iterator.hasNext()) {
                AppEvent event = iterator.next();
                if (!deprecatedEvents.contains(event.getName())) continue;
                iterator.remove();
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, EventDeactivationManager.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void processDeprecatedParameters(@NotNull Map<String, String> map, @NotNull String string) {
        if (CrashShieldHandler.isObjectCrashing(EventDeactivationManager.class)) {
            return;
        }
        try {
            void eventName;
            Map<String, String> parameters;
            Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
            Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
            if (!enabled) {
                return;
            }
            List keys = new ArrayList(parameters.keySet());
            List deprecatedParamFiltersCopy = new ArrayList(deprecatedParamFilters);
            for (DeprecatedParamFilter filter : deprecatedParamFiltersCopy) {
                if (Intrinsics.areEqual((Object)filter.getEventName(), (Object)eventName) ^ true) continue;
                for (String key : keys) {
                    if (!filter.getDeprecateParams().contains(key)) continue;
                    parameters.remove(key);
                }
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, EventDeactivationManager.class);
            return;
        }
    }

    private EventDeactivationManager() {
    }

    static {
        EventDeactivationManager eventDeactivationManager;
        INSTANCE = eventDeactivationManager = new EventDeactivationManager();
        deprecatedParamFilters = new ArrayList();
        deprecatedEvents = new HashSet();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\n\b\u0007\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/facebook/appevents/eventdeactivation/EventDeactivationManager$DeprecatedParamFilter;", "", "eventName", "", "deprecateParams", "", "(Ljava/lang/String;Ljava/util/List;)V", "getDeprecateParams", "()Ljava/util/List;", "setDeprecateParams", "(Ljava/util/List;)V", "getEventName", "()Ljava/lang/String;", "setEventName", "(Ljava/lang/String;)V", "facebook-core_release"})
    @VisibleForTesting(otherwise=3)
    public static final class DeprecatedParamFilter {
        @NotNull
        private String eventName;
        @NotNull
        private List<String> deprecateParams;

        @NotNull
        public final String getEventName() {
            return this.eventName;
        }

        public final void setEventName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.eventName = string;
        }

        @NotNull
        public final List<String> getDeprecateParams() {
            return this.deprecateParams;
        }

        public final void setDeprecateParams(@NotNull List<String> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.deprecateParams = list;
        }

        public DeprecatedParamFilter(@NotNull String eventName, @NotNull List<String> deprecateParams) {
            Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
            Intrinsics.checkNotNullParameter(deprecateParams, (String)"deprecateParams");
            this.eventName = eventName;
            this.deprecateParams = deprecateParams;
        }
    }
}

