/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents;

import androidx.annotation.RestrictTo;
import com.facebook.appevents.aam.MetadataIndexer;
import com.facebook.appevents.eventdeactivation.EventDeactivationManager;
import com.facebook.appevents.iap.InAppPurchaseManager;
import com.facebook.appevents.ml.ModelManager;
import com.facebook.appevents.restrictivedatafilter.RestrictiveDataManager;
import com.facebook.internal.FeatureManager;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class AppEventsManager {
    public static void start() {
        if (CrashShieldHandler.isObjectCrashing(AppEventsManager.class)) {
            return;
        }
        try {
            FetchedAppSettingsManager.getAppSettingsAsync(new FetchedAppSettingsManager.FetchedAppSettingsCallback(){

                @Override
                public void onSuccess(FetchedAppSettings fetchedAppSettings) {
                    FeatureManager.checkFeature(FeatureManager.Feature.AAM, new FeatureManager.Callback(){

                        @Override
                        public void onCompleted(boolean enabled) {
                            if (enabled) {
                                MetadataIndexer.enable();
                            }
                        }
                    });
                    FeatureManager.checkFeature(FeatureManager.Feature.RestrictiveDataFiltering, new FeatureManager.Callback(){

                        @Override
                        public void onCompleted(boolean enabled) {
                            if (enabled) {
                                RestrictiveDataManager.enable();
                            }
                        }
                    });
                    FeatureManager.checkFeature(FeatureManager.Feature.PrivacyProtection, new FeatureManager.Callback(){

                        @Override
                        public void onCompleted(boolean enabled) {
                            if (enabled) {
                                ModelManager.enable();
                            }
                        }
                    });
                    FeatureManager.checkFeature(FeatureManager.Feature.EventDeactivation, new FeatureManager.Callback(){

                        @Override
                        public void onCompleted(boolean enabled) {
                            if (enabled) {
                                EventDeactivationManager.enable();
                            }
                        }
                    });
                    FeatureManager.checkFeature(FeatureManager.Feature.IapLogging, new FeatureManager.Callback(){

                        @Override
                        public void onCompleted(boolean enabled) {
                            if (enabled) {
                                InAppPurchaseManager.enableAutoLogging();
                            }
                        }
                    });
                }

                @Override
                public void onError() {
                }
            });
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventsManager.class);
            return;
        }
    }
}

