/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.facebook.FacebookRequestError;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.GraphResponse;
import com.facebook.LoggingBehavior;
import com.facebook.appevents.AccessTokenAppIdPair;
import com.facebook.appevents.AppEvent;
import com.facebook.appevents.AppEventCollection;
import com.facebook.appevents.AppEventStore;
import com.facebook.appevents.AppEventsLogger;
import com.facebook.appevents.AppEventsLoggerImpl;
import com.facebook.appevents.FlushReason;
import com.facebook.appevents.FlushResult;
import com.facebook.appevents.FlushStatistics;
import com.facebook.appevents.InternalAppEventsLogger;
import com.facebook.appevents.PersistedEvents;
import com.facebook.appevents.SessionEventsState;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.Logger;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;

class AppEventQueue {
    private static final String TAG = AppEventQueue.class.getName();
    private static final Integer NUM_LOG_EVENTS_TO_TRY_TO_FLUSH_AFTER = 100;
    private static final int FLUSH_PERIOD_IN_SECONDS = 15;
    private static volatile AppEventCollection appEventCollection = new AppEventCollection();
    private static final ScheduledExecutorService singleThreadExecutor = Executors.newSingleThreadScheduledExecutor();
    private static ScheduledFuture scheduledFuture;
    private static final Runnable flushRunnable;

    AppEventQueue() {
    }

    public static void persistToDisk() {
        if (CrashShieldHandler.isObjectCrashing(AppEventQueue.class)) {
            return;
        }
        try {
            singleThreadExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    if (CrashShieldHandler.isObjectCrashing(this)) {
                        return;
                    }
                    try {
                        AppEventStore.persistEvents(AppEventQueue.access$100());
                        AppEventQueue.access$102(new AppEventCollection());
                        return;
                    }
                    catch (Throwable throwable) {
                        CrashShieldHandler.handleThrowable(throwable, this);
                        return;
                    }
                }
            });
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventQueue.class);
            return;
        }
    }

    public static void flush(FlushReason flushReason) {
        if (CrashShieldHandler.isObjectCrashing(AppEventQueue.class)) {
            return;
        }
        try {
            FlushReason reason;
            singleThreadExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    if (CrashShieldHandler.isObjectCrashing(this)) {
                        return;
                    }
                    try {
                        AppEventQueue.flushAndWait(reason);
                        return;
                    }
                    catch (Throwable throwable) {
                        CrashShieldHandler.handleThrowable(throwable, this);
                        return;
                    }
                }
            });
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventQueue.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void add(AccessTokenAppIdPair accessTokenAppIdPair, AppEvent appEvent) {
        if (CrashShieldHandler.isObjectCrashing(AppEventQueue.class)) {
            return;
        }
        try {
            void appEvent2;
            AccessTokenAppIdPair accessTokenAppId;
            singleThreadExecutor.execute(new Runnable((AppEvent)appEvent2){
                final /* synthetic */ AppEvent val$appEvent;
                {
                    this.val$appEvent = appEvent;
                }

                @Override
                public void run() {
                    if (CrashShieldHandler.isObjectCrashing(this)) {
                        return;
                    }
                    try {
                        AppEventQueue.access$100().addEvent(accessTokenAppId, this.val$appEvent);
                        if (AppEventsLogger.getFlushBehavior() != AppEventsLogger.FlushBehavior.EXPLICIT_ONLY && AppEventQueue.access$100().getEventCount() > AppEventQueue.access$200()) {
                            AppEventQueue.flushAndWait(FlushReason.EVENT_THRESHOLD);
                        } else if (AppEventQueue.access$000() == null) {
                            AppEventQueue.access$002(AppEventQueue.access$400().schedule(AppEventQueue.access$300(), 15L, TimeUnit.SECONDS));
                        }
                        return;
                    }
                    catch (Throwable throwable) {
                        CrashShieldHandler.handleThrowable(throwable, this);
                        return;
                    }
                }
            });
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventQueue.class);
            return;
        }
    }

    public static Set<AccessTokenAppIdPair> getKeySet() {
        if (CrashShieldHandler.isObjectCrashing(AppEventQueue.class)) {
            return null;
        }
        try {
            return appEventCollection.keySet();
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventQueue.class);
            return null;
        }
    }

    static void flushAndWait(FlushReason flushReason) {
        if (CrashShieldHandler.isObjectCrashing(AppEventQueue.class)) {
            return;
        }
        try {
            FlushStatistics flushResults;
            PersistedEvents result = AppEventStore.readAndClearStore();
            appEventCollection.addPersistedEvents(result);
            try {
                FlushReason reason;
                flushResults = AppEventQueue.sendEventsToServer(reason, appEventCollection);
            }
            catch (Exception e) {
                Log.w((String)TAG, (String)"Caught unexpected exception while flushing app events: ", (Throwable)e);
                return;
            }
            if (flushResults != null) {
                Intent intent = new Intent("com.facebook.sdk.APP_EVENTS_FLUSHED");
                intent.putExtra("com.facebook.sdk.APP_EVENTS_NUM_EVENTS_FLUSHED", flushResults.numEvents);
                intent.putExtra("com.facebook.sdk.APP_EVENTS_FLUSH_RESULT", (Serializable)((Object)flushResults.result));
                Context context = FacebookSdk.getApplicationContext();
                LocalBroadcastManager.getInstance((Context)context).sendBroadcast(intent);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventQueue.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static FlushStatistics sendEventsToServer(FlushReason flushReason, AppEventCollection appEventCollection) {
        if (CrashShieldHandler.isObjectCrashing(AppEventQueue.class)) {
            return null;
        }
        try {
            void appEventCollection2;
            FlushStatistics flushResults = new FlushStatistics();
            List<GraphRequest> requestsToExecute = AppEventQueue.buildRequests((AppEventCollection)appEventCollection2, flushResults);
            if (requestsToExecute.size() > 0) {
                FlushReason reason;
                Logger.log(LoggingBehavior.APP_EVENTS, TAG, "Flushing %d events due to %s.", flushResults.numEvents, reason.toString());
                for (GraphRequest request2 : requestsToExecute) {
                    request2.executeAndWait();
                }
                return flushResults;
            }
            return null;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventQueue.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    static List<GraphRequest> buildRequests(AppEventCollection appEventCollection, FlushStatistics flushStatistics) {
        if (CrashShieldHandler.isObjectCrashing(AppEventQueue.class)) {
            return null;
        }
        try {
            AppEventCollection appEventCollection2;
            Context context = FacebookSdk.getApplicationContext();
            boolean limitEventUsage = FacebookSdk.getLimitEventAndDataUsage(context);
            ArrayList<GraphRequest> requestsToExecute = new ArrayList<GraphRequest>();
            for (AccessTokenAppIdPair accessTokenAppId : appEventCollection2.keySet()) {
                void flushResults;
                GraphRequest request2 = AppEventQueue.buildRequestForSession(accessTokenAppId, appEventCollection2.get(accessTokenAppId), limitEventUsage, (FlushStatistics)flushResults);
                if (request2 == null) continue;
                requestsToExecute.add(request2);
            }
            return requestsToExecute;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventQueue.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    static GraphRequest buildRequestForSession(AccessTokenAppIdPair accessTokenAppIdPair, SessionEventsState sessionEventsState, boolean bl, FlushStatistics flushStatistics) {
        if (CrashShieldHandler.isObjectCrashing(AppEventQueue.class)) {
            return null;
        }
        try {
            void flushState;
            void limitEventUsage;
            void appEvents;
            int numEvents;
            String installReferrer;
            AccessTokenAppIdPair accessTokenAppId;
            String applicationId = accessTokenAppId.getApplicationId();
            FetchedAppSettings fetchedAppSettings = FetchedAppSettingsManager.queryAppSettings(applicationId, false);
            final GraphRequest postRequest = GraphRequest.newPostRequest(null, String.format("%s/activities", applicationId), null, null);
            Bundle requestParameters = postRequest.getParameters();
            if (requestParameters == null) {
                requestParameters = new Bundle();
            }
            requestParameters.putString("access_token", accessTokenAppId.getAccessTokenString());
            String pushNotificationsRegistrationId = InternalAppEventsLogger.getPushNotificationsRegistrationId();
            if (pushNotificationsRegistrationId != null) {
                requestParameters.putString("device_token", pushNotificationsRegistrationId);
            }
            if ((installReferrer = AppEventsLoggerImpl.getInstallReferrer()) != null) {
                requestParameters.putString("install_referrer", installReferrer);
            }
            postRequest.setParameters(requestParameters);
            boolean supportsImplicitLogging = false;
            if (fetchedAppSettings != null) {
                supportsImplicitLogging = fetchedAppSettings.supportsImplicitLogging();
            }
            if ((numEvents = appEvents.populateRequest(postRequest, FacebookSdk.getApplicationContext(), supportsImplicitLogging, (boolean)limitEventUsage)) == 0) {
                return null;
            }
            flushState.numEvents += numEvents;
            postRequest.setCallback(new GraphRequest.Callback((SessionEventsState)appEvents, (FlushStatistics)flushState){
                final /* synthetic */ SessionEventsState val$appEvents;
                final /* synthetic */ FlushStatistics val$flushState;
                {
                    this.val$appEvents = sessionEventsState;
                    this.val$flushState = flushStatistics;
                }

                @Override
                public void onCompleted(GraphResponse response) {
                    AppEventQueue.handleResponse(accessTokenAppId, postRequest, response, this.val$appEvents, this.val$flushState);
                }
            });
            return postRequest;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventQueue.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    static void handleResponse(AccessTokenAppIdPair accessTokenAppIdPair, GraphRequest graphRequest, GraphResponse graphResponse, SessionEventsState sessionEventsState, FlushStatistics flushStatistics) {
        if (CrashShieldHandler.isObjectCrashing(AppEventQueue.class)) {
            return;
        }
        try {
            void flushState;
            void appEvents;
            void response;
            FacebookRequestError error = response.getError();
            String resultDescription = "Success";
            FlushResult flushResult = FlushResult.SUCCESS;
            if (error != null) {
                int NO_CONNECTIVITY_ERROR_CODE = -1;
                if (error.getErrorCode() == -1) {
                    resultDescription = "Failed: No Connectivity";
                    flushResult = FlushResult.NO_CONNECTIVITY;
                } else {
                    resultDescription = String.format("Failed:\n  Response: %s\n  Error %s", response.toString(), error.toString());
                    flushResult = FlushResult.SERVER_ERROR;
                }
            }
            if (FacebookSdk.isLoggingBehaviorEnabled(LoggingBehavior.APP_EVENTS)) {
                String prettyPrintedEvents;
                void request2;
                String eventsJsonString = (String)request2.getTag();
                try {
                    JSONArray jsonArray = new JSONArray(eventsJsonString);
                    prettyPrintedEvents = jsonArray.toString(2);
                }
                catch (JSONException exc) {
                    prettyPrintedEvents = "<Can't encode events for debug logging>";
                }
                Logger.log(LoggingBehavior.APP_EVENTS, TAG, "Flush completed\nParams: %s\n  Result: %s\n  Events JSON: %s", request2.getGraphObject().toString(), resultDescription, prettyPrintedEvents);
            }
            appEvents.clearInFlightAndStats(error != null);
            if (flushResult == FlushResult.NO_CONNECTIVITY) {
                AccessTokenAppIdPair accessTokenAppId;
                FacebookSdk.getExecutor().execute(new Runnable((SessionEventsState)appEvents){
                    final /* synthetic */ SessionEventsState val$appEvents;
                    {
                        this.val$appEvents = sessionEventsState;
                    }

                    @Override
                    public void run() {
                        if (CrashShieldHandler.isObjectCrashing(this)) {
                            return;
                        }
                        try {
                            AppEventStore.persistEvents(accessTokenAppId, this.val$appEvents);
                            return;
                        }
                        catch (Throwable throwable) {
                            CrashShieldHandler.handleThrowable(throwable, this);
                            return;
                        }
                    }
                });
            }
            if (flushResult != FlushResult.SUCCESS && flushState.result != FlushResult.NO_CONNECTIVITY) {
                flushState.result = flushResult;
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventQueue.class);
            return;
        }
    }

    static /* synthetic */ ScheduledFuture access$002(ScheduledFuture scheduledFuture) {
        if (CrashShieldHandler.isObjectCrashing(AppEventQueue.class)) {
            return null;
        }
        try {
            ScheduledFuture x0;
            AppEventQueue.scheduledFuture = x0;
            return AppEventQueue.scheduledFuture;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventQueue.class);
            return null;
        }
    }

    static /* synthetic */ AppEventCollection access$100() {
        if (CrashShieldHandler.isObjectCrashing(AppEventQueue.class)) {
            return null;
        }
        try {
            return appEventCollection;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventQueue.class);
            return null;
        }
    }

    static /* synthetic */ AppEventCollection access$102(AppEventCollection appEventCollection) {
        if (CrashShieldHandler.isObjectCrashing(AppEventQueue.class)) {
            return null;
        }
        try {
            AppEventCollection x0;
            AppEventQueue.appEventCollection = x0;
            return AppEventQueue.appEventCollection;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventQueue.class);
            return null;
        }
    }

    static /* synthetic */ Integer access$200() {
        if (CrashShieldHandler.isObjectCrashing(AppEventQueue.class)) {
            return null;
        }
        try {
            return NUM_LOG_EVENTS_TO_TRY_TO_FLUSH_AFTER;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventQueue.class);
            return null;
        }
    }

    static /* synthetic */ ScheduledFuture access$000() {
        if (CrashShieldHandler.isObjectCrashing(AppEventQueue.class)) {
            return null;
        }
        try {
            return scheduledFuture;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventQueue.class);
            return null;
        }
    }

    static /* synthetic */ Runnable access$300() {
        if (CrashShieldHandler.isObjectCrashing(AppEventQueue.class)) {
            return null;
        }
        try {
            return flushRunnable;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventQueue.class);
            return null;
        }
    }

    static /* synthetic */ ScheduledExecutorService access$400() {
        if (CrashShieldHandler.isObjectCrashing(AppEventQueue.class)) {
            return null;
        }
        try {
            return singleThreadExecutor;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventQueue.class);
            return null;
        }
    }

    static {
        flushRunnable = new Runnable(){

            @Override
            public void run() {
                if (CrashShieldHandler.isObjectCrashing(this)) {
                    return;
                }
                try {
                    AppEventQueue.access$002(null);
                    if (AppEventsLogger.getFlushBehavior() != AppEventsLogger.FlushBehavior.EXPLICIT_ONLY) {
                        AppEventQueue.flushAndWait(FlushReason.TIMER);
                    }
                    return;
                }
                catch (Throwable throwable) {
                    CrashShieldHandler.handleThrowable(throwable, this);
                    return;
                }
            }
        };
    }
}

