/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import androidx.browser.customtabs.CustomTabsIntent;
import androidx.browser.customtabs.CustomTabsSession;
import com.facebook.FacebookSdk;
import com.facebook.internal.ServerProtocol;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.AutoHandleExceptions;
import com.facebook.login.CustomTabPrefetchHelper;

@AutoHandleExceptions
public class CustomTab {
    private Uri uri;

    public CustomTab(String action, Bundle parameters) {
        if (parameters == null) {
            parameters = new Bundle();
        }
        this.uri = CustomTab.getURIForAction(action, parameters);
    }

    public static Uri getURIForAction(String action, Bundle parameters) {
        return Utility.buildUri((String)ServerProtocol.getDialogAuthority(), (String)(FacebookSdk.getGraphApiVersion() + "/" + "dialog/" + action), (Bundle)parameters);
    }

    public boolean openCustomTab(Activity activity, String packageName) {
        CustomTabsSession session = CustomTabPrefetchHelper.getPreparedSessionOnce();
        CustomTabsIntent customTabsIntent = new CustomTabsIntent.Builder(session).build();
        customTabsIntent.intent.setPackage(packageName);
        customTabsIntent.intent.addFlags(0x40000000);
        try {
            customTabsIntent.launchUrl((Context)activity, this.uri);
        }
        catch (ActivityNotFoundException e) {
            return false;
        }
        return true;
    }
}

