/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.content.Intent;
import com.facebook.internal.instrument.crashshield.AutoHandleExceptions;
import java.util.UUID;

@AutoHandleExceptions
public class AppCall {
    private static AppCall currentPendingCall;
    private UUID callId;
    private Intent requestIntent;
    private int requestCode;

    public static AppCall getCurrentPendingCall() {
        return currentPendingCall;
    }

    public static synchronized AppCall finishPendingCall(UUID callId, int requestCode) {
        AppCall pendingCall = AppCall.getCurrentPendingCall();
        if (pendingCall == null || !pendingCall.getCallId().equals(callId) || pendingCall.getRequestCode() != requestCode) {
            return null;
        }
        AppCall.setCurrentPendingCall(null);
        return pendingCall;
    }

    private static synchronized boolean setCurrentPendingCall(AppCall appCall) {
        AppCall oldAppCall = AppCall.getCurrentPendingCall();
        currentPendingCall = appCall;
        return oldAppCall != null;
    }

    public AppCall(int requestCode) {
        this(requestCode, UUID.randomUUID());
    }

    public AppCall(int requestCode, UUID callId) {
        this.callId = callId;
        this.requestCode = requestCode;
    }

    public Intent getRequestIntent() {
        return this.requestIntent;
    }

    public UUID getCallId() {
        return this.callId;
    }

    public int getRequestCode() {
        return this.requestCode;
    }

    public void setRequestCode(int requestCode) {
        this.requestCode = requestCode;
    }

    public void setRequestIntent(Intent requestIntent) {
        this.requestIntent = requestIntent;
    }

    public boolean setPending() {
        return AppCall.setCurrentPendingCall(this);
    }
}

