/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.login;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.app.FragmentActivity;
import com.facebook.AccessTokenSource;
import com.facebook.CustomTabMainActivity;
import com.facebook.FacebookException;
import com.facebook.FacebookOperationCanceledException;
import com.facebook.FacebookRequestError;
import com.facebook.FacebookSdk;
import com.facebook.FacebookServiceException;
import com.facebook.internal.CustomTab;
import com.facebook.internal.CustomTabUtils;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import com.facebook.login.CustomTabPrefetchHelper;
import com.facebook.login.LoginClient;
import com.facebook.login.WebLoginMethodHandler;
import org.json.JSONException;
import org.json.JSONObject;

public class CustomTabLoginMethodHandler
extends WebLoginMethodHandler {
    private static final String OAUTH_DIALOG = "oauth";
    private static final int CUSTOM_TAB_REQUEST_CODE = 1;
    private static final int CHALLENGE_LENGTH = 20;
    private static final int API_EC_DIALOG_CANCEL = 4201;
    private String currentPackage;
    private String expectedChallenge;
    private String validRedirectURI = "";
    public static final Parcelable.Creator<CustomTabLoginMethodHandler> CREATOR = new Parcelable.Creator(){

        public CustomTabLoginMethodHandler createFromParcel(Parcel source) {
            return new CustomTabLoginMethodHandler(source);
        }

        public CustomTabLoginMethodHandler[] newArray(int size) {
            return new CustomTabLoginMethodHandler[size];
        }
    };

    CustomTabLoginMethodHandler(LoginClient loginClient) {
        super(loginClient);
        this.expectedChallenge = Utility.generateRandomString((int)20);
        boolean hasDeveloperDefinedRedirect = Validate.hasCustomTabRedirectActivity((Context)FacebookSdk.getApplicationContext(), (String)this.getDeveloperDefinedRedirectURI());
        if (hasDeveloperDefinedRedirect) {
            this.validRedirectURI = this.getDeveloperDefinedRedirectURI();
        } else {
            boolean hasDefaultRedirect = Validate.hasCustomTabRedirectActivity((Context)FacebookSdk.getApplicationContext(), (String)CustomTabUtils.getDefaultRedirectURI());
            if (hasDefaultRedirect) {
                this.validRedirectURI = CustomTabUtils.getDefaultRedirectURI();
            }
        }
    }

    @Override
    String getNameForLogging() {
        return "custom_tab";
    }

    @Override
    AccessTokenSource getTokenSource() {
        return AccessTokenSource.CHROME_CUSTOM_TAB;
    }

    private String getDeveloperDefinedRedirectURI() {
        return super.getRedirectUrl();
    }

    @Override
    protected String getRedirectUrl() {
        return this.validRedirectURI;
    }

    @Override
    protected String getSSODevice() {
        return "chrome_custom_tab";
    }

    @Override
    boolean tryAuthorize(LoginClient.Request request) {
        if (!this.isCustomTabsAllowed()) {
            return false;
        }
        Bundle parameters = this.getParameters(request);
        parameters = this.addExtraParameters(parameters, request);
        if (FacebookSdk.hasCustomTabsPrefetching) {
            CustomTabPrefetchHelper.mayLaunchUrl(CustomTab.getURIForAction(OAUTH_DIALOG, parameters));
        }
        FragmentActivity activity = this.loginClient.getActivity();
        Intent intent = new Intent((Context)activity, CustomTabMainActivity.class);
        intent.putExtra(CustomTabMainActivity.EXTRA_ACTION, OAUTH_DIALOG);
        intent.putExtra(CustomTabMainActivity.EXTRA_PARAMS, parameters);
        intent.putExtra(CustomTabMainActivity.EXTRA_CHROME_PACKAGE, this.getChromePackage());
        this.loginClient.getFragment().startActivityForResult(intent, 1);
        return true;
    }

    private boolean isCustomTabsAllowed() {
        return this.getChromePackage() != null && !this.getRedirectUrl().isEmpty();
    }

    private String getChromePackage() {
        if (this.currentPackage != null) {
            return this.currentPackage;
        }
        this.currentPackage = CustomTabUtils.getChromePackage();
        return this.currentPackage;
    }

    @Override
    boolean onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode != 1) {
            return super.onActivityResult(requestCode, resultCode, data);
        }
        LoginClient.Request request = this.loginClient.getPendingRequest();
        if (resultCode == -1) {
            this.onCustomTabComplete(data.getStringExtra(CustomTabMainActivity.EXTRA_URL), request);
            return true;
        }
        super.onComplete(request, null, (FacebookException)new FacebookOperationCanceledException());
        return false;
    }

    private void onCustomTabComplete(String url, LoginClient.Request request) {
        if (url != null && (url.startsWith("fbconnect://cct.") || url.startsWith(super.getRedirectUrl()))) {
            String errorMessage;
            Uri uri = Uri.parse((String)url);
            Bundle values = Utility.parseUrlQueryString((String)uri.getQuery());
            values.putAll(Utility.parseUrlQueryString((String)uri.getFragment()));
            if (!this.validateChallengeParam(values)) {
                super.onComplete(request, null, new FacebookException("Invalid state parameter"));
                return;
            }
            String error = values.getString("error");
            if (error == null) {
                error = values.getString("error_type");
            }
            if ((errorMessage = values.getString("error_msg")) == null) {
                errorMessage = values.getString("error_message");
            }
            if (errorMessage == null) {
                errorMessage = values.getString("error_description");
            }
            String errorCodeString = values.getString("error_code");
            int errorCode = -1;
            if (!Utility.isNullOrEmpty((String)errorCodeString)) {
                try {
                    errorCode = Integer.parseInt(errorCodeString);
                }
                catch (NumberFormatException ex) {
                    errorCode = -1;
                }
            }
            if (Utility.isNullOrEmpty((String)error) && Utility.isNullOrEmpty((String)errorMessage) && errorCode == -1) {
                super.onComplete(request, values, null);
            } else if (error != null && (error.equals("access_denied") || error.equals("OAuthAccessDeniedException"))) {
                super.onComplete(request, null, (FacebookException)new FacebookOperationCanceledException());
            } else if (errorCode == 4201) {
                super.onComplete(request, null, (FacebookException)new FacebookOperationCanceledException());
            } else {
                FacebookRequestError requestError = new FacebookRequestError(errorCode, error, errorMessage);
                super.onComplete(request, null, (FacebookException)new FacebookServiceException(requestError, errorMessage));
            }
        }
    }

    @Override
    protected void putChallengeParam(JSONObject param) throws JSONException {
        param.put("7_challenge", (Object)this.expectedChallenge);
    }

    private boolean validateChallengeParam(Bundle values) {
        try {
            String stateString = values.getString("state");
            if (stateString == null) {
                return false;
            }
            JSONObject state = new JSONObject(stateString);
            String challenge = state.getString("7_challenge");
            return challenge.equals(this.expectedChallenge);
        }
        catch (JSONException e) {
            return false;
        }
    }

    public int describeContents() {
        return 0;
    }

    CustomTabLoginMethodHandler(Parcel source) {
        super(source);
        this.expectedChallenge = source.readString();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeString(this.expectedChallenge);
    }
}

