/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.login;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Parcel;
import android.support.v4.app.FragmentActivity;
import android.text.TextUtils;
import android.webkit.CookieSyncManager;
import com.facebook.AccessToken;
import com.facebook.AccessTokenSource;
import com.facebook.FacebookException;
import com.facebook.FacebookOperationCanceledException;
import com.facebook.FacebookRequestError;
import com.facebook.FacebookSdk;
import com.facebook.FacebookServiceException;
import com.facebook.internal.Utility;
import com.facebook.login.DefaultAudience;
import com.facebook.login.LoginClient;
import com.facebook.login.LoginMethodHandler;
import java.util.Locale;

abstract class WebLoginMethodHandler
extends LoginMethodHandler {
    private static final String WEB_VIEW_AUTH_HANDLER_STORE = "com.facebook.login.AuthorizationClient.WebViewAuthHandler.TOKEN_STORE_KEY";
    private static final String WEB_VIEW_AUTH_HANDLER_TOKEN_KEY = "TOKEN";
    private String e2e;

    private static final String getRedirectUri() {
        return "fb" + FacebookSdk.getApplicationId() + "://authorize";
    }

    WebLoginMethodHandler(LoginClient loginClient) {
        super(loginClient);
    }

    WebLoginMethodHandler(Parcel source) {
        super(source);
    }

    abstract AccessTokenSource getTokenSource();

    protected String getSSODevice() {
        return null;
    }

    protected Bundle getParameters(LoginClient.Request request) {
        String previousTokenString;
        Bundle parameters = new Bundle();
        if (!Utility.isNullOrEmpty(request.getPermissions())) {
            String scope = TextUtils.join((CharSequence)",", request.getPermissions());
            parameters.putString("scope", scope);
            this.addLoggingExtra("scope", scope);
        }
        DefaultAudience audience = request.getDefaultAudience();
        parameters.putString("default_audience", audience.getNativeProtocolAudience());
        parameters.putString("state", this.getClientState(request.getAuthId()));
        AccessToken previousToken = AccessToken.getCurrentAccessToken();
        String string2 = previousTokenString = previousToken != null ? previousToken.getToken() : null;
        if (previousTokenString != null && previousTokenString.equals(this.loadCookieToken())) {
            parameters.putString("access_token", previousTokenString);
            this.addLoggingExtra("access_token", "1");
        } else {
            Utility.clearFacebookCookies((Context)this.loginClient.getActivity());
            this.addLoggingExtra("access_token", "0");
        }
        return parameters;
    }

    protected Bundle addExtraParameters(Bundle parameters, LoginClient.Request request) {
        parameters.putString("redirect_uri", WebLoginMethodHandler.getRedirectUri());
        parameters.putString("client_id", request.getApplicationId());
        WebLoginMethodHandler webLoginMethodHandler = this;
        parameters.putString("e2e", webLoginMethodHandler.loginClient.getE2E());
        parameters.putString("response_type", "token,signed_request");
        parameters.putString("return_scopes", "true");
        parameters.putString("auth_type", request.getAuthType());
        parameters.putString("sdk", String.format(Locale.ROOT, "android-%s", FacebookSdk.getSdkVersion()));
        if (this.getSSODevice() != null) {
            parameters.putString("sso", this.getSSODevice());
        }
        return parameters;
    }

    protected void onComplete(LoginClient.Request request, Bundle values, FacebookException error) {
        LoginClient.Result outcome;
        this.e2e = null;
        if (values != null) {
            if (values.containsKey("e2e")) {
                this.e2e = values.getString("e2e");
            }
            try {
                AccessToken token = WebLoginMethodHandler.createAccessTokenFromWebBundle(request.getPermissions(), values, this.getTokenSource(), request.getApplicationId());
                outcome = LoginClient.Result.createTokenResult(this.loginClient.getPendingRequest(), token);
                CookieSyncManager syncManager = CookieSyncManager.createInstance((Context)this.loginClient.getActivity());
                syncManager.sync();
                this.saveCookieToken(token.getToken());
            }
            catch (FacebookException ex) {
                outcome = LoginClient.Result.createErrorResult(this.loginClient.getPendingRequest(), null, ex.getMessage());
            }
        } else if (error instanceof FacebookOperationCanceledException) {
            outcome = LoginClient.Result.createCancelResult(this.loginClient.getPendingRequest(), "User canceled log in.");
        } else {
            this.e2e = null;
            String errorCode = null;
            String errorMessage = error.getMessage();
            if (error instanceof FacebookServiceException) {
                FacebookRequestError requestError = ((FacebookServiceException)error).getRequestError();
                errorCode = String.format(Locale.ROOT, "%d", requestError.getErrorCode());
                errorMessage = requestError.toString();
            }
            outcome = LoginClient.Result.createErrorResult(this.loginClient.getPendingRequest(), null, errorMessage, errorCode);
        }
        if (!Utility.isNullOrEmpty((String)this.e2e)) {
            this.logWebLoginCompleted(this.e2e);
        }
        this.loginClient.completeAndValidate(outcome);
    }

    private String loadCookieToken() {
        FragmentActivity context = this.loginClient.getActivity();
        SharedPreferences sharedPreferences = context.getSharedPreferences(WEB_VIEW_AUTH_HANDLER_STORE, 0);
        return sharedPreferences.getString(WEB_VIEW_AUTH_HANDLER_TOKEN_KEY, "");
    }

    private void saveCookieToken(String token) {
        FragmentActivity context = this.loginClient.getActivity();
        context.getSharedPreferences(WEB_VIEW_AUTH_HANDLER_STORE, 0).edit().putString(WEB_VIEW_AUTH_HANDLER_TOKEN_KEY, token).apply();
    }
}

