/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.share.internal;

import android.net.Uri;
import android.os.Bundle;
import com.facebook.FacebookException;
import com.facebook.internal.Utility;
import com.facebook.share.internal.ShareFeedContent;
import com.facebook.share.internal.ShareInternalUtility;
import com.facebook.share.model.AppGroupCreationContent;
import com.facebook.share.model.GameRequestContent;
import com.facebook.share.model.ShareContent;
import com.facebook.share.model.ShareHashtag;
import com.facebook.share.model.ShareLinkContent;
import com.facebook.share.model.ShareOpenGraphContent;
import com.facebook.share.model.SharePhoto;
import com.facebook.share.model.SharePhotoContent;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public class WebDialogParameters {
    public static Bundle create(AppGroupCreationContent appGroupCreationContent) {
        Bundle webParams = new Bundle();
        Utility.putNonEmptyString((Bundle)webParams, (String)"name", (String)appGroupCreationContent.getName());
        Utility.putNonEmptyString((Bundle)webParams, (String)"description", (String)appGroupCreationContent.getDescription());
        AppGroupCreationContent.AppGroupPrivacy privacy = appGroupCreationContent.getAppGroupPrivacy();
        if (privacy != null) {
            Utility.putNonEmptyString((Bundle)webParams, (String)"privacy", (String)privacy.toString().toLowerCase(Locale.ENGLISH));
        }
        return webParams;
    }

    public static Bundle create(GameRequestContent gameRequestContent) {
        Bundle webParams = new Bundle();
        Utility.putNonEmptyString((Bundle)webParams, (String)"message", (String)gameRequestContent.getMessage());
        Utility.putCommaSeparatedStringList((Bundle)webParams, (String)"to", gameRequestContent.getRecipients());
        Utility.putNonEmptyString((Bundle)webParams, (String)"title", (String)gameRequestContent.getTitle());
        Utility.putNonEmptyString((Bundle)webParams, (String)"data", (String)gameRequestContent.getData());
        if (gameRequestContent.getActionType() != null) {
            Utility.putNonEmptyString((Bundle)webParams, (String)"action_type", (String)gameRequestContent.getActionType().toString().toLowerCase(Locale.ENGLISH));
        }
        Utility.putNonEmptyString((Bundle)webParams, (String)"object_id", (String)gameRequestContent.getObjectId());
        if (gameRequestContent.getFilters() != null) {
            Utility.putNonEmptyString((Bundle)webParams, (String)"filters", (String)gameRequestContent.getFilters().toString().toLowerCase(Locale.ENGLISH));
        }
        Utility.putCommaSeparatedStringList((Bundle)webParams, (String)"suggestions", gameRequestContent.getSuggestions());
        return webParams;
    }

    public static Bundle create(ShareLinkContent shareLinkContent) {
        Bundle params = WebDialogParameters.createBaseParameters(shareLinkContent);
        Utility.putUri((Bundle)params, (String)"href", (Uri)shareLinkContent.getContentUrl());
        Utility.putNonEmptyString((Bundle)params, (String)"quote", (String)shareLinkContent.getQuote());
        return params;
    }

    public static Bundle create(ShareOpenGraphContent shareOpenGraphContent) {
        Bundle params = WebDialogParameters.createBaseParameters(shareOpenGraphContent);
        Utility.putNonEmptyString((Bundle)params, (String)"action_type", (String)shareOpenGraphContent.getAction().getActionType());
        try {
            JSONObject ogJSON = ShareInternalUtility.toJSONObjectForWeb(shareOpenGraphContent);
            ogJSON = ShareInternalUtility.removeNamespacesFromOGJsonObject(ogJSON, false);
            if (ogJSON != null) {
                Utility.putNonEmptyString((Bundle)params, (String)"action_properties", (String)ogJSON.toString());
            }
        }
        catch (JSONException e) {
            throw new FacebookException("Unable to serialize the ShareOpenGraphContent to JSON", (Throwable)e);
        }
        return params;
    }

    public static Bundle create(SharePhotoContent sharePhotoContent) {
        Bundle params = WebDialogParameters.createBaseParameters(sharePhotoContent);
        String[] urls = new String[sharePhotoContent.getPhotos().size()];
        Utility.map(sharePhotoContent.getPhotos(), (Utility.Mapper)new Utility.Mapper<SharePhoto, String>(){

            public String apply(SharePhoto item) {
                return item.getImageUrl().toString();
            }
        }).toArray(urls);
        params.putStringArray("media", urls);
        return params;
    }

    public static Bundle createBaseParameters(ShareContent shareContent) {
        Bundle params = new Bundle();
        ShareHashtag shareHashtag = shareContent.getShareHashtag();
        if (shareHashtag != null) {
            Utility.putNonEmptyString((Bundle)params, (String)"hashtag", (String)shareHashtag.getHashtag());
        }
        return params;
    }

    public static Bundle createForFeed(ShareLinkContent shareLinkContent) {
        Bundle webParams = new Bundle();
        Utility.putNonEmptyString((Bundle)webParams, (String)"name", (String)shareLinkContent.getContentTitle());
        Utility.putNonEmptyString((Bundle)webParams, (String)"description", (String)shareLinkContent.getContentDescription());
        Utility.putNonEmptyString((Bundle)webParams, (String)"link", (String)Utility.getUriString((Uri)shareLinkContent.getContentUrl()));
        Utility.putNonEmptyString((Bundle)webParams, (String)"picture", (String)Utility.getUriString((Uri)shareLinkContent.getImageUrl()));
        Utility.putNonEmptyString((Bundle)webParams, (String)"quote", (String)shareLinkContent.getQuote());
        ShareHashtag shareHashtag = shareLinkContent.getShareHashtag();
        if (shareHashtag != null) {
            Utility.putNonEmptyString((Bundle)webParams, (String)"hashtag", (String)shareLinkContent.getShareHashtag().getHashtag());
        }
        return webParams;
    }

    public static Bundle createForFeed(ShareFeedContent shareFeedContent) {
        Bundle webParams = new Bundle();
        Utility.putNonEmptyString((Bundle)webParams, (String)"to", (String)shareFeedContent.getToId());
        Utility.putNonEmptyString((Bundle)webParams, (String)"link", (String)shareFeedContent.getLink());
        Utility.putNonEmptyString((Bundle)webParams, (String)"picture", (String)shareFeedContent.getPicture());
        Utility.putNonEmptyString((Bundle)webParams, (String)"source", (String)shareFeedContent.getMediaSource());
        Utility.putNonEmptyString((Bundle)webParams, (String)"name", (String)shareFeedContent.getLinkName());
        Utility.putNonEmptyString((Bundle)webParams, (String)"caption", (String)shareFeedContent.getLinkCaption());
        Utility.putNonEmptyString((Bundle)webParams, (String)"description", (String)shareFeedContent.getLinkDescription());
        return webParams;
    }
}

