/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.share.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.facebook.share.model.ShareModel;
import com.facebook.share.model.ShareModelBuilder;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

public final class GameRequestContent
implements ShareModel {
    private final String message;
    private final List<String> recipients;
    private final String title;
    private final String data;
    private final ActionType actionType;
    private final String objectId;
    private final Filters filters;
    private final List<String> suggestions;
    public static final Parcelable.Creator<GameRequestContent> CREATOR = new Parcelable.Creator<GameRequestContent>(){

        public GameRequestContent createFromParcel(Parcel in) {
            return new GameRequestContent(in);
        }

        public GameRequestContent[] newArray(int size) {
            return new GameRequestContent[size];
        }
    };

    private GameRequestContent(Builder builder) {
        this.message = builder.message;
        this.recipients = builder.recipients;
        this.title = builder.title;
        this.data = builder.data;
        this.actionType = builder.actionType;
        this.objectId = builder.objectId;
        this.filters = builder.filters;
        this.suggestions = builder.suggestions;
    }

    GameRequestContent(Parcel in) {
        this.message = in.readString();
        this.recipients = in.createStringArrayList();
        this.title = in.readString();
        this.data = in.readString();
        this.actionType = (ActionType)((Object)in.readSerializable());
        this.objectId = in.readString();
        this.filters = (Filters)((Object)in.readSerializable());
        this.suggestions = in.createStringArrayList();
        in.readStringList(this.suggestions);
    }

    public String getMessage() {
        return this.message;
    }

    public String getTo() {
        return this.getRecipients() != null ? TextUtils.join((CharSequence)",", this.getRecipients()) : null;
    }

    public List<String> getRecipients() {
        return this.recipients;
    }

    public String getTitle() {
        return this.title;
    }

    public String getData() {
        return this.data;
    }

    public ActionType getActionType() {
        return this.actionType;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public Filters getFilters() {
        return this.filters;
    }

    public List<String> getSuggestions() {
        return this.suggestions;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeString(this.message);
        out.writeStringList(this.recipients);
        out.writeString(this.title);
        out.writeString(this.data);
        out.writeSerializable((Serializable)((Object)this.actionType));
        out.writeString(this.objectId);
        out.writeSerializable((Serializable)((Object)this.filters));
        out.writeStringList(this.suggestions);
    }

    public static class Builder
    implements ShareModelBuilder<GameRequestContent, Builder> {
        private String message;
        private List<String> recipients;
        private String data;
        private String title;
        private ActionType actionType;
        private String objectId;
        private Filters filters;
        private List<String> suggestions;

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder setTo(String to) {
            if (to != null) {
                String[] recipientsArray = to.split(",");
                this.recipients = Arrays.asList(recipientsArray);
            }
            return this;
        }

        public Builder setRecipients(List<String> recipients) {
            this.recipients = recipients;
            return this;
        }

        public Builder setData(String data) {
            this.data = data;
            return this;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setActionType(ActionType actionType) {
            this.actionType = actionType;
            return this;
        }

        public Builder setObjectId(String objectId) {
            this.objectId = objectId;
            return this;
        }

        public Builder setFilters(Filters filters) {
            this.filters = filters;
            return this;
        }

        public Builder setSuggestions(List<String> suggestions) {
            this.suggestions = suggestions;
            return this;
        }

        @Override
        public GameRequestContent build() {
            return new GameRequestContent(this);
        }

        @Override
        public Builder readFrom(GameRequestContent content) {
            if (content == null) {
                return this;
            }
            return this.setMessage(content.getMessage()).setRecipients(content.getRecipients()).setTitle(content.getTitle()).setData(content.getData()).setActionType(content.getActionType()).setObjectId(content.getObjectId()).setFilters(content.getFilters()).setSuggestions(content.getSuggestions());
        }

        @Override
        Builder readFrom(Parcel parcel) {
            return this.readFrom((GameRequestContent)parcel.readParcelable(GameRequestContent.class.getClassLoader()));
        }
    }

    public static enum Filters {
        APP_USERS,
        APP_NON_USERS;

    }

    public static enum ActionType {
        SEND,
        ASKFOR,
        TURN;

    }
}

