/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.share.internal;

import android.net.Uri;
import android.os.Bundle;
import com.facebook.FacebookException;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import com.facebook.share.internal.CameraEffectJSONUtility;
import com.facebook.share.internal.MessengerShareContentUtility;
import com.facebook.share.internal.ShareInternalUtility;
import com.facebook.share.model.ShareCameraEffectContent;
import com.facebook.share.model.ShareContent;
import com.facebook.share.model.ShareHashtag;
import com.facebook.share.model.ShareLinkContent;
import com.facebook.share.model.ShareMediaContent;
import com.facebook.share.model.ShareMessengerGenericTemplateContent;
import com.facebook.share.model.ShareMessengerMediaTemplateContent;
import com.facebook.share.model.ShareMessengerOpenGraphMusicTemplateContent;
import com.facebook.share.model.ShareOpenGraphContent;
import com.facebook.share.model.SharePhotoContent;
import com.facebook.share.model.ShareVideoContent;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public class NativeDialogParameters {
    public static Bundle create(UUID callId, ShareContent shareContent, boolean shouldFailOnDataError) {
        Validate.notNull((Object)shareContent, (String)"shareContent");
        Validate.notNull((Object)callId, (String)"callId");
        Bundle nativeParams = null;
        if (shareContent instanceof ShareLinkContent) {
            ShareLinkContent linkContent = (ShareLinkContent)shareContent;
            nativeParams = NativeDialogParameters.create(linkContent, shouldFailOnDataError);
        } else if (shareContent instanceof SharePhotoContent) {
            SharePhotoContent photoContent = (SharePhotoContent)shareContent;
            List<String> photoUrls = ShareInternalUtility.getPhotoUrls(photoContent, callId);
            nativeParams = NativeDialogParameters.create(photoContent, photoUrls, shouldFailOnDataError);
        } else if (shareContent instanceof ShareVideoContent) {
            ShareVideoContent videoContent = (ShareVideoContent)shareContent;
            String videoUrl = ShareInternalUtility.getVideoUrl(videoContent, callId);
            nativeParams = NativeDialogParameters.create(videoContent, videoUrl, shouldFailOnDataError);
        } else if (shareContent instanceof ShareOpenGraphContent) {
            ShareOpenGraphContent openGraphContent = (ShareOpenGraphContent)shareContent;
            try {
                JSONObject openGraphActionJSON = ShareInternalUtility.toJSONObjectForCall(callId, openGraphContent);
                openGraphActionJSON = ShareInternalUtility.removeNamespacesFromOGJsonObject(openGraphActionJSON, false);
                nativeParams = NativeDialogParameters.create(openGraphContent, openGraphActionJSON, shouldFailOnDataError);
            }
            catch (JSONException e) {
                throw new FacebookException("Unable to create a JSON Object from the provided ShareOpenGraphContent: " + e.getMessage());
            }
        } else if (shareContent instanceof ShareMediaContent) {
            ShareMediaContent mediaContent = (ShareMediaContent)shareContent;
            List<Bundle> mediaInfos = ShareInternalUtility.getMediaInfos(mediaContent, callId);
            nativeParams = NativeDialogParameters.create(mediaContent, mediaInfos, shouldFailOnDataError);
        } else if (shareContent instanceof ShareCameraEffectContent) {
            ShareCameraEffectContent cameraEffectContent = (ShareCameraEffectContent)shareContent;
            Bundle attachmentUrlsBundle = ShareInternalUtility.getTextureUrlBundle(cameraEffectContent, callId);
            nativeParams = NativeDialogParameters.create(cameraEffectContent, attachmentUrlsBundle, shouldFailOnDataError);
        } else if (shareContent instanceof ShareMessengerGenericTemplateContent) {
            ShareMessengerGenericTemplateContent genericTemplateContent = (ShareMessengerGenericTemplateContent)shareContent;
            nativeParams = NativeDialogParameters.create(genericTemplateContent, shouldFailOnDataError);
        } else if (shareContent instanceof ShareMessengerOpenGraphMusicTemplateContent) {
            ShareMessengerOpenGraphMusicTemplateContent openGraphMusicTemplateContent = (ShareMessengerOpenGraphMusicTemplateContent)shareContent;
            nativeParams = NativeDialogParameters.create(openGraphMusicTemplateContent, shouldFailOnDataError);
        } else if (shareContent instanceof ShareMessengerMediaTemplateContent) {
            ShareMessengerMediaTemplateContent mediaTemplateContent = (ShareMessengerMediaTemplateContent)shareContent;
            nativeParams = NativeDialogParameters.create(mediaTemplateContent, shouldFailOnDataError);
        }
        return nativeParams;
    }

    private static Bundle create(ShareCameraEffectContent cameraEffectContent, Bundle attachmentUrlsBundle, boolean dataErrorsFatal) {
        Bundle params = NativeDialogParameters.createBaseParameters(cameraEffectContent, dataErrorsFatal);
        Utility.putNonEmptyString((Bundle)params, (String)"effect_id", (String)cameraEffectContent.getEffectId());
        if (attachmentUrlsBundle != null) {
            params.putBundle("effect_textures", attachmentUrlsBundle);
        }
        try {
            JSONObject argsJSON = CameraEffectJSONUtility.convertToJSON(cameraEffectContent.getArguments());
            if (argsJSON != null) {
                Utility.putNonEmptyString((Bundle)params, (String)"effect_arguments", (String)argsJSON.toString());
            }
        }
        catch (JSONException e) {
            throw new FacebookException("Unable to create a JSON Object from the provided CameraEffectArguments: " + e.getMessage());
        }
        return params;
    }

    private static Bundle create(ShareLinkContent linkContent, boolean dataErrorsFatal) {
        Bundle params = NativeDialogParameters.createBaseParameters(linkContent, dataErrorsFatal);
        Utility.putNonEmptyString((Bundle)params, (String)"TITLE", (String)linkContent.getContentTitle());
        Utility.putNonEmptyString((Bundle)params, (String)"DESCRIPTION", (String)linkContent.getContentDescription());
        Utility.putUri((Bundle)params, (String)"IMAGE", (Uri)linkContent.getImageUrl());
        Utility.putNonEmptyString((Bundle)params, (String)"QUOTE", (String)linkContent.getQuote());
        Utility.putUri((Bundle)params, (String)"MESSENGER_LINK", (Uri)linkContent.getContentUrl());
        Utility.putUri((Bundle)params, (String)"TARGET_DISPLAY", (Uri)linkContent.getContentUrl());
        return params;
    }

    private static Bundle create(SharePhotoContent photoContent, List<String> imageUrls, boolean dataErrorsFatal) {
        Bundle params = NativeDialogParameters.createBaseParameters(photoContent, dataErrorsFatal);
        params.putStringArrayList("PHOTOS", new ArrayList<String>(imageUrls));
        return params;
    }

    private static Bundle create(ShareVideoContent videoContent, String videoUrl, boolean dataErrorsFatal) {
        Bundle params = NativeDialogParameters.createBaseParameters(videoContent, dataErrorsFatal);
        Utility.putNonEmptyString((Bundle)params, (String)"TITLE", (String)videoContent.getContentTitle());
        Utility.putNonEmptyString((Bundle)params, (String)"DESCRIPTION", (String)videoContent.getContentDescription());
        Utility.putNonEmptyString((Bundle)params, (String)"VIDEO", (String)videoUrl);
        return params;
    }

    private static Bundle create(ShareMediaContent mediaContent, List<Bundle> mediaInfos, boolean dataErrorsFatal) {
        Bundle params = NativeDialogParameters.createBaseParameters(mediaContent, dataErrorsFatal);
        params.putParcelableArrayList("MEDIA", new ArrayList<Bundle>(mediaInfos));
        return params;
    }

    private static Bundle create(ShareOpenGraphContent openGraphContent, JSONObject openGraphActionJSON, boolean dataErrorsFatal) {
        Bundle params = NativeDialogParameters.createBaseParameters(openGraphContent, dataErrorsFatal);
        String previewProperty = (String)ShareInternalUtility.getFieldNameAndNamespaceFromFullName((String)openGraphContent.getPreviewPropertyName()).second;
        Utility.putNonEmptyString((Bundle)params, (String)"PREVIEW_PROPERTY_NAME", (String)previewProperty);
        Utility.putNonEmptyString((Bundle)params, (String)"ACTION_TYPE", (String)openGraphContent.getAction().getActionType());
        Utility.putNonEmptyString((Bundle)params, (String)"ACTION", (String)openGraphActionJSON.toString());
        return params;
    }

    private static Bundle create(ShareMessengerGenericTemplateContent genericTemplateContent, boolean dataErrorsFatal) {
        Bundle params = NativeDialogParameters.createBaseParameters(genericTemplateContent, dataErrorsFatal);
        try {
            MessengerShareContentUtility.addGenericTemplateContent(params, genericTemplateContent);
        }
        catch (JSONException e) {
            throw new FacebookException("Unable to create a JSON Object from the provided ShareMessengerGenericTemplateContent: " + e.getMessage());
        }
        return params;
    }

    private static Bundle create(ShareMessengerOpenGraphMusicTemplateContent openGraphMusicTemplateContent, boolean dataErrorsFatal) {
        Bundle params = NativeDialogParameters.createBaseParameters(openGraphMusicTemplateContent, dataErrorsFatal);
        try {
            MessengerShareContentUtility.addOpenGraphMusicTemplateContent(params, openGraphMusicTemplateContent);
        }
        catch (JSONException e) {
            throw new FacebookException("Unable to create a JSON Object from the provided ShareMessengerOpenGraphMusicTemplateContent: " + e.getMessage());
        }
        return params;
    }

    private static Bundle create(ShareMessengerMediaTemplateContent mediaTemplateContent, boolean dataErrorsFatal) {
        Bundle params = NativeDialogParameters.createBaseParameters(mediaTemplateContent, dataErrorsFatal);
        try {
            MessengerShareContentUtility.addMediaTemplateContent(params, mediaTemplateContent);
        }
        catch (JSONException e) {
            throw new FacebookException("Unable to create a JSON Object from the provided ShareMessengerMediaTemplateContent: " + e.getMessage());
        }
        return params;
    }

    private static Bundle createBaseParameters(ShareContent content, boolean dataErrorsFatal) {
        ShareHashtag shareHashtag;
        Bundle params = new Bundle();
        Utility.putUri((Bundle)params, (String)"LINK", (Uri)content.getContentUrl());
        Utility.putNonEmptyString((Bundle)params, (String)"PLACE", (String)content.getPlaceId());
        Utility.putNonEmptyString((Bundle)params, (String)"PAGE", (String)content.getPageId());
        Utility.putNonEmptyString((Bundle)params, (String)"REF", (String)content.getRef());
        params.putBoolean("DATA_FAILURES_FATAL", dataErrorsFatal);
        List<String> peopleIds = content.getPeopleIds();
        if (!Utility.isNullOrEmpty(peopleIds)) {
            params.putStringArrayList("FRIENDS", new ArrayList<String>(peopleIds));
        }
        if ((shareHashtag = content.getShareHashtag()) != null) {
            Utility.putNonEmptyString((Bundle)params, (String)"HASHTAG", (String)shareHashtag.getHashtag());
        }
        return params;
    }
}

