/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.share.widget;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import com.facebook.AccessToken;
import com.facebook.CallbackManager;
import com.facebook.FacebookCallback;
import com.facebook.FacebookSdk;
import com.facebook.appevents.InternalAppEventsLogger;
import com.facebook.internal.AppCall;
import com.facebook.internal.CallbackManagerImpl;
import com.facebook.internal.DialogFeature;
import com.facebook.internal.DialogPresenter;
import com.facebook.internal.FacebookDialogBase;
import com.facebook.internal.FragmentWrapper;
import com.facebook.internal.NativeAppCallAttachmentStore;
import com.facebook.share.Sharer;
import com.facebook.share.internal.CameraEffectFeature;
import com.facebook.share.internal.LegacyNativeDialogParameters;
import com.facebook.share.internal.NativeDialogParameters;
import com.facebook.share.internal.ShareContentValidation;
import com.facebook.share.internal.ShareDialogFeature;
import com.facebook.share.internal.ShareFeedContent;
import com.facebook.share.internal.ShareInternalUtility;
import com.facebook.share.internal.ShareStoryFeature;
import com.facebook.share.internal.WebDialogParameters;
import com.facebook.share.model.ShareCameraEffectContent;
import com.facebook.share.model.ShareContent;
import com.facebook.share.model.ShareLinkContent;
import com.facebook.share.model.ShareMediaContent;
import com.facebook.share.model.SharePhoto;
import com.facebook.share.model.SharePhotoContent;
import com.facebook.share.model.ShareStoryContent;
import com.facebook.share.model.ShareVideoContent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0016\u0018\u0000 12\u0016\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004:\u00070123456B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0011\b\u0016\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\u000f\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rB\u000f\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fB\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0010B\u0017\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0011B\u0017\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\u000e\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0012B\u0019\b\u0016\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0015J \u0010\u001e\u001a\u00020\u00172\u000e\u0010\u001f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00022\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0014J\b\u0010$\u001a\u00020\u0017H\u0016J*\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(2\u000e\u0010\u001f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00022\u0006\u0010 \u001a\u00020!H\u0002J\u001e\u0010)\u001a\u00020&2\u0006\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00030-H\u0014J\u0010\u0010.\u001a\u00020&2\u0006\u0010\u001d\u001a\u00020\u0017H\u0016J \u0010/\u001a\u00020&2\u000e\u0010\u001f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00022\u0006\u0010 \u001a\u00020!H\u0016R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R2\u0010\u0018\u001a \u0012\u001c\u0012\u001a0\u001aR\u0016\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0002\u0012\u0004\u0012\u00020\u00030\u00010\u0019X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/facebook/share/widget/ShareDialog;", "Lcom/facebook/internal/FacebookDialogBase;", "Lcom/facebook/share/model/ShareContent;", "Lcom/facebook/share/Sharer$Result;", "Lcom/facebook/share/Sharer;", "activity", "Landroid/app/Activity;", "(Landroid/app/Activity;)V", "requestCode", "", "(I)V", "fragment", "Landroidx/fragment/app/Fragment;", "(Landroidx/fragment/app/Fragment;)V", "Landroid/app/Fragment;", "(Landroid/app/Fragment;)V", "(Landroid/app/Activity;I)V", "(Landroidx/fragment/app/Fragment;I)V", "(Landroid/app/Fragment;I)V", "fragmentWrapper", "Lcom/facebook/internal/FragmentWrapper;", "(Lcom/facebook/internal/FragmentWrapper;I)V", "isAutomaticMode", "", "orderedModeHandlers", "", "Lcom/facebook/internal/FacebookDialogBase$ModeHandler;", "getOrderedModeHandlers", "()Ljava/util/List;", "shouldFailOnDataError", "canShow", "content", "mode", "Lcom/facebook/share/widget/ShareDialog$Mode;", "createBaseAppCall", "Lcom/facebook/internal/AppCall;", "getShouldFailOnDataError", "logDialogShare", "", "context", "Landroid/content/Context;", "registerCallbackImpl", "callbackManager", "Lcom/facebook/internal/CallbackManagerImpl;", "callback", "Lcom/facebook/FacebookCallback;", "setShouldFailOnDataError", "show", "CameraEffectHandler", "Companion", "FeedHandler", "Mode", "NativeHandler", "ShareStoryHandler", "WebShareHandler", "facebook-common_release"})
public class ShareDialog
extends FacebookDialogBase<ShareContent<?, ?>, Sharer.Result>
implements Sharer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean shouldFailOnDataError;
    private boolean isAutomaticMode;
    @NotNull
    private final List<FacebookDialogBase.ModeHandler> orderedModeHandlers;
    private static final String TAG = ShareDialog.class.getSimpleName();
    @NotNull
    private static final String FEED_DIALOG = "feed";
    @NotNull
    public static final String WEB_SHARE_DIALOG = "share";
    @NotNull
    private static final String WEB_OG_SHARE_DIALOG = "share_open_graph";
    private static final int DEFAULT_REQUEST_CODE = CallbackManagerImpl.RequestCodeOffset.Share.toRequestCode();

    public ShareDialog(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this(activity, DEFAULT_REQUEST_CODE);
    }

    public ShareDialog(int requestCode) {
        super(requestCode);
        this.isAutomaticMode = true;
        Object[] objectArray = new FacebookDialogBase.ModeHandler[]{new NativeHandler(), new FeedHandler(), new WebShareHandler(), new CameraEffectHandler(), new ShareStoryHandler()};
        this.orderedModeHandlers = CollectionsKt.arrayListOf((Object[])objectArray);
        ShareInternalUtility.registerStaticShareCallback(requestCode);
    }

    public /* synthetic */ ShareDialog(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = DEFAULT_REQUEST_CODE;
        }
        this(n);
    }

    public ShareDialog(@NotNull androidx.fragment.app.Fragment fragment) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        this(new FragmentWrapper(fragment), 0, 2, null);
    }

    public ShareDialog(@NotNull Fragment fragment) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        this(new FragmentWrapper(fragment), 0, 2, null);
    }

    public ShareDialog(@NotNull Activity activity, int requestCode) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        super(activity, requestCode);
        this.isAutomaticMode = true;
        Object[] objectArray = new FacebookDialogBase.ModeHandler[]{new NativeHandler(), new FeedHandler(), new WebShareHandler(), new CameraEffectHandler(), new ShareStoryHandler()};
        this.orderedModeHandlers = CollectionsKt.arrayListOf((Object[])objectArray);
        ShareInternalUtility.registerStaticShareCallback(requestCode);
    }

    public ShareDialog(@NotNull androidx.fragment.app.Fragment fragment, int requestCode) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        this(new FragmentWrapper(fragment), requestCode);
    }

    public ShareDialog(@NotNull Fragment fragment, int requestCode) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        this(new FragmentWrapper(fragment), requestCode);
    }

    public ShareDialog(@NotNull FragmentWrapper fragmentWrapper, int requestCode) {
        Intrinsics.checkNotNullParameter((Object)fragmentWrapper, (String)"fragmentWrapper");
        super(fragmentWrapper, requestCode);
        this.isAutomaticMode = true;
        Object[] objectArray = new FacebookDialogBase.ModeHandler[]{new NativeHandler(), new FeedHandler(), new WebShareHandler(), new CameraEffectHandler(), new ShareStoryHandler()};
        this.orderedModeHandlers = CollectionsKt.arrayListOf((Object[])objectArray);
        ShareInternalUtility.registerStaticShareCallback(requestCode);
    }

    public /* synthetic */ ShareDialog(FragmentWrapper fragmentWrapper, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = DEFAULT_REQUEST_CODE;
        }
        this(fragmentWrapper, n);
    }

    @Override
    protected void registerCallbackImpl(@NotNull CallbackManagerImpl callbackManager, @NotNull FacebookCallback<Sharer.Result> callback) {
        Intrinsics.checkNotNullParameter((Object)callbackManager, (String)"callbackManager");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        ShareInternalUtility.registerSharerCallback(this.getRequestCode(), (CallbackManager)callbackManager, callback);
    }

    @Override
    public boolean getShouldFailOnDataError() {
        return this.shouldFailOnDataError;
    }

    @Override
    public void setShouldFailOnDataError(boolean shouldFailOnDataError) {
        this.shouldFailOnDataError = shouldFailOnDataError;
    }

    public boolean canShow(@NotNull ShareContent<?, ?> content, @NotNull Mode mode) {
        Intrinsics.checkNotNullParameter(content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        return this.canShowImpl(content, mode == Mode.AUTOMATIC ? FacebookDialogBase.BASE_AUTOMATIC_MODE : mode);
    }

    public void show(@NotNull ShareContent<?, ?> content, @NotNull Mode mode) {
        Intrinsics.checkNotNullParameter(content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        this.isAutomaticMode = mode == Mode.AUTOMATIC;
        this.showImpl(content, this.isAutomaticMode ? FacebookDialogBase.BASE_AUTOMATIC_MODE : mode);
    }

    @Override
    @NotNull
    protected AppCall createBaseAppCall() {
        return new AppCall(this.getRequestCode(), null, 2, null);
    }

    @Override
    @NotNull
    protected List<FacebookDialogBase.ModeHandler> getOrderedModeHandlers() {
        return this.orderedModeHandlers;
    }

    private final void logDialogShare(Context context, ShareContent<?, ?> content, Mode mode) {
        String string2;
        Mode displayMode = this.isAutomaticMode ? Mode.AUTOMATIC : mode;
        switch (WhenMappings.$EnumSwitchMapping$0[displayMode.ordinal()]) {
            case 1: {
                string2 = "automatic";
                break;
            }
            case 2: {
                string2 = "web";
                break;
            }
            case 3: {
                string2 = "native";
                break;
            }
            default: {
                string2 = "unknown";
            }
        }
        String displayType = string2;
        String contentType = null;
        DialogFeature dialogFeature = ShareDialog.Companion.getFeature(content.getClass());
        contentType = dialogFeature == ShareDialogFeature.SHARE_DIALOG ? "status" : (dialogFeature == ShareDialogFeature.PHOTOS ? "photo" : (dialogFeature == ShareDialogFeature.VIDEO ? "video" : "unknown"));
        InternalAppEventsLogger logger = InternalAppEventsLogger.Companion.createInstance(context, FacebookSdk.getApplicationId());
        Bundle parameters = new Bundle();
        parameters.putString("fb_share_dialog_show", displayType);
        parameters.putString("fb_share_dialog_content_type", contentType);
        logger.logEventImplicitly("fb_share_dialog_show", parameters);
    }

    @JvmStatic
    public static void show(@NotNull Activity activity, @NotNull ShareContent<?, ?> shareContent) {
        Companion.show(activity, shareContent);
    }

    @JvmStatic
    public static void show(@NotNull androidx.fragment.app.Fragment fragment, @NotNull ShareContent<?, ?> shareContent) {
        Companion.show(fragment, shareContent);
    }

    @JvmStatic
    public static void show(@NotNull Fragment fragment, @NotNull ShareContent<?, ?> shareContent) {
        Companion.show(fragment, shareContent);
    }

    @JvmStatic
    public static boolean canShow(@NotNull Class<? extends ShareContent<?, ?>> contentType) {
        return Companion.canShow(contentType);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u001a0\u0001R\u0016\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u0012\u0004\u0012\u00020\u00040\u0002B\u0005\u00a2\u0006\u0002\u0010\u0005J \u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00032\u0006\u0010\u000f\u001a\u00020\rH\u0016J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u000e\u0010\u000e\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003H\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lcom/facebook/share/widget/ShareDialog$CameraEffectHandler;", "Lcom/facebook/internal/FacebookDialogBase$ModeHandler;", "Lcom/facebook/internal/FacebookDialogBase;", "Lcom/facebook/share/model/ShareContent;", "Lcom/facebook/share/Sharer$Result;", "(Lcom/facebook/share/widget/ShareDialog;)V", "mode", "", "getMode", "()Ljava/lang/Object;", "setMode", "(Ljava/lang/Object;)V", "canShow", "", "content", "isBestEffort", "createAppCall", "Lcom/facebook/internal/AppCall;", "facebook-common_release"})
    private final class CameraEffectHandler
    extends FacebookDialogBase.ModeHandler {
        @NotNull
        private Object mode = Mode.NATIVE;

        @Override
        @NotNull
        public Object getMode() {
            return this.mode;
        }

        @Override
        public void setMode(@NotNull Object object) {
            Intrinsics.checkNotNullParameter((Object)object, (String)"<set-?>");
            this.mode = object;
        }

        public boolean canShow(@NotNull ShareContent<?, ?> content, boolean isBestEffort) {
            Intrinsics.checkNotNullParameter(content, (String)"content");
            boolean canShowResult = content instanceof ShareCameraEffectContent;
            return canShowResult && Companion.canShowNative(content.getClass());
        }

        @Nullable
        public AppCall createAppCall(@NotNull ShareContent<?, ?> content) {
            Intrinsics.checkNotNullParameter(content, (String)"content");
            ShareContentValidation.validateForNativeShare(content);
            AppCall appCall = ShareDialog.this.createBaseAppCall();
            boolean shouldFailOnDataError = ShareDialog.this.getShouldFailOnDataError();
            DialogFeature dialogFeature = Companion.getFeature(content.getClass());
            if (dialogFeature == null) {
                return null;
            }
            DialogFeature feature = dialogFeature;
            DialogPresenter.setupAppCallForNativeDialog(appCall, new DialogPresenter.ParameterProvider(appCall, content, shouldFailOnDataError){
                final /* synthetic */ AppCall $appCall;
                final /* synthetic */ ShareContent<?, ?> $content;
                final /* synthetic */ boolean $shouldFailOnDataError;
                {
                    this.$appCall = $appCall;
                    this.$content = $content;
                    this.$shouldFailOnDataError = $shouldFailOnDataError;
                }

                @Nullable
                public Bundle getParameters() {
                    return NativeDialogParameters.create(this.$appCall.getCallId(), this.$content, this.$shouldFailOnDataError);
                }

                @Nullable
                public Bundle getLegacyParameters() {
                    return LegacyNativeDialogParameters.create(this.$appCall.getCallId(), this.$content, this.$shouldFailOnDataError);
                }
            }, feature);
            return appCall;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u000b\u001a\u00020\f2\u0016\u0010\r\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000f0\u000eH\u0017J \u0010\u0010\u001a\u00020\f2\u0016\u0010\r\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000f0\u000eH\u0002J\u0018\u0010\u0011\u001a\u00020\f2\u000e\u0010\u0012\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000fH\u0002J \u0010\u0013\u001a\u00020\f2\u0016\u0010\r\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000f0\u000eH\u0002J\"\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0016\u0010\r\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000f0\u000eH\u0002J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u000e\u0010\u001a\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000fH\u0017J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001c2\u000e\u0010\u001a\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000fH\u0017J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001d2\u000e\u0010\u001a\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000fH\u0017J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\u000e\u0010\u001a\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \b*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/facebook/share/widget/ShareDialog$Companion;", "", "()V", "DEFAULT_REQUEST_CODE", "", "FEED_DIALOG", "", "TAG", "kotlin.jvm.PlatformType", "WEB_OG_SHARE_DIALOG", "WEB_SHARE_DIALOG", "canShow", "", "contentType", "Ljava/lang/Class;", "Lcom/facebook/share/model/ShareContent;", "canShowNative", "canShowWebCheck", "content", "canShowWebTypeCheck", "getFeature", "Lcom/facebook/internal/DialogFeature;", "show", "", "activity", "Landroid/app/Activity;", "shareContent", "fragment", "Landroid/app/Fragment;", "Landroidx/fragment/app/Fragment;", "fragmentWrapper", "Lcom/facebook/internal/FragmentWrapper;", "facebook-common_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public void show(@NotNull Activity activity, @NotNull ShareContent<?, ?> shareContent) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            Intrinsics.checkNotNullParameter(shareContent, (String)"shareContent");
            new ShareDialog(activity).show(shareContent);
        }

        @JvmStatic
        public void show(@NotNull androidx.fragment.app.Fragment fragment, @NotNull ShareContent<?, ?> shareContent) {
            Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
            Intrinsics.checkNotNullParameter(shareContent, (String)"shareContent");
            this.show(new FragmentWrapper(fragment), shareContent);
        }

        @JvmStatic
        public void show(@NotNull Fragment fragment, @NotNull ShareContent<?, ?> shareContent) {
            Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
            Intrinsics.checkNotNullParameter(shareContent, (String)"shareContent");
            this.show(new FragmentWrapper(fragment), shareContent);
        }

        private final void show(FragmentWrapper fragmentWrapper, ShareContent<?, ?> shareContent) {
            new ShareDialog(fragmentWrapper, 0, 2, null).show(shareContent);
        }

        @JvmStatic
        public boolean canShow(@NotNull Class<? extends ShareContent<?, ?>> contentType) {
            Intrinsics.checkNotNullParameter(contentType, (String)"contentType");
            return this.canShowWebTypeCheck(contentType) || this.canShowNative(contentType);
        }

        private final boolean canShowNative(Class<? extends ShareContent<?, ?>> contentType) {
            DialogFeature feature = this.getFeature(contentType);
            return feature != null && DialogPresenter.canPresentNativeDialogWithFeature(feature);
        }

        private final boolean canShowWebTypeCheck(Class<? extends ShareContent<?, ?>> contentType) {
            return ShareLinkContent.class.isAssignableFrom(contentType) || SharePhotoContent.class.isAssignableFrom(contentType) && AccessToken.Companion.isCurrentAccessTokenActive();
        }

        private final boolean canShowWebCheck(ShareContent<?, ?> content) {
            return this.canShowWebTypeCheck(content.getClass());
        }

        private final DialogFeature getFeature(Class<? extends ShareContent<?, ?>> contentType) {
            return ShareLinkContent.class.isAssignableFrom(contentType) ? (DialogFeature)ShareDialogFeature.SHARE_DIALOG : (SharePhotoContent.class.isAssignableFrom(contentType) ? (DialogFeature)ShareDialogFeature.PHOTOS : (ShareVideoContent.class.isAssignableFrom(contentType) ? (DialogFeature)ShareDialogFeature.VIDEO : (ShareMediaContent.class.isAssignableFrom(contentType) ? (DialogFeature)ShareDialogFeature.MULTIMEDIA : (ShareCameraEffectContent.class.isAssignableFrom(contentType) ? (DialogFeature)CameraEffectFeature.SHARE_CAMERA_EFFECT : (ShareStoryContent.class.isAssignableFrom(contentType) ? (DialogFeature)ShareStoryFeature.SHARE_STORY_ASSET : null)))));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u001a0\u0001R\u0016\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u0012\u0004\u0012\u00020\u00040\u0002B\u0005\u00a2\u0006\u0002\u0010\u0005J \u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00032\u0006\u0010\u000f\u001a\u00020\rH\u0016J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u000e\u0010\u000e\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003H\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lcom/facebook/share/widget/ShareDialog$FeedHandler;", "Lcom/facebook/internal/FacebookDialogBase$ModeHandler;", "Lcom/facebook/internal/FacebookDialogBase;", "Lcom/facebook/share/model/ShareContent;", "Lcom/facebook/share/Sharer$Result;", "(Lcom/facebook/share/widget/ShareDialog;)V", "mode", "", "getMode", "()Ljava/lang/Object;", "setMode", "(Ljava/lang/Object;)V", "canShow", "", "content", "isBestEffort", "createAppCall", "Lcom/facebook/internal/AppCall;", "facebook-common_release"})
    private final class FeedHandler
    extends FacebookDialogBase.ModeHandler {
        @NotNull
        private Object mode = Mode.FEED;

        @Override
        @NotNull
        public Object getMode() {
            return this.mode;
        }

        @Override
        public void setMode(@NotNull Object object) {
            Intrinsics.checkNotNullParameter((Object)object, (String)"<set-?>");
            this.mode = object;
        }

        public boolean canShow(@NotNull ShareContent<?, ?> content, boolean isBestEffort) {
            Intrinsics.checkNotNullParameter(content, (String)"content");
            return content instanceof ShareLinkContent || content instanceof ShareFeedContent;
        }

        @Nullable
        public AppCall createAppCall(@NotNull ShareContent<?, ?> content) {
            Bundle bundle;
            Intrinsics.checkNotNullParameter(content, (String)"content");
            ShareDialog.this.logDialogShare((Context)ShareDialog.this.getActivityContext(), content, Mode.FEED);
            AppCall appCall = ShareDialog.this.createBaseAppCall();
            ShareContent<?, ?> shareContent = content;
            if (shareContent instanceof ShareLinkContent) {
                ShareContentValidation.validateForWebShare(content);
                bundle = WebDialogParameters.createForFeed((ShareLinkContent)content);
            } else if (shareContent instanceof ShareFeedContent) {
                bundle = WebDialogParameters.createForFeed((ShareFeedContent)content);
            } else {
                return null;
            }
            Bundle params = bundle;
            DialogPresenter.setupAppCallForWebDialog(appCall, ShareDialog.FEED_DIALOG, params);
            return appCall;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/facebook/share/widget/ShareDialog$Mode;", "", "(Ljava/lang/String;I)V", "AUTOMATIC", "NATIVE", "WEB", "FEED", "facebook-common_release"})
    public static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode AUTOMATIC = new Mode();
        public static final /* enum */ Mode NATIVE = new Mode();
        public static final /* enum */ Mode WEB = new Mode();
        public static final /* enum */ Mode FEED = new Mode();
        private static final /* synthetic */ Mode[] $VALUES;

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String value) {
            return Enum.valueOf(Mode.class, value);
        }

        static {
            $VALUES = modeArray = new Mode[]{Mode.AUTOMATIC, Mode.NATIVE, Mode.WEB, Mode.FEED};
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u001a0\u0001R\u0016\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u0012\u0004\u0012\u00020\u00040\u0002B\u0005\u00a2\u0006\u0002\u0010\u0005J \u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00032\u0006\u0010\u000f\u001a\u00020\rH\u0016J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u000e\u0010\u000e\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003H\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lcom/facebook/share/widget/ShareDialog$NativeHandler;", "Lcom/facebook/internal/FacebookDialogBase$ModeHandler;", "Lcom/facebook/internal/FacebookDialogBase;", "Lcom/facebook/share/model/ShareContent;", "Lcom/facebook/share/Sharer$Result;", "(Lcom/facebook/share/widget/ShareDialog;)V", "mode", "", "getMode", "()Ljava/lang/Object;", "setMode", "(Ljava/lang/Object;)V", "canShow", "", "content", "isBestEffort", "createAppCall", "Lcom/facebook/internal/AppCall;", "facebook-common_release"})
    private final class NativeHandler
    extends FacebookDialogBase.ModeHandler {
        @NotNull
        private Object mode = Mode.NATIVE;

        @Override
        @NotNull
        public Object getMode() {
            return this.mode;
        }

        @Override
        public void setMode(@NotNull Object object) {
            Intrinsics.checkNotNullParameter((Object)object, (String)"<set-?>");
            this.mode = object;
        }

        public boolean canShow(@NotNull ShareContent<?, ?> content, boolean isBestEffort) {
            Intrinsics.checkNotNullParameter(content, (String)"content");
            if (content instanceof ShareCameraEffectContent || content instanceof ShareStoryContent) {
                return false;
            }
            boolean canShowResult = true;
            if (!isBestEffort) {
                CharSequence charSequence;
                if (content.getShareHashtag() != null) {
                    canShowResult = DialogPresenter.canPresentNativeDialogWithFeature(ShareDialogFeature.HASHTAG);
                }
                if (content instanceof ShareLinkContent && !((charSequence = (CharSequence)((ShareLinkContent)content).getQuote()) == null || charSequence.length() == 0)) {
                    canShowResult = canShowResult && DialogPresenter.canPresentNativeDialogWithFeature(ShareDialogFeature.LINK_SHARE_QUOTES);
                }
            }
            return canShowResult && Companion.canShowNative(content.getClass());
        }

        @Nullable
        public AppCall createAppCall(@NotNull ShareContent<?, ?> content) {
            Intrinsics.checkNotNullParameter(content, (String)"content");
            ShareDialog.this.logDialogShare((Context)ShareDialog.this.getActivityContext(), content, Mode.NATIVE);
            ShareContentValidation.validateForNativeShare(content);
            AppCall appCall = ShareDialog.this.createBaseAppCall();
            boolean shouldFailOnDataError = ShareDialog.this.getShouldFailOnDataError();
            DialogFeature dialogFeature = Companion.getFeature(content.getClass());
            if (dialogFeature == null) {
                return null;
            }
            DialogFeature feature = dialogFeature;
            DialogPresenter.setupAppCallForNativeDialog(appCall, new DialogPresenter.ParameterProvider(appCall, content, shouldFailOnDataError){
                final /* synthetic */ AppCall $appCall;
                final /* synthetic */ ShareContent<?, ?> $content;
                final /* synthetic */ boolean $shouldFailOnDataError;
                {
                    this.$appCall = $appCall;
                    this.$content = $content;
                    this.$shouldFailOnDataError = $shouldFailOnDataError;
                }

                @Nullable
                public Bundle getParameters() {
                    return NativeDialogParameters.create(this.$appCall.getCallId(), this.$content, this.$shouldFailOnDataError);
                }

                @Nullable
                public Bundle getLegacyParameters() {
                    return LegacyNativeDialogParameters.create(this.$appCall.getCallId(), this.$content, this.$shouldFailOnDataError);
                }
            }, feature);
            return appCall;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u001a0\u0001R\u0016\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u0012\u0004\u0012\u00020\u00040\u0002B\u0005\u00a2\u0006\u0002\u0010\u0005J \u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00032\u0006\u0010\u000f\u001a\u00020\rH\u0016J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u000e\u0010\u000e\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003H\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lcom/facebook/share/widget/ShareDialog$ShareStoryHandler;", "Lcom/facebook/internal/FacebookDialogBase$ModeHandler;", "Lcom/facebook/internal/FacebookDialogBase;", "Lcom/facebook/share/model/ShareContent;", "Lcom/facebook/share/Sharer$Result;", "(Lcom/facebook/share/widget/ShareDialog;)V", "mode", "", "getMode", "()Ljava/lang/Object;", "setMode", "(Ljava/lang/Object;)V", "canShow", "", "content", "isBestEffort", "createAppCall", "Lcom/facebook/internal/AppCall;", "facebook-common_release"})
    private final class ShareStoryHandler
    extends FacebookDialogBase.ModeHandler {
        @NotNull
        private Object mode = Mode.NATIVE;

        @Override
        @NotNull
        public Object getMode() {
            return this.mode;
        }

        @Override
        public void setMode(@NotNull Object object) {
            Intrinsics.checkNotNullParameter((Object)object, (String)"<set-?>");
            this.mode = object;
        }

        public boolean canShow(@NotNull ShareContent<?, ?> content, boolean isBestEffort) {
            Intrinsics.checkNotNullParameter(content, (String)"content");
            boolean canShowResult = content instanceof ShareStoryContent;
            return canShowResult && Companion.canShowNative(content.getClass());
        }

        @Nullable
        public AppCall createAppCall(@NotNull ShareContent<?, ?> content) {
            Intrinsics.checkNotNullParameter(content, (String)"content");
            ShareContentValidation.validateForStoryShare(content);
            AppCall appCall = ShareDialog.this.createBaseAppCall();
            boolean shouldFailOnDataError = ShareDialog.this.getShouldFailOnDataError();
            DialogFeature dialogFeature = Companion.getFeature(content.getClass());
            if (dialogFeature == null) {
                return null;
            }
            DialogFeature feature = dialogFeature;
            DialogPresenter.setupAppCallForNativeDialog(appCall, new DialogPresenter.ParameterProvider(appCall, content, shouldFailOnDataError){
                final /* synthetic */ AppCall $appCall;
                final /* synthetic */ ShareContent<?, ?> $content;
                final /* synthetic */ boolean $shouldFailOnDataError;
                {
                    this.$appCall = $appCall;
                    this.$content = $content;
                    this.$shouldFailOnDataError = $shouldFailOnDataError;
                }

                @Nullable
                public Bundle getParameters() {
                    return NativeDialogParameters.create(this.$appCall.getCallId(), this.$content, this.$shouldFailOnDataError);
                }

                @Nullable
                public Bundle getLegacyParameters() {
                    return LegacyNativeDialogParameters.create(this.$appCall.getCallId(), this.$content, this.$shouldFailOnDataError);
                }
            }, feature);
            return appCall;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u001a0\u0001R\u0016\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u0012\u0004\u0012\u00020\u00040\u0002B\u0005\u00a2\u0006\u0002\u0010\u0005J \u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00032\u0006\u0010\u000f\u001a\u00020\rH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u000e\u0010\u000e\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003H\u0016J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u000e\u0010\u0018\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003H\u0002R\u001a\u0010\u0006\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/facebook/share/widget/ShareDialog$WebShareHandler;", "Lcom/facebook/internal/FacebookDialogBase$ModeHandler;", "Lcom/facebook/internal/FacebookDialogBase;", "Lcom/facebook/share/model/ShareContent;", "Lcom/facebook/share/Sharer$Result;", "(Lcom/facebook/share/widget/ShareDialog;)V", "mode", "", "getMode", "()Ljava/lang/Object;", "setMode", "(Ljava/lang/Object;)V", "canShow", "", "content", "isBestEffort", "createAndMapAttachments", "Lcom/facebook/share/model/SharePhotoContent;", "callId", "Ljava/util/UUID;", "createAppCall", "Lcom/facebook/internal/AppCall;", "getActionName", "", "shareContent", "facebook-common_release"})
    private final class WebShareHandler
    extends FacebookDialogBase.ModeHandler {
        @NotNull
        private Object mode = Mode.WEB;

        @Override
        @NotNull
        public Object getMode() {
            return this.mode;
        }

        @Override
        public void setMode(@NotNull Object object) {
            Intrinsics.checkNotNullParameter((Object)object, (String)"<set-?>");
            this.mode = object;
        }

        public boolean canShow(@NotNull ShareContent<?, ?> content, boolean isBestEffort) {
            Intrinsics.checkNotNullParameter(content, (String)"content");
            return Companion.canShowWebCheck(content);
        }

        @Nullable
        public AppCall createAppCall(@NotNull ShareContent<?, ?> content) {
            Bundle bundle;
            Intrinsics.checkNotNullParameter(content, (String)"content");
            ShareDialog.this.logDialogShare((Context)ShareDialog.this.getActivityContext(), content, Mode.WEB);
            AppCall appCall = ShareDialog.this.createBaseAppCall();
            ShareContentValidation.validateForWebShare(content);
            ShareContent<?, ?> shareContent = content;
            if (shareContent instanceof ShareLinkContent) {
                bundle = WebDialogParameters.create((ShareLinkContent)content);
            } else if (shareContent instanceof SharePhotoContent) {
                SharePhotoContent photoContent = this.createAndMapAttachments((SharePhotoContent)content, appCall.getCallId());
                bundle = WebDialogParameters.create(photoContent);
            } else {
                return null;
            }
            Bundle params = bundle;
            DialogPresenter.setupAppCallForWebDialog(appCall, this.getActionName(content), params);
            return appCall;
        }

        private final String getActionName(ShareContent<?, ?> shareContent) {
            return shareContent instanceof ShareLinkContent || shareContent instanceof SharePhotoContent ? ShareDialog.WEB_SHARE_DIALOG : null;
        }

        private final SharePhotoContent createAndMapAttachments(SharePhotoContent content, UUID callId) {
            SharePhotoContent.Builder contentBuilder = new SharePhotoContent.Builder().readFrom(content);
            List photos = new ArrayList();
            List attachments = new ArrayList();
            int n = content.getPhotos().size();
            for (int i = 0; i < n; ++i) {
                SharePhoto sharePhoto = content.getPhotos().get(i);
                Bitmap photoBitmap = sharePhoto.getBitmap();
                if (photoBitmap != null) {
                    NativeAppCallAttachmentStore.Attachment attachment = NativeAppCallAttachmentStore.createAttachment((UUID)callId, (Bitmap)photoBitmap);
                    sharePhoto = new SharePhoto.Builder().readFrom(sharePhoto).setImageUrl(Uri.parse((String)attachment.getAttachmentUrl())).setBitmap(null).build();
                    attachments.add(attachment);
                }
                photos.add(sharePhoto);
            }
            contentBuilder.setPhotos(photos);
            NativeAppCallAttachmentStore.addAttachments((Collection)attachments);
            return contentBuilder.build();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Mode.values().length];
            try {
                nArray[Mode.AUTOMATIC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Mode.WEB.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Mode.NATIVE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

