/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import androidx.annotation.VisibleForTesting;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.FragmentActivity;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.internal.FacebookWebFallbackDialog;
import com.facebook.internal.NativeProtocol;
import com.facebook.internal.Utility;
import com.facebook.internal.WebDialog;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\r\u0010\t\u001a\u00020\nH\u0001\u00a2\u0006\u0002\b\u000bJ\u001c\u0010\f\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0012\u0010\u0011\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u00020\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000eH\u0016J\u0012\u0010\u0017\u001a\u00020\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010\u0018\u001a\u00020\nH\u0016J\b\u0010\u0019\u001a\u00020\nH\u0016R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u001b"}, d2={"Lcom/facebook/internal/FacebookDialogFragment;", "Landroidx/fragment/app/DialogFragment;", "()V", "innerDialog", "Landroid/app/Dialog;", "getInnerDialog", "()Landroid/app/Dialog;", "setInnerDialog", "(Landroid/app/Dialog;)V", "initDialog", "", "initDialog$facebook_common_release", "onCompleteWebDialog", "values", "Landroid/os/Bundle;", "error", "Lcom/facebook/FacebookException;", "onCompleteWebFallbackDialog", "onConfigurationChanged", "newConfig", "Landroid/content/res/Configuration;", "onCreate", "savedInstanceState", "onCreateDialog", "onDestroyView", "onResume", "Companion", "facebook-common_release"})
public final class FacebookDialogFragment
extends DialogFragment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Dialog innerDialog;
    @NotNull
    public static final String TAG = "FacebookDialogFragment";

    @Nullable
    public final Dialog getInnerDialog() {
        return this.innerDialog;
    }

    public final void setInnerDialog(@Nullable Dialog dialog2) {
        this.innerDialog = dialog2;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.initDialog$facebook_common_release();
    }

    @VisibleForTesting
    public final void initDialog$facebook_common_release() {
        Bundle params;
        if (this.innerDialog != null) {
            return;
        }
        FragmentActivity fragmentActivity = this.getActivity();
        if (fragmentActivity == null) {
            return;
        }
        FragmentActivity activity = fragmentActivity;
        Intent intent = activity.getIntent();
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"intent");
        Bundle bundle = params = NativeProtocol.getMethodArgumentsFromIntent((Intent)intent);
        boolean isWebFallback = bundle != null ? bundle.getBoolean("is_fallback", false) : false;
        WebDialog webDialog = null;
        if (!isWebFallback) {
            Bundle webParams;
            Bundle bundle2 = params;
            String actionName = bundle2 != null ? bundle2.getString("action") : null;
            Bundle bundle3 = params;
            Object object = webParams = bundle3 != null ? bundle3.getBundle("params") : null;
            if (Utility.isNullOrEmpty((String)actionName)) {
                Utility.logd((String)TAG, (String)"Cannot start a WebDialog with an empty/missing 'actionName'");
                activity.finish();
                return;
            }
            Context context = (Context)activity;
            Intrinsics.checkNotNull((Object)actionName, (String)"null cannot be cast to non-null type kotlin.String");
            webDialog = new WebDialog.Builder(context, actionName, webParams).setOnCompleteListener((arg_0, arg_1) -> FacebookDialogFragment.initDialog$lambda$0(this, arg_0, arg_1)).build();
        } else {
            String url;
            Bundle bundle4 = params;
            String string2 = url = bundle4 != null ? bundle4.getString("url") : null;
            if (Utility.isNullOrEmpty((String)url)) {
                Utility.logd((String)TAG, (String)"Cannot start a fallback WebDialog with an empty/missing 'url'");
                activity.finish();
                return;
            }
            String string3 = "fb%s://bridge/";
            Object[] objectArray = new Object[]{FacebookSdk.getApplicationId()};
            String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(format, *args)");
            String redirectUrl = string4;
            Context context = (Context)activity;
            Intrinsics.checkNotNull((Object)url, (String)"null cannot be cast to non-null type kotlin.String");
            webDialog = FacebookWebFallbackDialog.Companion.newInstance(context, url, redirectUrl);
            ((FacebookWebFallbackDialog)webDialog).setOnCompleteListener((arg_0, arg_1) -> FacebookDialogFragment.initDialog$lambda$1(this, arg_0, arg_1));
        }
        this.innerDialog = webDialog;
    }

    @NotNull
    public Dialog onCreateDialog(@Nullable Bundle savedInstanceState) {
        if (this.innerDialog == null) {
            this.onCompleteWebDialog(null, null);
            this.setShowsDialog(false);
            Dialog dialog2 = super.onCreateDialog(savedInstanceState);
            Intrinsics.checkNotNullExpressionValue((Object)dialog2, (String)"super.onCreateDialog(savedInstanceState)");
            return dialog2;
        }
        Dialog dialog3 = this.innerDialog;
        Intrinsics.checkNotNull((Object)dialog3, (String)"null cannot be cast to non-null type android.app.Dialog");
        return dialog3;
    }

    public void onResume() {
        super.onResume();
        if (this.innerDialog instanceof WebDialog) {
            Dialog dialog2 = this.innerDialog;
            Intrinsics.checkNotNull((Object)dialog2, (String)"null cannot be cast to non-null type com.facebook.internal.WebDialog");
            ((WebDialog)dialog2).resize();
        }
    }

    public void onConfigurationChanged(@NotNull Configuration newConfig) {
        Intrinsics.checkNotNullParameter((Object)newConfig, (String)"newConfig");
        super.onConfigurationChanged(newConfig);
        if (this.innerDialog instanceof WebDialog && this.isResumed()) {
            Dialog dialog2 = this.innerDialog;
            Intrinsics.checkNotNull((Object)dialog2, (String)"null cannot be cast to non-null type com.facebook.internal.WebDialog");
            ((WebDialog)dialog2).resize();
        }
    }

    public void onDestroyView() {
        Dialog dialog2 = this.getDialog();
        if (dialog2 != null && this.getRetainInstance()) {
            dialog2.setDismissMessage(null);
        }
        super.onDestroyView();
    }

    private final void onCompleteWebDialog(Bundle values, FacebookException error) {
        FragmentActivity fragmentActivity = this.getActivity();
        if (fragmentActivity == null) {
            return;
        }
        FragmentActivity fragmentActivity2 = fragmentActivity;
        Intent intent = fragmentActivity2.getIntent();
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"fragmentActivity.intent");
        Intent resultIntent = NativeProtocol.createProtocolResultIntent((Intent)intent, (Bundle)values, (FacebookException)error);
        int resultCode = error == null ? -1 : 0;
        fragmentActivity2.setResult(resultCode, resultIntent);
        fragmentActivity2.finish();
    }

    private final void onCompleteWebFallbackDialog(Bundle values) {
        FragmentActivity fragmentActivity = this.getActivity();
        if (fragmentActivity == null) {
            return;
        }
        FragmentActivity fragmentActivity2 = fragmentActivity;
        Intent resultIntent = new Intent();
        Bundle bundle = values;
        if (bundle == null) {
            bundle = new Bundle();
        }
        resultIntent.putExtras(bundle);
        fragmentActivity2.setResult(-1, resultIntent);
        fragmentActivity2.finish();
    }

    private static final void initDialog$lambda$0(FacebookDialogFragment this$0, Bundle values, FacebookException error) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.onCompleteWebDialog(values, error);
    }

    private static final void initDialog$lambda$1(FacebookDialogFragment this$0, Bundle values, FacebookException facebookException) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.onCompleteWebFallbackDialog(values);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/facebook/internal/FacebookDialogFragment$Companion;", "", "()V", "TAG", "", "facebook-common_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

