/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.content.Intent;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0013\u001a\u00020\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lcom/facebook/internal/AppCall;", "", "requestCode", "", "callId", "Ljava/util/UUID;", "(ILjava/util/UUID;)V", "getCallId", "()Ljava/util/UUID;", "getRequestCode", "()I", "setRequestCode", "(I)V", "requestIntent", "Landroid/content/Intent;", "getRequestIntent", "()Landroid/content/Intent;", "setRequestIntent", "(Landroid/content/Intent;)V", "setPending", "", "Companion", "facebook-common_release"})
public final class AppCall {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int requestCode;
    @NotNull
    private final UUID callId;
    @Nullable
    private Intent requestIntent;
    @Nullable
    private static AppCall currentPendingCall;

    @JvmOverloads
    public AppCall(int requestCode, @NotNull UUID callId) {
        Intrinsics.checkNotNullParameter((Object)callId, (String)"callId");
        this.requestCode = requestCode;
        this.callId = callId;
    }

    public /* synthetic */ AppCall(int n, UUID uUID, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            UUID uUID2 = UUID.randomUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"randomUUID()");
            uUID = uUID2;
        }
        this(n, uUID);
    }

    public final int getRequestCode() {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return 0;
        }
        try {
            return this.requestCode;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setRequestCode(int n) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void <set-?>;
            this.requestCode = <set-?>;
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return;
        }
    }

    @NotNull
    public final UUID getCallId() {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return null;
        }
        try {
            return this.callId;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return null;
        }
    }

    @Nullable
    public final Intent getRequestIntent() {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return null;
        }
        try {
            return this.requestIntent;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setRequestIntent(@Nullable Intent intent) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void <set-?>;
            this.requestIntent = <set-?>;
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return;
        }
    }

    public final boolean setPending() {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return false;
        }
        try {
            return AppCall.Companion.setCurrentPendingCall(this);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return false;
        }
    }

    @JvmOverloads
    public AppCall(int requestCode) {
        this(requestCode, null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final synchronized AppCall finishPendingCall(@NotNull UUID uUID, int n) {
        if (CrashShieldHandler.isObjectCrashing(AppCall.class)) {
            return null;
        }
        try {
            void requestCode;
            UUID callId;
            return Companion.finishPendingCall(callId, (int)requestCode);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, AppCall.class);
            return null;
        }
    }

    public static final /* synthetic */ AppCall access$getCurrentPendingCall$cp() {
        if (CrashShieldHandler.isObjectCrashing(AppCall.class)) {
            return null;
        }
        try {
            return currentPendingCall;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, AppCall.class);
            return null;
        }
    }

    public static final /* synthetic */ void access$setCurrentPendingCall$cp(AppCall appCall) {
        if (CrashShieldHandler.isObjectCrashing(AppCall.class)) {
            return;
        }
        try {
            AppCall appCall2;
            currentPendingCall = appCall2;
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, AppCall.class);
            return;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004H\u0002R\"\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/facebook/internal/AppCall$Companion;", "", "()V", "<set-?>", "Lcom/facebook/internal/AppCall;", "currentPendingCall", "getCurrentPendingCall", "()Lcom/facebook/internal/AppCall;", "finishPendingCall", "callId", "Ljava/util/UUID;", "requestCode", "", "setCurrentPendingCall", "", "appCall", "facebook-common_release"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final AppCall getCurrentPendingCall() {
            return AppCall.access$getCurrentPendingCall$cp();
        }

        @JvmStatic
        @Nullable
        public final synchronized AppCall finishPendingCall(@NotNull UUID callId, int requestCode) {
            Intrinsics.checkNotNullParameter((Object)callId, (String)"callId");
            AppCall pendingCall = this.getCurrentPendingCall();
            if (pendingCall == null || !Intrinsics.areEqual((Object)pendingCall.getCallId(), (Object)callId) || pendingCall.getRequestCode() != requestCode) {
                return null;
            }
            this.setCurrentPendingCall(null);
            return pendingCall;
        }

        private final synchronized boolean setCurrentPendingCall(AppCall appCall) {
            AppCall oldAppCall = this.getCurrentPendingCall();
            AppCall.access$setCurrentPendingCall$cp(appCall);
            return oldAppCall != null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

