/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import androidx.browser.customtabs.CustomTabsIntent;
import androidx.browser.customtabs.CustomTabsSession;
import com.facebook.FacebookSdk;
import com.facebook.internal.ServerProtocol;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import com.facebook.login.CustomTabPrefetchHelper;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0003R\u001a\u0010\u0007\u001a\u00020\bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/facebook/internal/CustomTab;", "", "action", "", "parameters", "Landroid/os/Bundle;", "(Ljava/lang/String;Landroid/os/Bundle;)V", "uri", "Landroid/net/Uri;", "getUri", "()Landroid/net/Uri;", "setUri", "(Landroid/net/Uri;)V", "openCustomTab", "", "activity", "Landroid/app/Activity;", "packageName", "Companion", "facebook-common_release"})
public class CustomTab {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Uri uri;

    public CustomTab(@NotNull String action, @Nullable Bundle parameters) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Bundle parameters2 = parameters;
        if (parameters2 == null) {
            parameters2 = new Bundle();
        }
        this.uri = Intrinsics.areEqual((Object)action, (Object)"context_choose") ? Utility.buildUri((String)ServerProtocol.INSTANCE.getGamingDialogAuthority(), (String)Intrinsics.stringPlus((String)"/dialog/", (Object)action), (Bundle)parameters2) : Companion.getURIForAction(action, parameters2);
    }

    @NotNull
    protected final Uri getUri() {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return null;
        }
        try {
            return this.uri;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final void setUri(@NotNull Uri uri) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void <set-?>;
            Intrinsics.checkNotNullParameter((Object)<set-?>, (String)"<set-?>");
            this.uri = <set-?>;
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean openCustomTab(@NotNull Activity activity, @Nullable String string) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return false;
        }
        try {
            void packageName;
            void activity2;
            Intrinsics.checkNotNullParameter((Object)activity2, (String)"activity");
            CustomTabsSession session = CustomTabPrefetchHelper.Companion.getPreparedSessionOnce();
            CustomTabsIntent customTabsIntent = new CustomTabsIntent.Builder(session).build();
            customTabsIntent.intent.setPackage((String)packageName);
            try {
                customTabsIntent.launchUrl((Context)activity2, this.uri);
            }
            catch (ActivityNotFoundException e) {
                return false;
            }
            return true;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static Uri getURIForAction(@NotNull String string, @Nullable Bundle bundle) {
        if (CrashShieldHandler.isObjectCrashing(CustomTab.class)) {
            return null;
        }
        try {
            void parameters;
            String action;
            return Companion.getURIForAction(action, (Bundle)parameters);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, CustomTab.class);
            return null;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0017\u00a8\u0006\t"}, d2={"Lcom/facebook/internal/CustomTab$Companion;", "", "()V", "getURIForAction", "Landroid/net/Uri;", "action", "", "parameters", "Landroid/os/Bundle;", "facebook-common_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public Uri getURIForAction(@NotNull String action, @Nullable Bundle parameters) {
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            return Utility.buildUri((String)ServerProtocol.INSTANCE.getDialogAuthority(), (String)(FacebookSdk.INSTANCE.getGraphApiVersion() + "/dialog/" + action), (Bundle)parameters);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

