/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.login;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.Html;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import androidx.annotation.LayoutRes;
import androidx.annotation.VisibleForTesting;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.FragmentActivity;
import com.facebook.AccessToken;
import com.facebook.AccessTokenSource;
import com.facebook.FacebookActivity;
import com.facebook.FacebookException;
import com.facebook.FacebookRequestError;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.GraphRequestAsyncTask;
import com.facebook.GraphResponse;
import com.facebook.HttpMethod;
import com.facebook.appevents.InternalAppEventsLogger;
import com.facebook.common.R;
import com.facebook.devicerequests.internal.DeviceRequestsHelper;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.SmartLoginOption;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import com.facebook.login.DeviceAuthMethodHandler;
import com.facebook.login.LoginClient;
import com.facebook.login.LoginFragment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u000b\b\u0016\u0018\u0000 I2\u00020\u0001:\u0003IJKB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001cH\u0016J4\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001d2\b\u0010$\u001a\u0004\u0018\u00010%2\b\u0010&\u001a\u0004\u0018\u00010%H\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u000fH\u0015J\u0010\u0010*\u001a\u00020\u00162\u0006\u0010)\u001a\u00020\u000fH\u0014J\b\u0010+\u001a\u00020\u001fH\u0014J\b\u0010,\u001a\u00020\u001fH\u0014J\u0012\u0010-\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u000100H\u0016J&\u00101\u001a\u0004\u0018\u00010\u00162\u0006\u00102\u001a\u0002032\b\u00104\u001a\u0004\u0018\u0001052\b\u0010/\u001a\u0004\u0018\u000100H\u0016J\b\u00106\u001a\u00020\u001fH\u0016J\u0010\u00107\u001a\u00020\u001f2\u0006\u00108\u001a\u000209H\u0016J\u0010\u0010:\u001a\u00020\u001f2\u0006\u0010;\u001a\u00020<H\u0014J\u0010\u0010=\u001a\u00020\u001f2\u0006\u0010>\u001a\u000200H\u0016J'\u0010?\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u001d2\u0006\u0010@\u001a\u00020A2\b\u0010&\u001a\u0004\u0018\u00010AH\u0002\u00a2\u0006\u0002\u0010BJ\b\u0010C\u001a\u00020\u001fH\u0002J<\u0010D\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001d2\u0006\u0010E\u001a\u00020\u001d2\b\u0010$\u001a\u0004\u0018\u00010%2\b\u0010&\u001a\u0004\u0018\u00010%H\u0002J\b\u0010F\u001a\u00020\u001fH\u0002J\u0010\u0010G\u001a\u00020\u001f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010H\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Lcom/facebook/login/DeviceAuthDialog;", "Landroidx/fragment/app/DialogFragment;", "()V", "completed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "confirmationCode", "Landroid/widget/TextView;", "currentGraphRequestPoll", "Lcom/facebook/GraphRequestAsyncTask;", "currentRequestState", "Lcom/facebook/login/DeviceAuthDialog$RequestState;", "deviceAuthMethodHandler", "Lcom/facebook/login/DeviceAuthMethodHandler;", "instructions", "isBeingDestroyed", "", "isRetry", "pollRequest", "Lcom/facebook/GraphRequest;", "getPollRequest", "()Lcom/facebook/GraphRequest;", "progressBar", "Landroid/view/View;", "request", "Lcom/facebook/login/LoginClient$Request;", "scheduledPoll", "Ljava/util/concurrent/ScheduledFuture;", "additionalDeviceInfo", "", "", "completeLogin", "", "userId", "permissions", "Lcom/facebook/login/DeviceAuthDialog$PermissionsLists;", "accessToken", "expirationTime", "Ljava/util/Date;", "dataAccessExpirationTime", "getLayoutResId", "", "isSmartLogin", "initializeContentView", "onBackButtonPressed", "onCancel", "onCreateDialog", "Landroid/app/Dialog;", "savedInstanceState", "Landroid/os/Bundle;", "onCreateView", "inflater", "Landroid/view/LayoutInflater;", "container", "Landroid/view/ViewGroup;", "onDestroyView", "onDismiss", "dialog", "Landroid/content/DialogInterface;", "onError", "ex", "Lcom/facebook/FacebookException;", "onSaveInstanceState", "outState", "onSuccess", "expiresIn", "", "(Ljava/lang/String;JLjava/lang/Long;)V", "poll", "presentConfirmation", "name", "schedulePoll", "setCurrentRequestState", "startLogin", "Companion", "PermissionsLists", "RequestState", "facebook-common_release"})
public class DeviceAuthDialog
extends DialogFragment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private View progressBar;
    private TextView confirmationCode;
    private TextView instructions;
    @Nullable
    private DeviceAuthMethodHandler deviceAuthMethodHandler;
    @NotNull
    private final AtomicBoolean completed = new AtomicBoolean();
    @Nullable
    private volatile GraphRequestAsyncTask currentGraphRequestPoll;
    @Nullable
    private volatile ScheduledFuture<?> scheduledPoll;
    @Nullable
    private volatile RequestState currentRequestState;
    private boolean isBeingDestroyed;
    private boolean isRetry;
    @Nullable
    private LoginClient.Request request;
    @NotNull
    private static final String DEVICE_LOGIN_ENDPOINT = "device/login";
    @NotNull
    private static final String DEVICE_LOGIN_STATUS_ENDPOINT = "device/login_status";
    @NotNull
    private static final String REQUEST_STATE_KEY = "request_state";
    private static final int LOGIN_ERROR_SUBCODE_EXCESSIVE_POLLING = 1349172;
    private static final int LOGIN_ERROR_SUBCODE_AUTHORIZATION_DECLINED = 1349173;
    private static final int LOGIN_ERROR_SUBCODE_AUTHORIZATION_PENDING = 1349174;
    private static final int LOGIN_ERROR_SUBCODE_CODE_EXPIRED = 1349152;

    @Nullable
    public View onCreateView(@NotNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        Object object;
        LoginFragment fragment;
        Intrinsics.checkNotNullParameter((Object)inflater, (String)"inflater");
        View view = super.onCreateView(inflater, container, savedInstanceState);
        FacebookActivity facebookActivity = (FacebookActivity)this.requireActivity();
        LoginFragment loginFragment = fragment = (LoginFragment)facebookActivity.getCurrentFragment();
        this.deviceAuthMethodHandler = (DeviceAuthMethodHandler)(loginFragment == null ? null : ((object = loginFragment.getLoginClient()) == null ? null : object.getCurrentHandler()));
        loginFragment = savedInstanceState;
        if (loginFragment != null && (object = (RequestState)loginFragment.getParcelable(REQUEST_STATE_KEY)) != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object requestState = object2;
            boolean bl3 = false;
            this.setCurrentRequestState((RequestState)requestState);
        }
        return view;
    }

    @NotNull
    public Dialog onCreateDialog(@Nullable Bundle savedInstanceState) {
        FragmentActivity fragmentActivity = this.requireActivity();
        int n = R.style.com_facebook_auth_dialog;
        Dialog dialog2 = new Dialog(this, fragmentActivity, n){
            final /* synthetic */ DeviceAuthDialog this$0;
            {
                this.this$0 = $receiver;
                super((Context)$super_call_param$1, $super_call_param$2);
            }

            public void onBackPressed() {
                this.this$0.onBackButtonPressed();
                super.onBackPressed();
            }
        };
        dialog2.setContentView(this.initializeContentView(DeviceRequestsHelper.INSTANCE.isAvailable() && !this.isRetry));
        return dialog2;
    }

    public void onDismiss(@NotNull DialogInterface dialog2) {
        Intrinsics.checkNotNullParameter((Object)dialog2, (String)"dialog");
        super.onDismiss(dialog2);
        if (!this.isBeingDestroyed) {
            this.onCancel();
        }
    }

    public void onSaveInstanceState(@NotNull Bundle outState) {
        Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
        super.onSaveInstanceState(outState);
        if (this.currentRequestState != null) {
            outState.putParcelable(REQUEST_STATE_KEY, (Parcelable)this.currentRequestState);
        }
    }

    public void onDestroyView() {
        this.isBeingDestroyed = true;
        this.completed.set(true);
        super.onDestroyView();
        Object object = this.currentGraphRequestPoll;
        if (object != null) {
            object.cancel(true);
        }
        object = this.scheduledPoll;
        if (object != null) {
            object.cancel(true);
        }
    }

    public void startLogin(@NotNull LoginClient.Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.request = request;
        Bundle parameters = new Bundle();
        parameters.putString("scope", TextUtils.join((CharSequence)",", (Iterable)request.getPermissions()));
        Utility.putNonEmptyString((Bundle)parameters, (String)"redirect_uri", (String)request.getDeviceRedirectUriString());
        Utility.putNonEmptyString((Bundle)parameters, (String)"target_user_id", (String)request.getDeviceAuthTargetUserId());
        String accessToken = Validate.INSTANCE.hasAppID() + '|' + Validate.INSTANCE.hasClientToken();
        parameters.putString("access_token", accessToken);
        Map<String, String> map = this.additionalDeviceInfo();
        parameters.putString("device_info", DeviceRequestsHelper.getDeviceInfo(map == null ? null : MapsKt.toMutableMap(map)));
        GraphRequest graphRequest = GraphRequest.Companion.newPostRequestWithBundle(null, DEVICE_LOGIN_ENDPOINT, parameters, arg_0 -> DeviceAuthDialog.startLogin$lambda-1(this, arg_0));
        graphRequest.executeAsync();
    }

    @Nullable
    public Map<String, String> additionalDeviceInfo() {
        return null;
    }

    private final void setCurrentRequestState(RequestState currentRequestState) {
        this.currentRequestState = currentRequestState;
        TextView textView = this.confirmationCode;
        if (textView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"confirmationCode");
            throw null;
        }
        textView.setText((CharSequence)currentRequestState.getUserCode());
        Bitmap bitmap = DeviceRequestsHelper.generateQRCode(currentRequestState.getAuthorizationUri());
        BitmapDrawable qrCode = new BitmapDrawable(this.getResources(), bitmap);
        TextView textView2 = this.instructions;
        if (textView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"instructions");
            throw null;
        }
        textView2.setCompoundDrawablesWithIntrinsicBounds(null, (Drawable)qrCode, null, null);
        textView2 = this.confirmationCode;
        if (textView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"confirmationCode");
            throw null;
        }
        textView2.setVisibility(0);
        textView2 = this.progressBar;
        if (textView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"progressBar");
            throw null;
        }
        textView2.setVisibility(8);
        if (!this.isRetry) {
            if (DeviceRequestsHelper.startAdvertisementService(currentRequestState.getUserCode())) {
                InternalAppEventsLogger logger = new InternalAppEventsLogger(this.getContext());
                logger.logEventImplicitly("fb_smart_login_service");
            }
        }
        if (currentRequestState.withinLastRefreshWindow()) {
            this.schedulePoll();
        } else {
            this.poll();
        }
    }

    @NotNull
    protected View initializeContentView(boolean isSmartLogin) {
        LayoutInflater view = null;
        LayoutInflater layoutInflater = this.requireActivity().getLayoutInflater();
        Intrinsics.checkNotNullExpressionValue((Object)layoutInflater, (String)"requireActivity().layoutInflater");
        LayoutInflater inflater = layoutInflater;
        layoutInflater = inflater.inflate(this.getLayoutResId(isSmartLogin), null);
        Intrinsics.checkNotNullExpressionValue((Object)layoutInflater, (String)"inflater.inflate(getLayoutResId(isSmartLogin), null)");
        view = layoutInflater;
        layoutInflater = view.findViewById(R.id.progress_bar);
        Intrinsics.checkNotNullExpressionValue((Object)layoutInflater, (String)"view.findViewById(R.id.progress_bar)");
        this.progressBar = layoutInflater;
        layoutInflater = view.findViewById(R.id.confirmation_code);
        if (layoutInflater == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.widget.TextView");
        }
        this.confirmationCode = (TextView)layoutInflater;
        View view2 = view.findViewById(R.id.cancel_button);
        if (view2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.widget.Button");
        }
        Button cancelButton = (Button)view2;
        cancelButton.setOnClickListener(arg_0 -> DeviceAuthDialog.initializeContentView$lambda-2(this, arg_0));
        view2 = view.findViewById(R.id.com_facebook_device_auth_instructions);
        if (view2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.widget.TextView");
        }
        this.instructions = (TextView)view2;
        view2 = this.instructions;
        if (view2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"instructions");
            throw null;
        }
        view2.setText((CharSequence)Html.fromHtml((String)this.getString(R.string.com_facebook_device_auth_instructions)));
        return view;
    }

    @LayoutRes
    protected int getLayoutResId(boolean isSmartLogin) {
        return isSmartLogin ? R.layout.com_facebook_smart_device_dialog_fragment : R.layout.com_facebook_device_auth_dialog_fragment;
    }

    private final void poll() {
        RequestState requestState = this.currentRequestState;
        if (requestState != null) {
            requestState.setLastPoll(new Date().getTime());
        }
        this.currentGraphRequestPoll = this.getPollRequest().executeAsync();
    }

    private final void schedulePoll() {
        Long interval;
        RequestState requestState = this.currentRequestState;
        Long l = interval = requestState == null ? null : Long.valueOf(requestState.getInterval());
        if (interval != null) {
            this.scheduledPoll = DeviceAuthMethodHandler.Companion.getBackgroundExecutor().schedule(() -> DeviceAuthDialog.schedulePoll$lambda-3(this), (long)interval, TimeUnit.SECONDS);
        }
    }

    private final GraphRequest getPollRequest() {
        Bundle parameters = new Bundle();
        RequestState requestState = this.currentRequestState;
        parameters.putString("code", requestState == null ? null : requestState.getRequestCode());
        return GraphRequest.Companion.newPostRequestWithBundle(null, DEVICE_LOGIN_STATUS_ENDPOINT, parameters, arg_0 -> DeviceAuthDialog._get_pollRequest_$lambda-5(this, arg_0));
    }

    private final void presentConfirmation(String userId, PermissionsLists permissions, String accessToken, String name, Date expirationTime, Date dataAccessExpirationTime) {
        String string2 = this.getResources().getString(R.string.com_facebook_smart_login_confirmation_title);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"resources.getString(R.string.com_facebook_smart_login_confirmation_title)");
        String message = string2;
        String string3 = this.getResources().getString(R.string.com_facebook_smart_login_confirmation_continue_as);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"resources.getString(R.string.com_facebook_smart_login_confirmation_continue_as)");
        String continueFormat = string3;
        String string4 = this.getResources().getString(R.string.com_facebook_smart_login_confirmation_cancel);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"resources.getString(R.string.com_facebook_smart_login_confirmation_cancel)");
        String cancel = string4;
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        Object[] objectArray = new Object[]{name};
        boolean bl = false;
        String string5 = String.format(continueFormat, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"java.lang.String.format(format, *args)");
        String continueText = string5;
        AlertDialog.Builder builder = new AlertDialog.Builder(this.getContext());
        builder.setMessage((CharSequence)message).setCancelable(true).setNegativeButton((CharSequence)continueText, (arg_0, arg_1) -> DeviceAuthDialog.presentConfirmation$lambda-6(this, userId, permissions, accessToken, expirationTime, dataAccessExpirationTime, arg_0, arg_1)).setPositiveButton((CharSequence)cancel, (arg_0, arg_1) -> DeviceAuthDialog.presentConfirmation$lambda-8(this, arg_0, arg_1));
        builder.create().show();
    }

    private final void onSuccess(String accessToken, long expiresIn, Long dataAccessExpirationTime) {
        Bundle parameters = new Bundle();
        parameters.putString("fields", "id,permissions,name");
        Date expirationTime = expiresIn != 0L ? new Date(new Date().getTime() + expiresIn * 1000L) : null;
        Long l = dataAccessExpirationTime;
        long l2 = 0L;
        Date dataAccessExpirationTimeDate = (l == null || l != l2) && dataAccessExpirationTime != null ? new Date(dataAccessExpirationTime * 1000L) : null;
        AccessToken temporaryToken = new AccessToken(accessToken, FacebookSdk.INSTANCE.getApplicationId(), "0", null, null, null, null, expirationTime, null, dataAccessExpirationTimeDate, null, 1024, null);
        GraphRequest request = GraphRequest.Companion.newGraphPathRequest(temporaryToken, "me", arg_0 -> DeviceAuthDialog.onSuccess$lambda-10(this, accessToken, expirationTime, dataAccessExpirationTimeDate, arg_0));
        request.setHttpMethod(HttpMethod.GET);
        request.setParameters(parameters);
        request.executeAsync();
    }

    private final void completeLogin(String userId, PermissionsLists permissions, String accessToken, Date expirationTime, Date dataAccessExpirationTime) {
        DeviceAuthMethodHandler deviceAuthMethodHandler = this.deviceAuthMethodHandler;
        if (deviceAuthMethodHandler != null) {
            deviceAuthMethodHandler.onSuccess(accessToken, FacebookSdk.INSTANCE.getApplicationId(), userId, (Collection<String>)permissions.getGrantedPermissions(), (Collection<String>)permissions.getDeclinedPermissions(), (Collection<String>)permissions.getExpiredPermissions(), AccessTokenSource.DEVICE_AUTH, expirationTime, null, dataAccessExpirationTime);
        }
        deviceAuthMethodHandler = this.getDialog();
        if (deviceAuthMethodHandler != null) {
            deviceAuthMethodHandler.dismiss();
        }
    }

    protected void onError(@NotNull FacebookException ex) {
        Intrinsics.checkNotNullParameter((Object)((Object)ex), (String)"ex");
        if (!this.completed.compareAndSet(false, true)) {
            return;
        }
        Object object = this.currentRequestState;
        if (object != null) {
            RequestState requestState = object;
            boolean bl = false;
            boolean bl2 = false;
            RequestState it = requestState;
            boolean bl3 = false;
            DeviceRequestsHelper.cleanUpAdvertisementService(it.getUserCode());
        }
        object = this.deviceAuthMethodHandler;
        if (object != null) {
            ((DeviceAuthMethodHandler)object).onError((Exception)((Object)ex));
        }
        object = this.getDialog();
        if (object != null) {
            object.dismiss();
        }
    }

    protected void onCancel() {
        if (!this.completed.compareAndSet(false, true)) {
            return;
        }
        Object object = this.currentRequestState;
        if (object != null) {
            RequestState requestState = object;
            boolean bl = false;
            boolean bl2 = false;
            RequestState it = requestState;
            boolean bl3 = false;
            DeviceRequestsHelper.cleanUpAdvertisementService(it.getUserCode());
        }
        object = this.deviceAuthMethodHandler;
        if (object != null) {
            ((DeviceAuthMethodHandler)object).onCancel();
        }
        object = this.getDialog();
        if (object != null) {
            object.dismiss();
        }
    }

    protected void onBackButtonPressed() {
    }

    private static final void startLogin$lambda-1(DeviceAuthDialog this$0, GraphResponse response) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        if (this$0.isBeingDestroyed) {
            return;
        }
        if (response.getError() != null) {
            FacebookRequestError facebookRequestError = response.getError();
            FacebookException facebookException = facebookRequestError == null ? null : facebookRequestError.getException();
            this$0.onError(facebookException == null ? new FacebookException() : facebookException);
            return;
        }
        JSONObject jSONObject = response.getJSONObject();
        JSONObject jsonObject = jSONObject == null ? new JSONObject() : jSONObject;
        RequestState requestState = new RequestState();
        try {
            requestState.setUserCode(jsonObject.getString("user_code"));
            requestState.setRequestCode(jsonObject.getString("code"));
            requestState.setInterval(jsonObject.getLong("interval"));
        }
        catch (JSONException ex) {
            this$0.onError(new FacebookException((Throwable)ex));
            return;
        }
        this$0.setCurrentRequestState(requestState);
    }

    private static final void initializeContentView$lambda-2(DeviceAuthDialog this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.onCancel();
    }

    private static final void schedulePoll$lambda-3(DeviceAuthDialog this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.poll();
    }

    private static final void _get_pollRequest_$lambda-5(DeviceAuthDialog this$0, GraphResponse response) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        if (this$0.completed.get()) {
            return;
        }
        FacebookRequestError error = response.getError();
        if (error != null) {
            int n = error.getSubErrorCode();
            if (n == LOGIN_ERROR_SUBCODE_AUTHORIZATION_PENDING ? true : n == 1349172) {
                this$0.schedulePoll();
            } else if (n == 1349152) {
                RequestState requestState = this$0.currentRequestState;
                if (requestState != null) {
                    RequestState requestState2 = requestState;
                    boolean bl = false;
                    boolean bl2 = false;
                    RequestState it = requestState2;
                    boolean bl3 = false;
                    DeviceRequestsHelper.cleanUpAdvertisementService(it.getUserCode());
                }
                LoginClient.Request request = this$0.request;
                if (request != null) {
                    this$0.startLogin(request);
                } else {
                    this$0.onCancel();
                }
            } else if (n == 1349173) {
                this$0.onCancel();
            } else {
                FacebookRequestError facebookRequestError = response.getError();
                FacebookException facebookException = facebookRequestError == null ? null : facebookRequestError.getException();
                this$0.onError(facebookException == null ? new FacebookException() : facebookException);
            }
            return;
        }
        try {
            Object object = response.getJSONObject();
            JSONObject resultObject = object == null ? new JSONObject() : object;
            object = resultObject.getString("access_token");
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"resultObject.getString(\"access_token\")");
            this$0.onSuccess((String)object, resultObject.getLong("expires_in"), resultObject.optLong("data_access_expiration_time"));
        }
        catch (JSONException ex) {
            this$0.onError(new FacebookException((Throwable)ex));
        }
    }

    private static final void presentConfirmation$lambda-6(DeviceAuthDialog this$0, String $userId, PermissionsLists $permissions, String $accessToken, Date $expirationTime, Date $dataAccessExpirationTime, DialogInterface $noName_0, int $noName_1) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$userId, (String)"$userId");
        Intrinsics.checkNotNullParameter((Object)$permissions, (String)"$permissions");
        Intrinsics.checkNotNullParameter((Object)$accessToken, (String)"$accessToken");
        this$0.completeLogin($userId, $permissions, $accessToken, $expirationTime, $dataAccessExpirationTime);
    }

    private static final void presentConfirmation$lambda-8(DeviceAuthDialog this$0, DialogInterface $noName_0, int $noName_1) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        View view = this$0.initializeContentView(false);
        Object object = this$0.getDialog();
        if (object != null) {
            object.setContentView(view);
        }
        object = this$0.request;
        if (object != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            this$0.startLogin((LoginClient.Request)it);
        }
    }

    private static final void onSuccess$lambda-10(DeviceAuthDialog this$0, String $accessToken, Date $expirationTime, Date $dataAccessExpirationTimeDate, GraphResponse response) {
        EnumSet enumSet;
        Boolean requireConfirm;
        Object object;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$accessToken, (String)"$accessToken");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        if (this$0.completed.get()) {
            return;
        }
        FacebookRequestError error = response.getError();
        if (error != null) {
            FacebookException facebookException = error.getException();
            this$0.onError(facebookException == null ? new FacebookException() : facebookException);
            return;
        }
        Object userId = null;
        PermissionsLists permissions = null;
        Object name = null;
        try {
            object = response.getJSONObject();
            JSONObject jsonObject = object == null ? new JSONObject() : object;
            object = jsonObject.getString("id");
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jsonObject.getString(\"id\")");
            userId = object;
            permissions = DeviceAuthDialog.Companion.handlePermissionResponse(jsonObject);
            object = jsonObject.getString("name");
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jsonObject.getString(\"name\")");
            name = object;
        }
        catch (JSONException ex) {
            this$0.onError(new FacebookException((Throwable)ex));
            return;
        }
        RequestState ex = this$0.currentRequestState;
        if (ex != null) {
            object = ex;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object;
            boolean bl3 = false;
            DeviceRequestsHelper.cleanUpAdvertisementService(((RequestState)it).getUserCode());
        }
        object = FetchedAppSettingsManager.getAppSettingsWithoutQuery((String)FacebookSdk.INSTANCE.getApplicationId());
        Boolean bl = object == null ? null : (requireConfirm = (enumSet = object.getSmartLoginOptions()) == null ? null : Boolean.valueOf(enumSet.contains(SmartLoginOption.RequireConfirm)));
        if (Intrinsics.areEqual(requireConfirm, (Object)true) && !this$0.isRetry) {
            this$0.isRetry = true;
            this$0.presentConfirmation((String)userId, permissions, $accessToken, (String)name, $expirationTime, $dataAccessExpirationTimeDate);
            return;
        }
        this$0.completeLogin((String)userId, permissions, $accessToken, $expirationTime, $dataAccessExpirationTimeDate);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0007\b\u0010\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0014\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u0004\u0018\u00010\u0007J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\fJ\u0010\u0010\u001c\u001a\u00020\u001b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0007J\u0006\u0010\u001d\u001a\u00020\u001eJ\u0018\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u0018H\u0016R\"\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\n\"\u0004\b\u0014\u0010\u0015R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/facebook/login/DeviceAuthDialog$RequestState;", "Landroid/os/Parcelable;", "()V", "parcel", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "<set-?>", "", "authorizationUri", "getAuthorizationUri", "()Ljava/lang/String;", "interval", "", "getInterval", "()J", "setInterval", "(J)V", "lastPoll", "requestCode", "getRequestCode", "setRequestCode", "(Ljava/lang/String;)V", "userCode", "describeContents", "", "getUserCode", "setLastPoll", "", "setUserCode", "withinLastRefreshWindow", "", "writeToParcel", "dest", "flags", "Companion", "facebook-common_release"})
    private static final class RequestState
    implements Parcelable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private String authorizationUri;
        @Nullable
        private String userCode;
        @Nullable
        private String requestCode;
        private long interval;
        private long lastPoll;
        @JvmField
        @NotNull
        public static final Parcelable.Creator<RequestState> CREATOR = (Parcelable.Creator)new Parcelable.Creator<RequestState>(){

            @NotNull
            public RequestState createFromParcel(@NotNull Parcel parcel) {
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                return new RequestState(parcel);
            }

            @NotNull
            public RequestState[] newArray(int size) {
                return new RequestState[size];
            }
        };

        @Nullable
        public final String getAuthorizationUri() {
            return this.authorizationUri;
        }

        @Nullable
        public final String getRequestCode() {
            return this.requestCode;
        }

        public final void setRequestCode(@Nullable String string2) {
            this.requestCode = string2;
        }

        public final long getInterval() {
            return this.interval;
        }

        public final void setInterval(long l) {
            this.interval = l;
        }

        public RequestState() {
        }

        @Nullable
        public final String getUserCode() {
            return this.userCode;
        }

        public final void setUserCode(@Nullable String userCode) {
            this.userCode = userCode;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Locale locale = Locale.ENGLISH;
            String string2 = "https://facebook.com/device?user_code=%1$s&qr=1";
            Object[] objectArray = new Object[]{userCode};
            boolean bl = false;
            String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(locale, format, *args)");
            this.authorizationUri = string3;
        }

        public final void setLastPoll(long lastPoll) {
            this.lastPoll = lastPoll;
        }

        protected RequestState(@NotNull Parcel parcel) {
            Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
            this.authorizationUri = parcel.readString();
            this.userCode = parcel.readString();
            this.requestCode = parcel.readString();
            this.interval = parcel.readLong();
            this.lastPoll = parcel.readLong();
        }

        public final boolean withinLastRefreshWindow() {
            if (this.lastPoll == 0L) {
                return false;
            }
            long diff = new Date().getTime() - this.lastPoll - this.interval * 1000L;
            return diff < 0L;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel dest, int flags) {
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            dest.writeString(this.authorizationUri);
            dest.writeString(this.userCode);
            dest.writeString(this.requestCode);
            dest.writeLong(this.interval);
            dest.writeLong(this.lastPoll);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/facebook/login/DeviceAuthDialog$RequestState$Companion;", "", "()V", "CREATOR", "Landroid/os/Parcelable$Creator;", "Lcom/facebook/login/DeviceAuthDialog$RequestState;", "facebook-common_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0000X\u0081D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u00020\u00048\u0000X\u0081D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\t\u0010\u0002\u001a\u0004\b\n\u0010\u0007R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u00020\f8\u0000X\u0081D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000e\u0010\u0002\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/facebook/login/DeviceAuthDialog$Companion;", "", "()V", "DEVICE_LOGIN_ENDPOINT", "", "getDEVICE_LOGIN_ENDPOINT$facebook_common_release$annotations", "getDEVICE_LOGIN_ENDPOINT$facebook_common_release", "()Ljava/lang/String;", "DEVICE_LOGIN_STATUS_ENDPOINT", "getDEVICE_LOGIN_STATUS_ENDPOINT$facebook_common_release$annotations", "getDEVICE_LOGIN_STATUS_ENDPOINT$facebook_common_release", "LOGIN_ERROR_SUBCODE_AUTHORIZATION_DECLINED", "", "LOGIN_ERROR_SUBCODE_AUTHORIZATION_PENDING", "getLOGIN_ERROR_SUBCODE_AUTHORIZATION_PENDING$facebook_common_release$annotations", "getLOGIN_ERROR_SUBCODE_AUTHORIZATION_PENDING$facebook_common_release", "()I", "LOGIN_ERROR_SUBCODE_CODE_EXPIRED", "LOGIN_ERROR_SUBCODE_EXCESSIVE_POLLING", "REQUEST_STATE_KEY", "handlePermissionResponse", "Lcom/facebook/login/DeviceAuthDialog$PermissionsLists;", "result", "Lorg/json/JSONObject;", "facebook-common_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getDEVICE_LOGIN_ENDPOINT$facebook_common_release() {
            return DEVICE_LOGIN_ENDPOINT;
        }

        @VisibleForTesting
        public static /* synthetic */ void getDEVICE_LOGIN_ENDPOINT$facebook_common_release$annotations() {
        }

        @NotNull
        public final String getDEVICE_LOGIN_STATUS_ENDPOINT$facebook_common_release() {
            return DEVICE_LOGIN_STATUS_ENDPOINT;
        }

        @VisibleForTesting
        public static /* synthetic */ void getDEVICE_LOGIN_STATUS_ENDPOINT$facebook_common_release$annotations() {
        }

        public final int getLOGIN_ERROR_SUBCODE_AUTHORIZATION_PENDING$facebook_common_release() {
            return LOGIN_ERROR_SUBCODE_AUTHORIZATION_PENDING;
        }

        @VisibleForTesting
        public static /* synthetic */ void getLOGIN_ERROR_SUBCODE_AUTHORIZATION_PENDING$facebook_common_release$annotations() {
        }

        private final PermissionsLists handlePermissionResponse(JSONObject result) throws JSONException {
            ArrayList<String> expiredPermissions;
            ArrayList<String> declinedPermissions;
            ArrayList<String> grantedPermissions;
            block14: {
                JSONObject permissions = result.getJSONObject("permissions");
                JSONArray data = permissions.getJSONArray("data");
                boolean bl = false;
                grantedPermissions = new ArrayList<String>();
                boolean bl2 = false;
                declinedPermissions = new ArrayList<String>();
                int n = 0;
                expiredPermissions = new ArrayList<String>();
                n = 0;
                int n2 = data.length();
                if (n >= n2) break block14;
                do {
                    int i = n++;
                    JSONObject obj = data.optJSONObject(i);
                    String permission = obj.optString("permission");
                    Intrinsics.checkNotNullExpressionValue((Object)permission, (String)"permission");
                    CharSequence charSequence = permission;
                    boolean bl3 = false;
                    if (charSequence.length() == 0 || Intrinsics.areEqual((Object)permission, (Object)"installed") || (charSequence = obj.optString("status")) == null) continue;
                    int n3 = -1;
                    switch (((String)charSequence).hashCode()) {
                        case 568196142: {
                            if (((String)charSequence).equals("declined")) {
                                n3 = 1;
                            }
                            break;
                        }
                        case -1309235419: {
                            if (((String)charSequence).equals("expired")) {
                                n3 = 2;
                            }
                            break;
                        }
                        case 280295099: {
                            if (((String)charSequence).equals("granted")) {
                                n3 = 3;
                            }
                            break;
                        }
                    }
                    switch (n3) {
                        case 3: {
                            grantedPermissions.add(permission);
                            break;
                        }
                        case 1: {
                            declinedPermissions.add(permission);
                            break;
                        }
                        case 2: {
                            expiredPermissions.add(permission);
                            break;
                        }
                    }
                } while (n < n2);
            }
            return new PermissionsLists((List<String>)grantedPermissions, (List<String>)declinedPermissions, (List<String>)expiredPermissions);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\f\b\u0002\u0018\u00002\u00020\u0001B/\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0007R \u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000bR \u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/facebook/login/DeviceAuthDialog$PermissionsLists;", "", "grantedPermissions", "", "", "declinedPermissions", "expiredPermissions", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getDeclinedPermissions", "()Ljava/util/List;", "setDeclinedPermissions", "(Ljava/util/List;)V", "getExpiredPermissions", "setExpiredPermissions", "getGrantedPermissions", "setGrantedPermissions", "facebook-common_release"})
    private static final class PermissionsLists {
        @NotNull
        private List<String> grantedPermissions;
        @NotNull
        private List<String> declinedPermissions;
        @NotNull
        private List<String> expiredPermissions;

        public PermissionsLists(@NotNull List<String> grantedPermissions, @NotNull List<String> declinedPermissions, @NotNull List<String> expiredPermissions) {
            Intrinsics.checkNotNullParameter(grantedPermissions, (String)"grantedPermissions");
            Intrinsics.checkNotNullParameter(declinedPermissions, (String)"declinedPermissions");
            Intrinsics.checkNotNullParameter(expiredPermissions, (String)"expiredPermissions");
            this.grantedPermissions = grantedPermissions;
            this.declinedPermissions = declinedPermissions;
            this.expiredPermissions = expiredPermissions;
        }

        @NotNull
        public final List<String> getGrantedPermissions() {
            return this.grantedPermissions;
        }

        public final void setGrantedPermissions(@NotNull List<String> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.grantedPermissions = list;
        }

        @NotNull
        public final List<String> getDeclinedPermissions() {
            return this.declinedPermissions;
        }

        public final void setDeclinedPermissions(@NotNull List<String> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.declinedPermissions = list;
        }

        @NotNull
        public final List<String> getExpiredPermissions() {
            return this.expiredPermissions;
        }

        public final void setExpiredPermissions(@NotNull List<String> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.expiredPermissions = list;
        }
    }
}

