/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.share.internal;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import com.facebook.share.model.ShareCameraEffectContent;
import com.facebook.share.model.ShareContent;
import com.facebook.share.model.ShareLinkContent;
import com.facebook.share.model.ShareMedia;
import com.facebook.share.model.ShareMediaContent;
import com.facebook.share.model.ShareMessengerActionButton;
import com.facebook.share.model.ShareMessengerGenericTemplateContent;
import com.facebook.share.model.ShareMessengerGenericTemplateElement;
import com.facebook.share.model.ShareMessengerMediaTemplateContent;
import com.facebook.share.model.ShareMessengerOpenGraphMusicTemplateContent;
import com.facebook.share.model.ShareMessengerURLActionButton;
import com.facebook.share.model.ShareOpenGraphAction;
import com.facebook.share.model.ShareOpenGraphContent;
import com.facebook.share.model.ShareOpenGraphObject;
import com.facebook.share.model.ShareOpenGraphValueContainer;
import com.facebook.share.model.SharePhoto;
import com.facebook.share.model.SharePhotoContent;
import com.facebook.share.model.ShareStoryContent;
import com.facebook.share.model.ShareVideo;
import com.facebook.share.model.ShareVideoContent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004NOPQB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\b\u001a\u00020\t2\u0010\u0010\n\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0010\u001a\u00020\t2\u0010\u0010\n\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u000bH\u0007J\u001a\u0010\u0011\u001a\u00020\t2\u0010\u0010\n\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u000bH\u0007J\u001a\u0010\u0012\u001a\u00020\t2\u0010\u0010\n\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u000bH\u0007J\u001a\u0010\u0013\u001a\u00020\t2\u0010\u0010\n\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u000bH\u0007J\u001a\u0010\u0014\u001a\u00020\t2\u0010\u0010\n\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u000bH\u0007J\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u0018\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u0018\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\f\u001a\u00020\u0004H\u0007J\u0010\u0010\u001e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u001fH\u0002J\u001a\u0010 \u001a\u00020\t2\b\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u0018\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020%2\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u0018\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0002J\u001a\u0010+\u001a\u00020\t2\b\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010\f\u001a\u00020\u0004H\u0002J(\u0010.\u001a\u00020\t2\u000e\u0010/\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u0003002\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010)\u001a\u00020*H\u0002J\u001a\u00101\u001a\u00020\t2\b\u00102\u001a\u0004\u0018\u00010\u00012\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u0012\u00103\u001a\u00020\t2\b\u00104\u001a\u0004\u0018\u000105H\u0002J\u0018\u00106\u001a\u00020\t2\u0006\u00107\u001a\u0002082\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u0018\u00109\u001a\u00020\t2\u0006\u00104\u001a\u0002052\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u0018\u0010:\u001a\u00020\t2\u0006\u00104\u001a\u0002052\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u0018\u0010;\u001a\u00020\t2\u0006\u00104\u001a\u0002052\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u0012\u0010<\u001a\u00020\t2\b\u0010=\u001a\u0004\u0018\u00010>H\u0002J\u0010\u0010?\u001a\u00020\t2\u0006\u0010\n\u001a\u00020@H\u0002J\u0010\u0010A\u001a\u00020\t2\u0006\u0010\n\u001a\u00020BH\u0002J\u0010\u0010C\u001a\u00020\t2\u0006\u0010=\u001a\u00020DH\u0002J\u001a\u0010E\u001a\u00020\t2\b\u0010F\u001a\u0004\u0018\u00010G2\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u001a\u0010H\u001a\u00020\t2\b\u0010I\u001a\u0004\u0018\u00010J2\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u0018\u0010K\u001a\u00020\t2\u0006\u0010L\u001a\u00020M2\u0006\u0010\f\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lcom/facebook/share/internal/ShareContentValidation;", "", "()V", "apiValidator", "Lcom/facebook/share/internal/ShareContentValidation$Validator;", "defaultValidator", "storyValidator", "webShareValidator", "validate", "", "content", "Lcom/facebook/share/model/ShareContent;", "validator", "validateCameraEffectContent", "cameraEffectContent", "Lcom/facebook/share/model/ShareCameraEffectContent;", "validateForApiShare", "validateForMessage", "validateForNativeShare", "validateForStoryShare", "validateForWebShare", "validateLinkContent", "linkContent", "Lcom/facebook/share/model/ShareLinkContent;", "validateMediaContent", "mediaContent", "Lcom/facebook/share/model/ShareMediaContent;", "validateMedium", "medium", "Lcom/facebook/share/model/ShareMedia;", "validateMessengerOpenGraphMusicTemplate", "Lcom/facebook/share/model/ShareMessengerOpenGraphMusicTemplateContent;", "validateOpenGraphAction", "openGraphAction", "Lcom/facebook/share/model/ShareOpenGraphAction;", "validateOpenGraphContent", "openGraphContent", "Lcom/facebook/share/model/ShareOpenGraphContent;", "validateOpenGraphKey", "key", "", "requireNamespace", "", "validateOpenGraphObject", "openGraphObject", "Lcom/facebook/share/model/ShareOpenGraphObject;", "validateOpenGraphValueContainer", "valueContainer", "Lcom/facebook/share/model/ShareOpenGraphValueContainer;", "validateOpenGraphValueContainerObject", "o", "validatePhoto", "photo", "Lcom/facebook/share/model/SharePhoto;", "validatePhotoContent", "photoContent", "Lcom/facebook/share/model/SharePhotoContent;", "validatePhotoForApi", "validatePhotoForNativeDialog", "validatePhotoForWebDialog", "validateShareMessengerActionButton", "button", "Lcom/facebook/share/model/ShareMessengerActionButton;", "validateShareMessengerGenericTemplateContent", "Lcom/facebook/share/model/ShareMessengerGenericTemplateContent;", "validateShareMessengerMediaTemplateContent", "Lcom/facebook/share/model/ShareMessengerMediaTemplateContent;", "validateShareMessengerURLActionButton", "Lcom/facebook/share/model/ShareMessengerURLActionButton;", "validateStoryContent", "storyContent", "Lcom/facebook/share/model/ShareStoryContent;", "validateVideo", "video", "Lcom/facebook/share/model/ShareVideo;", "validateVideoContent", "videoContent", "Lcom/facebook/share/model/ShareVideoContent;", "ApiValidator", "StoryShareValidator", "Validator", "WebShareValidator", "facebook-common_release"})
public final class ShareContentValidation {
    private static final Validator webShareValidator;
    private static final Validator defaultValidator;
    private static final Validator apiValidator;
    private static final Validator storyValidator;
    @NotNull
    public static final ShareContentValidation INSTANCE;

    @JvmStatic
    public static final void validateForMessage(@Nullable ShareContent<?, ?> content) {
        INSTANCE.validate(content, defaultValidator);
    }

    @JvmStatic
    public static final void validateForNativeShare(@Nullable ShareContent<?, ?> content) {
        INSTANCE.validate(content, defaultValidator);
    }

    @JvmStatic
    public static final void validateForWebShare(@Nullable ShareContent<?, ?> content) {
        INSTANCE.validate(content, webShareValidator);
    }

    @JvmStatic
    public static final void validateForApiShare(@Nullable ShareContent<?, ?> content) {
        INSTANCE.validate(content, apiValidator);
    }

    @JvmStatic
    public static final void validateForStoryShare(@Nullable ShareContent<?, ?> content) {
        INSTANCE.validate(content, storyValidator);
    }

    private final void validate(ShareContent<?, ?> content, Validator validator) throws FacebookException {
        block2: {
            ShareContent<?, ?> shareContent;
            block10: {
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                block5: {
                                    block4: {
                                        block3: {
                                            block1: {
                                                if (content == null) {
                                                    throw (Throwable)new FacebookException("Must provide non-null content to share");
                                                }
                                                shareContent = content;
                                                if (!(shareContent instanceof ShareLinkContent)) break block1;
                                                validator.validate((ShareLinkContent)content);
                                                break block2;
                                            }
                                            if (!(shareContent instanceof SharePhotoContent)) break block3;
                                            validator.validate((SharePhotoContent)content);
                                            break block2;
                                        }
                                        if (!(shareContent instanceof ShareVideoContent)) break block4;
                                        validator.validate((ShareVideoContent)content);
                                        break block2;
                                    }
                                    if (!(shareContent instanceof ShareOpenGraphContent)) break block5;
                                    validator.validate((ShareOpenGraphContent)content);
                                    break block2;
                                }
                                if (!(shareContent instanceof ShareMediaContent)) break block6;
                                validator.validate((ShareMediaContent)content);
                                break block2;
                            }
                            if (!(shareContent instanceof ShareCameraEffectContent)) break block7;
                            validator.validate((ShareCameraEffectContent)content);
                            break block2;
                        }
                        if (!(shareContent instanceof ShareMessengerOpenGraphMusicTemplateContent)) break block8;
                        validator.validate((ShareMessengerOpenGraphMusicTemplateContent)content);
                        break block2;
                    }
                    if (!(shareContent instanceof ShareMessengerMediaTemplateContent)) break block9;
                    validator.validate((ShareMessengerMediaTemplateContent)content);
                    break block2;
                }
                if (!(shareContent instanceof ShareMessengerGenericTemplateContent)) break block10;
                validator.validate((ShareMessengerGenericTemplateContent)content);
                break block2;
            }
            if (!(shareContent instanceof ShareStoryContent)) break block2;
            validator.validate((ShareStoryContent)content);
        }
    }

    private final void validateStoryContent(ShareStoryContent storyContent, Validator validator) {
        if (storyContent == null || storyContent.getBackgroundAsset() == null && storyContent.getStickerAsset() == null) {
            throw (Throwable)new FacebookException("Must pass the Facebook app a background asset, a sticker asset, or both");
        }
        if (storyContent.getBackgroundAsset() != null) {
            ShareMedia shareMedia = storyContent.getBackgroundAsset();
            Intrinsics.checkNotNullExpressionValue((Object)shareMedia, (String)"storyContent.backgroundAsset");
            validator.validate(shareMedia);
        }
        if (storyContent.getStickerAsset() != null) {
            SharePhoto sharePhoto = storyContent.getStickerAsset();
            Intrinsics.checkNotNullExpressionValue((Object)sharePhoto, (String)"storyContent.stickerAsset");
            validator.validate(sharePhoto);
        }
    }

    private final void validateLinkContent(ShareLinkContent linkContent, Validator validator) {
        Uri imageUrl = linkContent.getImageUrl();
        if (imageUrl != null && !Utility.isWebUri((Uri)imageUrl)) {
            throw (Throwable)new FacebookException("Image Url must be an http:// or https:// url");
        }
    }

    private final void validatePhotoContent(SharePhotoContent photoContent, Validator validator) {
        List<SharePhoto> photos = photoContent.getPhotos();
        if (photos == null || photos.isEmpty()) {
            throw (Throwable)new FacebookException("Must specify at least one Photo in SharePhotoContent.");
        }
        if (photos.size() > 6) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Locale locale = Locale.ROOT;
            String string2 = "Cannot add more than %d photos.";
            Object[] objectArray = new Object[]{6};
            boolean bl = false;
            String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(locale, format, *args)");
            throw (Throwable)new FacebookException(string3);
        }
        for (SharePhoto photo : photos) {
            validator.validate(photo);
        }
    }

    private final void validatePhoto(SharePhoto photo) {
        if (photo == null) {
            throw (Throwable)new FacebookException("Cannot share a null SharePhoto");
        }
        Bitmap photoBitmap = photo.getBitmap();
        Uri photoUri = photo.getImageUrl();
        if (photoBitmap == null && photoUri == null) {
            throw (Throwable)new FacebookException("SharePhoto does not have a Bitmap or ImageUrl specified");
        }
    }

    private final void validatePhotoForApi(SharePhoto photo, Validator validator) {
        this.validatePhoto(photo);
        Bitmap photoBitmap = photo.getBitmap();
        Uri photoUri = photo.getImageUrl();
        if (photoBitmap == null && Utility.isWebUri((Uri)photoUri) && !validator.isOpenGraphContent()) {
            throw (Throwable)new FacebookException("Cannot set the ImageUrl of a SharePhoto to the Uri of an image on the web when sharing SharePhotoContent");
        }
    }

    private final void validatePhotoForNativeDialog(SharePhoto photo, Validator validator) {
        this.validatePhotoForApi(photo, validator);
        if (photo.getBitmap() != null || !Utility.isWebUri((Uri)photo.getImageUrl())) {
            Validate.hasContentProvider((Context)FacebookSdk.getApplicationContext());
        }
    }

    private final void validatePhotoForWebDialog(SharePhoto photo, Validator validator) {
        this.validatePhoto(photo);
    }

    private final void validateVideoContent(ShareVideoContent videoContent, Validator validator) {
        validator.validate(videoContent.getVideo());
        SharePhoto previewPhoto = videoContent.getPreviewPhoto();
        if (previewPhoto != null) {
            validator.validate(previewPhoto);
        }
    }

    private final void validateVideo(ShareVideo video, Validator validator) {
        if (video == null) {
            throw (Throwable)new FacebookException("Cannot share a null ShareVideo");
        }
        Uri uri = video.getLocalUrl();
        if (uri == null) {
            throw (Throwable)new FacebookException("ShareVideo does not have a LocalUrl specified");
        }
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"video.localUrl ?: throw \u2026ve a LocalUrl specified\")");
        Uri localUri = uri;
        if (!Utility.isContentUri((Uri)localUri) && !Utility.isFileUri((Uri)localUri)) {
            throw (Throwable)new FacebookException("ShareVideo must reference a video that is on the device");
        }
    }

    private final void validateMediaContent(ShareMediaContent mediaContent, Validator validator) {
        List<ShareMedia> media = mediaContent.getMedia();
        if (media == null || media.isEmpty()) {
            throw (Throwable)new FacebookException("Must specify at least one medium in ShareMediaContent.");
        }
        if (media.size() > 6) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Locale locale = Locale.ROOT;
            String string2 = "Cannot add more than %d media.";
            Object[] objectArray = new Object[]{6};
            boolean bl = false;
            String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(locale, format, *args)");
            throw (Throwable)new FacebookException(string3);
        }
        Iterator<ShareMedia> iterator = media.iterator();
        while (iterator.hasNext()) {
            ShareMedia medium;
            ShareMedia shareMedia = medium = iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)shareMedia, (String)"medium");
            validator.validate(shareMedia);
        }
    }

    @JvmStatic
    public static final void validateMedium(@NotNull ShareMedia medium, @NotNull Validator validator) {
        Intrinsics.checkNotNullParameter((Object)medium, (String)"medium");
        Intrinsics.checkNotNullParameter((Object)validator, (String)"validator");
        ShareMedia shareMedia = medium;
        if (shareMedia instanceof SharePhoto) {
            validator.validate((SharePhoto)medium);
        } else if (shareMedia instanceof ShareVideo) {
            validator.validate((ShareVideo)medium);
        } else {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Locale locale = Locale.ROOT;
            String string2 = "Invalid media type: %s";
            Object[] objectArray = new Object[]{medium.getClass().getSimpleName()};
            boolean bl = false;
            String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(locale, format, *args)");
            throw (Throwable)new FacebookException(string3);
        }
    }

    private final void validateCameraEffectContent(ShareCameraEffectContent cameraEffectContent) {
        String effectId = cameraEffectContent.getEffectId();
        if (Utility.isNullOrEmpty((String)effectId)) {
            throw (Throwable)new FacebookException("Must specify a non-empty effectId");
        }
    }

    private final void validateOpenGraphContent(ShareOpenGraphContent openGraphContent, Validator validator) {
        validator.validate(openGraphContent.getAction());
        String previewPropertyName = openGraphContent.getPreviewPropertyName();
        if (Utility.isNullOrEmpty((String)previewPropertyName)) {
            throw (Throwable)new FacebookException("Must specify a previewPropertyName.");
        }
        ShareOpenGraphAction action = openGraphContent.getAction();
        if (action == null || action.get(previewPropertyName) == null) {
            String message = "Property \"" + previewPropertyName + "\" was not found on the action. The name of the preview property must match the name of an action property.";
            throw (Throwable)new FacebookException(message);
        }
    }

    private final void validateOpenGraphAction(ShareOpenGraphAction openGraphAction, Validator validator) {
        if (openGraphAction == null) {
            throw (Throwable)new FacebookException("Must specify a non-null ShareOpenGraphAction");
        }
        if (Utility.isNullOrEmpty((String)openGraphAction.getActionType())) {
            throw (Throwable)new FacebookException("ShareOpenGraphAction must have a non-empty actionType");
        }
        validator.validate(openGraphAction, false);
    }

    private final void validateOpenGraphObject(ShareOpenGraphObject openGraphObject, Validator validator) {
        if (openGraphObject == null) {
            throw (Throwable)new FacebookException("Cannot share a null ShareOpenGraphObject");
        }
        validator.validate(openGraphObject, true);
    }

    private final void validateOpenGraphValueContainer(ShareOpenGraphValueContainer<?, ?> valueContainer, Validator validator, boolean requireNamespace) {
        Set<String> keySet = valueContainer.keySet();
        Iterator<String> iterator = keySet.iterator();
        while (iterator.hasNext()) {
            String key;
            String string2 = key = iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"key");
            this.validateOpenGraphKey(string2, requireNamespace);
            Object o = valueContainer.get(key);
            if (o instanceof List) {
                for (Object objectInList : (List)o) {
                    if (objectInList == null) {
                        throw (Throwable)new FacebookException("Cannot put null objects in Lists in ShareOpenGraphObjects and ShareOpenGraphActions");
                    }
                    this.validateOpenGraphValueContainerObject(objectInList, validator);
                }
                continue;
            }
            this.validateOpenGraphValueContainerObject(o, validator);
        }
    }

    private final void validateMessengerOpenGraphMusicTemplate(ShareMessengerOpenGraphMusicTemplateContent content) {
        if (Utility.isNullOrEmpty((String)content.getPageId())) {
            throw (Throwable)new FacebookException("Must specify Page Id for ShareMessengerOpenGraphMusicTemplateContent");
        }
        if (content.getUrl() == null) {
            throw (Throwable)new FacebookException("Must specify url for ShareMessengerOpenGraphMusicTemplateContent");
        }
        this.validateShareMessengerActionButton(content.getButton());
    }

    private final void validateShareMessengerGenericTemplateContent(ShareMessengerGenericTemplateContent content) {
        if (Utility.isNullOrEmpty((String)content.getPageId())) {
            throw (Throwable)new FacebookException("Must specify Page Id for ShareMessengerGenericTemplateContent");
        }
        if (content.getGenericTemplateElement() == null) {
            throw (Throwable)new FacebookException("Must specify element for ShareMessengerGenericTemplateContent");
        }
        ShareMessengerGenericTemplateElement shareMessengerGenericTemplateElement = content.getGenericTemplateElement();
        Intrinsics.checkNotNullExpressionValue((Object)shareMessengerGenericTemplateElement, (String)"content.genericTemplateElement");
        if (Utility.isNullOrEmpty((String)shareMessengerGenericTemplateElement.getTitle())) {
            throw (Throwable)new FacebookException("Must specify title for ShareMessengerGenericTemplateElement");
        }
        ShareMessengerGenericTemplateElement shareMessengerGenericTemplateElement2 = content.getGenericTemplateElement();
        Intrinsics.checkNotNullExpressionValue((Object)shareMessengerGenericTemplateElement2, (String)"content.genericTemplateElement");
        this.validateShareMessengerActionButton(shareMessengerGenericTemplateElement2.getButton());
    }

    private final void validateShareMessengerMediaTemplateContent(ShareMessengerMediaTemplateContent content) {
        if (Utility.isNullOrEmpty((String)content.getPageId())) {
            throw (Throwable)new FacebookException("Must specify Page Id for ShareMessengerMediaTemplateContent");
        }
        if (content.getMediaUrl() == null && Utility.isNullOrEmpty((String)content.getAttachmentId())) {
            throw (Throwable)new FacebookException("Must specify either attachmentId or mediaURL for ShareMessengerMediaTemplateContent");
        }
        this.validateShareMessengerActionButton(content.getButton());
    }

    private final void validateShareMessengerActionButton(ShareMessengerActionButton button) {
        if (button == null) {
            return;
        }
        if (Utility.isNullOrEmpty((String)button.getTitle())) {
            throw (Throwable)new FacebookException("Must specify title for ShareMessengerActionButton");
        }
        if (button instanceof ShareMessengerURLActionButton) {
            this.validateShareMessengerURLActionButton((ShareMessengerURLActionButton)button);
        }
    }

    private final void validateShareMessengerURLActionButton(ShareMessengerURLActionButton button) {
        if (button.getUrl() == null) {
            throw (Throwable)new FacebookException("Must specify url for ShareMessengerURLActionButton");
        }
    }

    private final void validateOpenGraphKey(String key, boolean requireNamespace) {
        if (!requireNamespace) {
            return;
        }
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)key, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] components = stringArray;
        if (components.length < 2) {
            throw (Throwable)new FacebookException("Open Graph keys must be namespaced: %s", new Object[]{key});
        }
        for (String component : components) {
            CharSequence charSequence = component;
            boolean bl = false;
            if (!(charSequence.length() == 0)) continue;
            throw (Throwable)new FacebookException("Invalid key found in Open Graph dictionary: %s", new Object[]{key});
        }
    }

    private final void validateOpenGraphValueContainerObject(Object o, Validator validator) {
        if (o instanceof ShareOpenGraphObject) {
            validator.validate((ShareOpenGraphObject)o);
        } else if (o instanceof SharePhoto) {
            validator.validate((SharePhoto)o);
        }
    }

    private ShareContentValidation() {
    }

    static {
        ShareContentValidation shareContentValidation;
        INSTANCE = shareContentValidation = new ShareContentValidation();
        webShareValidator = new WebShareValidator();
        defaultValidator = new Validator();
        apiValidator = new ApiValidator();
        storyValidator = new StoryShareValidator();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/facebook/share/internal/ShareContentValidation$StoryShareValidator;", "Lcom/facebook/share/internal/ShareContentValidation$Validator;", "()V", "validate", "", "storyContent", "Lcom/facebook/share/model/ShareStoryContent;", "facebook-common_release"})
    private static final class StoryShareValidator
    extends Validator {
        @Override
        public void validate(@Nullable ShareStoryContent storyContent) {
            INSTANCE.validateStoryContent(storyContent, this);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/facebook/share/internal/ShareContentValidation$WebShareValidator;", "Lcom/facebook/share/internal/ShareContentValidation$Validator;", "()V", "validate", "", "mediaContent", "Lcom/facebook/share/model/ShareMediaContent;", "photo", "Lcom/facebook/share/model/SharePhoto;", "videoContent", "Lcom/facebook/share/model/ShareVideoContent;", "facebook-common_release"})
    private static final class WebShareValidator
    extends Validator {
        @Override
        public void validate(@NotNull ShareVideoContent videoContent) {
            Intrinsics.checkNotNullParameter((Object)videoContent, (String)"videoContent");
            throw (Throwable)new FacebookException("Cannot share ShareVideoContent via web sharing dialogs");
        }

        @Override
        public void validate(@NotNull ShareMediaContent mediaContent) {
            Intrinsics.checkNotNullParameter((Object)mediaContent, (String)"mediaContent");
            throw (Throwable)new FacebookException("Cannot share ShareMediaContent via web sharing dialogs");
        }

        @Override
        public void validate(@NotNull SharePhoto photo) {
            Intrinsics.checkNotNullParameter((Object)photo, (String)"photo");
            INSTANCE.validatePhotoForWebDialog(photo, this);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/facebook/share/internal/ShareContentValidation$ApiValidator;", "Lcom/facebook/share/internal/ShareContentValidation$Validator;", "()V", "validate", "", "linkContent", "Lcom/facebook/share/model/ShareLinkContent;", "mediaContent", "Lcom/facebook/share/model/ShareMediaContent;", "photo", "Lcom/facebook/share/model/SharePhoto;", "videoContent", "Lcom/facebook/share/model/ShareVideoContent;", "facebook-common_release"})
    private static final class ApiValidator
    extends Validator {
        @Override
        public void validate(@NotNull SharePhoto photo) {
            Intrinsics.checkNotNullParameter((Object)photo, (String)"photo");
            INSTANCE.validatePhotoForApi(photo, this);
        }

        @Override
        public void validate(@NotNull ShareVideoContent videoContent) {
            Intrinsics.checkNotNullParameter((Object)videoContent, (String)"videoContent");
            if (!Utility.isNullOrEmpty((String)videoContent.getPlaceId())) {
                throw (Throwable)new FacebookException("Cannot share video content with place IDs using the share api");
            }
            if (!Utility.isNullOrEmpty((Collection)videoContent.getPeopleIds())) {
                throw (Throwable)new FacebookException("Cannot share video content with people IDs using the share api");
            }
            if (!Utility.isNullOrEmpty((String)videoContent.getRef())) {
                throw (Throwable)new FacebookException("Cannot share video content with referrer URL using the share api");
            }
        }

        @Override
        public void validate(@NotNull ShareMediaContent mediaContent) {
            Intrinsics.checkNotNullParameter((Object)mediaContent, (String)"mediaContent");
            throw (Throwable)new FacebookException("Cannot share ShareMediaContent using the share api");
        }

        @Override
        public void validate(@NotNull ShareLinkContent linkContent) {
            Intrinsics.checkNotNullParameter((Object)linkContent, (String)"linkContent");
            if (!Utility.isNullOrEmpty((String)linkContent.getQuote())) {
                throw (Throwable)new FacebookException("Cannot share link content with quote using the share api");
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0013H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0014H\u0016J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J \u0010\u0007\u001a\u00020\b2\u000e\u0010\u001b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001c2\u0006\u0010\u001d\u001a\u00020\u0004H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010 \u001a\u00020!H\u0016J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010&\u001a\u00020'H\u0016R\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006("}, d2={"Lcom/facebook/share/internal/ShareContentValidation$Validator;", "", "()V", "<set-?>", "", "isOpenGraphContent", "()Z", "validate", "", "cameraEffectContent", "Lcom/facebook/share/model/ShareCameraEffectContent;", "linkContent", "Lcom/facebook/share/model/ShareLinkContent;", "medium", "Lcom/facebook/share/model/ShareMedia;", "mediaContent", "Lcom/facebook/share/model/ShareMediaContent;", "content", "Lcom/facebook/share/model/ShareMessengerGenericTemplateContent;", "Lcom/facebook/share/model/ShareMessengerMediaTemplateContent;", "Lcom/facebook/share/model/ShareMessengerOpenGraphMusicTemplateContent;", "openGraphAction", "Lcom/facebook/share/model/ShareOpenGraphAction;", "openGraphContent", "Lcom/facebook/share/model/ShareOpenGraphContent;", "openGraphObject", "Lcom/facebook/share/model/ShareOpenGraphObject;", "openGraphValueContainer", "Lcom/facebook/share/model/ShareOpenGraphValueContainer;", "requireNamespace", "photo", "Lcom/facebook/share/model/SharePhoto;", "photoContent", "Lcom/facebook/share/model/SharePhotoContent;", "storyContent", "Lcom/facebook/share/model/ShareStoryContent;", "video", "Lcom/facebook/share/model/ShareVideo;", "videoContent", "Lcom/facebook/share/model/ShareVideoContent;", "facebook-common_release"})
    public static class Validator {
        private boolean isOpenGraphContent;

        public final boolean isOpenGraphContent() {
            return this.isOpenGraphContent;
        }

        public void validate(@NotNull ShareLinkContent linkContent) {
            Intrinsics.checkNotNullParameter((Object)linkContent, (String)"linkContent");
            INSTANCE.validateLinkContent(linkContent, this);
        }

        public void validate(@NotNull SharePhotoContent photoContent) {
            Intrinsics.checkNotNullParameter((Object)photoContent, (String)"photoContent");
            INSTANCE.validatePhotoContent(photoContent, this);
        }

        public void validate(@NotNull ShareVideoContent videoContent) {
            Intrinsics.checkNotNullParameter((Object)videoContent, (String)"videoContent");
            INSTANCE.validateVideoContent(videoContent, this);
        }

        public void validate(@NotNull ShareMediaContent mediaContent) {
            Intrinsics.checkNotNullParameter((Object)mediaContent, (String)"mediaContent");
            INSTANCE.validateMediaContent(mediaContent, this);
        }

        public void validate(@NotNull ShareCameraEffectContent cameraEffectContent) {
            Intrinsics.checkNotNullParameter((Object)cameraEffectContent, (String)"cameraEffectContent");
            INSTANCE.validateCameraEffectContent(cameraEffectContent);
        }

        public void validate(@NotNull ShareOpenGraphContent openGraphContent) {
            Intrinsics.checkNotNullParameter((Object)openGraphContent, (String)"openGraphContent");
            this.isOpenGraphContent = true;
            INSTANCE.validateOpenGraphContent(openGraphContent, this);
        }

        public void validate(@Nullable ShareOpenGraphAction openGraphAction) {
            INSTANCE.validateOpenGraphAction(openGraphAction, this);
        }

        public void validate(@Nullable ShareOpenGraphObject openGraphObject) {
            INSTANCE.validateOpenGraphObject(openGraphObject, this);
        }

        public void validate(@NotNull ShareOpenGraphValueContainer<?, ?> openGraphValueContainer, boolean requireNamespace) {
            Intrinsics.checkNotNullParameter(openGraphValueContainer, (String)"openGraphValueContainer");
            INSTANCE.validateOpenGraphValueContainer(openGraphValueContainer, this, requireNamespace);
        }

        public void validate(@NotNull SharePhoto photo) {
            Intrinsics.checkNotNullParameter((Object)photo, (String)"photo");
            INSTANCE.validatePhotoForNativeDialog(photo, this);
        }

        public void validate(@Nullable ShareVideo video) {
            INSTANCE.validateVideo(video, this);
        }

        public void validate(@NotNull ShareMedia medium) {
            Intrinsics.checkNotNullParameter((Object)medium, (String)"medium");
            ShareContentValidation.validateMedium(medium, this);
        }

        public void validate(@NotNull ShareMessengerOpenGraphMusicTemplateContent content) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            INSTANCE.validateMessengerOpenGraphMusicTemplate(content);
        }

        public void validate(@NotNull ShareMessengerGenericTemplateContent content) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            INSTANCE.validateShareMessengerGenericTemplateContent(content);
        }

        public void validate(@NotNull ShareMessengerMediaTemplateContent content) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            INSTANCE.validateShareMessengerMediaTemplateContent(content);
        }

        public void validate(@Nullable ShareStoryContent storyContent) {
            INSTANCE.validateStoryContent(storyContent, this);
        }
    }
}

