/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import com.facebook.internal.NativeProtocol;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u00002\u00020\u0001:\u0001+B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\u0006\u0010\u001c\u001a\u00020\u0019J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fH\u0004J\u0018\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"H\u0016J\u0012\u0010&\u001a\u00020\u00192\b\u0010'\u001a\u0004\u0018\u00010\u001bH$J\b\u0010(\u001a\u00020\u0019H\u0002J\u0010\u0010)\u001a\u00020\u00192\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u0006\u0010*\u001a\u00020\u0015R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/facebook/internal/PlatformServiceClient;", "Landroid/content/ServiceConnection;", "context", "Landroid/content/Context;", "requestMessage", "", "replyMessage", "protocolVersion", "applicationId", "", "nonce", "(Landroid/content/Context;IIILjava/lang/String;Ljava/lang/String;)V", "getContext", "()Landroid/content/Context;", "handler", "Landroid/os/Handler;", "listener", "Lcom/facebook/internal/PlatformServiceClient$CompletedListener;", "getNonce", "()Ljava/lang/String;", "running", "", "sender", "Landroid/os/Messenger;", "callback", "", "result", "Landroid/os/Bundle;", "cancel", "handleMessage", "message", "Landroid/os/Message;", "onServiceConnected", "name", "Landroid/content/ComponentName;", "service", "Landroid/os/IBinder;", "onServiceDisconnected", "populateRequestBundle", "data", "sendMessage", "setCompletedListener", "start", "CompletedListener", "facebook-common_release"})
public abstract class PlatformServiceClient
implements ServiceConnection {
    @NotNull
    private final Context context;
    private final Handler handler;
    private CompletedListener listener;
    private boolean running;
    private Messenger sender;
    private final int requestMessage;
    private final int replyMessage;
    private final String applicationId;
    private final int protocolVersion;
    @Nullable
    private final String nonce;

    @NotNull
    protected final Context getContext() {
        return this.context;
    }

    @Nullable
    public final String getNonce() {
        return this.nonce;
    }

    public final void setCompletedListener(@Nullable CompletedListener listener) {
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean start() {
        PlatformServiceClient platformServiceClient = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (platformServiceClient) {
            boolean bl3;
            block8: {
                block7: {
                    boolean bl4 = false;
                    if (!this.running) break block7;
                    boolean bl5 = false;
                    return bl5;
                }
                int availableVersion = NativeProtocol.getLatestAvailableProtocolVersionForService((int)this.protocolVersion);
                if (availableVersion != -1) break block8;
                boolean bl6 = false;
                return bl6;
            }
            Intent intent = NativeProtocol.createPlatformServiceIntent((Context)this.context);
            if (intent == null) {
                bl3 = false;
            } else {
                this.running = true;
                this.context.bindService(intent, (ServiceConnection)this, 1);
                bl3 = true;
            }
            boolean bl7 = bl3;
            return bl7;
        }
    }

    public final void cancel() {
        this.running = false;
    }

    public void onServiceConnected(@NotNull ComponentName name, @NotNull IBinder service) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        this.sender = new Messenger(service);
        this.sendMessage();
    }

    public void onServiceDisconnected(@NotNull ComponentName name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.sender = null;
        try {
            this.context.unbindService((ServiceConnection)this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.callback(null);
    }

    private final void sendMessage() {
        Bundle data = new Bundle();
        data.putString("com.facebook.platform.extra.APPLICATION_ID", this.applicationId);
        if (this.nonce != null) {
            data.putString("com.facebook.platform.extra.NONCE", this.nonce);
        }
        this.populateRequestBundle(data);
        Message request = Message.obtain(null, (int)this.requestMessage);
        request.arg1 = this.protocolVersion;
        Message message = request;
        Intrinsics.checkNotNullExpressionValue((Object)message, (String)"request");
        message.setData(data);
        request.replyTo = new Messenger(this.handler);
        try {
            Messenger messenger = this.sender;
            if (messenger != null) {
                messenger.send(request);
            }
        }
        catch (RemoteException e) {
            this.callback(null);
        }
    }

    protected abstract void populateRequestBundle(@Nullable Bundle var1);

    protected final void handleMessage(@NotNull Message message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (message.what == this.replyMessage) {
            Bundle extras = message.getData();
            String errorType = extras.getString("com.facebook.platform.status.ERROR_TYPE");
            if (errorType != null) {
                this.callback(null);
            } else {
                this.callback(extras);
            }
            try {
                this.context.unbindService((ServiceConnection)this);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private final void callback(Bundle result) {
        block1: {
            CompletedListener callback2;
            if (!this.running) {
                return;
            }
            this.running = false;
            CompletedListener completedListener = callback2 = this.listener;
            if (completedListener == null) break block1;
            completedListener.completed(result);
        }
    }

    public PlatformServiceClient(@NotNull Context context, int requestMessage, int replyMessage, int protocolVersion, @NotNull String applicationId, @Nullable String nonce) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        Context applicationContext = context.getApplicationContext();
        Context context2 = applicationContext;
        if (context2 == null) {
            context2 = context;
        }
        this.context = context2;
        this.requestMessage = requestMessage;
        this.replyMessage = replyMessage;
        this.applicationId = applicationId;
        this.protocolVersion = protocolVersion;
        this.nonce = nonce;
        this.handler = new Handler(){

            /*
             * WARNING - void declaration
             */
            public void handleMessage(@NotNull Message message) {
                if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
                    return;
                }
                try {
                    void message2;
                    Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                    this.handleMessage((Message)message2);
                    return;
                }
                catch (Throwable throwable) {
                    CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
                    return;
                }
            }
        };
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/facebook/internal/PlatformServiceClient$CompletedListener;", "", "completed", "", "result", "Landroid/os/Bundle;", "facebook-common_release"})
    public static interface CompletedListener {
        public void completed(@Nullable Bundle var1);
    }
}

