/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.referrals;

import android.app.Activity;
import android.app.Fragment;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import com.facebook.CallbackManager;
import com.facebook.FacebookActivity;
import com.facebook.FacebookCallback;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.internal.CallbackManagerImpl;
import com.facebook.internal.FragmentWrapper;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import com.facebook.referrals.ReferralClient;
import com.facebook.referrals.ReferralLogger;
import com.facebook.referrals.ReferralResult;
import com.facebook.referrals.StartActivityDelegate;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;

@Deprecated
public class ReferralManager {
    private static volatile ReferralManager instance;
    private ReferralLogger logger;

    ReferralManager() {
        Validate.sdkInitialized();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ReferralManager getInstance() {
        if (instance != null) return instance;
        Class<ReferralManager> clazz = ReferralManager.class;
        synchronized (ReferralManager.class) {
            if (instance != null) return instance;
            instance = new ReferralManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void startReferral(Activity activity) {
        this.startReferralImpl(new ActivityStartActivityDelegate(activity));
    }

    public void startReferral(androidx.fragment.app.Fragment fragment) {
        this.startReferralImpl(new FragmentStartActivityDelegate(new FragmentWrapper(fragment)));
    }

    public void startReferral(Fragment fragment) {
        this.startReferralImpl(new FragmentStartActivityDelegate(new FragmentWrapper(fragment)));
    }

    public void startReferral(FragmentWrapper fragment) {
        this.startReferralImpl(new FragmentStartActivityDelegate(fragment));
    }

    public void registerCallback(CallbackManager callbackManager, final FacebookCallback<ReferralResult> callback) {
        if (!(callbackManager instanceof CallbackManagerImpl)) {
            throw new FacebookException("Unexpected CallbackManager, please use the provided Factory.");
        }
        ((CallbackManagerImpl)callbackManager).registerCallback(ReferralClient.getReferralRequestCode(), new CallbackManagerImpl.Callback(){

            public boolean onActivityResult(int resultCode, Intent data) {
                return ReferralManager.this.onActivityResult(resultCode, data, callback);
            }
        });
    }

    private void startReferralImpl(StartActivityDelegate activity) {
        boolean started;
        ReferralLogger logger = this.getLogger((Context)activity.getActivityContext());
        if (logger != null) {
            logger.logStartReferral();
        }
        if (!(started = this.tryFacebookActivity(activity))) {
            FacebookException exception = new FacebookException("Failed to open Referral dialog: FacebookActivity could not be started. Please make sure you added FacebookActivity to the AndroidManifest.");
            if (logger != null) {
                logger.logError((Exception)((Object)exception));
            }
            throw exception;
        }
    }

    boolean onActivityResult(int resultCode, Intent data, FacebookCallback<ReferralResult> callback) {
        FacebookException exception = null;
        ReferralResult result = null;
        try {
            if (resultCode == -1 && data != null && data.getExtras() != null && data.getExtras().containsKey("fb_referral_codes")) {
                String referralCodesStr = data.getExtras().getString("fb_referral_codes");
                List referralCodes = Utility.convertJSONArrayToList((JSONArray)new JSONArray(referralCodesStr));
                result = new ReferralResult(referralCodes);
            } else if (resultCode == 0) {
                if (data != null && data.getExtras() != null && data.getExtras().containsKey("error_message")) {
                    String errorMessage = data.getExtras().getString("error_message");
                    exception = new FacebookException(errorMessage);
                }
            } else {
                exception = new FacebookException("Unexpected call to ReferralManager.onActivityResult");
            }
        }
        catch (JSONException ex) {
            exception = new FacebookException("Unable to parse referral codes from response");
        }
        ReferralLogger logger = this.getLogger(null);
        if (logger != null) {
            if (result != null) {
                logger.logSuccess();
            } else if (exception != null) {
                logger.logError((Exception)((Object)exception));
            } else {
                logger.logCancel();
            }
        }
        if (result != null) {
            callback.onSuccess(result);
        } else if (exception != null) {
            callback.onError(exception);
        } else {
            callback.onCancel();
        }
        return true;
    }

    private boolean tryFacebookActivity(StartActivityDelegate activity) {
        Intent intent = new Intent();
        intent.setClass(FacebookSdk.getApplicationContext(), FacebookActivity.class);
        intent.setAction("ReferralFragment");
        if (!ReferralManager.resolveIntent(intent)) {
            return false;
        }
        try {
            activity.startActivityForResult(intent, CallbackManagerImpl.RequestCodeOffset.Referral.toRequestCode());
        }
        catch (ActivityNotFoundException e) {
            return false;
        }
        return true;
    }

    private ReferralLogger getLogger(Context context) {
        Context context2 = context = context != null ? context : FacebookSdk.getApplicationContext();
        if (context == null) {
            return null;
        }
        if (this.logger == null) {
            this.logger = new ReferralLogger(context, FacebookSdk.getApplicationId());
        }
        return this.logger;
    }

    private static boolean resolveIntent(Intent intent) {
        ResolveInfo resolveInfo = FacebookSdk.getApplicationContext().getPackageManager().resolveActivity(intent, 0);
        return resolveInfo != null;
    }

    private static class FragmentStartActivityDelegate
    implements StartActivityDelegate {
        private final FragmentWrapper fragment;

        FragmentStartActivityDelegate(FragmentWrapper fragment) {
            Validate.notNull((Object)fragment, (String)"fragment");
            this.fragment = fragment;
        }

        @Override
        public void startActivityForResult(Intent intent, int requestCode) {
            this.fragment.startActivityForResult(intent, requestCode);
        }

        @Override
        public Activity getActivityContext() {
            return this.fragment.getActivity();
        }
    }

    private static class ActivityStartActivityDelegate
    implements StartActivityDelegate {
        private final Activity activity;

        ActivityStartActivityDelegate(Activity activity) {
            Validate.notNull((Object)activity, (String)"activity");
            this.activity = activity;
        }

        @Override
        public void startActivityForResult(Intent intent, int requestCode) {
            this.activity.startActivityForResult(intent, requestCode);
        }

        @Override
        public Activity getActivityContext() {
            return this.activity;
        }
    }
}

