/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.login;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.fragment.app.FragmentActivity;
import com.facebook.AccessTokenSource;
import com.facebook.FacebookException;
import com.facebook.internal.FacebookDialogFragment;
import com.facebook.internal.Utility;
import com.facebook.internal.WebDialog;
import com.facebook.login.LoginBehavior;
import com.facebook.login.LoginClient;
import com.facebook.login.LoginTargetApp;
import com.facebook.login.WebLoginMethodHandler;

class WebViewLoginMethodHandler
extends WebLoginMethodHandler {
    private WebDialog loginDialog;
    private String e2e;
    public static final Parcelable.Creator<WebViewLoginMethodHandler> CREATOR = new Parcelable.Creator<WebViewLoginMethodHandler>(){

        public WebViewLoginMethodHandler createFromParcel(Parcel source) {
            return new WebViewLoginMethodHandler(source);
        }

        public WebViewLoginMethodHandler[] newArray(int size) {
            return new WebViewLoginMethodHandler[size];
        }
    };

    WebViewLoginMethodHandler(LoginClient loginClient) {
        super(loginClient);
    }

    @Override
    String getNameForLogging() {
        return "web_view";
    }

    @Override
    AccessTokenSource getTokenSource() {
        return AccessTokenSource.WEB_VIEW;
    }

    @Override
    boolean needsInternetPermission() {
        return true;
    }

    @Override
    void cancel() {
        if (this.loginDialog != null) {
            this.loginDialog.cancel();
            this.loginDialog = null;
        }
    }

    @Override
    int tryAuthorize(final LoginClient.Request request) {
        Bundle parameters = this.getParameters(request);
        WebDialog.OnCompleteListener listener = new WebDialog.OnCompleteListener(){

            @Override
            public void onComplete(Bundle values, FacebookException error) {
                WebViewLoginMethodHandler.this.onWebDialogComplete(request, values, error);
            }
        };
        this.e2e = LoginClient.getE2E();
        this.addLoggingExtra("e2e", this.e2e);
        FragmentActivity fragmentActivity = this.loginClient.getActivity();
        boolean isChromeOS = Utility.isChromeOS((Context)fragmentActivity);
        WebDialog.Builder builder = new AuthDialogBuilder((Context)fragmentActivity, request.getApplicationId(), parameters).setE2E(this.e2e).setIsChromeOS(isChromeOS).setAuthType(request.getAuthType()).setLoginBehavior(request.getLoginBehavior()).setLoginTargetApp(request.getLoginTargetApp()).setFamilyLogin(request.isFamilyLogin()).setShouldSkipDedupe(request.shouldSkipAccountDeduplication()).setOnCompleteListener(listener);
        this.loginDialog = builder.build();
        FacebookDialogFragment dialogFragment = new FacebookDialogFragment();
        dialogFragment.setRetainInstance(true);
        dialogFragment.setDialog(this.loginDialog);
        dialogFragment.show(fragmentActivity.getSupportFragmentManager(), "FacebookDialogFragment");
        return 1;
    }

    void onWebDialogComplete(LoginClient.Request request, Bundle values, FacebookException error) {
        super.onComplete(request, values, error);
    }

    WebViewLoginMethodHandler(Parcel source) {
        super(source);
        this.e2e = source.readString();
    }

    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeString(this.e2e);
    }

    static class AuthDialogBuilder
    extends WebDialog.Builder {
        private static final String OAUTH_DIALOG = "oauth";
        private String e2e;
        private String authType;
        private String redirect_uri = "fbconnect://success";
        private LoginBehavior loginBehavior = LoginBehavior.NATIVE_WITH_FALLBACK;
        private LoginTargetApp targetApp = LoginTargetApp.FACEBOOK;
        private boolean isFamilyLogin = false;
        private boolean shouldSkipDedupe = false;

        public AuthDialogBuilder(Context context, String applicationId, Bundle parameters) {
            super(context, applicationId, OAUTH_DIALOG, parameters);
        }

        public AuthDialogBuilder setE2E(String e2e) {
            this.e2e = e2e;
            return this;
        }

        public AuthDialogBuilder setIsRerequest(boolean isRerequest) {
            return this;
        }

        public AuthDialogBuilder setIsChromeOS(boolean isChromeOS) {
            this.redirect_uri = isChromeOS ? "fbconnect://chrome_os_success" : "fbconnect://success";
            return this;
        }

        public AuthDialogBuilder setAuthType(String authType) {
            this.authType = authType;
            return this;
        }

        public AuthDialogBuilder setLoginBehavior(LoginBehavior loginBehavior) {
            this.loginBehavior = loginBehavior;
            return this;
        }

        public AuthDialogBuilder setLoginTargetApp(LoginTargetApp targetApp) {
            this.targetApp = targetApp;
            return this;
        }

        public AuthDialogBuilder setFamilyLogin(boolean isFamilyLogin) {
            this.isFamilyLogin = isFamilyLogin;
            return this;
        }

        public AuthDialogBuilder setShouldSkipDedupe(boolean shouldSkip) {
            this.shouldSkipDedupe = shouldSkip;
            return this;
        }

        @Override
        public WebDialog build() {
            Bundle parameters = this.getParameters();
            parameters.putString("redirect_uri", this.redirect_uri);
            parameters.putString("client_id", this.getApplicationId());
            parameters.putString("e2e", this.e2e);
            parameters.putString("response_type", this.targetApp == LoginTargetApp.INSTAGRAM ? "token,signed_request,graph_domain,granted_scopes" : "token,signed_request,graph_domain");
            parameters.putString("return_scopes", "true");
            parameters.putString("auth_type", this.authType);
            parameters.putString("login_behavior", this.loginBehavior.name());
            if (this.isFamilyLogin) {
                parameters.putString("fx_app", this.targetApp.toString());
            }
            if (this.shouldSkipDedupe) {
                parameters.putString("skip_dedupe", "true");
            }
            return WebDialog.newInstance(this.getContext(), OAUTH_DIALOG, parameters, this.getTheme(), this.targetApp, this.getListener());
        }
    }
}

