/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.util.Pair;
import androidx.activity.result.ActivityResultCallback;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.ActivityResultRegistry;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.facebook.CallbackManager;
import com.facebook.CustomTabMainActivity;
import com.facebook.FacebookActivity;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.appevents.InternalAppEventsLogger;
import com.facebook.internal.AppCall;
import com.facebook.internal.CallbackManagerImpl;
import com.facebook.internal.CustomTabUtils;
import com.facebook.internal.DialogFeature;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FragmentWrapper;
import com.facebook.internal.NativeProtocol;
import com.facebook.internal.ServerProtocol;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;

public class DialogPresenter {
    public static void setupAppCallForCannotShowError(AppCall appCall) {
        FacebookException e = new FacebookException("Unable to show the provided content via the web or the installed version of the Facebook app. Some dialogs are only supported starting API 14.");
        DialogPresenter.setupAppCallForValidationError(appCall, e);
    }

    public static void setupAppCallForValidationError(AppCall appCall, FacebookException validationError) {
        DialogPresenter.setupAppCallForErrorResult(appCall, validationError);
    }

    public static void present(AppCall appCall, Activity activity) {
        activity.startActivityForResult(appCall.getRequestIntent(), appCall.getRequestCode());
        appCall.setPending();
    }

    public static void present(AppCall appCall, FragmentWrapper fragmentWrapper) {
        fragmentWrapper.startActivityForResult(appCall.getRequestIntent(), appCall.getRequestCode());
        appCall.setPending();
    }

    public static void present(@NonNull AppCall appCall, @NonNull ActivityResultRegistry registry, @Nullable CallbackManager callbackManager) {
        DialogPresenter.startActivityForResultWithAndroidX(registry, callbackManager, appCall.getRequestIntent(), appCall.getRequestCode());
        appCall.setPending();
    }

    public static void startActivityForResultWithAndroidX(@NonNull ActivityResultRegistry registry, final @Nullable CallbackManager callbackManager, @NonNull Intent intent, final int requestCode) {
        class LauncherHolder {
            private ActivityResultLauncher<Intent> launcher = null;

            LauncherHolder() {
            }
        }
        final LauncherHolder launcherHolder = new LauncherHolder();
        launcherHolder.launcher = registry.register(String.format("facebook-dialog-request-%d", requestCode), (ActivityResultContract)new ActivityResultContract<Intent, Pair<Integer, Intent>>(){

            @NonNull
            public Intent createIntent(@NonNull Context context, Intent input) {
                return input;
            }

            public Pair<Integer, Intent> parseResult(int resultCode, @Nullable Intent intent) {
                return Pair.create((Object)resultCode, (Object)intent);
            }
        }, (ActivityResultCallback)new ActivityResultCallback<Pair<Integer, Intent>>(){
            {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onActivityResult(Pair<Integer, Intent> result) {
                CallbackManager innerCallbackManager = callbackManager;
                if (innerCallbackManager == null) {
                    innerCallbackManager = new CallbackManagerImpl();
                }
                innerCallbackManager.onActivityResult(requestCode, ((Integer)result.first).intValue(), (Intent)result.second);
                LauncherHolder launcherHolder2 = launcherHolder;
                synchronized (launcherHolder2) {
                    if (launcherHolder.launcher != null) {
                        launcherHolder.launcher.unregister();
                        launcherHolder.launcher = null;
                    }
                }
            }
        });
        launcherHolder.launcher.launch((Object)intent);
    }

    public static boolean canPresentNativeDialogWithFeature(DialogFeature feature) {
        return DialogPresenter.getProtocolVersionForNativeDialog(feature).getProtocolVersion() != -1;
    }

    public static boolean canPresentWebFallbackDialogWithFeature(DialogFeature feature) {
        return DialogPresenter.getDialogWebFallbackUri(feature) != null;
    }

    public static void setupAppCallForErrorResult(AppCall appCall, FacebookException exception) {
        if (exception == null) {
            return;
        }
        Validate.hasFacebookActivity((Context)FacebookSdk.getApplicationContext());
        Intent errorResultIntent = new Intent();
        errorResultIntent.setClass(FacebookSdk.getApplicationContext(), FacebookActivity.class);
        errorResultIntent.setAction(FacebookActivity.PASS_THROUGH_CANCEL_ACTION);
        NativeProtocol.setupProtocolRequestIntent((Intent)errorResultIntent, (String)appCall.getCallId().toString(), null, (int)NativeProtocol.getLatestKnownVersion(), (Bundle)NativeProtocol.createBundleForException((FacebookException)exception));
        appCall.setRequestIntent(errorResultIntent);
    }

    public static void setupAppCallForWebDialog(AppCall appCall, String actionName, Bundle parameters) {
        Validate.hasFacebookActivity((Context)FacebookSdk.getApplicationContext());
        Validate.hasInternetPermissions((Context)FacebookSdk.getApplicationContext());
        Bundle intentParameters = new Bundle();
        intentParameters.putString("action", actionName);
        intentParameters.putBundle("params", parameters);
        Intent webDialogIntent = new Intent();
        NativeProtocol.setupProtocolRequestIntent((Intent)webDialogIntent, (String)appCall.getCallId().toString(), (String)actionName, (int)NativeProtocol.getLatestKnownVersion(), (Bundle)intentParameters);
        webDialogIntent.setClass(FacebookSdk.getApplicationContext(), FacebookActivity.class);
        webDialogIntent.setAction("FacebookDialogFragment");
        appCall.setRequestIntent(webDialogIntent);
    }

    public static void setupAppCallForWebFallbackDialog(AppCall appCall, Bundle parameters, DialogFeature feature) {
        Validate.hasFacebookActivity((Context)FacebookSdk.getApplicationContext());
        Validate.hasInternetPermissions((Context)FacebookSdk.getApplicationContext());
        String featureName = feature.name();
        Uri fallbackUrl = DialogPresenter.getDialogWebFallbackUri(feature);
        if (fallbackUrl == null) {
            throw new FacebookException("Unable to fetch the Url for the DialogFeature : '" + featureName + "'");
        }
        int protocolVersion = NativeProtocol.getLatestKnownVersion();
        Bundle webParams = ServerProtocol.getQueryParamsForPlatformActivityIntentWebFallback((String)appCall.getCallId().toString(), (int)protocolVersion, (Bundle)parameters);
        if (webParams == null) {
            throw new FacebookException("Unable to fetch the app's key-hash");
        }
        fallbackUrl = fallbackUrl.isRelative() ? Utility.buildUri((String)ServerProtocol.getDialogAuthority(), (String)fallbackUrl.toString(), (Bundle)webParams) : Utility.buildUri((String)fallbackUrl.getAuthority(), (String)fallbackUrl.getPath(), (Bundle)webParams);
        Bundle intentParameters = new Bundle();
        intentParameters.putString("url", fallbackUrl.toString());
        intentParameters.putBoolean("is_fallback", true);
        Intent webDialogIntent = new Intent();
        NativeProtocol.setupProtocolRequestIntent((Intent)webDialogIntent, (String)appCall.getCallId().toString(), (String)feature.getAction(), (int)NativeProtocol.getLatestKnownVersion(), (Bundle)intentParameters);
        webDialogIntent.setClass(FacebookSdk.getApplicationContext(), FacebookActivity.class);
        webDialogIntent.setAction("FacebookDialogFragment");
        appCall.setRequestIntent(webDialogIntent);
    }

    public static void setupAppCallForNativeDialog(AppCall appCall, ParameterProvider parameterProvider, DialogFeature feature) {
        Intent intent;
        Context context = FacebookSdk.getApplicationContext();
        String action = feature.getAction();
        NativeProtocol.ProtocolVersionQueryResult protocolVersionResult = DialogPresenter.getProtocolVersionForNativeDialog(feature);
        int protocolVersion = protocolVersionResult.getProtocolVersion();
        if (protocolVersion == -1) {
            throw new FacebookException("Cannot present this dialog. This likely means that the Facebook app is not installed.");
        }
        Bundle params = NativeProtocol.isVersionCompatibleWithBucketedIntent((int)protocolVersion) ? parameterProvider.getParameters() : parameterProvider.getLegacyParameters();
        if (params == null) {
            params = new Bundle();
        }
        if ((intent = NativeProtocol.createPlatformActivityIntent((Context)context, (String)appCall.getCallId().toString(), (String)action, (NativeProtocol.ProtocolVersionQueryResult)protocolVersionResult, (Bundle)params)) == null) {
            throw new FacebookException("Unable to create Intent; this likely means theFacebook app is not installed.");
        }
        appCall.setRequestIntent(intent);
    }

    public static void setupAppCallForCustomTabDialog(AppCall appCall, String action, Bundle parameters) {
        Validate.hasCustomTabRedirectActivity((Context)FacebookSdk.getApplicationContext(), (String)CustomTabUtils.getDefaultRedirectURI());
        Validate.hasInternetPermissions((Context)FacebookSdk.getApplicationContext());
        Intent intent = new Intent(FacebookSdk.getApplicationContext(), CustomTabMainActivity.class);
        intent.putExtra(CustomTabMainActivity.EXTRA_ACTION, action);
        intent.putExtra(CustomTabMainActivity.EXTRA_PARAMS, parameters);
        intent.putExtra(CustomTabMainActivity.EXTRA_CHROME_PACKAGE, CustomTabUtils.getChromePackage());
        NativeProtocol.setupProtocolRequestIntent((Intent)intent, (String)appCall.getCallId().toString(), (String)action, (int)NativeProtocol.getLatestKnownVersion(), null);
        appCall.setRequestIntent(intent);
    }

    private static Uri getDialogWebFallbackUri(DialogFeature feature) {
        String featureName = feature.name();
        String action = feature.getAction();
        String applicationId = FacebookSdk.getApplicationId();
        FetchedAppSettings.DialogFeatureConfig config = FetchedAppSettings.getDialogFeatureConfig((String)applicationId, (String)action, (String)featureName);
        Uri fallbackUrl = null;
        if (config != null) {
            fallbackUrl = config.getFallbackUrl();
        }
        return fallbackUrl;
    }

    public static NativeProtocol.ProtocolVersionQueryResult getProtocolVersionForNativeDialog(DialogFeature feature) {
        String applicationId = FacebookSdk.getApplicationId();
        String action = feature.getAction();
        int[] featureVersionSpec = DialogPresenter.getVersionSpecForFeature(applicationId, action, feature);
        return NativeProtocol.getLatestAvailableProtocolVersionForAction((String)action, (int[])featureVersionSpec);
    }

    private static int[] getVersionSpecForFeature(String applicationId, String actionName, DialogFeature feature) {
        FetchedAppSettings.DialogFeatureConfig config = FetchedAppSettings.getDialogFeatureConfig((String)applicationId, (String)actionName, (String)feature.name());
        if (config != null) {
            return config.getVersionSpec();
        }
        return new int[]{feature.getMinVersion()};
    }

    public static void logDialogActivity(Context context, String eventName, String outcome) {
        InternalAppEventsLogger logger = new InternalAppEventsLogger(context);
        Bundle parameters = new Bundle();
        parameters.putString("fb_dialog_outcome", outcome);
        logger.logEventImplicitly(eventName, parameters);
    }

    public static interface ParameterProvider {
        public Bundle getParameters();

        public Bundle getLegacyParameters();
    }
}

