/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.share.internal;

import android.net.Uri;
import android.os.Bundle;
import com.facebook.FacebookException;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import com.facebook.share.internal.ShareInternalUtility;
import com.facebook.share.model.ShareContent;
import com.facebook.share.model.ShareLinkContent;
import com.facebook.share.model.ShareOpenGraphContent;
import com.facebook.share.model.SharePhotoContent;
import com.facebook.share.model.ShareVideoContent;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public class LegacyNativeDialogParameters {
    public static Bundle create(UUID callId, ShareContent shareContent, boolean shouldFailOnDataError) {
        Validate.notNull((Object)shareContent, (String)"shareContent");
        Validate.notNull((Object)callId, (String)"callId");
        Bundle nativeParams = null;
        if (shareContent instanceof ShareLinkContent) {
            ShareLinkContent linkContent = (ShareLinkContent)shareContent;
            nativeParams = LegacyNativeDialogParameters.create(linkContent, shouldFailOnDataError);
        } else if (shareContent instanceof SharePhotoContent) {
            SharePhotoContent photoContent = (SharePhotoContent)shareContent;
            List<String> photoUrls = ShareInternalUtility.getPhotoUrls(photoContent, callId);
            nativeParams = LegacyNativeDialogParameters.create(photoContent, photoUrls, shouldFailOnDataError);
        } else if (shareContent instanceof ShareVideoContent) {
            ShareVideoContent videoContent = (ShareVideoContent)shareContent;
            nativeParams = LegacyNativeDialogParameters.create(videoContent, shouldFailOnDataError);
        } else if (shareContent instanceof ShareOpenGraphContent) {
            ShareOpenGraphContent openGraphContent = (ShareOpenGraphContent)shareContent;
            try {
                JSONObject openGraphActionJSON = ShareInternalUtility.toJSONObjectForCall(callId, openGraphContent);
                nativeParams = LegacyNativeDialogParameters.create(openGraphContent, openGraphActionJSON, shouldFailOnDataError);
            }
            catch (JSONException e) {
                throw new FacebookException("Unable to create a JSON Object from the provided ShareOpenGraphContent: " + e.getMessage());
            }
        }
        return nativeParams;
    }

    private static Bundle create(ShareLinkContent linkContent, boolean dataErrorsFatal) {
        Bundle params = LegacyNativeDialogParameters.createBaseParameters(linkContent, dataErrorsFatal);
        Utility.putNonEmptyString((Bundle)params, (String)"com.facebook.platform.extra.TITLE", (String)linkContent.getContentTitle());
        Utility.putNonEmptyString((Bundle)params, (String)"com.facebook.platform.extra.DESCRIPTION", (String)linkContent.getContentDescription());
        Utility.putUri((Bundle)params, (String)"com.facebook.platform.extra.IMAGE", (Uri)linkContent.getImageUrl());
        return params;
    }

    private static Bundle create(SharePhotoContent photoContent, List<String> imageUrls, boolean dataErrorsFatal) {
        Bundle params = LegacyNativeDialogParameters.createBaseParameters(photoContent, dataErrorsFatal);
        params.putStringArrayList("com.facebook.platform.extra.PHOTOS", new ArrayList<String>(imageUrls));
        return params;
    }

    private static Bundle create(ShareVideoContent videoContent, boolean dataErrorsFatal) {
        return null;
    }

    private static Bundle create(ShareOpenGraphContent openGraphContent, JSONObject openGraphActionJSON, boolean dataErrorsFatal) {
        Bundle params = LegacyNativeDialogParameters.createBaseParameters(openGraphContent, dataErrorsFatal);
        Utility.putNonEmptyString((Bundle)params, (String)"com.facebook.platform.extra.PREVIEW_PROPERTY_NAME", (String)openGraphContent.getPreviewPropertyName());
        Utility.putNonEmptyString((Bundle)params, (String)"com.facebook.platform.extra.ACTION_TYPE", (String)openGraphContent.getAction().getActionType());
        Utility.putNonEmptyString((Bundle)params, (String)"com.facebook.platform.extra.ACTION", (String)openGraphActionJSON.toString());
        return params;
    }

    private static Bundle createBaseParameters(ShareContent content, boolean dataErrorsFatal) {
        Bundle params = new Bundle();
        Utility.putUri((Bundle)params, (String)"com.facebook.platform.extra.LINK", (Uri)content.getContentUrl());
        Utility.putNonEmptyString((Bundle)params, (String)"com.facebook.platform.extra.PLACE", (String)content.getPlaceId());
        Utility.putNonEmptyString((Bundle)params, (String)"com.facebook.platform.extra.REF", (String)content.getRef());
        params.putBoolean("com.facebook.platform.extra.DATA_FAILURES_FATAL", dataErrorsFatal);
        List<String> peopleIds = content.getPeopleIds();
        if (!Utility.isNullOrEmpty(peopleIds)) {
            params.putStringArrayList("com.facebook.platform.extra.FRIENDS", new ArrayList<String>(peopleIds));
        }
        return params;
    }
}

