/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.View;
import android.widget.Button;
import androidx.activity.result.ActivityResultRegistryOwner;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.facebook.FacebookException;
import com.facebook.appevents.InternalAppEventsLogger;
import com.facebook.common.R;
import com.facebook.internal.FragmentWrapper;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;

public abstract class FacebookButtonBase
extends Button {
    private String analyticsButtonCreatedEventName;
    private String analyticsButtonTappedEventName;
    private View.OnClickListener externalOnClickListener;
    private View.OnClickListener internalOnClickListener;
    private boolean overrideCompoundPadding;
    private int overrideCompoundPaddingLeft;
    private int overrideCompoundPaddingRight;
    private FragmentWrapper parentFragment;

    protected FacebookButtonBase(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes, String analyticsButtonCreatedEventName, String analyticsButtonTappedEventName) {
        super(context, attrs, 0);
        defStyleRes = defStyleRes == 0 ? this.getDefaultStyleResource() : defStyleRes;
        defStyleRes = defStyleRes == 0 ? R.style.com_facebook_button : defStyleRes;
        this.configureButton(context, attrs, defStyleAttr, defStyleRes);
        this.analyticsButtonCreatedEventName = analyticsButtonCreatedEventName;
        this.analyticsButtonTappedEventName = analyticsButtonTappedEventName;
        this.setClickable(true);
        this.setFocusable(true);
    }

    protected abstract int getDefaultRequestCode();

    /*
     * WARNING - void declaration
     */
    public void setFragment(androidx.fragment.app.Fragment fragment) {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            void fragment2;
            this.parentFragment = new FragmentWrapper((androidx.fragment.app.Fragment)fragment2);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setFragment(Fragment fragment) {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            void fragment2;
            this.parentFragment = new FragmentWrapper((Fragment)fragment2);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    public androidx.fragment.app.Fragment getFragment() {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return null;
        }
        try {
            return this.parentFragment != null ? this.parentFragment.getSupportFragment() : null;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return null;
        }
    }

    public Fragment getNativeFragment() {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return null;
        }
        try {
            return this.parentFragment != null ? this.parentFragment.getNativeFragment() : null;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return null;
        }
    }

    @Nullable
    public ActivityResultRegistryOwner getAndroidxActivityResultRegistryOwner() {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return null;
        }
        try {
            Activity activity = this.getActivity();
            if (activity instanceof ActivityResultRegistryOwner) {
                return (ActivityResultRegistryOwner)activity;
            }
            return null;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setOnClickListener(View.OnClickListener onClickListener) {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            void l;
            this.externalOnClickListener = l;
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    public int getRequestCode() {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return 0;
        }
        try {
            return this.getDefaultRequestCode();
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return 0;
        }
    }

    protected void onAttachedToWindow() {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            super.onAttachedToWindow();
            if (!this.isInEditMode()) {
                this.logButtonCreated(this.getContext());
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void onDraw(Canvas canvas) {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            void canvas2;
            boolean centered;
            boolean bl = centered = (this.getGravity() & 1) != 0;
            if (centered) {
                int compoundPaddingLeft = this.getCompoundPaddingLeft();
                int compoundPaddingRight = this.getCompoundPaddingRight();
                int compoundDrawablePadding = this.getCompoundDrawablePadding();
                int textX = compoundPaddingLeft + compoundDrawablePadding;
                int textContentWidth = this.getWidth() - textX - compoundPaddingRight;
                int textWidth = this.measureTextWidth(this.getText().toString());
                int textPaddingWidth = (textContentWidth - textWidth) / 2;
                int imagePaddingWidth = (compoundPaddingLeft - this.getPaddingLeft()) / 2;
                int inset = Math.min(textPaddingWidth, imagePaddingWidth);
                this.overrideCompoundPaddingLeft = compoundPaddingLeft - inset;
                this.overrideCompoundPaddingRight = compoundPaddingRight + inset;
                this.overrideCompoundPadding = true;
            }
            super.onDraw((Canvas)canvas2);
            this.overrideCompoundPadding = false;
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    public int getCompoundPaddingLeft() {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return 0;
        }
        try {
            return this.overrideCompoundPadding ? this.overrideCompoundPaddingLeft : super.getCompoundPaddingLeft();
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return 0;
        }
    }

    public int getCompoundPaddingRight() {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return 0;
        }
        try {
            return this.overrideCompoundPadding ? this.overrideCompoundPaddingRight : super.getCompoundPaddingRight();
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return 0;
        }
    }

    protected Activity getActivity() {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return null;
        }
        try {
            Context context = this.getContext();
            while (!(context instanceof Activity) && context instanceof ContextWrapper) {
                context = ((ContextWrapper)context).getBaseContext();
            }
            if (context instanceof Activity) {
                return (Activity)context;
            }
            throw new FacebookException("Unable to get Activity.");
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return null;
        }
    }

    protected int getDefaultStyleResource() {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return 0;
        }
        try {
            return 0;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected int measureTextWidth(String string2) {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return 0;
        }
        try {
            void text;
            return (int)Math.ceil(this.getPaint().measureText((String)text));
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void configureButton(Context context, AttributeSet attributeSet, int n, int n2) {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            void defStyleRes;
            void defStyleAttr;
            void attrs;
            void context2;
            this.parseBackgroundAttributes((Context)context2, (AttributeSet)attrs, (int)defStyleAttr, (int)defStyleRes);
            this.parseCompoundDrawableAttributes((Context)context2, (AttributeSet)attrs, (int)defStyleAttr, (int)defStyleRes);
            this.parseContentAttributes((Context)context2, (AttributeSet)attrs, (int)defStyleAttr, (int)defStyleRes);
            this.parseTextAttributes((Context)context2, (AttributeSet)attrs, (int)defStyleAttr, (int)defStyleRes);
            this.setupOnClickListener();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void callExternalOnClickListener(View view) {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            if (this.externalOnClickListener != null) {
                void v;
                this.externalOnClickListener.onClick((View)v);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void setInternalOnClickListener(View.OnClickListener onClickListener) {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            void l;
            this.internalOnClickListener = l;
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void logButtonCreated(Context context) {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            void context2;
            InternalAppEventsLogger logger = new InternalAppEventsLogger((Context)context2);
            logger.logEventImplicitly(this.analyticsButtonCreatedEventName);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void logButtonTapped(Context context) {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            void context2;
            InternalAppEventsLogger logger = new InternalAppEventsLogger((Context)context2);
            logger.logEventImplicitly(this.analyticsButtonTappedEventName);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void parseBackgroundAttributes(Context context, AttributeSet attributeSet, int n, int n2) {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            void defStyleRes;
            void defStyleAttr;
            void attrs;
            void context2;
            if (this.isInEditMode()) {
                return;
            }
            int[] attrsResources = new int[]{16842964};
            TypedArray a = context2.getTheme().obtainStyledAttributes((AttributeSet)attrs, attrsResources, (int)defStyleAttr, (int)defStyleRes);
            try {
                if (a.hasValue(0)) {
                    int backgroundResource = a.getResourceId(0, 0);
                    if (backgroundResource != 0) {
                        this.setBackgroundResource(backgroundResource);
                    } else {
                        this.setBackgroundColor(a.getColor(0, 0));
                    }
                } else {
                    this.setBackgroundColor(ContextCompat.getColor((Context)context2, (int)R.color.com_facebook_blue));
                }
            }
            finally {
                a.recycle();
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @SuppressLint(value={"ResourceType"})
    private void parseCompoundDrawableAttributes(Context context, AttributeSet attributeSet, int n, int n2) {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            void defStyleRes;
            void defStyleAttr;
            void attrs;
            void context2;
            int[] attrsResources = new int[]{16843119, 16843117, 0x1010170, 16843118, 0x1010171};
            TypedArray a = context2.getTheme().obtainStyledAttributes((AttributeSet)attrs, attrsResources, (int)defStyleAttr, (int)defStyleRes);
            try {
                this.setCompoundDrawablesWithIntrinsicBounds(a.getResourceId(0, 0), a.getResourceId(1, 0), a.getResourceId(2, 0), a.getResourceId(3, 0));
                this.setCompoundDrawablePadding(a.getDimensionPixelSize(4, 0));
            }
            finally {
                a.recycle();
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void parseContentAttributes(Context context, AttributeSet attributeSet, int n, int n2) {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            void defStyleRes;
            void defStyleAttr;
            void attrs;
            void context2;
            int[] attrsResources = new int[]{16842966, 16842967, 16842968, 16842969};
            TypedArray a = context2.getTheme().obtainStyledAttributes((AttributeSet)attrs, attrsResources, (int)defStyleAttr, (int)defStyleRes);
            try {
                this.setPadding(a.getDimensionPixelSize(0, 0), a.getDimensionPixelSize(1, 0), a.getDimensionPixelSize(2, 0), a.getDimensionPixelSize(3, 0));
            }
            finally {
                a.recycle();
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void parseTextAttributes(Context context, AttributeSet attributeSet, int n, int n2) {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            void defStyleRes;
            void defStyleAttr;
            void attrs;
            void context2;
            int[] colorResources = new int[]{16842904};
            TypedArray colorAttrs = context2.getTheme().obtainStyledAttributes((AttributeSet)attrs, colorResources, (int)defStyleAttr, (int)defStyleRes);
            try {
                this.setTextColor(colorAttrs.getColorStateList(0));
            }
            finally {
                colorAttrs.recycle();
            }
            int[] gravityResources = new int[]{16842927};
            TypedArray gravityAttrs = context2.getTheme().obtainStyledAttributes((AttributeSet)attrs, gravityResources, (int)defStyleAttr, (int)defStyleRes);
            try {
                this.setGravity(gravityAttrs.getInt(0, 17));
            }
            finally {
                gravityAttrs.recycle();
            }
            int[] attrsResources = new int[]{16842901, 16842903, 16843087};
            TypedArray a = context2.getTheme().obtainStyledAttributes((AttributeSet)attrs, attrsResources, (int)defStyleAttr, (int)defStyleRes);
            try {
                this.setTextSize(0, a.getDimensionPixelSize(0, 0));
                this.setTypeface(Typeface.defaultFromStyle((int)a.getInt(1, 1)));
                this.setText(a.getString(2));
            }
            finally {
                a.recycle();
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    private void setupOnClickListener() {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            super.setOnClickListener(new View.OnClickListener(){

                /*
                 * WARNING - void declaration
                 */
                public void onClick(View view) {
                    if (CrashShieldHandler.isObjectCrashing((Object)this)) {
                        return;
                    }
                    try {
                        void v;
                        FacebookButtonBase.access$000(FacebookButtonBase.this, FacebookButtonBase.this.getContext());
                        if (FacebookButtonBase.access$100(FacebookButtonBase.this) != null) {
                            FacebookButtonBase.access$100(FacebookButtonBase.this).onClick((View)v);
                        } else if (FacebookButtonBase.access$200(FacebookButtonBase.this) != null) {
                            FacebookButtonBase.access$200(FacebookButtonBase.this).onClick((View)v);
                        }
                        return;
                    }
                    catch (Throwable throwable) {
                        CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
                        return;
                    }
                }
            });
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(FacebookButtonBase facebookButtonBase, Context context) {
        if (CrashShieldHandler.isObjectCrashing(FacebookButtonBase.class)) {
            return;
        }
        try {
            void x1;
            FacebookButtonBase x0;
            x0.logButtonTapped((Context)x1);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, FacebookButtonBase.class);
            return;
        }
    }

    static /* synthetic */ View.OnClickListener access$100(FacebookButtonBase facebookButtonBase) {
        if (CrashShieldHandler.isObjectCrashing(FacebookButtonBase.class)) {
            return null;
        }
        try {
            FacebookButtonBase x0;
            return x0.internalOnClickListener;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, FacebookButtonBase.class);
            return null;
        }
    }

    static /* synthetic */ View.OnClickListener access$200(FacebookButtonBase facebookButtonBase) {
        if (CrashShieldHandler.isObjectCrashing(FacebookButtonBase.class)) {
            return null;
        }
        try {
            FacebookButtonBase x0;
            return x0.externalOnClickListener;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, FacebookButtonBase.class);
            return null;
        }
    }
}

