/*
 * Copyright (c) 2014-present, Facebook, Inc. All rights reserved.
 *
 * You are hereby granted a non-exclusive, worldwide, royalty-free license to use,
 * copy, modify, and distribute this software in source code or binary form for use
 * in connection with the web services and APIs provided by Facebook.
 *
 * As with any software that integrates with the Facebook platform, your use of
 * this software is subject to the Facebook Developer Principles and Policies
 * [http://developers.facebook.com/policy/]. This copyright notice shall be
 * included in all copies or substantial portions of the software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.facebook.internal;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.facebook.internal.qualityvalidation.Excuse;
import com.facebook.internal.qualityvalidation.ExcusesForDesignViolations;

@ExcusesForDesignViolations(@Excuse(type = "MISSING_UNIT_TEST", reason = "Legacy"))
public class FragmentWrapper {
  private Fragment supportFragment;
  private android.app.Fragment nativeFragment;

  public FragmentWrapper(Fragment fragment) {
    Validate.notNull(fragment, "fragment");
    this.supportFragment = fragment;
  }

  public FragmentWrapper(android.app.Fragment fragment) {
    Validate.notNull(fragment, "fragment");
    this.nativeFragment = fragment;
  }

  public android.app.Fragment getNativeFragment() {
    return this.nativeFragment;
  }

  public Fragment getSupportFragment() {
    return this.supportFragment;
  }

  /**
   * Call {@link Activity#startActivityForResult(Intent, int)} from the fragment's containing
   * Activity.
   */
  public void startActivityForResult(Intent intent, int requestCode) {
    if (supportFragment != null) {
      supportFragment.startActivityForResult(intent, requestCode);
    } else {
      nativeFragment.startActivityForResult(intent, requestCode);
    }
  }

  /**
   * Return the {@link FragmentActivity} this fragment is currently associated with. May return
   * {@code null} if the fragment is associated with a {@link Context} instead.
   */
  public final Activity getActivity() {
    if (supportFragment != null) {
      return supportFragment.getActivity();
    } else {
      return nativeFragment.getActivity();
    }
  }
}
