/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.login;

import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import androidx.annotation.Nullable;
import com.facebook.AccessToken;
import com.facebook.AccessTokenSource;
import com.facebook.FacebookException;
import com.facebook.internal.ServerProtocol;
import com.facebook.internal.Utility;
import com.facebook.login.CustomTabLoginMethodHandler;
import com.facebook.login.LoginClient;
import com.facebook.login.LoginMethodHandler;

abstract class NativeAppLoginMethodHandler
extends LoginMethodHandler {
    NativeAppLoginMethodHandler(LoginClient loginClient) {
        super(loginClient);
    }

    NativeAppLoginMethodHandler(Parcel source) {
        super(source);
    }

    @Override
    abstract int tryAuthorize(LoginClient.Request var1);

    public AccessTokenSource getTokenSource() {
        return AccessTokenSource.FACEBOOK_APPLICATION_WEB;
    }

    @Override
    boolean onActivityResult(int requestCode, int resultCode, Intent data) {
        LoginClient.Request request = this.loginClient.getPendingRequest();
        if (data == null) {
            this.completeLogin(LoginClient.Result.createCancelResult(request, "Operation canceled"));
        } else if (resultCode == 0) {
            this.handleResultCancel(request, data);
        } else if (resultCode != -1) {
            this.completeLogin(LoginClient.Result.createErrorResult(request, "Unexpected resultCode from authorization.", null));
        } else {
            Bundle extras = data.getExtras();
            if (extras == null) {
                this.completeLogin(LoginClient.Result.createErrorResult(request, "Unexpected null from returned authorization data.", null));
                return true;
            }
            String error = this.getError(extras);
            String errorCode = extras.get("error_code") != null ? extras.get("error_code").toString() : null;
            String errorMessage = this.getErrorMessage(extras);
            String e2e = extras.getString("e2e");
            if (!Utility.isNullOrEmpty((String)e2e)) {
                this.logWebLoginCompleted(e2e);
            }
            if (error == null && errorCode == null && errorMessage == null) {
                this.handleResultOk(request, extras);
            } else {
                this.handleResultError(request, error, errorMessage, errorCode);
            }
        }
        return true;
    }

    private void completeLogin(@Nullable LoginClient.Result outcome) {
        if (outcome != null) {
            this.loginClient.completeAndValidate(outcome);
        } else {
            this.loginClient.tryNextHandler();
        }
    }

    protected void handleResultError(LoginClient.Request request, @Nullable String error, @Nullable String errorMessage, @Nullable String errorCode) {
        if (error != null && error.equals("logged_out")) {
            CustomTabLoginMethodHandler.calledThroughLoggedOutAppSwitch = true;
            this.completeLogin(null);
        } else if (ServerProtocol.getErrorsProxyAuthDisabled().contains(error)) {
            this.completeLogin(null);
        } else if (ServerProtocol.getErrorsUserCanceled().contains(error)) {
            this.completeLogin(LoginClient.Result.createCancelResult(request, null));
        } else {
            this.completeLogin(LoginClient.Result.createErrorResult(request, error, errorMessage, errorCode));
        }
    }

    protected void handleResultOk(LoginClient.Request request, Bundle extras) {
        try {
            AccessToken token = NativeAppLoginMethodHandler.createAccessTokenFromWebBundle(request.getPermissions(), extras, this.getTokenSource(), request.getApplicationId());
            this.completeLogin(LoginClient.Result.createTokenResult(request, token));
        }
        catch (FacebookException ex) {
            this.completeLogin(LoginClient.Result.createErrorResult(request, null, ex.getMessage()));
        }
    }

    protected void handleResultCancel(LoginClient.Request request, Intent data) {
        String errorCode;
        Bundle extras = data.getExtras();
        String error = this.getError(extras);
        String string2 = errorCode = extras.get("error_code") != null ? extras.get("error_code").toString() : null;
        if (ServerProtocol.getErrorConnectionFailure().equals(errorCode)) {
            String errorMessage = this.getErrorMessage(extras);
            this.completeLogin(LoginClient.Result.createErrorResult(request, error, errorMessage, errorCode));
        }
        this.completeLogin(LoginClient.Result.createCancelResult(request, error));
    }

    @Nullable
    protected String getError(@Nullable Bundle extras) {
        if (extras == null) {
            return null;
        }
        String error = extras.getString("error");
        if (error == null) {
            error = extras.getString("error_type");
        }
        return error;
    }

    @Nullable
    protected String getErrorMessage(@Nullable Bundle extras) {
        if (extras == null) {
            return null;
        }
        String errorMessage = extras.getString("error_message");
        if (errorMessage == null) {
            errorMessage = extras.getString("error_description");
        }
        return errorMessage;
    }

    protected boolean tryIntent(Intent intent, int requestCode) {
        if (intent == null) {
            return false;
        }
        try {
            this.loginClient.getFragment().startActivityForResult(intent, requestCode);
        }
        catch (ActivityNotFoundException e) {
            return false;
        }
        return true;
    }
}

