/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.share.widget;

import android.app.Activity;
import android.app.Fragment;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.facebook.FacebookException;
import com.facebook.common.R;
import com.facebook.internal.FragmentWrapper;
import com.facebook.internal.NativeProtocol;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import com.facebook.share.internal.LikeActionController;
import com.facebook.share.internal.LikeBoxCountView;
import com.facebook.share.internal.LikeButton;

@Deprecated
public class LikeView
extends FrameLayout {
    private static final int NO_FOREGROUND_COLOR = -1;
    private String objectId;
    private ObjectType objectType;
    private LinearLayout containerView;
    private LikeButton likeButton;
    private LikeBoxCountView likeBoxCountView;
    private TextView socialSentenceView;
    private LikeActionController likeActionController;
    private OnErrorListener onErrorListener;
    private BroadcastReceiver broadcastReceiver;
    private LikeActionControllerCreationCallback creationCallback;
    private Style likeViewStyle = Style.DEFAULT;
    private HorizontalAlignment horizontalAlignment = HorizontalAlignment.DEFAULT;
    private AuxiliaryViewPosition auxiliaryViewPosition = AuxiliaryViewPosition.DEFAULT;
    private int foregroundColor = -1;
    private int edgePadding;
    private int internalPadding;
    private FragmentWrapper parentFragment;
    private boolean explicitlyDisabled = true;

    @Deprecated
    public LikeView(Context context) {
        super(context);
        this.initialize(context);
    }

    @Deprecated
    public LikeView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.parseAttributes(attrs);
        this.initialize(context);
    }

    @Deprecated
    public void setObjectIdAndType(String objectId, ObjectType objectType) {
        objectId = Utility.coerceValueIfNullOrEmpty((String)objectId, null);
        ObjectType objectType2 = objectType = objectType != null ? objectType : ObjectType.DEFAULT;
        if (!Utility.areObjectsEqual((Object)objectId, (Object)this.objectId) || objectType != this.objectType) {
            this.setObjectIdAndTypeForced(objectId, objectType);
            this.updateLikeStateAndLayout();
        }
    }

    @Deprecated
    public void setLikeViewStyle(Style likeViewStyle) {
        Style style2 = likeViewStyle = likeViewStyle != null ? likeViewStyle : Style.DEFAULT;
        if (this.likeViewStyle != likeViewStyle) {
            this.likeViewStyle = likeViewStyle;
            this.updateLayout();
        }
    }

    @Deprecated
    public void setAuxiliaryViewPosition(AuxiliaryViewPosition auxiliaryViewPosition) {
        AuxiliaryViewPosition auxiliaryViewPosition2 = auxiliaryViewPosition = auxiliaryViewPosition != null ? auxiliaryViewPosition : AuxiliaryViewPosition.DEFAULT;
        if (this.auxiliaryViewPosition != auxiliaryViewPosition) {
            this.auxiliaryViewPosition = auxiliaryViewPosition;
            this.updateLayout();
        }
    }

    @Deprecated
    public void setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        HorizontalAlignment horizontalAlignment2 = horizontalAlignment = horizontalAlignment != null ? horizontalAlignment : HorizontalAlignment.DEFAULT;
        if (this.horizontalAlignment != horizontalAlignment) {
            this.horizontalAlignment = horizontalAlignment;
            this.updateLayout();
        }
    }

    @Deprecated
    public void setForegroundColor(int foregroundColor) {
        if (this.foregroundColor != foregroundColor) {
            this.socialSentenceView.setTextColor(foregroundColor);
        }
    }

    @Deprecated
    public void setOnErrorListener(OnErrorListener onErrorListener) {
        this.onErrorListener = onErrorListener;
    }

    @Deprecated
    public OnErrorListener getOnErrorListener() {
        return this.onErrorListener;
    }

    @Deprecated
    public void setFragment(androidx.fragment.app.Fragment fragment) {
        this.parentFragment = new FragmentWrapper(fragment);
    }

    @Deprecated
    public void setFragment(Fragment fragment) {
        this.parentFragment = new FragmentWrapper(fragment);
    }

    @Deprecated
    public void setEnabled(boolean enabled) {
        this.explicitlyDisabled = true;
        this.updateLikeStateAndLayout();
    }

    protected void onDetachedFromWindow() {
        this.setObjectIdAndType(null, ObjectType.UNKNOWN);
        super.onDetachedFromWindow();
    }

    private void parseAttributes(AttributeSet attrs) {
        if (attrs == null || this.getContext() == null) {
            return;
        }
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.com_facebook_like_view);
        if (a == null) {
            return;
        }
        this.objectId = Utility.coerceValueIfNullOrEmpty((String)a.getString(R.styleable.com_facebook_like_view_com_facebook_object_id), null);
        this.objectType = ObjectType.fromInt(a.getInt(R.styleable.com_facebook_like_view_com_facebook_object_type, ObjectType.DEFAULT.getValue()));
        this.likeViewStyle = Style.fromInt(a.getInt(R.styleable.com_facebook_like_view_com_facebook_style, Style.DEFAULT.getValue()));
        if (this.likeViewStyle == null) {
            throw new IllegalArgumentException("Unsupported value for LikeView 'style'");
        }
        this.auxiliaryViewPosition = AuxiliaryViewPosition.fromInt(a.getInt(R.styleable.com_facebook_like_view_com_facebook_auxiliary_view_position, AuxiliaryViewPosition.DEFAULT.getValue()));
        if (this.auxiliaryViewPosition == null) {
            throw new IllegalArgumentException("Unsupported value for LikeView 'auxiliary_view_position'");
        }
        this.horizontalAlignment = HorizontalAlignment.fromInt(a.getInt(R.styleable.com_facebook_like_view_com_facebook_horizontal_alignment, HorizontalAlignment.DEFAULT.getValue()));
        if (this.horizontalAlignment == null) {
            throw new IllegalArgumentException("Unsupported value for LikeView 'horizontal_alignment'");
        }
        this.foregroundColor = a.getColor(R.styleable.com_facebook_like_view_com_facebook_foreground_color, -1);
        a.recycle();
    }

    private void initialize(Context context) {
        this.edgePadding = this.getResources().getDimensionPixelSize(R.dimen.com_facebook_likeview_edge_padding);
        this.internalPadding = this.getResources().getDimensionPixelSize(R.dimen.com_facebook_likeview_internal_padding);
        if (this.foregroundColor == -1) {
            this.foregroundColor = this.getResources().getColor(R.color.com_facebook_likeview_text_color);
        }
        this.setBackgroundColor(0);
        this.containerView = new LinearLayout(context);
        FrameLayout.LayoutParams containerViewLayoutParams = new FrameLayout.LayoutParams(-2, -2);
        this.containerView.setLayoutParams((ViewGroup.LayoutParams)containerViewLayoutParams);
        this.initializeLikeButton(context);
        this.initializeSocialSentenceView(context);
        this.initializeLikeCountView(context);
        this.containerView.addView((View)this.likeButton);
        this.containerView.addView((View)this.socialSentenceView);
        this.containerView.addView((View)this.likeBoxCountView);
        this.addView((View)this.containerView);
        this.setObjectIdAndTypeForced(this.objectId, this.objectType);
        this.updateLikeStateAndLayout();
    }

    private void initializeLikeButton(Context context) {
        this.likeButton = new LikeButton(context, this.likeActionController != null && this.likeActionController.isObjectLiked());
        this.likeButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (CrashShieldHandler.isObjectCrashing((Object)this)) {
                    return;
                }
                try {
                    LikeView.this.toggleLike();
                    return;
                }
                catch (Throwable throwable) {
                    CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
                    return;
                }
            }
        });
        LinearLayout.LayoutParams buttonLayout = new LinearLayout.LayoutParams(-2, -2);
        this.likeButton.setLayoutParams((ViewGroup.LayoutParams)buttonLayout);
    }

    private void initializeSocialSentenceView(Context context) {
        this.socialSentenceView = new TextView(context);
        this.socialSentenceView.setTextSize(0, this.getResources().getDimension(R.dimen.com_facebook_likeview_text_size));
        this.socialSentenceView.setMaxLines(2);
        this.socialSentenceView.setTextColor(this.foregroundColor);
        this.socialSentenceView.setGravity(17);
        LinearLayout.LayoutParams socialSentenceViewLayout = new LinearLayout.LayoutParams(-2, -1);
        this.socialSentenceView.setLayoutParams((ViewGroup.LayoutParams)socialSentenceViewLayout);
    }

    private void initializeLikeCountView(Context context) {
        this.likeBoxCountView = new LikeBoxCountView(context);
        LinearLayout.LayoutParams likeCountViewLayout = new LinearLayout.LayoutParams(-1, -1);
        this.likeBoxCountView.setLayoutParams((ViewGroup.LayoutParams)likeCountViewLayout);
    }

    private void toggleLike() {
        if (this.likeActionController != null) {
            Activity activity = null;
            if (this.parentFragment == null) {
                activity = this.getActivity();
            }
            this.likeActionController.toggleLike(activity, this.parentFragment, this.getAnalyticsParameters());
        }
    }

    private Activity getActivity() {
        Context context = this.getContext();
        while (!(context instanceof Activity) && context instanceof ContextWrapper) {
            context = ((ContextWrapper)context).getBaseContext();
        }
        if (context instanceof Activity) {
            return (Activity)context;
        }
        throw new FacebookException("Unable to get Activity.");
    }

    private Bundle getAnalyticsParameters() {
        Bundle params = new Bundle();
        params.putString("style", this.likeViewStyle.toString());
        params.putString("auxiliary_position", this.auxiliaryViewPosition.toString());
        params.putString("horizontal_alignment", this.horizontalAlignment.toString());
        params.putString("object_id", Utility.coerceValueIfNullOrEmpty((String)this.objectId, (String)""));
        params.putString("object_type", this.objectType.toString());
        return params;
    }

    private void setObjectIdAndTypeForced(String newObjectId, ObjectType newObjectType) {
        this.tearDownObjectAssociations();
        this.objectId = newObjectId;
        this.objectType = newObjectType;
        if (Utility.isNullOrEmpty((String)newObjectId)) {
            return;
        }
        this.creationCallback = new LikeActionControllerCreationCallback();
        if (!this.isInEditMode()) {
            LikeActionController.getControllerForObjectId(newObjectId, newObjectType, this.creationCallback);
        }
    }

    private void associateWithLikeActionController(LikeActionController likeActionController) {
        this.likeActionController = likeActionController;
        this.broadcastReceiver = new LikeControllerBroadcastReceiver();
        LocalBroadcastManager localBroadcastManager = LocalBroadcastManager.getInstance((Context)this.getContext());
        IntentFilter filter = new IntentFilter();
        filter.addAction("com.facebook.sdk.LikeActionController.UPDATED");
        filter.addAction("com.facebook.sdk.LikeActionController.DID_ERROR");
        filter.addAction("com.facebook.sdk.LikeActionController.DID_RESET");
        localBroadcastManager.registerReceiver(this.broadcastReceiver, filter);
    }

    private void tearDownObjectAssociations() {
        if (this.broadcastReceiver != null) {
            LocalBroadcastManager localBroadcastManager = LocalBroadcastManager.getInstance((Context)this.getContext());
            localBroadcastManager.unregisterReceiver(this.broadcastReceiver);
            this.broadcastReceiver = null;
        }
        if (this.creationCallback != null) {
            this.creationCallback.cancel();
            this.creationCallback = null;
        }
        this.likeActionController = null;
    }

    private void updateLikeStateAndLayout() {
        boolean enabled;
        boolean bl = enabled = !this.explicitlyDisabled;
        if (this.likeActionController == null) {
            this.likeButton.setSelected(false);
            this.socialSentenceView.setText(null);
            this.likeBoxCountView.setText(null);
        } else {
            this.likeButton.setSelected(this.likeActionController.isObjectLiked());
            this.socialSentenceView.setText((CharSequence)this.likeActionController.getSocialSentence());
            this.likeBoxCountView.setText(this.likeActionController.getLikeCountString());
            enabled &= this.likeActionController.shouldEnableView();
        }
        super.setEnabled(enabled);
        this.likeButton.setEnabled(enabled);
        this.updateLayout();
    }

    private void updateLayout() {
        Object auxView;
        FrameLayout.LayoutParams containerViewLayoutParams = (FrameLayout.LayoutParams)this.containerView.getLayoutParams();
        LinearLayout.LayoutParams buttonLayoutParams = (LinearLayout.LayoutParams)this.likeButton.getLayoutParams();
        int viewGravity = this.horizontalAlignment == HorizontalAlignment.LEFT ? 3 : (this.horizontalAlignment == HorizontalAlignment.CENTER ? 1 : 5);
        containerViewLayoutParams.gravity = viewGravity | 0x30;
        buttonLayoutParams.gravity = viewGravity;
        this.socialSentenceView.setVisibility(8);
        this.likeBoxCountView.setVisibility(8);
        if (this.likeViewStyle == Style.STANDARD && this.likeActionController != null && !Utility.isNullOrEmpty((String)this.likeActionController.getSocialSentence())) {
            auxView = this.socialSentenceView;
        } else if (this.likeViewStyle == Style.BOX_COUNT && this.likeActionController != null && !Utility.isNullOrEmpty((String)this.likeActionController.getLikeCountString())) {
            this.updateBoxCountCaretPosition();
            auxView = this.likeBoxCountView;
        } else {
            return;
        }
        auxView.setVisibility(0);
        LinearLayout.LayoutParams auxViewLayoutParams = (LinearLayout.LayoutParams)auxView.getLayoutParams();
        auxViewLayoutParams.gravity = viewGravity;
        this.containerView.setOrientation(this.auxiliaryViewPosition == AuxiliaryViewPosition.INLINE ? 0 : 1);
        if (this.auxiliaryViewPosition == AuxiliaryViewPosition.TOP || this.auxiliaryViewPosition == AuxiliaryViewPosition.INLINE && this.horizontalAlignment == HorizontalAlignment.RIGHT) {
            this.containerView.removeView((View)this.likeButton);
            this.containerView.addView((View)this.likeButton);
        } else {
            this.containerView.removeView((View)auxView);
            this.containerView.addView((View)auxView);
        }
        switch (this.auxiliaryViewPosition) {
            case TOP: {
                auxView.setPadding(this.edgePadding, this.edgePadding, this.edgePadding, this.internalPadding);
                break;
            }
            case BOTTOM: {
                auxView.setPadding(this.edgePadding, this.internalPadding, this.edgePadding, this.edgePadding);
                break;
            }
            case INLINE: {
                if (this.horizontalAlignment == HorizontalAlignment.RIGHT) {
                    auxView.setPadding(this.edgePadding, this.edgePadding, this.internalPadding, this.edgePadding);
                    break;
                }
                auxView.setPadding(this.internalPadding, this.edgePadding, this.edgePadding, this.edgePadding);
            }
        }
    }

    private void updateBoxCountCaretPosition() {
        switch (this.auxiliaryViewPosition) {
            case TOP: {
                this.likeBoxCountView.setCaretPosition(LikeBoxCountView.LikeBoxCountViewCaretPosition.BOTTOM);
                break;
            }
            case BOTTOM: {
                this.likeBoxCountView.setCaretPosition(LikeBoxCountView.LikeBoxCountViewCaretPosition.TOP);
                break;
            }
            case INLINE: {
                this.likeBoxCountView.setCaretPosition(this.horizontalAlignment == HorizontalAlignment.RIGHT ? LikeBoxCountView.LikeBoxCountViewCaretPosition.RIGHT : LikeBoxCountView.LikeBoxCountViewCaretPosition.LEFT);
            }
        }
    }

    private class LikeActionControllerCreationCallback
    implements LikeActionController.CreationCallback {
        private boolean isCancelled;

        private LikeActionControllerCreationCallback() {
        }

        public void cancel() {
            this.isCancelled = true;
        }

        @Override
        public void onComplete(LikeActionController likeActionController, FacebookException error) {
            if (this.isCancelled) {
                return;
            }
            if (likeActionController != null) {
                if (!likeActionController.shouldEnableView()) {
                    error = new FacebookException("Cannot use LikeView. The device may not be supported.");
                }
                LikeView.this.associateWithLikeActionController(likeActionController);
                LikeView.this.updateLikeStateAndLayout();
            }
            if (error != null && LikeView.this.onErrorListener != null) {
                LikeView.this.onErrorListener.onError(error);
            }
            LikeView.this.creationCallback = null;
        }
    }

    private class LikeControllerBroadcastReceiver
    extends BroadcastReceiver {
        private LikeControllerBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            String intentAction = intent.getAction();
            Bundle extras = intent.getExtras();
            boolean shouldRespond = true;
            if (extras != null) {
                String broadcastObjectId = extras.getString("com.facebook.sdk.LikeActionController.OBJECT_ID");
                boolean bl = shouldRespond = Utility.isNullOrEmpty((String)broadcastObjectId) || Utility.areObjectsEqual((Object)LikeView.this.objectId, (Object)broadcastObjectId);
            }
            if (!shouldRespond) {
                return;
            }
            if ("com.facebook.sdk.LikeActionController.UPDATED".equals(intentAction)) {
                LikeView.this.updateLikeStateAndLayout();
            } else if ("com.facebook.sdk.LikeActionController.DID_ERROR".equals(intentAction)) {
                if (LikeView.this.onErrorListener != null) {
                    LikeView.this.onErrorListener.onError(NativeProtocol.getExceptionFromErrorData((Bundle)extras));
                }
            } else if ("com.facebook.sdk.LikeActionController.DID_RESET".equals(intentAction)) {
                LikeView.this.setObjectIdAndTypeForced(LikeView.this.objectId, LikeView.this.objectType);
                LikeView.this.updateLikeStateAndLayout();
            }
        }
    }

    public static interface OnErrorListener {
        public void onError(FacebookException var1);
    }

    @Deprecated
    public static enum AuxiliaryViewPosition {
        BOTTOM("bottom", 0),
        INLINE("inline", 1),
        TOP("top", 2);

        static AuxiliaryViewPosition DEFAULT;
        private String stringValue;
        private int intValue;

        static AuxiliaryViewPosition fromInt(int enumValue) {
            for (AuxiliaryViewPosition auxViewPosition : AuxiliaryViewPosition.values()) {
                if (auxViewPosition.getValue() != enumValue) continue;
                return auxViewPosition;
            }
            return null;
        }

        private AuxiliaryViewPosition(String stringValue, int value) {
            this.stringValue = stringValue;
            this.intValue = value;
        }

        public String toString() {
            return this.stringValue;
        }

        private int getValue() {
            return this.intValue;
        }

        static {
            DEFAULT = BOTTOM;
        }
    }

    @Deprecated
    public static enum HorizontalAlignment {
        CENTER("center", 0),
        LEFT("left", 1),
        RIGHT("right", 2);

        static HorizontalAlignment DEFAULT;
        private String stringValue;
        private int intValue;

        static HorizontalAlignment fromInt(int enumValue) {
            for (HorizontalAlignment horizontalAlignment : HorizontalAlignment.values()) {
                if (horizontalAlignment.getValue() != enumValue) continue;
                return horizontalAlignment;
            }
            return null;
        }

        private HorizontalAlignment(String stringValue, int value) {
            this.stringValue = stringValue;
            this.intValue = value;
        }

        public String toString() {
            return this.stringValue;
        }

        private int getValue() {
            return this.intValue;
        }

        static {
            DEFAULT = CENTER;
        }
    }

    @Deprecated
    public static enum Style {
        STANDARD("standard", 0),
        BUTTON("button", 1),
        BOX_COUNT("box_count", 2);

        static Style DEFAULT;
        private String stringValue;
        private int intValue;

        static Style fromInt(int enumValue) {
            for (Style style2 : Style.values()) {
                if (style2.getValue() != enumValue) continue;
                return style2;
            }
            return null;
        }

        private Style(String stringValue, int value) {
            this.stringValue = stringValue;
            this.intValue = value;
        }

        public String toString() {
            return this.stringValue;
        }

        private int getValue() {
            return this.intValue;
        }

        static {
            DEFAULT = STANDARD;
        }
    }

    @Deprecated
    public static enum ObjectType {
        UNKNOWN("unknown", 0),
        OPEN_GRAPH("open_graph", 1),
        PAGE("page", 2);

        public static ObjectType DEFAULT;
        private String stringValue;
        private int intValue;

        public static ObjectType fromInt(int enumValue) {
            for (ObjectType objectType : ObjectType.values()) {
                if (objectType.getValue() != enumValue) continue;
                return objectType;
            }
            return null;
        }

        private ObjectType(String stringValue, int value) {
            this.stringValue = stringValue;
            this.intValue = value;
        }

        public String toString() {
            return this.stringValue;
        }

        public int getValue() {
            return this.intValue;
        }

        static {
            DEFAULT = UNKNOWN;
        }
    }
}

