/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.applinks;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.RestrictTo;
import com.facebook.FacebookSdk;
import com.facebook.appevents.InternalAppEventsLogger;
import com.facebook.applinks.AppLinkData;

public final class AppLinks {
    public static final String AUTO_APPLINK_DATA_KEY = "fb_aut_applink_data";
    private static Class<? extends Activity> autoAppLinkActivity;
    private static final String AUTO_APPLINK_EVENT = "fb_auto_applink";
    private static final String AUTO_APPLINK_KEY = "com.facebook.sdk.AutoAppLinkActivity";

    private AppLinks() {
    }

    private static synchronized boolean initialize(Context context) {
        if (!FacebookSdk.isInitialized()) {
            return false;
        }
        if (autoAppLinkActivity != null) {
            return true;
        }
        try {
            ApplicationInfo ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            if (ai != null && ai.metaData != null && ai.metaData.containsKey(AUTO_APPLINK_KEY)) {
                String name = ai.metaData.getString(AUTO_APPLINK_KEY);
                autoAppLinkActivity = Class.forName(name);
            }
            return true;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static boolean handleAutoAppLink(Activity activity) {
        if (activity == null || !AppLinks.initialize((Context)activity)) {
            return false;
        }
        AppLinkData data = AppLinkData.createFromAlApplinkData(activity.getIntent());
        if (data == null || !data.isAutoAppLink()) {
            return false;
        }
        Intent intent = new Intent((Context)activity, autoAppLinkActivity);
        intent.putExtra(AUTO_APPLINK_DATA_KEY, (Parcelable)data);
        InternalAppEventsLogger logger = new InternalAppEventsLogger(FacebookSdk.getApplicationContext());
        logger.logEvent(AUTO_APPLINK_EVENT, new Bundle());
        activity.startActivity(intent);
        return true;
    }
}

